<div class="row mt-4">
    <div class="col-sm-12 col-md-1 col-form-label">
        View
    </div>
    <div class="col-sm-12 col-md-5">
        <select class="form-select" name='report' id='report'>
            <option value=''>Select a Report Type</option>
            @foreach($reports as $key => $value)
            <option value="{{$key}}" @if($key==$show_report) selected="selected" @endif>{{$value}}</option>
            @endforeach
        </select>
    </div>
</div>

@if($show_report == 'report_leads')
<div class="row">
    <div class="col-md-1 col-form-label">
    </div>
    <div class="col-sm-12 col-md-5">
        <select class="form-select" name='subtype' id='leads_subtype'>
            <option value='summary' @if($subtype=='summary' ) selected="selected" @endif>Summary</option>
            <option value='stats_by_status' @if($subtype=='stats_by_status' ) selected="selected" @endif>Stats by Status</option>
            <option value='stats_by_staff' @if($subtype=='stats_by_staff' ) selected="selected" @endif>Stats by Staff</option>
            <option value='converted_staff_wise' @if($subtype=='converted_staff_wise' ) selected="selected" @endif>Converted (Staff-wise)</option>
            <option value='charts' @if($subtype=='charts' ) selected="selected" @endif>Charts</option>
            <option value='all_leads' @if($subtype=='all_leads' ) selected="selected" @endif>All Leads</option>
        </select>
    </div>
</div>

<div class="row" id="leadstatusdiv" @unless($show_report == 'report_leads' && $subtype == 'stats_by_staff')style="display:none;"@endunless>
    <div class="col-md-1 col-form-label">
    </div>
    <div class="col-sm-12 col-md-5">
        <select class="form-select" name='lead_status'>
            <option value=''>All Lead Status</option>
            @foreach(lead_status_list() as $status)
            @if($status->status != get_converted_lead_status())
                <option value='{{$status->status}}' @if(isset($lead_status) && $lead_status == $status->status) selected="selected" @endif>{{$status->status}}</option>
            @endif
            @endforeach
        </select>
    </div>
</div>
@elseif($show_report == 'report_applications')
<div class="row">
    <div class="col-md-1 col-form-label">
    </div>
    <div class="col-sm-12 col-md-5">
        <select class="form-select" name='subtype' id='appls_subtype'>
            <option value='summary' @if($subtype=='summary' ) selected="selected" @endif>Summary</option>
            <option value='stats_by_status' @if($subtype=='stats_by_status' ) selected="selected" @endif>Stats by Status</option>
            <option value='stats_by_staff' @if($subtype=='stats_by_staff' ) selected="selected" @endif>Stats by Staff</option>
            <option value='charts' @if($subtype=='charts' ) selected="selected" @endif>Charts</option>
            <option value='all_apps' @if($subtype=='all_apps' ) selected="selected" @endif>All University Applications</option>
        </select>
    </div>
</div>
<div class="row" id="applstatusdiv" @unless($show_report == 'report_applications' && $subtype == 'stats_by_staff')style="display:none;"@endunless>
    <div class="col-md-1 col-form-label">
    </div>
    <div class="col-sm-12 col-md-5">
        <select class="form-select" name='appl_status'>
            <option value=''>All University Applications Status</option>
            @foreach(get_application_statuses() as $status)
            <option value='{{$status->status_name}}' @if(isset($appl_status) && $appl_status == $status->status_name) selected="selected" @endif>{{$status->status_name}}</option>
            @endforeach
        </select>
    </div>
</div>

@elseif($show_report == 'report_students')

<div class="row">
    <div class="col-md-1 col-form-label">
    </div>
    <div class="col-sm-12 col-md-5">
        <select class="form-select" name='subtype' id='students_subtype'>
            <option value='summary' @if($subtype=='summary' ) selected="selected" @endif>Summary by Status</option>
            <option value='stats_by_staff' @if($subtype=='stats_by_staff' ) selected="selected" @endif>Stats by Staff</option>
            <option value='charts' @if($subtype=='charts' ) selected="selected" @endif>Charts</option>
            <option value='all_students' @if($subtype=='all_students' ) selected="selected" @endif>All Students</option>
        </select>
    </div>
</div>

@elseif($show_report == 'report_student_referrals')
<div class="row">
    <div class="col-md-1 col-form-label">
    </div>
    <div class="col-sm-12 col-md-5">
        <select class="form-select" name='subtype' id='student_referrals_subtype'>
            <option value='student_referrals' @if($subtype=='student_referrals' ) selected="selected" @endif>Student Referrals</option>
            <option value='referral_commission_payout' @if($subtype=='referral_commission_payout' ) selected="selected" @endif>Referral Commission Payout</option>
        </select>
    </div>
</div>

@elseif($show_report == 'report_staff')
<div class="row">
    <div class="col-md-1 col-form-label">
    </div>
    <div class="col-sm-12 col-md-5">
        <select class="form-select" name='subtype' id='staff_subtype'>
            <option value='summary' @if($subtype=='summary' ) selected="selected" @endif>Summary</option>
            <option value='follow_up' @if($subtype=='follow_up' ) selected="selected" @endif>Follow-up Activity</option>
        </select>
    </div>
</div>

@elseif($show_report == 'report_agents')
<div class="row">
    <div class="col-md-1 col-form-label">
    </div>
    <div class="col-sm-12 col-md-5">
        <select class="form-select" name='subtype' id='agents_subtype'>
            <option value='summary' @if($subtype=='summary' ) selected="selected" @endif>Summary</option>
            <option value='charts' @if($subtype=='charts' ) selected="selected" @endif>Charts</option>
        </select>
    </div>
</div>
@endif


<div class="row">
    <div class="col-md-1 col-form-label">
    </div>
    <div class="col-sm-12 col-md-5" id="daterangediv">
        Date Range <input type="text" autocomplete="off" id="daterange" value="@if($daterange){{$daterange}}@endif" name="daterange" class="daterange form-control" placeholder="">
    </div>
    <div class="col-sm-12 col-md-4">
        Branch
        <select class="form-select" id="branch" name="branch">
            <option value="">All Branches</option>
            {{-- @if(isset($subtype) && ($subtype!='stats_by_staff' && $subtype!='charts')) --}}
            <option value="branch-wise" @if($current_branch=="branch-wise") selected="selected" @endif>Branch-wise</option>
            {{-- @endif --}}
            @foreach($branch as $id => $name)
            <option value="{{ $id }}" @if($current_branch==$id) selected="selected" @endif>{{ $name }}</option>
            @endforeach
        </select>
    </div>
</div>

<div class="row mt-2">
    <div class="col-sm-12 col-md-12 text-center">
        <button type="submit" class="btn btn-primary btn-sm">Show Report</button>
        <button id="clear_report" class="btn btn-primary btn-sm">Clear</button>
    </div>
</div>

@push ('after-styles')
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
@endpush

@push ('after-scripts')
<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<script type="text/javascript">
    $(document).ready(function() {
        @if(!$daterange)
        var start = moment().subtract(29, 'days');
        var end = moment();
        
        $('.daterange').daterangepicker({
            //autoUpdateInput: false,
            "startDate": start,
            "endDate": end,
            locale: {
                format: 'DD-MM-YYYY',
                separator: " to ",
            }
        });
        @else
        $('.daterange').daterangepicker({
            //autoUpdateInput: false,
            locale: {
                format: 'DD-MM-YYYY',
                separator: " to ",
            }
        });
        @endif
        $('.daterange').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('DD-MM-YYYY') + ' to ' + picker.endDate.format('DD-MM-YYYY'));
        });
        $('.daterange').on('cancel.daterangepicker', function(ev, picker) {
            $(this).val('');
        });
    
        //Show/hide blocks on load
        @if($show_report == 'report_leads' && isset($subtype) && ($subtype == 'stats_by_status' || $subtype == 'stats_by_staff' || $subtype == 'charts'))
        $('#daterangediv').hide();
        @endif

        @if($show_report == 'report_leads' && isset($subtype) && ($subtype == 'stats_by_staff' || $subtype == 'charts' || $subtype == 'all_leads' || $subtype == 'converted_staff_wise'))
        $("#branch option[value='branch-wise']").hide();
        //$('#branch').prop('selectedIndex',0);
        @endif

        

        @if($show_report == 'report_students' && isset($subtype) && ($subtype == 'stats_by_status' || $subtype == 'stats_by_staff' || $subtype == 'charts'))
        $('#daterangediv').hide();
        @endif
        @if($show_report == 'report_students' && isset($subtype) && ($subtype == 'stats_by_staff' || $subtype == 'charts' || $subtype == 'all_students'))
        $("#branch option[value='branch-wise']").hide();
        $('#branch').prop('selectedIndex',0);
        @endif

        @if($show_report == 'report_student_referrals' && isset($subtype) && ($subtype == 'student_referrals' || $subtype == 'referral_commission_payout'))
        $("#branch option[value='branch-wise']").hide();
        // $('#branch').prop('selectedIndex',0);
        @endif


        @if($show_report == 'report_applications' && isset($subtype) && ($subtype == 'stats_by_status' || $subtype == 'stats_by_staff' || $subtype == 'charts'))
        $('#daterangediv').hide();
        @endif
        @if($show_report == 'report_applications' && isset($subtype) && ($subtype == 'stats_by_staff' || $subtype == 'charts' || $subtype == 'all_apps'))
        $("#branch option[value='branch-wise']").hide();
        $('#branch').prop('selectedIndex',0);
        @endif
        @if($show_report == 'report_sales' && isset($subtype) && ($subtype == 'charts'))
        $("#branch option[value='branch-wise']").hide();
        // $('#branch').prop('selectedIndex',0);
        @endif

        @if($show_report == 'report_staff' && isset($subtype) && ($subtype == 'follow_up'))
        $("#branch option[value='branch-wise']").hide();
        // $('#branch').prop('selectedIndex',0);
        @endif

        @if($show_report == 'report_agents' && isset($subtype) && ($subtype == 'charts'))
        $('#daterangediv').hide();
        @endif

        //

        $("#report").change(function() {
            if ($("#report").val() == 'report_leads') {
                window.location.replace('{{ route("admin.analytics.leadsreport") }}');
            } else if ($("#report").val() == 'report_students') {
                window.location.replace('{{ route("admin.analytics.studentsreport") }}');
            } 
            else if ($("#report").val() == 'report_student_referrals') {
                window.location.replace('{{ route("admin.analytics.student-referrals-report") }}');
            } 
            else if ($("#report").val() == 'report_staff') {
                window.location.replace('{{ route("admin.analytics.staffreport") }}');
            }
            else if ($("#report").val() == 'report_applications') {
                window.location.replace('{{ route("admin.analytics.applicationsreport") }}');
            } 
            else if ($("#report").val() == 'report_sales') {
                window.location.replace('{{ route("admin.analytics.salesreport") }}');
            } 
            else if ($("#report").val() == 'report_agents') {
                window.location.replace('{{ route("admin.analytics.agentsreport") }}');
            } 
            // else if ($("#report").val() == 'graph_students') {
            //     window.location.replace('{{ route("admin.analytics.studentsgraph") }}');
            // } else if ($("#report").val() == 'graph_leads') {
            //     window.location.replace('{{ route("admin.analytics.leadsgraph") }}');
            // } else if ($("#report").val() == 'graph_sales') {
            //     window.location.replace('{{ route("admin.analytics.salesgraph") }}');
            // }
        });

        @if($show_report == 'report_leads')
        $('#leads_subtype').change(function() {
            var subtype = $(this).val();
            if(subtype == 'stats_by_status') {
                $('#daterangediv').hide();
                $('#leadstatusdiv').hide();
                $("#branch option[value='branch-wise']").show();
            } else if(subtype == 'stats_by_staff') {
                $('#daterangediv,#b_wise').hide();
                $("#branch option[value='branch-wise']").hide();
                $('#branch').prop('selectedIndex',0);
                $('#leadstatusdiv').show();
            }
            else if(subtype == 'converted_staff_wise') {
                $('#b_wise').hide();
                $('#daterangediv').show();
                $("#branch option[value='branch-wise']").hide();
                $('#branch').prop('selectedIndex',0);
                $('#leadstatusdiv').hide();
            }
             else if(subtype == 'charts') {
                $('#daterangediv').hide();
                $('#leadstatusdiv').hide();
                $("#branch option[value='branch-wise']").hide();
                $('#branch').prop('selectedIndex',0);
            }else if(subtype == 'all_leads') {
                $('#daterangediv').show();
                $('#leadstatusdiv').hide();
                $("#branch option[value='branch-wise']").hide();
                $('#branch').prop('selectedIndex',0);
            }
             else {
                $("#branch option[value='branch-wise']").show();
                $('#daterangediv').show();
                $('#leadstatusdiv').hide();
            }
        });
        @elseif($show_report == 'report_applications')
        $('#appls_subtype').change(function() {
            var subtype = $(this).val();
            if(subtype == 'stats_by_status') {
                $('#daterangediv').hide();
                $('#leadstatusdiv').hide();
                $("#branch option[value='branch-wise']").show();
            } else if(subtype == 'stats_by_staff') {
                $('#daterangediv').hide();
                $("#branch option[value='branch-wise']").hide();
                $('#branch').prop('selectedIndex',0);
                $('#applstatusdiv').show();
            }else if(subtype == 'all_apps') {
                $('#daterangediv').show();
                $('#leadstatusdiv').hide();
                $("#branch option[value='branch-wise']").hide();
                $('#branch').prop('selectedIndex',0);
            }
             else if(subtype == 'charts') {
                $('#daterangediv').hide();
                $('#leadstatusdiv').hide();
                $("#branch option[value='branch-wise']").hide();
                $('#branch').prop('selectedIndex',0);
            } else {
                $("#branch option[value='branch-wise']").show();
                $('#daterangediv').show();
                $('#leadstatusdiv').hide();
            }
        });
        @elseif($show_report == 'report_students')
        $('#students_subtype').change(function() {
            var subtype = $(this).val();
            if(subtype == 'stats_by_status') {
                $('#daterangediv').hide();
                $("#branch option[value='branch-wise']").show();
            } else if(subtype == 'stats_by_staff') {
                $('#daterangediv').hide();
                $("#branch option[value='branch-wise']").hide();
                $('#branch').prop('selectedIndex',0);
            }else if(subtype == 'all_students') {
                $('#daterangediv').show();
                $("#branch option[value='branch-wise']").hide();
                $('#branch').prop('selectedIndex',0);
            }
             else if(subtype == 'charts') {
                $('#daterangediv').hide();
                $("#branch option[value='branch-wise']").hide();
                $('#branch').prop('selectedIndex',0);
            } else {
                $("#branch option[value='branch-wise']").show();
                $('#daterangediv').show();
            }
        });
        @elseif($show_report == 'report_staff')
        $("#branch option[value='branch-wise']").hide();
        $('#staff_subtype').change(function() {
            var subtype = $(this).val();
            if(subtype == 'stats_by_status') {
                $('#daterangediv').hide();
                $('#leadstatusdiv').hide();
                $("#branch option[value='branch-wise']").show();
            } else if(subtype == 'stats_by_staff') {
                $('#daterangediv,#b_wise').hide();
                $("#branch option[value='branch-wise']").hide();
                $('#branch').prop('selectedIndex',0);
                $('#leadstatusdiv').show();
            }else if(subtype == 'follow_up') {
                $('#daterangediv').show();
                $('#leadstatusdiv').hide();
                $("#branch option[value='branch-wise']").hide();
                $('#branch').prop('selectedIndex',0);
            }
             else if(subtype == 'charts') {
                $('#daterangediv').hide();
                $('#leadstatusdiv').hide();
                $("#branch option[value='branch-wise']").hide();
                $('#branch').prop('selectedIndex',0);
            } else {
                $("#branch option[value='branch-wise']").show();
                $('#daterangediv').show();
                $('#leadstatusdiv').hide();
            }
        }); 
        @elseif($show_report == 'report_agents')
        $("#branch option[value='branch-wise']").hide();
        $('#agents_subtype').change(function() {
            var subtype = $(this).val();
            if(subtype == 'charts') {
                $('#daterangediv').hide();
                $('#leadstatusdiv').hide();
                $("#branch option[value='branch-wise']").hide();
                $('#branch').prop('selectedIndex',0);
            } else {
                $("#branch option[value='branch-wise']").hide();
                $('#daterangediv').show();
                $('#leadstatusdiv').hide();
            }
        });       
        @endif

        $("#clear_report").click(function(e){
         e.preventDefault();
         window.location = "{{route('admin.analytics')}}";    
        });        

    });


</script>
@endpush