@extends('backend.layouts.app')

@section('title', "Analytics")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">

            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    Analytics
                </h4>
            </div>
            <!--col-->

            <div class="col-sm-7">
            </div>
            <!--col-->
        </div>
        <!--row-->
        <form class="" action="{{route('admin.analytics.salesreport')}}" method="get">
            @include('backend.analytics.report_filters')
        </form>

        <div class="row mt-4">
            <div class="col-sm-12 col-md-12">
                <div style="padding:50px;">
                    <h4>Sales</h4>
                    <canvas id="salesChart"></canvas>
                    <br />
                    <br />
                    <br />
                    
                </div>
            </div>
        </div>

    </div>
    <!--card-body-->
</div>
<!--card-->
@endsection

@push('after-scripts')
<script>
    const ctx = document.getElementById('salesChart');
    new Chart(ctx, {
        type: 'bar',
        data: {
            labels: [{!!implode(",", $sales_labels)!!}],
            datasets: [{
                label: 'Sales',
                data: [{!!implode(",", $sales_data)!!}],
                borderWidth: 2
            },
            {
                label: 'Receipts',
                data: [{!!implode(",", $invoice_data)!!}],
                borderWidth: 2,
            }
        ]
        },
        options: {
            scales: {
                y: {
                    beginAtZero: true,
                    title: {
                        display: true,
                        text: '{!!env('APP_CURRENCY')!!} ({!!env('APP_CURRENCY_SYMBOL')!!})'
                    }
                }
            }
        }
    });

</script>
@endpush