@extends('backend.layouts.app')

@section('title', "Analytics")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">

            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    Analytics
                </h4>
            </div>
            <!--col-->

            <div class="col-sm-7">
            </div>
            <!--col-->
        </div>
        <!--row-->

        <form class="" action="{{route('admin.analytics.staffreport')}}" method="get">
        @include('backend.analytics.report_filters')
        </form>
        @if($current_branch=="branch-wise")
        <div class="row mt-4">
            <div class="col-sm-12 col-md-10">
                <table class="table">
                    <th>
                        Branch
                    </th>
                    <th>
                        Profile Incomplete
                    </th>
                    <th>
                        Profile Completed
                    </th>
                    <th>
                        Course Preferences Added
                    </th>
                    <th>
                        Documents Uploaded
                    </th>
                    <th>
                        Application Processing
                    </th>
                    <th>
                        Application Rejected/Cancelled
                    </th>
                    <th>
                        Admission Complete
                    </th>
                    @if(count($branches))
                    <?php
                    if($daterange!=''){
                        $daterange = $daterange;
                    }
                    else {
                        $daterange='';
                    }
                    ?>
                    @foreach($branches as $branch)
                    <tr>
                        <td><strong>{{$branch->branch_name}}</strong></td>
                        <td style="min-width:80px;">
                            {{get_profile_status($branch->id,'Pending',$daterange)}}
                        </td>
                        <td style="min-width:80px;">
                            {{get_profile_status($branch->id,'Profile',$daterange)}}
                        </td>
                        <td style="min-width:80px;">
                            {{get_profile_status($branch->id,'Course Preferences',$daterange)}}
                        </td>
                        <td style="min-width:80px;">
                            {{get_profile_status($branch->id,'Documents',$daterange)}}
                        </td>
                        <td style="min-width:80px;">
                            {{get_profile_status($branch->id,'Application Processing',$daterange)}}
                        </td>
                        <td style="min-width:80px;">
                            {{get_profile_status($branch->id,'Application Rejected/Cancelled',$daterange)}}
                        </td>
                        <td style="min-width:80px;">
                            {{get_profile_status($branch->id,'Admission Complete',$daterange)}}
                        </td>

                    </tr>
                    @endforeach
                    @else
                    <tr><td colspan="4" style="text-align: center;">No results found.</td></tr>
                    @endif
                </table>
            </div>
        </div>
        @elseif($subtype == "follow_up")
        <div class="row mt-4">
            <div class="col table-responsive">
                <table class="table display nowrap" cellspacing="0" id="eductrl-sta-report-datatable" style="width:100%">
                    <thead>
                        <tr>
                        <th>Date</th>
                        <th class="select_data">Staff</th>
                        <th>Activity</th>
                        <th class="select_data">Communication Mode</th>
                        <th class="select_data">Application status</th>
                        <th>Student Name</th>
                        <th>Student Email</th>
                        <th>Student Mobile</th>
                        <th class="select_data">Branch</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($activities as $activity)
                        <tr>
                            <td>{{date('d M, g:ia', strtotime($activity->created_at))}}</td>
                            <td>{{$activity->staff ? get_user_full_name_by_id($activity->staff) : "--"}}</td>
                            <td>{!!$activity->detail!!}</td>
                            <td>{{{$activity->communication_mode}}}</td>
                            <td>{{{$activity->application_status}}}</td>
                            <td>
                                <p class="mb-0"><strong><a target="_blank" href="{{route('admin.auth.user.show', $activity->id)}}">{{$activity->first_name . ' ' . $activity->last_name}}</a></strong></p>
                            </td>
                            <td>
                                {{$activity->email}}
                            </td>
                            <td>
                                @if ($activity->mobile)
                                    @if ($activity->dialcode != '')
                                        <?php $mob = '+' . $activity->dialcode . '-' . $activity->mobile;?>
                                    @else
                                        <?php $mob = $activity->mobile;?>
                                    @endif
                                    {{$mob}}
                                @endif
                            </td>
                               <td>
                                @if($activity->branch)
                                    {{branch_name($activity->branch)}}
                                @endif
                               </td>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        @else
        <div class="row mt-4">
            <div class="col-sm-12 col-md-6">
                <table class="table">
                    <th>
                        Staff
                    </th>
                    <th>
                        Follow-ups Done
                    </th>
                    <th>
                        Counselling Done
                    </th>
                    {{-- <th>
                        Application Updates
                    </th> --}}
                    @if(count($staff_stats))
                    @foreach($staff_stats as $stats)
                    <tr>
                        <td>{{$stats->first_name.' '.$stats->last_name}}</td>
                        <td style="min-width:80px;">{{$stats->followup_count}}</td>
                        <td style="min-width:80px;">{{$stats->counselling_count}}</td>
                    </tr>
                    @endforeach
                    @else
                    <tr><td colspan="4" style="text-align: center;">No results found.</td></tr>
                    @endif
                </table>
            </div>
        </div>        
        @endif
    </div>
    <!--card-body-->
</div>
<!--card-->
@endsection
@push('after-scripts')
<script>
    var table = $('#eductrl-sta-report-datatable').DataTable({
                "dom": '<"row"<"col-md-3 text-start"l><"col-md-5 text-start"f><"col-md-4 text-end"B>>rtip',                
                "ordering": false,
                "lengthMenu": [100, 200, 500],
                "drawCallback": function( settings ) {
                    addDeleteForms();
                },
                initComplete: function () {
                    this.api().columns('.select_data').every( function () {
                        var column = this;
                        var colTitle = this.header().innerHTML;
                        var select = $('<select class="form-select" style="width:auto;"><option value="" selected>' + colTitle + '</option></select>')
                            .appendTo( $(column.header()).empty() )
                            .on( 'change', function () {
                                var val = $.fn.dataTable.util.escapeRegex(
                                    $(this).val()
                                );

                                column.search( val ? '^'+val+'$' : '', true, false ).draw();
                            } );

                        column.data().unique().sort().each( function ( d, j ) {
                            if(d !=''){
                                select.append( '<option value="'+d+'">'+d+'</option>' )
                            }
                        } );
                    } );
                },
                "buttons": [{
                    extend: 'excel',
                    text: '<i class="ri-file-excel-2-line export-btn-size" ></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: 
                    {
                    stripHtml: true,
                    }
                },
                {
                    extend: 'copy',
                    text: '<i class="ri-file-copy-2-line export-btn-size"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: 
                    {
                    stripHtml: true,
                    }
                },
                {
                    extend: 'csv',
                    text: '<i class="ri-file-excel-line export-btn-size"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: 
                    {
                    stripHtml: true,
                    }
                },
            ]
            });

var el_up = document.getElementById('GFG_UP');
if ($('#eductrl-sta-report-datatable').attr("data-datatable-nopaging") == 1) {
    $('#eductrl-sta-report-datatable').dataTable({
        "paging": false
    });
}
</script>
@endpush

