@extends('backend.layouts.app')

@section('title', "Analytics")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">

            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    Analytics - Student Referrals
                </h4>
            </div>
            <!--col-->

            <div class="col-sm-7">
            </div>
            <!--col-->
        </div>
        <!--row-->

        <form class="" action="{{route('admin.analytics.student-referrals-report')}}" method="get">
        @include('backend.analytics.report_filters')
        </form>
        @if($subtype == "student_referrals")
        <div class="row mt-4">
            <div class="col table-responsive">
                <table class="table display nowrap" cellspacing="0" id="eductrl-student-referrals-report-datatable" style="width:100%">
                    <thead>
                        <tr>
                        <th>Sl No.</th>
                        <th>Date</th>
                        <th>Name</th>
                        <th>Referred By</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $slno = 1; ?>
                        @foreach($student_referrals as $reffs)
                        <tr>
                            <td>{{$slno}}</td>
                            <td>{{$reffs->created_at}}</td>
                            <td><a target="_blank" href="{{route('admin.auth.user.show', $reffs->uid)}}"><b>{{$reffs->user_full_name}}</b></a>
                                <p>ID: {{$reffs->uid}}</p>
                            </td>
                            <td><a target="_blank" href="{{route('admin.auth.user.show', $reffs->rid)}}"><b>{{$reffs->referred_by}}</b></a>
                                <p>ID: {{$reffs->rid}}</p>
                            </td>
                        </tr>
                        <?php $slno++; ?>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        @elseif($subtype == "referral_commission_payout")
        <div class="row mt-4">
            <div class="col table-responsive">
                <table class="table display nowrap" cellspacing="0" id="eductrl-referral-commission-payout-datatable" style="width:100%">
                    <thead>
                        <tr>
                        <th>Sl No.</th>
                        <th>Date</th>
                        <th>Affiliate</th>
                        <th>Commission Paid</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $slno = 1; ?>
                        @foreach($referrals_payouts as $payout)
                        <tr>
                            <td>{{$slno}}</td>
                            <td>{{$payout->created_at}}</td>
                            <td><a target="_blank" href="{{route('admin.auth.user.show', $payout->rid)}}"><b>{{$payout->ref_full_name}}</b></a>
                                <p>ID: {{$payout->rid}}</p>
                            </td>
                            <td>{{config('app.currency_symbol')}}{{$payout->total_reward}}</td>
                        </tr>
                        <?php $slno++; ?>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        @endif
    </div>
    <!--card-body-->
</div>
<!--card-->
@endsection
@push('after-scripts')
<script>
    var table = $('#eductrl-student-referrals-report-datatable').DataTable({
                "dom": '<"row"<"col-md-3 text-start"l><"col-md-5 text-start"f><"col-md-4 text-end"B>>rtip',                
                "ordering": false,
                "lengthMenu": [200, 400, 500, 800, 1000],
                "drawCallback": function( settings ) {
                    addDeleteForms();
                },
                "buttons": [{
                    extend: 'excel',
                    text: '<i class="ri-file-excel-2-line export-btn-size" ></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: 
                    {
                    stripHtml: true,
                }},
                {
                    extend: 'copy',
                    text: '<i class="ri-file-copy-2-line export-btn-size"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: 
                    {
                    stripHtml: true,
                    }
                },
                {
                    extend: 'csv',
                    text: '<i class="ri-file-excel-line export-btn-size"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: 
                    {
                    stripHtml: true,
                    }
                },
            ]
            });

var payoutTable = $('#eductrl-referral-commission-payout-datatable').DataTable({
                "dom": '<"row"<"col-md-3 text-start"l><"col-md-5 text-start"f><"col-md-4 text-end"B>>rtip',                
                "ordering": false,
                "lengthMenu": [200, 400, 500, 800, 1000],
                "drawCallback": function( settings ) {
                    addDeleteForms();
                },
                "buttons": [{
                    extend: 'excel',
                    text: '<i class="ri-file-excel-2-line export-btn-size" ></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: 
                    {
                    stripHtml: true,
                }},
                {
                    extend: 'copy',
                    text: '<i class="ri-file-copy-2-line export-btn-size"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: 
                    {
                    stripHtml: true,
                    }
                },
                {
                    extend: 'csv',
                    text: '<i class="ri-file-excel-line export-btn-size"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: 
                    {
                    stripHtml: true,
                    }
                },
            ]
            });

</script>
@endpush


