@extends('backend.layouts.app')

@section('title', "Analytics")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">

            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    Analytics
                </h4>
            </div>
            <!--col-->

            <div class="col-sm-7">
            </div>
            <!--col-->
        </div>
        <!--row-->
        <form class="" action="{{route('admin.analytics.studentsreport')}}" method="get">
            @include('backend.analytics.report_filters')
        </form>

        <div class="row mt-4">
            <div class="col-sm-12 col-md-12">
                <div style="padding:50px;">
                    <h4>All Students</h4>
                    <canvas id="allStudentsChart"></canvas>
                    <br />
                    <br />
                    <br />
                    <h4>Students Added</h4>
                    <canvas id="studentsAddedChart"></canvas>
                    <br />
                    <br />
                    <br />
                    <h4>Lead to Student</h4>
                    <canvas id="leadsToStudentChart"></canvas>
                </div>
            </div>
        </div>

    </div>
    <!--card-body-->
</div>
<!--card-->
@endsection

@push('after-scripts')
<script>
    const ctx = document.getElementById('allStudentsChart');
    new Chart(ctx, {
        type: 'line',
        data: {
            labels: [{!!implode(",", $all_students_labels)!!}],
            datasets: [{
                label: '# of Students',
                data: [{!!implode(",", $all_students_data)!!}],
                borderWidth: 2
            }]
        },
        options: {
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });

    const ctx2 = document.getElementById('studentsAddedChart');
    new Chart(ctx2, {
        type: 'line',
        data: {
            labels: [{!!implode(",", $students_added_labels)!!}],
            datasets: [{
                label: '# of Students',
                data: [{!!implode(",", $students_added_data)!!}],
                borderWidth: 2
            }]
        },
        options: {
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });

    const ctx3 = document.getElementById('leadsToStudentChart');
    new Chart(ctx3, {
        type: 'line',
        data: {
            labels: [{!!implode(",", $lead_to_student_labels)!!}],
            datasets: [{
                label: '# of Students',
                data: [{!!implode(",", $lead_to_student_data)!!}],
                borderWidth: 2
            }]
        },
        options: {
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });

</script>
@endpush