@extends('backend.layouts.app')

@section('title', "Analytics")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">

            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    Analytics
                </h4>
            </div>
            <!--col-->

            <div class="col-sm-7">
            </div>
            <!--col-->
        </div>
        <!--row-->

        <form class="" action="{{route('admin.analytics.studentsreport')}}" method="get">
        @include('backend.analytics.report_filters')
        </form>
        @if($current_branch=="branch-wise")
        <div class="row mt-4">
            <div class="col-sm-12 col-md-10">
                <table class="table">
                    <th>
                        Branch
                    </th>
                    <th>
                        Profile Incomplete
                    </th>
                    <th>
                        Profile Completed
                    </th>
                    <th>
                        Course Preferences Added
                    </th>
                    <th>
                        Documents Uploaded
                    </th>
                    <th>
                        Application Processing
                    </th>
                    <th>
                        Application Rejected/Cancelled
                    </th>
                    <th>
                        Admission Complete
                    </th>
                    @if(count($branches))
                    <?php
                    if($daterange!=''){
                        $daterange = $daterange;
                    }
                    else {
                        $daterange='';
                    }
                    ?>
                    @foreach($branches as $branch)
                    <tr>
                        <td><strong>{{$branch->branch_name}}</strong></td>
                        <td style="min-width:80px;">
                            {{get_profile_status($branch->id,'Pending',$daterange)}}
                        </td>
                        <td style="min-width:80px;">
                            {{get_profile_status($branch->id,'Profile',$daterange)}}
                        </td>
                        <td style="min-width:80px;">
                            {{get_profile_status($branch->id,'Course Preferences',$daterange)}}
                        </td>
                        <td style="min-width:80px;">
                            {{get_profile_status($branch->id,'Documents',$daterange)}}
                        </td>
                        <td style="min-width:80px;">
                            {{get_profile_status($branch->id,'Application Processing',$daterange)}}
                        </td>
                        <td style="min-width:80px;">
                            {{get_profile_status($branch->id,'Application Rejected/Cancelled',$daterange)}}
                        </td>
                        <td style="min-width:80px;">
                            {{get_profile_status($branch->id,'Admission Complete',$daterange)}}
                        </td>

                    </tr>
                    @endforeach
                    @else
                    <tr><td colspan="4" style="text-align: center;">No results found.</td></tr>
                    @endif
                </table>
            </div>
        </div>
        @elseif($subtype == "all_students")

        <div class="row mt-4">
            <div class="col table-responsive">
                <table class="table display nowrap" cellspacing="0" id="eductrl-stu-report-datatable" style="width:100%">
                    <thead>
                        <tr>
                        <th>ID</th>
                        <th>Student</th>
                        <th>Email</th>
                        <th>Mobile</th>
                        <th>Whatsapp</th>
                        <th>Alt. Contact</th>
                        <th class="select_data">Gender</th>
                        <th class="">DOB</th>
                        <th>City</th>
                        <th class="select_data">State</th>
                        <th class="select_data">Country</th>
                        <th class="select_data">Study Level</th>
                        <th class="">Country Interested to Study</th>
                        <th class="">Course Interested to Study</th>
                        <th class="select_data">Intake Month</th>
                        <th class="select_data">Intake Year</th>
                        <th class="select_data">Qualification</th>
                        <th class="">Passout Year</th>
                        <th class="">Score/Grade</th>
                        <th class="">Currently Studying Course</th>
                        <th class="">Work Exp.</th>
                        <th class="">Lead Source</th>
                        <th class="">Source Details</th>
                        <th class="select_data">Campaign Name</th>
                        <th class="select_data">Lead Ad Name</th>
                        <th class="select_data">Lead Form Name</th>
                        <th class="select_data">Lead Lead ID</th>
                        <th class="select_data">Branch</th>
                        <th class="select_data">Agent</th>
                        <th class="select_data">Status</th>
                        <th class="select_data">Deleted?</th>
                        <th>Assigned to</th>
                        <th>Signed Up</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($students as $student)
                        <tr>
                            <td>{{$student->id}}</td>
                            <td>
                                <p class="mb-0"><strong><a target="_blank" href="{{route('admin.auth.user.show', $student->id)}}">{{$student->first_name . ' ' . $student->last_name}}</a></strong></p>
                            </td>
                                <td>
                                @if($student->email)
                                    {{$student->email}}
                                @endif
                                </td>
                                <td>
                                @if ($student->mobile)
                                    @if ($student->dialcode != '')
                                        <?php $mob = '+' . $student->dialcode . '-' . $student->mobile;?>
                                    @else
                                        <?php $mob = $student->mobile;?>
                                    @endif
                                    {{$mob}}
                                @else
                                --
                                @endif
                                </td>
                                <td>
                                @if ($student->whatsapp) 
                                    @if ($student->dialcode != '')
                                        <?php $whtsp = '+' . $student->dialcode . '-' . $student->whatsapp;?>
                                    @else
                                        <?php $whtsp = $student->whatsapp;?>
                                    @endif
                                    {{$whtsp}}
                                @else
                                --
                                @endif
                                </td>
                                <td>
                                @if ($student->alternate_contact) 
                                    <?php $alt_cntct = $student->alternate_contact;?>
                                    {{$alt_cntct}}
                                @else
                                --
                                @endif
                                </td>
                                <td>{{$student->gender}}</td>
                                <td>{{($student->birthday) ? date('d-m-Y', strtotime($student->birthday)): '--'}}</td>
                                <td>
                                    @if ($student->city)
                                        {{get_city_name($student->city)}}
                                    @else
                                    --
                                    @endif
                                </td>
                                <td>
                                    @if ($student->state)
                                        {{get_state_name($student->state)}}
                                    @else
                                    --
                                    @endif
                                </td>
                                <td>
                                    @if ($student->country)
                                        {{get_country_name($student->country)}}
                                    @else
                                    --
                                    @endif
                                </td>
                               
                                <td>{{($student->overseas_study_level) ? $student->overseas_study_level : '--'}}</td>
                                <td>{{($student->country_interested)? $student->country_interested : '--'}}</td>
                                <td>{{($student->overseas_course_intersted) ? $student->overseas_course_intersted : '--'}}</td>
                                <td>{{($student->intake_month) ? date("F", mktime(0, 0, 0, $student->intake_month, 10)) : '--'}}</td>
                                <td>{{($student->intake_year) ? $student->intake_year : '--'}}</td>
                                <td>{{($student->highest_level_education)? $student->highest_level_education : '--'}}</td>
                                <td>{{($student->passout_year)? $student->passout_year : '--'}}</td>
                                <td>{{($student->qualification_score)? $student->qualification_score : '--'}}</td>
                                <td>{{($student->current_course)? $student->current_course : '--'}}</td>
                                <td>{{($student->work_experience)? $student->work_experience : '--'}}</td>
                                <td>{{($student->lead_source)? $student->lead_source : '--'}}</td>
                                <td>{{($student->lead_source_detail)? $student->lead_source_detail : '--'}}</td>
                                <td>{{($student->lead_campaign_name)? $student->lead_campaign_name : '--'}}</td>
                                <td>{{($student->lead_ad_name)? $student->lead_ad_name : '--'}}</td>
                                <td>{{($student->lead_form_name)? $student->lead_form_name : '--'}}</td>
                                <td>{{($student->lead_lead_id)? $student->lead_lead_id : '--'}}</td>

                                <td>
                                    @if($student->branch)
                                        {{branch_name($student->branch)}}
                                    @endif
                                </td>
                                <td>
                                    {{($student->agent_id)? get_user_full_name_by_id($student->agent_id) : '--'}}
                                </td>
                            <td>
                                {{$student->overseas_status}}
                            </td>   
                            <td>
                                @if ($student->trashed())
                                    Deleted
                                @endif
                            </td>
                            <td>{{$student->assigned_to ? get_user_full_name_by_id($student->assigned_to) : "--"}}</td>
                            <td>{{date('d M Y, g:ia', strtotime($student->created_at))}}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        @else
        <div class="row mt-4">
            <div class="col-sm-12 col-md-6">
                <table class="table">
                    @foreach($student_status_stats as $status => $count)
                    <tr>
                        <td>{{$status}}</td>
                        <td style="min-width:80px;">{{$count}}</td>
                    </tr>
                    @endforeach
                </table>
            </div>
        </div>        
        @endif
    </div>
    <!--card-body-->
</div>
<!--card-->
@endsection
@push('after-scripts')
<script>
    var table = $('#eductrl-stu-report-datatable').DataTable({
                "dom": '<"row"<"col-md-3 text-start"l><"col-md-5 text-start"f><"col-md-4 text-end"B>>rtip',                
                "ordering": false,
                "lengthMenu": [100, 200, 500],
                "drawCallback": function( settings ) {
                    addDeleteForms();
                },
                initComplete: function () {
                    this.api().columns('.select_data').every( function () {
                        var column = this;
                        var colTitle = this.header().innerHTML;
                        var select = $('<select class="form-select" style="width:auto;"><option value="" selected>' + colTitle + '</option></select>')
                            .appendTo( $(column.header()).empty() )
                            .on( 'change', function () {
                                var val = $.fn.dataTable.util.escapeRegex(
                                    $(this).val()
                                );

                                column.search( val ? '^'+val+'$' : '', true, false ).draw();
                            } );

                        column.data().unique().sort().each( function ( d, j ) {
                            if(d !=''){
                                select.append( '<option value="'+d+'">'+d+'</option>' )
                            }
                        } );
                    } );
                },
                "buttons": [{
                    extend: 'excel',
                    text: '<i class="ri-file-excel-2-line export-btn-size" ></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: 
                    {
                    stripHtml: true,
                    format: {
                        header: function ( data, columnIdx ) {
                                if(columnIdx==6){
                                    return 'Gender';
                                }
                                else if(columnIdx==9){
                                    return 'State';
                                }
                                else if(columnIdx==10){
                                    return 'Country';
                                }
                                else if(columnIdx==11){
                                    return 'Study Level';
                                }
                                // else if(columnIdx==12){
                                //     return 'Country Interested to Study';
                                // }
                                // else if(columnIdx==13){
                                //     return 'Course Interested to Study';
                                // }
                                else if(columnIdx==14){
                                    return 'Intake Month';
                                }
                                else if(columnIdx==15){
                                    return 'Intake Year';
                                }
                                else if(columnIdx==16){
                                    return 'Qualification';
                                }
                                // else if(columnIdx==17){
                                //     return 'Passout Year';
                                // }
                                // else if(columnIdx==18){
                                //     return 'Score/Grade';
                                // }
                                // else if(columnIdx==19){
                                //     return 'Currently Studying Course';
                                // }
                                // else if(columnIdx==20){
                                //     return 'Work Exp.';
                                // }
                                // else if(columnIdx==21){
                                //     return 'IELTS';
                                // }
                                // else if(columnIdx==22){
                                //     return 'TOEFL';
                                // }
                                // else if(columnIdx==23){
                                //     return 'PTE';
                                // }
                                // else if(columnIdx==24){
                                //     return 'GRE';
                                // }
                                // else if(columnIdx==25){
                                //     return 'DUOLINGO';
                                // }
                                // else if(columnIdx==26){
                                //     return 'Accomodation?';
                                // }
                                // else if(columnIdx==27){
                                //     return 'Study Permit?';
                                // }
                                // else if(columnIdx==28){
                                //     return 'Education Loan?';
                                // }
                                // else if(columnIdx==29){
                                //     return 'Lead Source';
                                // }
                                // else if(columnIdx==30){
                                //     return 'Source Details';
                                // }
                                else if(columnIdx==23){
                                    return 'Campaign Name';
                                }
                                else if(columnIdx==24){
                                    return 'Lead Ad Name';
                                }
                                else if(columnIdx==25){
                                    return 'Lead Form Name';
                                }
                                else if(columnIdx==26){
                                    return 'Lead Lead ID';
                                }
                                else if(columnIdx==27){
                                    return 'Branch';
                                }
                                else if(columnIdx==28){
                                    return 'Agent';
                                }
                                else if(columnIdx==29){
                                    return 'Status';
                                }
                                else if(columnIdx==30){
                                    return 'Deleted?';
                                }
                                else{
                                return data;
                                }
                            },
                    },
                }},
                {
                    extend: 'copy',
                    text: '<i class="ri-file-copy-2-line export-btn-size"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: 
                    {
                    stripHtml: true,
                    }
                },
                {
                    extend: 'csv',
                    text: '<i class="ri-file-excel-line export-btn-size"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: 
                    {
                    stripHtml: true,
                    }
                },
            ]
            });

var el_up = document.getElementById('GFG_UP');
if ($('#eductrl-stu-report-datatable').attr("data-datatable-nopaging") == 1) {
    $('#eductrl-stu-report-datatable').dataTable({
        "paging": false
    });
}
</script>
@endpush


