@extends('backend.layouts.app')

@section('title', "Analytics")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">

            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    Analytics
                </h4>
            </div>
            <!--col-->

            <div class="col-sm-7">
            </div>
            <!--col-->
        </div>
        <!--row-->

        @include('backend.analytics.report_filters')

        <div class="row mt-4">
            <div class="col">
                <div class="">
                    <table class="table" id="data_table">
                        <thead>
                            <tr>
                                <th>First Name</th>
                                <th>Middle Name</th>
                                <th>Last Name</th>
                                <th>Email</th>
                                <th>Mobile</th>
                                <th>Title</th>
                                <th>Interested In</th>
                                <th>Branch</th>
                                <th>Country Preference</th>
                                <th>Address</th>
                                <th>Postal Code</th>
                                <th>City</th>
                                <th>State</th>
                                <th>Country</th>
                                <th>DOB</th>
                                <th>Signed Up</th>
                                <th>Active</th>
                                <th>Deleted</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>

    </div>
    <!--card-body-->
</div>
<!--card-->
@endsection



@push ('after-scripts')

<script type="text/javascript">
    let datatable = '';
    $(document).ready(function() {
        loadData();
    });

    function showReport() {
        datatable.destroy();
        loadData();
    }

    function loadData() {
        datatable = $('#data_table').DataTable({
            "dom": '<"row"<"col-md-3 text-start"l><"col-md-5 text-start"f><"col-md-4 text-end"B>>rtip',
            processing: true,
            serverSide: true,
            "pageLength": 10,
            lengthMenu: [10, 25, 50, 100, 200, 500],
            scrollX: true,
            "searching": false,
            "ajax": {
                "url": "{{route('admin.analytics.studentsreportdata')}}",
                "dataType": "json",
                "type": "post",
                data: {
                    '_token': $('meta[name="csrf-token"]').attr('content'),
                    'report': $('#report').val(),
                    'date_from': $('#date_from').val(),
                    'date_to': $('#date_to').val(),
                    'branch': $('#branch').val(),
                },
            },
            order: [
                [14, 'desc']
            ],
            columns: [{
                    data: 'first_name',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'middle_name',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'last_name',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'email',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'mobile',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'title',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'student_type',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'branch',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'country_interested',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'address',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'post_code',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'city',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'state',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'country',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'birthday',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'created_at',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'active',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'deleted_at',
                    orderable: false,
                    searchable: false
                },
            ],
            "buttons": [{
                    extend: 'excel',
                    text: '<i class="ri-file-excel-2-line export-btn-size" ></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                },
                {
                    extend: 'pdf',
                    text: '<i class="bi bi-file-earmark-pdf"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    orientation: 'landscape',
                    pageSize: 'A3',
                },
                {
                    extend: 'print',
                    text: '<i class="bi bi-printer"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                },
                {
                    extend: 'copy',
                    text: '<i class="ri-file-copy-2-line export-btn-size"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                },
                {
                    extend: 'csv',
                    text: '<i class="ri-file-excel-line export-btn-size"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                },
            ]
        });
    }

</script>
@endpush