@extends('backend.layouts.app')

@push('after-styles')
<link rel="stylesheet" href="{{ asset('assets/plugins/html5-editor/bootstrap-wysihtml5.css') }} " />
@endpush

@section('title', "Create Announcement")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">Create Announcement</h4>
            </div><!--col-->
        </div><!--row-->

        <div class="row mt-4">
            <div class="col-md-8">
            {{ html()->form('POST', route('admin.announcements.save'))->class('form-horizontal')->open() }}
                <div style="margin-top:10px;">
                    <div class="form-group mb-3">
                            <?php
                            $field_name = 'area';
                            $field_label = 'Area';
                            $field_placeholder = __("Select an option");
                            $required = "required";
                            $select_options = [
                                'agent' => 'Agent Panel',
                            ];
                            ?>
                            {{ html()->label($field_label, $field_name)->class('required-field') }}
                            {{ html()->select($field_name, $select_options)->id('area')->placeholder($field_placeholder)->class('form-control form-select')->required() }}
                    </div>
                    <div class="form-group mb-3">
                        <label>Title</label>
                        <input type="text" name="title" class="form-control" maxlength="200" required>
                    </div>
                    <!-- <div class="form-group mb-3">
                        <label>Message</label>
                        <textarea name='message' rows="10" class="form-control" required></textarea>
                    </div> -->
                    <div class="row mt-4">
                        <div class="col-12">
                            <div class="form-group">
                                <?php
                                $field_name = 'message';
                                $field_lable = "Message";
                                $field_placeholder = '';
                                $required = ""; 
                                ?>
                                {{ html()->label($field_lable, $field_name)}} 
                                {{ html()->textarea($field_name)->id("message")->placeholder($field_placeholder)->class('form-control ckeditor_toolbar_all') }}
                                
                                <br>
                            </div>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <?php $field_name = "published_at"; $field_placeholder = "Published At";?>
                            {{ html()->label("Published At", "published_at") }} 
                            {{ html()->text($field_name)->placeholder($field_placeholder)->class('date form-control')->id('published_at_datepicker') }}
                        </div>
                    </div>

                    <div class="form-group" style="text-align: center;margin-top:50px;">
                        {{ form_submit("Create") }}
                        <a href="{{ route('admin.announcements') }}" class="btn btn-secondary btn-sm waves-effect waves-light" title="Cancel">Cancel</a>
                    </div>
                </div>
                {{ html()->form()->close() }}
            </div>
        </div>
    </div>
</div>
@endsection

@push('after-scripts')
<script>
    $(document).ready(function() {
       
        $('#published_at_datepicker').datetimepicker({
            timepicker: true,
            format: 'd-M-Y H:i',
            minDate: '0',
        });
    });
</script>
@endpush
