@extends('backend.layouts.app')

@push('after-styles')
<link rel="stylesheet" href="{{ asset('assets/plugins/html5-editor/bootstrap-wysihtml5.css') }} " />
@endpush

@section('title', "Edit Announcement")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">Edit Announcement</h4>
            </div><!--col-->
        </div><!--row-->

        <div class="row mt-4">
            <div class="col-md-8">
            {{ html()->form('PATCH', route('admin.announcements.update', $ann->id))->class('form-horizontal')->open() }}
                <div style="margin-top:10px;">
                    <div class="form-group mb-3">
                            <?php
                            $field_name = 'area';
                            $field_label = 'Panel';
                            $value = $ann->area;
                            $required = "required";
                            $select_options = [
                                'agent' => 'Agent Panel',
                            ];
                            ?>
                            {{ html()->label($field_label, $field_name)->class('required-field') }}
                            {{ html()->select($field_name, $select_options)->id('area')->value($value)->class('form-control form-select')->required() }}
                    </div>
                    <div class="form-group mb-3">
                        <label>Title</label>
                        <input type="text" name="title" class="form-control" maxlength="200" value="{{$ann->title}}" required>
                    </div>
                    <!-- <div class="form-group mb-3">
                        <label>Message</label>
                        <textarea name='message' rows="10" class="form-control" required></textarea>
                    </div> -->
                    <div class="row mt-4">
                        <div class="col-12">
                            <div class="form-group">
                                <?php
                                $field_name = 'message';
                                $field_lable = "Message";
                                $value = $ann->message;
                                $required = ""; 
                                ?>
                                {{ html()->label($field_lable, $field_name)}} 
                                {{ html()->textarea($field_name)->id("message")->value($value)->class('form-control ckeditor_toolbar_all') }}
                                
                            </div>
                        </div>
                    </div>
                    <br>
                    <div class="col-6">
                        <div class="form-group">
                            <?php $field_name = "published_at"; $value = $ann->published_at;?>
                            {{ html()->label("Published At", "published_at") }} 
                            {{ html()->text($field_name)->value($value)->class('date form-control')->id('published_at_datepicker') }}
                        </div>
                    </div>

                    <div class="form-group" style="text-align: center;margin-top:50px;">
                        {{ html()->submit($text = " Update")->class('btn btn-primary btn-sm') }}
                        <a href="{{ route('admin.announcements') }}" class="btn btn-secondary btn-sm waves-effect waves-light" title="Cancel">Cancel</a>
                    </div>
                    
                </div>
                {{ html()->form()->close() }}
            </div>
        </div>
    </div>
</div>
@endsection

@push('after-scripts')
<script>
    $(document).ready(function() {
       
        $('#published_at_datepicker').datetimepicker({
            timepicker: true,
            format: 'd-M-Y H:i',
            minDate: '0',
        });
    });
</script>
@endpush
