@extends('backend.layouts.app')

@section('title', "Announcements")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5 col-5">
                <h4 class="card-title mb-0">Announcements</h4>
            </div><!--col-->
            <div class="col-sm-7 col-7">
                <div class="btn-toolbar float-right" role="toolbar" aria-label="New Announcements" style="margin-top: 20px;float: right;">
                    <a href="{{ route('admin.announcements.create') }}" class="btn btn-primary btn-sm ml-1" data-toggle="tooltip" title="Add New Announcements"><i class="bi bi-plus-circle"></i> Create</a>
                </div><!--btn-toolbar-->
            </div><!--col--> 
        </div><!--row-->

        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive">
                    <table id="announcements-list" class="table table-hover">
                        <thead>
                            <tr>
                                <th>Title</th>
                                <th>Area</th>
                                <th>Created By</th>
                                <th>Published At</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
{!! csrf_field() !!}
@endsection

@push ('after-scripts')
<script type="text/javascript">
$(document).ready(function () {
    $('#announcements-list').DataTable({
        processing: true,
        serverSide: true,
        "language": {
            searchPlaceholder: "Search By Title and Area"
        },
        "lengthMenu" : [25,50,100],
        "ajax": {
            "url": "{{ route('admin.ajaxannouncementslist') }}",
            "dataType": "json",
            "type": "post",
            "data": { '_token': $('meta[name="csrf-token"]').attr('content')},
        }, 
        "drawCallback": function(settings) {
            addDeleteForms();
        },
        "order": [ 3, "desc" ],
        autoWidth: true,
        responsive: true,
        columns: [
            {data: 'title'},
            {data: 'area'},
            {data: 'created_by'},
            {data: 'published_at'},
            {data: 'actions'},
        ]
    });
});
</script>
@endpush
