@extends('backend.layouts.app')

@section('title', "Announcements")

@section('content')
<div class="container mt-5">
        <div class="row">
            <div class="col-md-12 mt-1">
                <h4>Announcements</h4>
                <br>
                <div class="announcement-list">
					@if($announcements && $announcements->count() > 0)
						@foreach($announcements as $announcement)
							{{-- @if(\Carbon\Carbon::now()->greaterThan($announcement->published_at)) --}}
								<div class="announcement-card">
									<div class="announcement-title">
										<a href="{{ route('admin.agent_announcement', ['id' => $announcement->id]) }}"><h3 id="t1">{{ $announcement->title }} </h3></a>
									</div>
									<hr>
									<div class="announcement-date">
										<i class="far fa-calendar-alt"></i> <i>{{ \Carbon\Carbon::parse($announcement->published_at)->format('d M Y') }}</i>
									</div>
									<div class="announcement-message">
										{{ \Illuminate\Support\Str::limit($announcement->message, 150) }}<a href="{{ route('admin.agent_announcement', ['id' => $announcement->id]) }}">
										read more</a>
									</div>
								</div>
							{{-- @endif --}}
						@endforeach
					@else
						<p>No announcements found!</p>
					@endif    
                </div>
            </div>
        </div>
    </div>
@endsection

@push('after-styles')
  <style>
    
    /* .announcement-list {
      max-height: 400px;
      overflow-y: auto;
    } */
    .announcement-card {
      margin-bottom: 20px;
      padding: 20px;
      transition: box-shadow 0.3s ease-in-out;
      /* background: rgb(240,248,255); */
      box-shadow: 0px 0px 15px 0px rgba(0,0,0,0.1);
    }
    
    #t1 {
      font-weight: bold;
      color: #333;
    }
    .announcement-date {
      font-size: 14px;
      color: #777;
      margin-bottom: 10px;
    }
    .announcement-message {
      font-size: 16px;
      color: #555;
    }
    
  </style>
  @endpush