@extends('backend.layouts.app')

@section('title', "Agent Commission")

@section('content')

<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-12">
                <h4 class="card-title mb-0">
                    Agent Commission
                    <small class="text-muted">University Applications #{{$data->appl_id}}</small>
                </h4>
                <hr>
            </div>
            <!--col-->
        </div>
        <!--row-->

        <div class="row">
            <div class="col-sm-12 col-md-6">
                <h6>User</h6>
                <h4>{{ $student->full_name }}</h4>
                <p>Email: {{$student->email}} Ph:{{$student->mobile}}</p>
                <h5><small class="text-muted">{{ $data->course }} / {{ $data->university }} / {{ $data->country }}</small></h5>
            </div>
            <div class="col-sm-12 col-md-6">
                <h6>Agent</h6>
                <h4>{{ $agent->full_name }}</h4>
                <p>Email: {{$agent->email}} Ph:{{$agent->mobile}}</p>
            </div>
        </div>
<hr>
{{ html()->form('POST', route('admin.applications.agentcommissionupdate'))->class('form-horizontal')->open() }}
<input type="hidden" name="app_id" value="{{$data->id}}">
        <div class="row m-b-10">
            <div class="col-sm-12 col-md-4" style="margin-bottom: 5px;">
                <label>Your Commission Value ({{config('app.currency_symbol')}})</label>
                <div class="input-group">
                    <input name="total_commission" {{($data->commission_paid==1)? 'disabled': ''}} type="number" class="form-control" id="" value="{{$data->total_commission}}" required>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12 col-md-4">
                <label>Agent Percent</label>
                <div class="input-group">
                    <input name="agent_percent" {{($data->commission_paid==1)? 'disabled': ''}} type="number" min="0" max="100" class="form-control" id="" value="{{$data->agent_percent}}" required>
                </div>
            </div>
        <div class="row">
                <div class="col-md-4">
                    <input type="submit" {{($data->commission_paid==1)? 'disabled': ''}} class="btn btn-primary btn-md" name="submit" value="Save" />
                </div>
        </div>
{{ html()->form()->close() }}
    </div>
</div>

@endsection
@push ('after-scripts')
<script>
</script>
@endpush