@extends('backend.layouts.app')

@section('title', "Close Application")

@section('content')


{{ html()->form('POST', route('admin.applicationedit'))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}
<input type="hidden" name="id" value="{{$data->id}}">
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-12">
                <h4 class="card-title mb-0">
                    Close University Applications
                    <small class="text-muted">#{{$data->appl_id}}</small>
                </h4>
                <hr>
            </div>
            <!--col-->
        </div>
        <!--row-->

        <div class="row">
            <div class="col-12">
                <h4>{{ $student->full_name }}</h4>
                <p>Email: {{$student->email}} Ph:{{$student->mobile}}</p>
                @if($data->type == 'visa')
                <h5><small class="text-muted">Country:</small> {{ $data->country }}</h5>
                <p style="padding-top:6px;">{!!show_visa_application_status($data->visa_status)!!}</p>                
                @elseif($data->type == 'abroad_job')
                <h5><small class="text-muted">Country:</small> {{ $data->country }}</h5>
                <p style="padding-top:6px;">{!!show_abroad_job_application_status($data->abroad_job_status)!!}</p>                
                @else
                <h5><small class="text-muted">Course:</small> {{ $data->course }}</h5>
                <h5><small class="text-muted">University:</small> {{ $data->university }}, {{ $data->country }}</h5>
                <p style="padding-top:6px;">{!!show_application_status($data->status)!!}</p>
                @endif
                <hr>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12 col-md-6">
                <div class="form-group">
                    <label class="required-field">Reason for Closure</label>
                    <select class="form-select form-control" name="close_appl_reason" required>
                        <option value="">-- Select --</option>
                        @if($data->type == 'visa')
                        <option value="visa_complete">Visa Complete</option>
                        <option value="visa_rejected">Visa Rejected</option>
                        @elseif($data->type == 'abroad_job')
                        <option value="visa_complete">Completed</option>
                        <option value="visa_rejected">Cancelled/ Rejected</option>
                        @else
                        <option value="admission_complete">Admission Complete</option>
                        <option value="rejected_by_institution">Rejected by Institution</option>
                        <option value="visa_rejected">Visa Rejected</option>
                        @endif
                        <option value="other">Other Reasons</option>
                    </select>
                </div>
                <div class="form-group">
                    <label class="required-field">Notes</label>
                    <textarea class="form-control" name="case_closed_notes" required></textarea>
                </div>
                <div class="text-center">
                <input type="submit" class="btn btn-primary" value="Submit">                
                </div>
            </div>
        </div>
    </div>
</div>
</form>
@endsection
