@extends('backend.layouts.app')

@section('title', "Application Management")

@section('content')

<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-9 col-9">
                <h4 class="card-title mb-0">
                    University Application #{{$data->appl_id}}
                    <small class="text-muted"></small>
                </h4>
            </div>
            <div class="col-sm-3 col-3 pull-right">
                <div class="btn-toolbar" role="toolbar" aria-label="" style="margin-top: 20px;float: right;">
                    <a href="{{ route('admin.applications') }}" class="btn btn-primary btn-sm"><i class="fa fa-reply"></i></a>             
                </div>
            </div>
        </div>
        <!--row-->

        <ul class="nav nav-tabs" id="myTab" role="tablist">
            <li class="nav-item" role="presentation">
                <button style="font-weight:bold;" class="nav-link active" id="application-tab" data-bs-toggle="tab" data-bs-target="#appilcation" type="button" role="tab" aria-controls="appilcation" aria-selected="true"><i class="bx bxs-id-card"></i> Application</button>
            </li>
            @if(!(\Auth::user()->isAgent()))
            <li class="nav-item" role="presentation">
                <button style="font-weight:bold;" class="nav-link" id="profile-tab" data-bs-toggle="tab" data-bs-target="#profile" type="button" role="tab" aria-controls="profile" aria-selected="false"><i class="bx bxs-user-circle"></i> Profile</button>
            </li>
            <li class="nav-item" role="presentation">
                <button style="font-weight:bold;" class="nav-link" id="docs-tab" data-bs-toggle="tab" data-bs-target="#docs" type="button" role="tab" aria-controls="docs" aria-selected="false"><i class="bx bxs-user-circle"></i> Documents</button>
            </li>
            @endif
            @if((\Auth::user()->isAdmin() || \Auth::user()->can('commission')))
            <li class="nav-item" role="presentation">
                <button style="font-weight:bold;" class="nav-link" id="fees-and-commission-tab" data-bs-toggle="tab" data-bs-target="#fees-and-commission" type="button" role="tab" aria-controls="fees-and-commission" aria-selected="false"><i class="fas fa-money-check-alt"></i> Fees & Commision</button>
            </li>
            @endif
            @if(!(\Auth::user()->isAgent()))
            <li class="nav-item" role="presentation">
                <button style="font-weight:bold;" class="nav-link" id="reminders-tab" data-bs-toggle="tab" data-bs-target="#reminders" type="button" role="tab" aria-controls="reminders" aria-selected="false"><i class="fas fa-bell"></i> Reminders ({{count($reminders)}})</button>
            </li>
            @endif
        </ul>

        <div class="tab-content" id="myTabContent">
            <div class="tab-pane fade show active pt-0" id="appilcation" role="tabpanel" aria-labelledby="appilcation-tab">
                @if(!(\Auth::user()->isAgent()))
                {{-- <div class="row justify-content-end d-print-none">
                    <div class="col-6 d-flex border border-top-0 border-bottom-0">
                    </div>
                    <div class="col-6 d-flex justify-content-end border border-top-0 border-bottom-0 ">
                        <div class="btn-toolbar mt-2 mx-2" role="toolbar" aria-label="">
                            <a href="#" title="Assigned Staff" class="text-reset" style="margin-bottom: 0px !important; float: right!important;">
                                <i class="ri-user-2-fill menu-icon" style="font-size: 16px !important;"></i>
                                {!!($data->assign_to) ? "<span class='text-primary'>".get_user_full_name_by_id($data->assign_to)."</span>" : '<span class="text-danger">--</span>'!!}
                            </a>
                        </div>
                    </div>
                </div> --}}
                {{-- <div class="row justify-content-end d-print-none">
                    <div class="col-4 d-flex justify-content-end">
                        <div class="btn-toolbar mt-2 mx-2" role="toolbar" aria-label="">
                            <a href="{{route('admin.application.course-university.edit.view', [$data->course_pref_id, "apllication"])}}" class="btn btn-primary btn-sm"><i class="fas fa-edit"></i> Edit</a>
                        </div>
                    </div>
                </div> --}}
                @endif 
                <div class="row mt-0">
                    <div class="col-sm-12 col-md-6 border border-top-0 border-bottom-0 border-left-0 p-3">
                        <a target="_blank" href="{{route('admin.auth.user.show', $student->id)}}">{{ $student->full_name }}</a>
                           
                        <p>Email: {{$student->email}} <br>Mobile: @if($student->dialcode)+{{$student->dialcode}}-@endif{{$student->mobile}}</p>
                        <hr>
                        
                         @if(!(\Auth::user()->isAgent()))
                            <a href="{{route('admin.application.course-university.edit.view', [$data->course_pref_id, "apllication"])}}" class="btn btn-primary btn-sm" style="float: right;"><i class="fas fa-edit"></i> Edit</a>
                            @endif 
                  
                            <p><span class="text-muted">Course:</span>
                                @if($course_id)
                                <a target="_blank" href="{{url('admin/course-finder/course-details/')."/".$course_id}}">
                                    {{ $data->course }}
                                   
                                </a>
                                @else
                                    {{ $data->course }}
                                @endif
                               <br>
                                <span class="text-muted">Intake:</span> {{ \Carbon\Carbon::createFromDate(null, $data->intake, 1)->format('F') }}, {{ $data->year }}
                            <br>
                            <span class="text-muted">University:</span> 
                                @if($uni_id)
                                <a target="_blank" href="{{url('admin/course-finder/university-details/')."/".$uni_id}}">{{ $data->university }}</a>
                                @else
                                {{ $data->university }}
                                @endif, {{ $data->country }}
                            </p>
                            <p style="">{!!show_application_status($data->status)!!}</p>
                                                    
                        <!-- <div class="row mt-3">
                            <hr>
                            @if($data->deadline && $data->task)
                            <div class="col-md-7 pb-3">
                                <p class="mb-0"><b>Deadline: </b> {{($data->deadline) ? date('d-m-Y',strtotime($data->deadline)) : '--'}} </p>
                                <p class="mb-0"><b>Task: </b> {{$data->task}}</p>
                            </div>
                            @endif
                            <div class="col-md-5 d-flex">
                                <button id="add_new_task" class="btn btn-primary btn-sm"><i class="fas fa-plus-circle"></i> New Task</button>
                                @if($data->task)
                                <a href="{{route('admin.application.clear-task',$data->id)}}" class="btn btn-primary btn-sm mx-2">Clear Task</a>
                                @endif
                            </div>
                            <hr>
                        </div> -->
                    @if(!auth()->user()->isAgent())
                        <form method="post" action="{{route('admin.applications.application-update-notes')}}">
                        @csrf
                            <input type="hidden" name="appl_id" value="{{$data->id}}">
                            <textarea class="form-control" name="notes" maxlength="500" placeholder="Notes" style="height: 60px;">{!!$data->notes!!}</textarea>
                            <span class="form-text" style="font-size: 13px !important;">This notes is visible only to staff</span><br>
                            <button class="btn btn-primary btn-sm mt-2"><i class="fas fa-save"></i> Save</button>
                        </form>
                    </div>
		            @endif
                     
                    @if(!auth()->user()->isAgent())
                        <div class="col-md-6 border border-top-0 border-right-0 border-bottom-0 p-3">                       
                            <h4 class="timeline-title pb-3">Update University Application Status
                                <span title="Assigned Staff" class="text-reset" style="margin-bottom: 0px !important; float: right!important;">
                                    <i class="ri-user-2-fill menu-icon" style="font-size: 16px !important;vertical-align: sub;"></i>
                                    @if($data->assign_to)
                                        <span class='text-primary'>{{$data->staff_first_name}} {{$data->staff_last_name}}</span>
                                    @else 
                                        <span class="text-danger">--</span>
                                    @endif
                                </span>
                            </h4>
                             <ul class="timeline">
                                Current Status: <strong>{!!show_application_status($data->status)!!}</strong>
                                <br />
                                <br />
                                <label>Change Status to</label>
                                {{ html()->form('POST', route('admin.application-status-updated-notes'))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}
                                <input type="hidden" name="id" value="{{$data->id}}">
                                <input type="hidden" name="closed" id="closed">
                                <select class="form-control form-select" name="new_status" id="new_status" required>
                                    {{-- <option value="">Select</option> --}}
                                    @foreach(get_application_statuses($data->country) as $statuses)
                                    <option data-loop_index="{{$loop->index}}" value="{{$statuses->status_name}}" data-file_upload="{{$statuses->file_upload}}"
                                        data-notes_req="{{$statuses->notes_required}}" data-go_back="{{$statuses->can_go_back}}" data-case_close_success="{{$statuses->case_close_success}}" data-case_close_rejected="{{$statuses->case_close_rejected}}" data-file_upload_required="{{$statuses->file_upload_required}}" data-file_upload_max="{{$statuses->file_upload_max}}" data-file_upload="{{$statuses->file_upload}}"
                                         @if($data->status == $statuses->status_name) selected @endif>{{$statuses->status_name}}</option>
                                    @endforeach
                                </select>
                                <div class="form-group mt-4" id="file_upload_div" style="display: none;">
                                    Upload File: <input style="margin-bottom: 2px!important;" type="file" id="app_stage_file" name="app_stage_file[]" accept=".pdf,.docx,.doc,.jpeg,.png"/>
                                    <p><small id="file_note"></small></p>
                                </div>
                                
                                <div class="form-group" id="reason_div" style="display: none;">
                                    <label class="required-field">Reason for Closure</label>
                                    <select class="form-select form-control" name="close_appl_reason" id="reason">
                                        <option value="">-- Select --</option>
                                        @if($data->type == 'visa')
                                        <option value="visa_complete">Visa Complete</option>
                                        <option value="visa_rejected">Visa Rejected</option>
                                        @elseif($data->type == 'abroad_job')
                                        <option value="visa_complete">Completed</option>
                                        <option value="visa_rejected">Cancelled/ Rejected</option>
                                        @else
                                        <option @if($data->case_closed_reason == "admission_complete") selected @endif value="admission_complete">Admission Complete</option>
                                        <option @if($data->case_closed_reason == "rejected_by_institution") selected @endif value="rejected_by_institution">Rejected by Institution</option>
                                        <option @if($data->case_closed_reason == "visa_rejected") selected @endif value="visa_rejected">Visa Rejected</option>
                                        @endif
                                        <option @if($data->case_closed_reason == "other") selected @endif value="other">Other Reasons</option>
                                    </select>
                                </div>

                                <div class="col mt-4">
                                    <div class="form-group">
                                        <label id="status_notes_req">Notes</label><br />
                                        <textarea class="form-control mb-1" name="notes" id="status_notes"></textarea>
                                        <small>This notes is visible to student</small>
                                    </div>
                                </div>
                                <div class="mt-2" style="text-align: center;">
                                <input type="submit" class="btn btn-primary btn-sm" id="updateBtn" name="submit" value="Update" />
                                </div>
                                {{ html()->form()->close() }}
                            </ul>
                        </div>
                        @endif
                    
                    {{-- <div class="col-sm-12 col-md-2" style="text-align:right;"> --}}
                        {{-- @if($student->agent_id!=0 && !auth()->user()->isAgent())
                            <a class="btn btn-secondary" href="{{route('admin.applications.agent-commission', [$data->id])}}"><i class="fa fa-dollar-sign"></i> Commission</a>
                        @endif --}}
                        {{-- @if(!$data->case_closed && !auth()->user()->isAgent())
                            <a class="btn btn-warning" href="{{route('admin.applications.close', [$data->id])}}">Close Case</a>
                        @endif --}}
                    {{-- </div> --}}
                </div>

                @if($data->type != 'visa')
                <hr>
                {{ html()->form('POST', route('admin.applicationedit'))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}
                    <input type="hidden" name="id" value="{{$data->id}}">
                    <input type="hidden" name="application_date" value="Application Date">
                    <div class="row m-b-10">
                        <div class="col-sm-12 col-md-3" style="margin-bottom: 5px;">
                            <label>Application Opening Date</label>
                            <div class="input-group">
                                @if(auth()->user()->isAgent())
                                {{ \Carbon\Carbon::parse($data->application_open_date)->format('d-M-Y')}}
                                @else
                                <input name="open_date" type="text" autocomplete="off" class="form-control mydatepicker" id="" value=" {{($data->application_open_date) ? date('d-m-Y',strtotime($data->application_open_date)) : ''}}">
                                @endif
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-3">
                            <label>Application Closing Date</label>
                            <div class="input-group">
                                @if(auth()->user()->isAgent())
                                {{ \Carbon\Carbon::parse($data->application_close_date)->format('d-M-Y')}}
                                @else
                                <input name="close_date" type="text" autocomplete="off" class="form-control mydatepicker" id="" value="{{($data->application_close_date) ? date('d-m-Y',strtotime($data->application_close_date)) : ''}}">
                                @endif
                            </div>
                        </div>
                        @if(\Auth::user()->isAdmin() || \Auth::user()->can('application apply through'))
                            <div class="col-sm-12 col-md-3">
                                <label>Applied Through Agent</label>
                                <div class="input-group">
                                    <select class="form-control form-select" name="applied_with">
                                        <option value="">Select</option>
                                        @foreach(get_app_apply_through() as $value)
                                        <option value="{{$value->id}}" {{($data->applied_with == $value->id)? 'selected' : ''}}>{{$value->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        @endif
                        @if(!auth()->user()->isAgent())
                        <div class="col-md-3" style="margin-top: 20px;">
                            <input type="submit" class="btn btn-primary btn-sm" name="submit" value="Update" />
                        </div>
                        @endif
                    </div>
                {{ html()->form()->close() }}
                @endif

                
                {{-- <hr>        
                <div class="row my-4">
                    <div class="col-12">
                        <div class="row">
                            <div class="col-9">
                                <h4>Document Request</h4>
                            </div>
                            @if(!auth()->user()->isAgent())
                            <div class="col-3">
                                <button type="button" data-bs-toggle="modal" data-bs-target="#documentRequest" class="btn btn-sm btn-primary"><i class="fas fa-plus-circle"></i> Request a Document</button>
                            </div>
                            @endif
                        </div>
                    </div> --}}
                    <hr>         
                        <div class="row my-4">
                            <div class="col-12">
                                <div class="d-flex justify-content-between align-items-center">
                                    <h4 class="mb-0">Document Request</h4>

                                    @if(!auth()->user()->isAgent())
                                        <div class="d-flex gap-2">
                                            <button type="button" data-bs-toggle="modal" data-bs-target="#documentRequest" class="btn btn-sm btn-primary">
                                                <i class="fas fa-plus-circle"></i> Request a Document
                                            </button>

                                            <a href="{{ route('admin.application.downloadDocsZip', $data->id) }}" class="btn btn-sm btn-primary">
                                                <i class="fas fa-file-archive"></i> Download Zip
                                            </a>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    <div class="col-12">
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Document</th>
                                        <th>Received</th>
                                        <th>File</th>
                                        @if(auth()->user()->isAgent())
                                        <th>Upload</th>
                                        @endif
                                    </tr>
                                </thead>
                                <tbody>
                                    @if(count($applicationDocRequest) > 0)
                                        @foreach ($applicationDocRequest as $docRequest)
                                        <tr>
                                            <td>{{date('d M Y h:i A', strtotime($docRequest->created_at))}}</td>
                                            <td>{{$docRequest->title}}</td>
                                            <td>@if($docRequest->uploaded_at){{date('d M Y h:i A', strtotime($docRequest->uploaded_at))}}@else -- @endif</td>
                                            <td class="">
                                                @if($docRequest->files)
                                                    @php
                                                        $all_files = explode('|', $docRequest->files);
                                                    @endphp
                                                    <ul class="list-unstyled">
                                                    @foreach($all_files as $file)
                                                        <li>
                                                            <a class="small text-primary" href="<?php echo url('storage/cert/' . $file) ?>" target="_blank">{{$file}}</a>
                                                        </li>
                                                    @endforeach
                                                    </ul>
                                                @else
                                                    --
                                                @endif
                                            </td>                        
                                            @if(auth()->user()->isAgent())
                                            <td>
                                                @if($docRequest->files)
                                                    <button type="submit" class="btn btn-sm btn-secondary disabled">Upload</button>
                                                @else
                                                <form action="{{route('admin.application.upload-requested-document')}}" method="post" enctype="multipart/form-data">
                                                    @csrf
                                                    <input type="hidden" name="doc_request_id" value="{{$docRequest->id}}">
                                                    <input type="hidden" name="application_id" value="{{$data->id}}">
                                                    <div class="input-group">
                                                        <input type="file" name="file_upload[]" id="file_upload" class="form-control file_edu" accept=".doc,.docx,.pdf,.jpeg" multiple required>
                                                    </div>
                                                    <button type="submit" class="btn btn-sm btn-primary">Upload</button>
                                                </form>
                                                @endif
                                            </td>  
                                            @endif
                                        </tr>
                                        @endforeach
                                    @else
                                        <tr>
                                            <td colspan="4" class="text-center">No Record Found</td>
                                        </tr>
                                    @endif
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <hr>        
                
                <div class="row my-4">
                    <div class="col-12">
                        {{-- <h4 class="mb-3">Message History</h4> --}}
                        <div class="row">
                            <div class="col-12">
                                @if(auth()->user()->isAgent())
                                    <h4 class="timeline-title mb-3">Send Message to Staff</h4>
                                @else
                                    <h4 class="timeline-title mb-3">Send Message to Student/Agent</h4>
                                @endif
                                @if(count($app_messages)>0)
                                <div class="mb-3" style="max-height: 300px; overflow-y: auto; background-color: rgb(245,246,247) !important; border: 1px solid rgb(170, 170, 170);">
                                    <div class="card-body" style="padding-top: 15px;">
                                    @foreach($app_messages as $msgs)
                                        <ul class="list-unstyled">
                                            <li class="justify-content-between ">
                                                <div>
                                                    @if($msgs->staff_id)
                                                    <p class="fw-bold mb-0">{{get_user_full_name_by_id($msgs->staff_id)}}</p>
                                                    @else
                                                    <p class="fw-bold mb-0 @if($msgs->user_id == Auth::user()->id) text-end @endif">{{get_user_full_name_by_id($msgs->user_id)}}</p>
                                                    @endif
                                                    <p class="mb-0 text-muted @if($msgs->user_id == Auth::user()->id) text-end @endif"><small>{{ date("d-M-Y h:i A", strtotime($msgs->created_at))}}</small></p>
                                                    <div class="rounded-3" style="background-color: #f5f6f7;">
                                                        {{-- <span style="font-size: 15px;" class="@if($msgs->user_id == Auth::user()->id) text-end @endif">{!!nl2br($msgs->message)!!}</span> --}}
                                                        <span style="font-size: 15px;" class="@if($msgs->user_id == Auth::user()->id) text-end @endif">{!!nl2br($msgs->message)!!}</span>
                                                        @if($msgs->attachment_1)
                                                        <p class="m-0 small @if($msgs->user_id == Auth::user()->id) text-end @endif"><a style="color: #0d6efd!important;" href="<?php echo url('storage/' . $msgs->attachment_1) ?>" target="_blank">{{substr($msgs->attachment_1, strpos($msgs->attachment_1, "/") + 1)}}</a></p>
                                                        @endif
                                                        @if($msgs->attachment_2)
                                                        <p class="m-0 small @if($msgs->user_id == Auth::user()->id) text-end @endif"><a style="color: #0d6efd!important;" href="<?php echo url('storage/' . $msgs->attachment_2) ?>" target="_blank">{{substr($msgs->attachment_2, strpos($msgs->attachment_2, "/") + 1)}}</a></p>
                                                        @endif
                                                        @if($msgs->attachment_3)
                                                        <p class="m-0 small @if($msgs->user_id == Auth::user()->id) text-end @endif"><a style="color: #0d6efd!important;" href="<?php echo url('storage/' . $msgs->attachment_3) ?>" target="_blank">{{substr($msgs->attachment_3, strpos($msgs->attachment_3, "/") + 1)}}</a></p>
                                                        @endif
                                                        @if($msgs->attachment_4)
                                                        <p class="m-0 small @if($msgs->user_id == Auth::user()->id) text-end @endif"><a style="color: #0d6efd!important;" href="<?php echo url('storage/' . $msgs->attachment_4) ?>" target="_blank">{{substr($msgs->attachment_4, strpos($msgs->attachment_4, "/") + 1)}}</a></p>
                                                        @endif
                                                        @if($msgs->notified_staff)
                                                        {{-- <hr> --}}
                                                        <p class="mb-1 @if($msgs->user_id == Auth::user()->id) text-end @endif"><small>Tagged:</small> 
                                                            <?php $tagged_staff = explode(',',$msgs->notified_staff); ?>
                                                            @foreach($tagged_staff as $tagged)
                                                            <a href="#" class="badge badge-primary @if($msgs->user_id == Auth::user()->id) text-end @endif">{{get_user_full_name_by_id($tagged)}}</a>
                                                            @endforeach
                                                        </p>
                                                        @endif
                                                    </div>
                                                </div>
                                            </li>
                                        </ul>
                                    @endforeach
                                    </div>
                                </div>
                                @else
                                <div class="card text-center py-4 fs-5" style="height: 100px !important; overflow-y: auto; background-color: rgb(245,246,247) !important; border: 1px solid rgb(170, 170, 170);">
                                    No messages found!
                                </div>
                                @endif
                            </div>

                            <div class="col-12">
                                <form action="{{route('admin.application.message.send')}}" method="POST" enctype="multipart/form-data">
                                    @csrf
                                    <input type="hidden" name="app_id" value="{{$data->id}}">
                                    @if(!auth()->user()->isAgent())
                                    <div class="row">
                                        <div class="col-md-6 mt-3" id="template_block">
                                            <select class="form-control form-select" id="canned_template">
                                                <option value="manual">Choose a template OR Type the message</option>
                                                @foreach(get_canned_templates() as $tpl)
                                                <option value="{{$tpl}}">{{$tpl}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    @endif
                                    <div class="tpl_loading" style="display:none;"><span style="color:red;">Loading... Please wait.</span></div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-outline">
                                                {{-- <textarea class="form-control" placeholder="Type a Message..." id="message" name="message" rows="1" required></textarea> --}}
                                                <textarea id="message_html" name="message" rows="10" style="height:300px;" class="ckeditor_toolbar1 form-control"></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row mt-2">
                                        @if(!auth()->user()->isAgent())
                                        <div class="col-md-4">
                                            <select class="form-control select2_ajax" name="notify_staff[]" data-placeholder="@if(!auth()->user()->isAgent()) Tag Staff/Agent to notify @else Tag Staff to notify @endif" multiple></select>
                                        </div>
                                        @endif
                                        <div class="col-md-4 mt-2">
                                            Attach files:
                                            <input type="file" name="attachment[]" id="attachment" accept=".doc,.jpeg,.jpg,.pdf,.docx,.png,application/msword,application/vnd.openxmlformats-officedocument.wordprocessingml.document" data-max="4" multiple>
                                            <p class="text-danger m-0" id="fileErr"></p>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <input type="submit" id="sendMsg" class="btn btn-primary btn-rounded text-left" value="Send Message">
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <hr>
                </div>

                <div class="row">
                    <div class="col-12">
                        <h4 class="mb-3">Application Activity</h4>
                        @if(count($appActivity))
                        <div class="card" style="max-height: 400px;overflow-y: auto;">
                            <div class="card-body">
                                @foreach($appActivity as $activity)
                                <div style="padding-top: 15px;color: #6e6e6e;font-size: 14px;font-style: italic;">
                                    {{ date('d M Y g:i A', strtotime($activity->created_at)) }}, {{get_user_name_by_id($activity->staff)}}:
                                </div>
                                @if($activity->detail)
                                <div class="card-text" style="font-size:15px;color: #353535 !important;padding-bottom:10px;">{!!$activity->title!!}</div> 
                                <div class="card-text" style="font-size:15px;color: #353535 !important;padding-bottom:10px;border-bottom:1px solid #ccc;">Details: {!!$activity->detail!!}
                                    @if($activity->attachment)
                                    <?php $attachments = explode(',',$activity->attachment); ?>
                                        @foreach($attachments as $attachment)
                                        <p class="m-0 mt-1 small"><a style="color: #0d6efd!important;" href="<?php echo url('storage/app_activity/' . $attachment) ?>" target="_blank">{{$attachment}}</a></p>
                                        @endforeach
                                     @endif
                                </div> 
                                @else
                                <div class="card-text" style="font-size:15px;color: #353535 !important;padding-bottom:10px;border-bottom:1px solid #ccc;">{{$activity->title}}
                                    @if($activity->attachment)
                                    <?php $attachments = explode(',',$activity->attachment); ?>
                                        @foreach($attachments as $attachment)
                                        <p class="m-0 mt-1 small"><a style="color: #0d6efd!important;" href="<?php echo url('storage/app_activity/' . $attachment) ?>" target="_blank">{{$attachment}}</a></p>
                                        @endforeach
                                     @endif
                                </div> 
                                @endif
                                @endforeach
                            </div>
                        </div>
                        @else
                        No records found!
                        @endif
                    </div>
                </div>
            </div>
            @if(!(\Auth::user()->isAgent()))
                <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                    @include('backend.applications.profile')
                </div>
                <div class="tab-pane fade" id="docs" role="tabpanel" aria-labelledby="docs-tab">
                    @include('backend.applications.docs')
                </div>
                <div class="tab-pane fade" id="fees-and-commission" role="tabpanel" aria-labelledby="fees-and-commission-tab">
                    @include('backend.applications.fees-and-commission')
                </div>
                <div class="tab-pane fade" id="reminders" role="tabpanel" aria-labelledby="reminders-tab">
                    @include('backend.applications.reminders')
                </div>
            @endif
        </div>
    </form>
    </div>
</div>

<div class="modal fade " id="documentRequest" tabindex="-1" aria-labelledby="documentRequestLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header ">
            <h5 class="modal-title" id="documentRequestLabel">Request a Document</h5>
            <button type="button" class="btn-close border" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <form method="post" action="{{ route('admin.application.request-document') }}">
        @csrf
            <div class="modal-body">
                <input type="hidden" name="application_id" value="{{$data->id}}">
                <div class="row">
                    <div class="form-group col-md-12">
                        <label class="required-field" for="title">Title</label>
                        <input type="test" placeholder="Title" class="form-control" name="title" id="title" required>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-sm btn-primary mx-auto">Submit</button>
            </div>
        </div>
    </form> 
    </div>
</div>

<div class="modal fade" id="newTaskModal">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="">Add New Task</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" style="font-size: 30px;"></button>
            </div>
            <div class="modal-body">
                <form action="{{route('admin.application.add-task')}}" method="post">
                    @csrf
                    <input type="hidden" name="appl_id" value="{{$data->id}}">
                    <div class="form-group">
                    <textarea class="form-control" name="task" id="" rows="3" placeholder="Task Details" required></textarea>
                    </div>
                    <div class="form-group">
                        <input type="text" name="deadline" autocomplete="off" class="form-control w-50 mydatepicker" placeholder="Deadline" required>
                    </div>
                    <div class="row mt-4">
                        <div class="col-sm-12 col-md-12">
                            <div class="form-group mb-0">
                                <button class="btn btn-primary btn-sm" type="submit">Save</button>
                                <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal" aria-label="Close" name="cancel" value="Cancel">Cancel</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
{{-- <div class="row">
    <div class="col-sm-12">
        <h4 class="mb-4">Application Activity</h4>
        @if(count($appActivity))
        <div class="card" style="max-height: 500px;overflow-y: auto;">
            <div class="card-body">
                @foreach($appActivity as $activity)
                <div style="padding-top: 15px;color: #6e6e6e;font-size: 14px;font-style: italic;">
                    {{ date('d M Y g:i A', strtotime($activity->created_at)) }}, {{get_user_name_by_id($activity->staff)}}:
                </div>
                @if($activity->detail)
                <div class="card-text" style="font-size:15px;color: #353535 !important;padding-bottom:10px;">{{$activity->title}}</div> 
                <div class="card-text" style="font-size:15px;color: #353535 !important;padding-bottom:10px;border-bottom:1px solid #ccc;">Details: {!!$activity->detail!!}</div> 
                @else
                <div class="card-text" style="font-size:15px;color: #353535 !important;padding-bottom:10px;border-bottom:1px solid #ccc;">{{$activity->title}}</div> 
                @endif
                @endforeach
            </div>
        </div>
        @else
        No records found!
        @endif
    </div>
</div> --}}

@endsection
@push('after-styles')
<style>
.title_lines {
    position: relative;
    font-size: 18px;
    z-index: 1;
    overflow: hidden;
    text-align: center;
    color: #000;
    font-family: arial;
}
.title_lines:before, .title_lines:after {
    position: absolute;
    top: 51%;
    overflow: hidden;
    width: 48%;
    height: 1.5px;
    content: '\a0';
    background-color: #cccccc;
    margin-left: 2%;
}
.title_lines:before {
    margin-left: -50%;
    text-align: right;
}
</style>
@endpush
@push ('after-scripts')
<script>
$(document).ready(function() {

    $('.mydatepicker').datetimepicker({
        timepicker: false,
        format: 'd-m-Y',
        scrollInput: false,
        minDate: new Date()
    });
    
        $('.select2_ajax').select2({
            minimumInputLength: 3,
            ajax: {
                url: '{{ route("admin.search.staff") }}',
                type: "POST",
                dataType: 'json',
                data: function(params) {
                    return {
                        q: params.term, // search term
                        _token: '{{csrf_token()}}'
                    };
                },
            },
        });

    $(document).on('click', '#add_new_task', function() {
        $('#newTaskModal').modal('show');
        $('#newTaskModal').on('hidden.bs.modal', function() {
            // $('#newTaskModal .load_modal').html("");
        });
    });

    $('#canned_template').change(function() {
            if (this.value == 'manual') {
                $('#subject_val').val('');
                window.editor.setData('');
            } else {
                $('.tpl_loading').show();
                $.post("{{route('admin.cannedtemplates.ajaxgetcannedtpl')}}", {
                    'hook': this.value,
                    '_token': $('meta[name="csrf-token"]').attr('content')
                },
                function(data, status) {
                    var tpl = JSON.parse(data);
                    $('.tpl_loading').hide();
                    window.editor.setData(tpl.canned_tpl.message);
                });
                
            }
        });
});
$(document).ready(function () {
    //Onload inputs
    var def_note_req = $("#new_status").find(':selected').data('notes_req');
    if (def_note_req == '1') {
            $("#status_notes_req").addClass('required-field');
            $("#status_notes").attr('required',true);
        }else{
            $("#status_notes_req").removeClass('required-field');
            $("#status_notes").attr('required',false);
        }
    var def_file = $("#new_status").find(':selected').data('file_upload');
    var def_upload_max = $(this).find(':selected').data('file_upload_max');
    var def_upload_required = $(this).find(':selected').data('file_upload_required');
    if (def_file == '1') {
        $("#file_upload_div").show();
            $("#file_note").html("<b>Note:</b> You can select upto "+def_upload_max+" files");
                $("#app_stage_file").on("change", function() {
                    if ($("#app_stage_file")[0].files.length > def_upload_max) {
                        $.toast({
                            heading: 'Warning',
                            text: "You can select only upto "+def_upload_max+" files",
                            position: 'top-right',
                            loaderBg: '#ff6849',
                            icon: 'warning',
                            hideAfter: 4000,
                            stack: 6
                        });
                        $("#updateBtn").attr('disabled',true);
                    } else {
                        $("#updateBtn").attr('disabled',false);
                    }
                });
            if (def_upload_required == '1') {
                $("#app_stage_file").attr('required',true);
            }
            if (def_upload_max > 1) {
                $("#app_stage_file").attr('multiple',true);
            }else{
                $("#app_stage_file").attr('multiple',false);
            }
        } else {
            $("#file_upload_div").hide();
            $("#app_stage_file").attr('required',false);
        }

    var def_succ = $("#new_status").find(':selected').data('case_close_success');
    var def_rej = $("#new_status").find(':selected').data('case_close_rejected');
    if (def_succ == '1' || def_rej == '1') {
            $("#reason_div").show();
            $("#closed").val("1");
            $("#reason").attr('required',true);
        }else{
            $("#reason_div").hide();
            $("#closed").val("0");
            $("#reason").attr('required',false);
        }


    @if(auth()->user()->id != '1')
    var $sel = $("#new_status").find(':selected').data("loop_index");
    var $can_go_back = $("#new_status").find(':selected').data("go_back");
    $("#new_status option").each(function() {
            var $thisOption = $(this);
            // var $selectedOption = $thisOption.find(':selected').data("loop_index");
            console.log("Selected: "+$sel);
            var $check = $(this).data('loop_index');
            console.log("Check: "+$check);
            if($check < $sel && $thisOption.data('loop_index') != $sel && !$can_go_back) {
                $thisOption.attr("disabled", "disabled");
                $thisOption.attr("style", "background-color:#ababab;color:#fff;");
                $thisOption.attr("title", "Cannot change status!");
            }
        });
    @endif
//Onload inputs
    $('#new_status').change(function () {
        var file_upload = $(this).find(':selected').data('file_upload');
        var file_upload_required = $(this).find(':selected').data('file_upload_required');
        var notes_req = $(this).find(':selected').data('notes_req');
        var file_upload_max = $(this).find(':selected').data('file_upload_max');
        var go_back = $(this).find(':selected').data('go_back');
        var case_close_success = $(this).find(':selected').data('case_close_success');
        var case_close_rejected = $(this).find(':selected').data('case_close_rejected');

        if (notes_req == '1') {
            $("#status_notes_req").addClass('required-field');
            $("#status_notes").attr('required',true);
        }else{
            $("#status_notes_req").removeClass('required-field');
            $("#status_notes").attr('required',false);
        }

        if (case_close_rejected == '1' || case_close_success == '1') {
            $("#reason_div").show();
            $("#closed").val("1");
            $("#reason").attr('required',true);
        }else{
            $("#reason_div").hide();
            $("#closed").val("0");
            $("#reason").attr('required',false);
        }

        if (file_upload == '1') {
            $("#file_upload_div").show();
            $("#file_note").html("<b>Note:</b> You can select upto "+file_upload_max+" files");
                $("#app_stage_file").on("change", function() {
                    if ($("#app_stage_file")[0].files.length > file_upload_max) {
                        $.toast({
                            heading: 'Warning',
                            text: "You can select only upto "+file_upload_max+" files",
                            position: 'top-right',
                            loaderBg: '#ff6849',
                            icon: 'warning',
                            hideAfter: 4000,
                            stack: 6
                        });
                        $("#updateBtn").attr('disabled',true);
                    } else {
                        $("#updateBtn").attr('disabled',false);
                    }
                });
            if (file_upload_required == '1') {
                $("#app_stage_file").attr('required',true);
            }
            if (file_upload_max > 1) {
                $("#app_stage_file").attr('multiple',true);
            }else{
                $("#app_stage_file").attr('multiple',false);
            }
        } else {
            $("#file_upload_div").hide();
            $("#app_stage_file").attr('required',false);
        }
    });
});
      
    const btn = document.querySelector('input[id=sendMsg]');
    document.querySelector('form').addEventListener('change', function(ev) {
        if (ev.target.type == 'file') {
            // I collect the inps here to allow for dynamic pages (varying number of inputs):
            const inps = [...document.querySelectorAll('input[type=file]')];
            btn.disabled = inps.some(inp => {
                // check whether the condition has been violated at least once
                if (inp.files.length > inp.dataset.max) { // show warning for first violation
                    console.log(`You are only allowed to upload a maximum of ${inp.dataset.max} files for ${inp.name}!`);
                    $('#fileErr').text(`You are only allowed to upload a maximum of ${inp.dataset.max} files`);
                    return true;
                } else {
                    $('#fileErr').text(``);
                }
            })
        }
    });

    $(document).ready(function() {
        let selectedTab = window.location.hash;
        if (selectedTab) {
            $('.nav-link[data-bs-target="' + selectedTab + '"]').trigger('click');
        }
    });

    function addURL(type){
        if(type == 'doc'){
            var uri = window.location.toString();
            if (uri.indexOf("#docs") < 0) {
                window.location.href= window.location+"#docs";
            }
        }else{
            var uri = window.location.toString();
            if (uri.indexOf("#docs") > 0) {
                var clean_uri = uri.substring(0, uri.indexOf("#docs"));
                window.history.replaceState({}, document.title, clean_uri);
            }
        }
    }
</script>
@endpush