@extends('backend.layouts.app')

@section('title', "University Applications")

@section('content')
<div class="card">
    <div class="card-body" style="padding-left: 0px !important; padding-right: 0px !important;">
        <div class="row" style="padding-left: 20px !important; padding-right: 20px !important;">
            <div class="col-sm-5 col-9">
                <h4 class="card-title mb-0">
                    University Applications
                    <small class="text-muted"></small>
                </h4>
            </div>
            <!--col-->
            <div class="col-sm-7 col-3">
                <div class="btn-toolbar float-right" role="toolbar" aria-label="" style="margin-top: 20px;float: right;">
                    <button id="filter_toggle" class="btn btn-outline-primary btn-sm" title="Filters"><i class="bi bi-funnel-fill"></i></button>
                </div>
            </div>
            <!--col-->

        </div>
        <!--row-->
        {{-- <input type="hidden" name="task_deadline" id="task_deadline" value="{{$filters['task_deadline']}}"> --}}
        <div id="filters" class="filterBox" >
            <div class="row mt-4">
                <div class="col-sm-12 col-md-4">
                    <select class="form-select select2" style="width:100%;" id='country_search'>
                        <option value=''>Study Country</option>
                        @foreach($country_list as $each_country)
                        <option value="{{$each_country->country}}">{{$each_country->country}}</option>
                        @endforeach
                    </select>
                </div>
                @if(config('app.product_code') == 'OVERSEAS' || config('app.product_code') == 'EDUCTRL_CRM')
                <div class="col-sm-12 col-md-4">
                    <select class="form-select" id='intake'>
                        <option value=''>Intake</option>
                            <?php 
                                // $month = date('n'); // current month
                                // Adding month from January
                                $month = date('n',strtotime(date('Y-01-01')));
                                for ($x = 0; $x < 24; $x++) { ?>
                                <option value="<?php echo date('m Y', mktime(0,0,0,$month + $x,1)); ?>" >
                            <?php echo date('F Y', mktime(0,0,0,$month + $x,1)); ?>
                            <?php } ?>
                        </option>
                    </select>
                </div>            
                <div class="col-sm-12 col-md-4">
                    <select class="form-select select2apps" id='appl_status' multiple>
                        {{-- <option value=''>Application Status</option> --}}
                        @foreach($statuses as $status)
                        <option value="{{$status->status_name}}" {{($filters['appl_status'] == $status->status_name)? 'selected' : ''}}>{{$status->status_name}}</option>
                        @endforeach
                    </select>
                </div>
                @endif  
                <div class="col-sm-12 col-md-4">
                    <input type="text" autocomplete="off" class="form-control" id="created_date" name="created_date" placeholder="Created Date">
                </div>
                @if(!auth()->user()->isAgent() && !\Auth::user()->can('view assigned data only'))
                    <div class="col-sm-12 col-md-4">
                        <select class="form-select" name="assigned_to" id="assigned_to">
                            <option value="">- Assigned To -</option>
                            <option value="null" >Unassigned</option>
                            @foreach($staff as $stf)
                            <option value="{{$stf->id}}">{{$stf->first_name.' '.$stf->last_name}}@if($logged_in_user->id == $stf->id)(Me) @endif</option>
                            @endforeach
                        </select>
                    </div>
                @endif

                @if(!auth()->user()->isAgent())
                <div class="col-sm-12 col-md-4">
                    <select class="form-select" id="branch" name="branch">
                        <option value="">All Branch</option>
                        @foreach($branch as $id => $name)
                        <option value="{{ $id }}">{{ $name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-sm-12 col-md-4">
                    <div class="input-group">
                        <select class="form-control form-select" name="applied_with" id="applied_with">
                            <option value="">Applied Through Agent</option>
                            @foreach(get_app_apply_through() as $value)
                            <option value="{{$value->id}}">{{$value->name}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                @endif

                
            </div>

            <div class="row">
                <div class="col-md-2 col-sm-12 text-center mx-auto">
                    <button onclick="javascript:searchTable();" class=" btn btn-primary btn-sm">Filter</button>
                    <button onclick="javascript:clearTable();" class=" btn btn-primary btn-sm">Clear</button>
                </div>
            </div>
        </div>

        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive">
                    <table class="table" id="application_tbl">
                        <thead>
                            <tr> 
                                {{-- <th><input type="checkbox" id="select_all_apps"></th> --}}
                                <th><input type="checkbox" id="select_all"></th>
                                <th>ID</th>
                                <th style="display: none;">ID</th>
                                <th style="min-width: 70px !important;">Date Created</th>
                                <th>{{_label('backend_student')}}</th>
                                <th>Country</th>
                                <th style="min-width: 200px !important;">Details</th>
                                <th style="display: none;">University</th>
                                <th style="display: none;">Course</th>
                                <th style="display: none;">Intake</th>
                                <th>Status</th>
                                <th>Assigned To</th>
                                <th style="min-width: 70px !important;">Actions</th>
                            </tr>
                        </thead>

                    </table>
                </div>
            </div>
            <!--col-->
        </div>
        <!--row-->
        <div class="col-md-3 col-sm-12 process-selected mx-3" id="bulk_operation_applications">
            <select class="form-select" name="bulk_application_action" id="bulk_application_action">
                <option value="">- Bulk Actions -</option>
                <option value="assign">Assign To</option>
                <option value="status">Change Status</option>
                <option value="delete">Delete</option>
            </select>
        </div>
    </div>
</div>
@endsection

@push ('after-styles')
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
@endpush
@push ('after-scripts')
<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<script type="text/javascript">
    $(document).ready(function() {
        $(".select2apps").select2({
            placeholder: "Applications Status",
        });
        loadData();

        $('#filter_toggle').on('click', function() {
            $('#filters').toggle();
        });

    });

    var start = moment().subtract(29, 'days');
    var end = moment();
    $('#created_date').daterangepicker({
        "showDropdowns": true,
        "showWeekNumbers": true,
        "showISOWeekNumbers": true,
        autoUpdateInput: false,
        locale: {
                format: 'DD-MM-YYYY',
                "separator": " to ",
        },
        "ranges": {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
            },
        "alwaysShowCalendars": true,
    });
    $('#created_date').on('apply.daterangepicker', function(ev, picker) {
        $(this).val(picker.startDate.format('DD-MM-YYYY') + ' to ' + picker.endDate.format('DD-MM-YYYY'));
    });
    $('#created_date').on('cancel.daterangepicker', function(ev, picker) {
        $(this).val('');
    });


    function loadData() {
        $('#application_tbl').DataTable({
            "dom": '<"row px-3"<"col-md-3 text-start"l><"col-md-5 text-start"f><"col-md-4 text-end"B>>rt<"ps-3"i><"pe-3"p>',
            processing: true,
            serverSide: true,
            "language": {
                searchPlaceholder: "Search..."
            },
            "lengthMenu": [10, 25, 50, 100],
            "order": [2, "desc"],
            "ajax": {
                "url": "{{route('admin.applications.ajaxapplicationdata')}}",
                "dataType": "json",
                "type": "post",
                data: {
                    '_token': $('meta[name="csrf-token"]').attr('content'),
                    'country': $('#country_search').val(),
                    'intake': $('#intake').val(),
                    'appl_status': $('#appl_status').val(),
                    'created_date': $('#created_date').val(),
                    // 'task_deadline': $('#task_deadline').val(),
                    'assigned_to': $('#assigned_to').val(),
                    'branch': $('#branch').val(),
                    'applied_with': $('#applied_with').val(),
                },
            },
            autoWidth: true,
            responsive: true,
            columns: [
                    {
                    data: 'checkbox',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'appl_id',
                    orderable: false,
                },
                {
                    data: 'export_id',
                    visible: false,
                },
                {
                    data: 'created_at'
                },
                {
                    data: 'name'
                },
                {
                    data: 'country'
                },
                {
                    data: 'details',
                    orderable: false,
                },
                {
                    data: 'university',
                    visible: false,
                },
                {
                    data: 'course',
                    visible: false,
                },
                {
                    data: 'intake',
                    visible: false,
                },
                
                {
                    data: 'status'
                },
                {
                    data: 'assigned_to',
                    orderable: false,
                    //searchable: false,
                },
                {
                    data: 'action2',
                    orderable: false,
                }
            ],
            "buttons": [{
                    extend: 'excel',
                    text: '<i class="ri-file-excel-2-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Excel"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [1, 2, 3, 4, 5, 6, 7, 8, 9]
                    }
                },
                {
                    extend: 'pdf',
                    text: '<i class="bi bi-file-earmark-pdf" data-toggle="tooltip" data-placement="top" title="Pdf"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [1, 2, 3, 4, 5, 9]
                    }
                },
                {
                    extend: 'print',
                    text: '<i class="bi bi-printer" data-toggle="tooltip" data-placement="top" title="Print"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [1, 2, 3, 4, 5, 9]
                    }
                },
                {
                    extend: 'copy',
                    text: '<i class="ri-file-copy-2-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Copy"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [1, 2, 3, 4, 5, 9]
                    }
                },
                {
                    extend: 'csv',
                    text: '<i class="ri-file-excel-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Csv"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [1, 2, 3, 4, 5, 6, 7, 8, 9]
                    }
                },
            ],
            'columnDefs': [
                @if(auth()->user()->isAgent())
                {
                    target: 10,
                    visible: false,
                },
                @endif
            ],
        });
    }

    function searchTable() {
        $("#application_tbl").dataTable().fnDestroy();
        loadData();
    }

    function clearTable() {
        $('#country_search').val('');
        $('#appl_status').val('').trigger('change');
        $("#country_search").val('').trigger('change');
        $('#intake').val('');
        $('#created_date').val(''); 
        $('#appl_status').val('');
        $('#assigned_to').val('');
        $('#branch').val('');
        $('#applied_with').val('');
        $("#application_tbl").dataTable().fnDestroy();
        loadData();
    }

    function bulkAction(type) {
        let selectedIds = [];
        $('.application_checkbox:checked').each(function() {
            selectedIds.push($(this).val());
        });

        if (selectedIds.length === 0) {
            alert('Please select at least one application.');
            return;
        }

        let route = '';
        if (type === 'assign') route = "{{ route('admin.applications.bulkassignview') }}";
        if (type === 'status') route = "{{ route('admin.applications.bulkstatuschangeview') }}";
        if (type === 'delete') route = "{{ route('admin.applications.bulkdeleteview') }}";


        let form = $('<form>', {
            action: route,
            method: 'POST'
        }).append($('<input>', {
            name: '_token',
            value: $('meta[name="csrf-token"]').attr('content'),
            type: 'hidden'
        })).append($('<input>', {
            name: 'selected_ids',
            value: selectedIds.join(','),
            type: 'hidden'
        }));

        $('body').append(form);
        form.submit();
    }

    $(document).on('click', '#select_all', function () {
        const table = $('#application_tbl').DataTable();
        table.$('input.application_checkbox').prop('checked', this.checked);
    });

    document.getElementById('bulk_application_action').addEventListener('change', function () {
        const action = this.value;
        if (action) {
            bulkAction(action);
        }
    });
</script>
@endpush
@push ('after-styles')
<style>
    .select2-container .select2-selection--single {
        height: 33px !important;
    }
    .select2-container {
        width: 100% !important;
    }
    .select2-container.select2-container--default.select2-container--open {
        z-index: 5000;
    }
</style>
@endpush