@extends('backend.layouts.app')

@section('title', "New University Applications")


<?php
$years = array();
$s_yr = date("Y") + 2;
$e_yr = date("Y");
for ($i = $e_yr; $i <= $s_yr; $i++) {
    $years[$i] = $i;
}
?>

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-10 col-10">
                <h4 class="card-title mb-0">
                    New University Applications
                    <small class="text-muted">Create University Application</small>
                </h4>
            </div>
            <div class="col-sm-2 col-2" style="margin-top:20px;text-align: right;">
                <button type="cancel" name="back" class="btn btn-primary btn-sm " value="Back" onclick="document.location ='{{ route('admin.applications') }}'" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </button>
            </div>
            <!--col-->
        </div>
        <!--row-->
        <div class="row mt-4">
            <div class="col">

                <form method="post" action="{{route('admin.applications.store')}}">
                    @csrf
                    <div class="row">
                        <div class="col-sm-12 col-md-5">
                            <div class="form-group mb-3">
                                <label>Student</label>
                                <select class="form-control select2_ajax" name="userid" required></select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12 col-md-5">
                            <div class="form-group mb-3">
                                <label>Country</label>
                                <select class="form-select" name="country" required>
                                    @foreach($countries as $country)
                                    <option value="{{$country->country}}" @if(old('country') == $country->country) selected @endif>{{$country->country}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12 col-md-5">
                            <div class="form-group mb-3">
                                <label>University</label>
                                <input type="text" class="form-control" name="university" value="{{old('university')}}" required />
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12 col-md-5">
                            <div class="form-group mb-3">
                                <label>Course</label>
                                <input type="text" class="form-control" name="course" value="{{old('course')}}" required />
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12 col-md-5">
                            <div class="form-group mb-3">
                                <label>Year</label>
                                <select class="form-select" name="year" required>
                                    @foreach($years as $year)
                                    <option value="{{$year}}" @if(old('year') == $year) selected @endif>{{$year}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12 col-md-5">
                            <div class="form-group mb-3">
                                <label>Intake</label>
                                <select class="form-select" name="intake" required>
                                    @for($i=1;$i<=12;$i++) 
                                    <option value="{{$i}}" @if(old('intake') == $i) selected @endif>{{date('F', mktime(0, 0, 0, $i, 1, 2000))}}</option>
                                    @endfor
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12 col-md-5 text-center">
                            <input type="submit" class="btn btn-primary" name="submit" value="Add" />
                            <button type="button" class="btn btn-secondary" name="cancel" value="Cancel" onclick="document.location ='{{ route('admin.applications') }}'">Cancel</button>
                        </div>
                    </div>
                </form>


            </div>
            <!--col-->
        </div>
        <!--row-->

    </div>
</div>
@endsection

@push ('after-scripts')
<script>
    $(document).ready(function() {

        $('.select2_ajax').select2({
        minimumInputLength: 3,
        ajax: {
            url: '{{ route("admin.searchStudent") }}',
            type: "POST",
            dataType: 'json',
            data: function(params) {
                return {
                    q: params.term, // search term
                    _token: '{{csrf_token()}}'
                };
            },
        },
        });        
    });
</script>
@endpush
