@extends('backend.layouts.app')
@section('title', "Applications - Assign Staff")

@section('content')
<div class="card">
    <div class="card-body">
        <h4 class="card-title mb-4">University Applications - Assign To Staff</h4>


        {{ html()->form('POST', route('admin.application.bulkassign.update'))
            ->class('form-horizontal')
            ->attribute('enctype', 'multipart/form-data')
            ->open() }}
        
        {{-- Hidden IDs --}}
        @foreach ($applications as $application)
            <input type="hidden" name="application_ids[]" value="{{ $application->application_id }}">
        @endforeach

        <div class="mb-3">
            <strong>Selected Applications:</strong>
            <ul>
                @foreach ($applications as $app)
                    <li>
                        <strong>Application</strong> #{{ $app->appl_id }} – {{ $app->first_name }} {{ $app->last_name }}
                    </li>
                @endforeach
            </ul>
        </div>

        <div class="row mb-3">
            <div class="col-md-6">
                <label for="staff_id" class="form-label"><strong>Assign To</strong></label>
                <select name="staff" class="form-select" required>
                    <option value="">Select Staff</option>
                    @foreach ($staff as $stf)
                        <option value="{{ $stf->id }}">{{ $stf->first_name }} {{ $stf->last_name }}</option>
                    @endforeach
                </select>
            </div>
        </div>

        <div class="mt-4">
            <button type="submit" class="btn btn-primary">Assign</button>
            <a href="{{ route('admin.applications') }}" class="btn btn-secondary">Cancel</a>
        </div>

        {{ html()->form()->close() }}
    </div>
</div>
@endsection

@push('after-scripts')
<script>
    $(document).ready(function () {
        $('select[name="staff_id"]').select2({
            placeholder: "Select Staff",
            width: '100%'
        });
    });
</script>
@endpush