@extends('backend.layouts.app')
@section('title', "Applications - Confirm Delete")
@section('content')

<div class="card">
    <div class="card-body">
        <h4 class="card-title mb-3 text-danger">Confirm Delete</h4>

        <div style="max-width: 500px;">
            {{ html()->form('POST', route('admin.application.bulkdelete'))
                ->class('form-horizontal')
                ->attribute('enctype', 'multipart/form-data')
                ->open() }}

            @foreach ($applications as $app)
                <input type="hidden" name="selected_ids[]" value="{{ $app->id }}">
            @endforeach

            <p>Are you sure you want to delete <strong>{{ count($applications) }}</strong> application(s)? This action cannot be undone.</p>

            <ul>
                @foreach ($applications as $app)
                    <li>
                        <strong>Application</strong> #{{ $app->appl_id }} – {{ $app->first_name }} {{ $app->last_name }}
                    </li>
                @endforeach
            </ul>

            <div class="mt-3">
                <button type="submit" class="btn btn-danger">Yes, Delete</button>
                <a href="{{ route('admin.applications') }}" class="btn btn-secondary">Cancel</a>
            </div>

            {{ html()->form()->close() }}
        </div>
    </div>
</div>
@endsection