@extends('backend.layouts.app')
@section('title', "Applications - Change Status")
@section('content')

<div class="card">
    <div class="card-body">
        <h4 class="card-title mb-3">University Applications - Change Status</h4>

        {{ html()->form('POST', route('admin.application.bulkstatus.update'))
            ->class('form-horizontal')
            ->attribute('enctype', 'multipart/form-data')
            ->open() }}

        @foreach ($applications as $app)
            <input type="hidden" name="selected_ids[]" value="{{ $app->id }}">
        @endforeach

        {{-- List shown to the user --}}
        <div class="mb-3">
            <strong>Selected Applications:</strong>
            <ul>
                @foreach ($applications as $app)
                    <li>
                        <strong>Application</strong> #{{ $app->appl_id }} –
                        {{ $app->first_name }} {{ $app->last_name }}
                    </li>
                @endforeach
            </ul>
        </div>

        <div class="row mb-3">
            <div class="col-md-4">
                <label><strong>Status</strong></label>
                <select name="status" class="form-select" required>
                    <option value="">Select Status</option>
                    @foreach ($statusList as $stat)
                        <option value="{{ $stat->status_name }}">
                            {{ ucfirst($stat->status_name) }}
                        </option>
                    @endforeach
                </select>
            </div>
        </div>

        <div class="row mb-3">
            <div class="col-md-4">
                <label><strong>Notes (Optional)</strong></label>
                <textarea name="note" class="form-control" rows="3" placeholder="Enter notes..."></textarea>
            </div>
        </div>

        <div class="mt-3">
            {{ form_submit('Update Status') }}
            <a href="{{ route('admin.applications') }}" class="btn btn-secondary btn-sm">Cancel</a>
        </div>

        {{ html()->form()->close() }}
    </div>
</div>
@endsection