@extends('backend.layouts.app')
@section('title', "Application - Assign To Staff")
@section('content')

<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-10 col-10">
                <h4 class="card-title mb-0">
                    University Applications - Assign To Staff
                </h4><br>
            </div>
            <!--col-->
            <div class="col-sm-2 col-2" style="margin-top:20px;text-align: right;">
                <button type="cancel" name="back" class="btn btn-primary btn-sm" value="Back" onclick="document.location ='{{ route('admin.applications') }}'" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </button>
            </div>
        </div>
        <!--row-->
        {{ html()->form('POST', route('admin.collegeApplication.assignstaff.update'))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}

       
        {{-- <input type="hidden" name="lead_id" value="{{$leaddata->id}}"> --}}
        <input type="hidden" name="id" value="{{$collegeApplication->id}}">
        <div class="row mb-2">
            <div class="col-sm-12 col-md-6">
                @if($collegeApplication->appl_id)<span class="col-form-label"><b>University Applications ID: </b>{{$collegeApplication->appl_id}}</span><br>@endif
                @if($collegeApplication->university)<span class="col-form-label"><b>University: </b>{{$collegeApplication->university}}</span><br>@endif
                @if($collegeApplication->course)<span class="col-form-label"><b>Course: </b>{{$collegeApplication->course}}<br>@endif
                @if($collegeApplication->country)<span class="col-form-label"><b>Country: </b>{{$collegeApplication->country}}@endif
                {{-- @if($visaApplication->appl_id)<span class="col-form-label"><b>Detail: {{$visaApplication->detail}}</b></span><br>@endif --}}
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12 col-md-6">
                <b>Student: </b><br>{{ $userdata->first_name }} {{$userdata->last_name }}<br>
                {{ $userdata->email }}
                </div>
            </div>
            <br>
        {{-- </div>

        <div class="row mb-2 mx-2"> --}}
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label"><b>Assign To</b></label>
                <div class="">
                    <select class="form-select" id='staff' name="staff">
                        <option value=''>Select</option>
                             @foreach($staff as $stf)
                                <option value="{{$stf->id}}" {{($collegeApplication->assign_to == $stf->id) ? 'selected' : ''}}>{{$stf->first_name . ' ' . $stf->last_name}}</option>
                            @endforeach
                    </select>
                </div>
            </div>
        </div>
            
        <div class="row mx-2 mb-3">
            <div class="col-sm-12 col-md-8">
                <div class="form-group mb-0 clearfix">
                    {{ form_submit("Save") }}
                    <button type="button" class="btn btn-secondary btn-sm" name="cancel" value="Cancel" onclick="document.location ='{{ route('admin.applications') }}'">Cancel</button>
                </div>
            </div>
        </div>


    </div>
</div>
@endsection
