@extends('backend.layouts.app')
@section('title', 'Edit Course Preference')
@section('content')
@php
$userCoursePref = get_user_by_id($pref->userid);
$countries = get_course_preference_countries();
$months = array();
for ($i = 1; $i <= 12; $i++) { $months[$i]=date('F', strtotime("2000-".$i."-01")); } 
@endphp 
<div class="card">

    <div class="card-body">
        <div class="row">
            <div class="col-sm-9 col-9">
                <h4 class="card-title mb-0">
                    Edit University Application #{{$applicationDetails->appl_id}}
                </h4>
            </div>
            {{-- <div class="col-sm-3 col-3" style="margin-top:20px;text-align: right;">
                <button type="cancel" name="back" class="btn btn-primary btn-sm " value="Back" onclick="document.location ='{{ url()->previous() }}'" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </button>
            </div> --}}
        </div>

        <div class="row mb-4">
            <div class="col">
                <div class="">
                    <form method="post" action="{{route('admin.application.course-university.edit.save')}}">
                        @csrf
                        <input type="hidden" name="pref_id" value="{{$pref->id}}">
                        <input type="hidden" name="user_id" value="{{$pref->userid}}">
                        <input type="hidden" name="byApplOrCouPref" value="{{$byApplOrCouPref}}">
                        <div class=" card-outline-info">
                            <div class="card-body mt-4">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group" style="margin-bottom:15px !important;">
                                            <label style="margin-bottom: 0.2rem;" class="required-field">Country</label>
                                            <select class="form-control form-select" id="country" name="country">
                                                @foreach($countries as $country)
                                                <option value="{{$country->id}}" @if($country->id == $pref->country_id) selected @endif>{{$country->title_en}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        @if($pref->university_id)
                                            <label for="university-select" class="required-field">University</label>
                                            <select name="university" id="university-select" style="width:100%;" placeholder="university" class='form-control form-select select2' type="text">
                                                {{-- <option value="{{$pref->university_id}}">{{get_university_data($pref->university_id)->university_name}}</option> --}}
                                            </select>
                                        @else
                                            <label for="university" class="required-field">University</label>
                                            <input type="text" value="{{$pref->university_other}}" name="university" id="university" placeholder="University" class='form-control'>
                                        @endif
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        @if($pref->course_id)
                                        <label for="course-select" class="required-field">Course</label>
                                        <select name="course" id="course-select" style="width:100%" placeholder="Course" class='form-control form-select select2' type="text" required>
                                            {{-- <option value="{{$pref->course_id}}">{{get_university_course_data($pref->course_id)->course_name}}</option> --}}
                                        </select>
                                        @else
                                            <label for="course" class="required-field">Course</label>
                                            <input type="text" value="{{$pref->course_other}}" name="course" id="course" placeholder="Course" class='form-control'>
                                        @endif
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="required-field">Intake</label><br>
                                           <!--  <select name="intake[]" class="select2 select2-multiple" style="min-width:260px;" multiple="multiple" data-placeholder="Choose">
                                                @php
                                                $intakes = explode(",", $pref->intake);
                                                @endphp
                                                @foreach($months as $key => $value)
                                                <option value="{{$key}}" @if(in_array($key, $intakes)) selected @endif>{{$value}}</option>
                                                @endforeach
                                            </select> -->
                                            @php
                                                $intake = $pref->intake.' '.$pref->intake_year;
                                            @endphp
                                            <select name="intake" class="form-select form-control">
                                                <option value="">Intake</option>
                                                <?php $month = date('n'); // current month
                                                 for ($x = 0; $x < 24; $x++) { ?>
                                                    <option <?php if($intake == date('m Y', mktime(0,0,0,$month + $x,1))) echo 'selected'; else echo''; ?> value="<?php echo date('m Y', mktime(0,0,0,$month + $x,1)); ?>" >
                                                  <?php echo date('F Y', mktime(0,0,0,$month + $x,1)); ?>
                                                 <?php } ?></option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="mt-4 text-left">
                                    <button type="submit" class="btn btn-primary" style="padding-left:40px;padding-right:40px;">Save</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
{{ html()->closeModelForm() }}
@endsection
@push('after-scripts')
<script>

    $(document).ready(function() {
        
        addDeleteForms();
        
        var s_level = "{{$userCoursePref->overseas_study_level_selection}}";

        $('#courseSelect').select2({
            minimumInputLength: 3,
            tags: true,
            placeholder: "Course*",
            selectOnClose: true,
            ajax: {
                url: '{{ route("admin.searchCourse") }}',
                type: "POST",
                dataType: 'json',
                data: function(params) {
                    return {
                        s_level: s_level,
                        q: params.term, // search term
                        _token: '{{csrf_token()}}'
                    };
                },
            },
        });

        $('#universitySelect').select2({
            minimumInputLength: 3,
            tags: true,
            placeholder: "University",
            selectOnClose: true,
            ajax: {
                url: '{{ route("admin.searchUniversity") }}',
                type: "POST",
                dataType: 'json',
                data: function(params) {
                    return {
                        q: params.term, // search term
                        _token: '{{csrf_token()}}'
                    };
                },
            },
        });

        $('#country').on('change', function () {
            var idCountry = this.value;
            $("#university-select").html('');
            $.ajax({
                url: "{{url('api/fetch-university')}}",
                type: "POST",
                data: {
                    country_id: idCountry,
                    _token: '{{csrf_token()}}'
                },
                dataType: 'json',
                success: function (result) {
                    $('#university-select').html('<option value="">Select University</option>');
                    $.each(result.university, function (key, value) {
                        if(value.id == "{{($pref) ? $pref->university_id :''}}"){
                            var selectedUniversity = "selected=\"'selected'\"";
                        }else if(value.id == "{{old('university')}}"){
                            var selectedUniversity = "selected=\"'selected'\"";
                        }
                        else{
                            var selectedUniversity = "";
                        }
                        $("#university-select").append('<option '+selectedUniversity+' value="'+ value.id + '">' + value.university_name + '</option>');
                    });
                    $('#university-select').trigger('change');
                }
            });
        });

        $('#university-select').on('change', function () {
            var idUniversity = this.value;
            var s_level = "{{$userCoursePref->overseas_study_level_selection}}";
            $("#course-select").html('');
            $.ajax({
                url: "{{url('api/fetch-course')}}",
                type: "POST",
                data: {
                    university_id: idUniversity,
                    s_level: s_level,
                    _token: '{{csrf_token()}}'
                },
                dataType: 'json',
                success: function (result) {
                    $('#course-select').html('<option value="">Select Course</option>');
                    $.each(result.course, function (key, value) {
                        if(value.id == "{{($pref) ? $pref->course_id :''}}"){
                            var selectedCourse = "selected=\"'selected'\"";
                        }else if(value.id == "{{old('course')}}"){
                            var selectedCourse = "selected=\"'selected'\"";
                        }
                        else{
                            var selectedCourse = "";
                        }
                        $("#course-select").append('<option '+selectedCourse+' value="'+ value.id + '">' + value.course_name + '</option>');
                    });
                }
            });
        });

        $('#country').trigger('change');
        // setTimeout(() => {
        //     $('#university-select').trigger('change');
        // }, 700);
    });

</script>
@endpush