<div class="row">
    <div class="col-3 ms-auto">
        <button type="button" data-bs-toggle="modal" data-bs-target="#setFeesCommssion" class="btn btn-sm btn-primary"><i class="fas fa-plus-circle"></i> Set Fee, Commission</button>
    </div>
</div>
<div class="row card mx-1 py-3 mt-2">
    <h4>University Fees Payments</h4>
    <div class="col-6 mt-2">
        <div class="row">
            <div class="col-6">
                <p>Total Fees: <b>@if($data->tuition_fees) {{$data->fees_currency}}{{get_currency_symbol($data->fees_currency)}} {{number_format($data->tuition_fees, 2)}} @else -- @endif</b></p>
            </div>
            <div class="col-6">
                @php
                    $paidAmount = 0;
                    foreach ($collegeFeePayments as $collegeFeePayment){
                        $paidAmount += $collegeFeePayment->college_fee_amount;
                    }
                @endphp
                <p>Paid: <b>@if($data->tuition_fees) {{$data->fees_currency}}{{get_currency_symbol($data->fees_currency)}} @endif {{number_format($paidAmount, 2)}}</b></p>
            </div>
        </div>
    </div>
    <div class="col-12">
        <div class="table-responsive">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>Date Paid</th>
                        <th>Notes</th>
                        <th>Amount</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @if(count($collegeFeePayments))
                    @foreach ($collegeFeePayments as $collegeFeePayment)
                    <tr>
                        <td>{{date('d M Y', strtotime($collegeFeePayment->date_paid))}}</td>
                        <td>{{$collegeFeePayment->notes}}</td>
                        <td>{{$data->fees_currency}}{{get_currency_symbol($data->fees_currency)}} {{number_format($collegeFeePayment->college_fee_amount, 2)}}</td>
                        <td class="d-flex">
                            <button
                                class="btn btn-sm btn-primary editCollegeFeePayment mx-1"
                                data-id="{{$collegeFeePayment->id}}"
                                data-toggle="tooltip" data-placement="top"
                                title="Edit">
                                <i class="fa fa-edit"></i>
                            </button>
                            <a href="{{ route('admin.application.delete-college-fee-payment',[$collegeFeePayment->id, $collegeFeePayment->application_id]) }}" data-method="delete"
                                data-html="true" 
                                data-trans-title="Are you sure you want to delete this? <br><br><label style=&quot;color: red; font-size: 15px;&quot;>This action cannot be reversed!</label>"
                                class="btn btn-danger btn-sm"><i class="fa fa-trash"></i>
                            </a>
                        </td>                        
                    </tr>
                    @endforeach
                    @else
                        <tr>
                            <td colspan="4" class="text-center">No Record Found</td>
                        </tr>
                    @endif
                </tbody>
            </table>
        </div>
    </div>
    <div class="col-3">
        <button type="button" data-bs-toggle="modal" data-bs-target="#collegeFeePayment" class="btn btn-sm @if($data->tuition_fees) btn-primary @else btn-secondary disabled @endif"><i class="fas fa-plus-circle"></i> Add New Record</button>
    </div>
</div>

<div class="row card mx-1 py-3 mt-4">
    <h4>Our Commission</h4>
    <div class="col-8 mt-2">
        <div class="row">
            <div class="col-4">
                <p>Expected: <b>@if($data->my_commission) {{$data->fees_currency}}{{get_currency_symbol($data->fees_currency)}} {{number_format($data->my_commission, 2)}}@else -- @endif</b></p>
            </div>
            <div class="col-4">
                @php
                    $totalCummission = $data->my_commission;
                    $received = 0;
                    $due = 0;
                    foreach ($myCommission as $commission){
                        $received += $commission->my_commission_amount;
                    }
                    $due = $totalCummission - $received;
                @endphp
                <p>Received: <b>@if($received) {{$data->fees_currency}}{{get_currency_symbol($data->fees_currency)}} {{number_format($received, 2)}} @else -- @endif</b></p>
            </div>
            <div class="col-4">
                <p>Due: <b>@if($due) {{$data->fees_currency}}{{get_currency_symbol($data->fees_currency)}} {{number_format($due, 2)}} @else -- @endif</b></p>
            </div>
        </div>
    </div>
    <div class="col-12">
        <div class="table-responsive">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>Date Received</th>
                        <th>Notes</th>
                        <th>Amount</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @if(count($myCommission))
                    @foreach ($myCommission as $commission)
                    <tr>
                        <td>{{date('d M Y', strtotime($commission->date_received))}}</td>
                        <td>{{$commission->notes}}</td>
                        <td>{{$data->fees_currency}}{{get_currency_symbol($data->fees_currency)}} {{number_format($commission->my_commission_amount, 2)}}</td>
                        <td class="d-flex">
                            <button
                                class="btn btn-sm btn-primary editMyCommission mx-1"
                                data-id="{{$commission->id}}"
                                data-toggle="tooltip" data-placement="top"
                                title="Edit">
                                <i class="fa fa-edit"></i>
                            </button>
                            <a href="{{ route('admin.application.delete-my-commission',[$commission->id, $commission->application_id]) }}" data-method="delete"
                                data-html="true" 
                                data-trans-title="Are you sure you want to delete this? <br><br><label style=&quot;color: red; font-size: 15px;&quot;>This action cannot be reversed!</label>"
                                class="btn btn-danger btn-sm"><i class="fa fa-trash"></i>
                            </a>
                        </td>
                    </tr>
                    @endforeach
                    @else
                        <tr>
                            <td colspan="4" class="text-center">No Record Found</td>
                        </tr>
                    @endif
                </tbody>
            </table>
        </div>
    </div>
    <div class="col-3">
        <button type="button" data-bs-toggle="modal" data-bs-target="#myCommision" class="btn btn-sm @if($data->tuition_fees) btn-primary @else btn-secondary disabled @endif"><i class="fas fa-plus-circle"></i> Add New Record</button>
    </div>
</div>

<div class="row card mx-1 py-3 mt-4">
    <h4>Agent Commission</h4>
    <div class="col-8 mt-2">
        <div class="row">
            <div class="col-4">
                
                <p>Expected: <b>@if($data->agent_commission) {{$data->fees_currency}}{{get_currency_symbol($data->fees_currency)}} {{number_format($data->agent_commission, 2)." (".get_currency_by_user_country($student->agent_id).get_currency_symbol(get_currency_by_user_country($student->agent_id)).' '.currency_convert($data->agent_commission, $data->fees_currency, get_currency_by_user_country($student->agent_id)).")"}}@else -- @endif</b></p>
                {{-- <p>Expected: <b>@if($data->agent_commission) {{$data->fees_currency}}{{get_currency_symbol($data->fees_currency)}} {{number_format($data->agent_commission, 2)}}@else -- @endif</b></p> --}}
            </div>
            <div class="col-4">
                @php
                    $totalCummission = $data->agent_commission;
                    $paid = 0;
                    $due = 0;
                    foreach ($agentCommission as $commission){
                        $paid += $commission->amount;
                    }
                    $due = $totalCummission - $paid;
                @endphp
                <p>Paid: <b>@if($paid) {{$data->fees_currency}}{{get_currency_symbol($data->fees_currency)}} {{number_format($paid, 2)." (".get_currency_by_user_country($student->agent_id).get_currency_symbol(get_currency_by_user_country($student->agent_id)).' '.currency_convert($paid, $data->fees_currency, get_currency_by_user_country($student->agent_id)).")"}} @else -- @endif</b></p>
            </div>
            <div class="col-4">
                <p>Due: <b>@if($due) {{$data->fees_currency}}{{get_currency_symbol($data->fees_currency)}} {{number_format($due, 2)." (".get_currency_by_user_country($student->agent_id).get_currency_symbol(get_currency_by_user_country($student->agent_id)).' '.currency_convert($due, $data->fees_currency, get_currency_by_user_country($student->agent_id)).")"}} @else -- @endif</b></p>
            </div>
        </div>
    </div>
    <div class="col-12">
        <div class="table-responsive">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Notes</th>
                        <th>Amount</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @if(count($agentCommission))
                    @foreach ($agentCommission as $commission)
                    <tr>
                        <td>{{date('d M Y', strtotime($commission->created_at))}}</td>
                        <td>{{$commission->agent_commission_notes}}</td>
                        <td>{{$data->fees_currency}}{{get_currency_symbol($data->fees_currency)}} {{number_format($commission->amount, 2)." (".get_currency_by_user_country($student->agent_id).get_currency_symbol(get_currency_by_user_country($student->agent_id)).' '.currency_convert($commission->amount, $data->fees_currency, get_currency_by_user_country($student->agent_id)).")"}}</td>
                        <td class="d-flex">
                            <button
                                class="btn btn-sm btn-primary editAgentCommission mx-1"
                                data-id="{{$commission->id}}"
                                data-toggle="tooltip" data-placement="top"
                                title="Edit">
                                <i class="fa fa-edit"></i>
                            </button>
                            <a href="{{ route('admin.application.delete-agent-commission',[$commission->id, $commission->appl_id]) }}" data-method="delete"
                                data-html="true" 
                                data-trans-title="Are you sure you want to delete this? <br><br><label style=&quot;color: red; font-size: 15px;&quot;>This action cannot be reversed!</label>"
                                class="btn btn-danger btn-sm"><i class="fa fa-trash"></i>
                            </a>
                        </td>
                    </tr>
                    @endforeach
                    @else
                        <tr>
                            <td colspan="4" class="text-center">No Record Found</td>
                        </tr>
                    @endif
                </tbody>
            </table>
        </div>
    </div>
    <div class="col-3">
        <button type="button" data-bs-toggle="modal" data-bs-target="#agentCommission" class="btn btn-sm @if($data->tuition_fees && $student->agent_id) btn-primary @else btn-secondary disabled @endif"><i class="fas fa-plus-circle"></i> Add New Record</button>
    </div>
</div>

{{-- Set Fees and Commssion --}}

<div class="modal fade " id="setFeesCommssion" tabindex="-1" aria-labelledby="setFeesCommssionLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header ">
            <h5 class="modal-title" id="setFeesCommssionLabel">Set Fee, Commission</h5>
            <button type="button" class="btn-close border" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <form method="post" action="{{ route('admin.application.set-fee-commission') }}">
        <div class="modal-body">
                @csrf
                <input type="hidden" name="application_id" value="{{$data->id}}">
                <div class="row">
                    <div class="col-sm-12 col-md-7">
                        <label class="required-field" for="tuition_fees">Total Tution Fees</label>
                        <div class="input-group">
                            <div class="input-group-prepend" style="width: 30% !important;">
                                <select name="fees_currency" class="form-select" style="height: 75%; border-top-right-radius: 0px !important; border-bottom-right-radius: 0px !important;" required>
                                    {{-- <option value="">Currency</option> --}}
                                    @foreach($currency as $curr)
                                    <option {{(old('fees_currency') == $curr->currency_code)? 'selected' : ''}}  value="{{ $curr->currency_code }}">{{ $curr->currency_code }} ({{ $curr->currency_symbol }})</option>
                                    @endforeach
                                </select>
                            </div>
                            <input type="number" placeholder="Total Fees" min="0" step="0.01" class="form-control" name="tuition_fees" id="tuition_fees" required>
                        </div>
                    </div>
                    <div class="form-group col-md-4">
                        <label class="required-field" for="my_commission">Our Commission (%)</label>
                        <input type="number" placeholder="" min="0" step="0.01" class="form-control" name="my_commission_percent" id="my_commission" required>
                    </div>
                    @if($student->agent_id)
                    <div class="form-group col-md-4">
                        <label class="required-field" for="agent_commission">For Agent (%)</label>
                        <input type="number" placeholder="" min="0" step="0.01" class="form-control" name="agent_commission_percent" id="agent_commission" required>
                        <small>% of Tuition fees</small>
                    </div>
                    @endif
                </div>
            </div>
            <div class="modal-footer">
                {{-- <button type="button" class="btn btn-sm btn-secondary" data-bs-dismiss="modal">Close</button> --}}
                <button type="submit" class="btn btn-sm btn-primary mx-auto">Save</button>
            </div>
        </div>
    </form>
    </div>
</div>

{{-- University Fee Payments --}}

<div class="modal fade " id="collegeFeePayment" tabindex="-1" aria-labelledby="collegeFeePaymentLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header ">
            <h5 class="modal-title" id="collegeFeePaymentLabel">Add University Fee Payment</h5>
            <button type="button" class="btn-close border" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <form method="post" action="{{ route('admin.application.add-college-fee-payment') }}">
        @csrf
            <div class="modal-body">
                <input type="hidden" name="application_id" value="{{$data->id}}">
                <input type="hidden" name="tution_fees" value="{{$data->tuition_fees}}">
                <div class="row">
                    <div class="form-group col-md-6">
                        <label class="required-field" for="date_paid">Date Paid</label>
                        <input type="text" placeholder="Date Paid" class="form-control modalMydatepicker" autocomplete="off" id="date_paid" name="date_paid" value="{{ Request::old('date_paid') }}" required>
                    </div>
                    <div class="form-group col-md-6">
                        <label class="required-field" for="college_fee_amount">Amount</label>
                        <input type="number" placeholder="Amount" class="form-control" min="0" step="0.01" name="college_fee_amount" id="college_fee_amount" required>
                    </div>
                    <div class="form-group col-12">
                        <label class="required-field" for="college_fee_notes">Notes</label>
                        <textarea class="form-control" name="college_fee_notes" id="college_fee_notes" placeholder="Notes..."></textarea>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                {{-- <button type="button" class="btn btn-sm btn-secondary" data-bs-dismiss="modal">Close</button> --}}
                <button type="submit" class="btn btn-sm btn-primary mx-auto">Save</button>
            </div>
        </div>
    </form>
    </div>
</div>

<div class="modal fade" id="editCollegeFeePayment">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Edit University Fee Payment</h5>
                <button type="button" class="btn-close border" data-bs-dismiss="modal" aria-label="Close"
                    style="font-size: 12px;"></button>
            </div>
            <div class="modal-body load_modal">

            </div>
        </div>
    </div>
</div>

{{-- --------------------------------------------------------------------------------------------------------------- --}}

{{-- My Commission --}}

<div class="modal fade " id="myCommision" tabindex="-1" aria-labelledby="myCommisionLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header ">
            <h5 class="modal-title" id="myCommisionLabel">Add My Commision</h5>
            <button type="button" class="btn-close border" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <form method="post" action="{{ route('admin.application.add-my-commission') }}">
        @csrf
            <div class="modal-body">
                <input type="hidden" name="application_id" value="{{$data->id}}">
                <input type="hidden" name="my_commission" value="{{$data->my_commission}}">
                <div class="row">
                    <div class="form-group col-md-6">
                        <label class="required-field" for="date_received">Date Received</label>
                        <input type="text" placeholder="Date Received" class="form-control modalMydatepicker" autocomplete="off" id="date_received" name="date_received" value="{{ Request::old('date_received') }}" required>
                    </div>
                    <div class="form-group col-md-6">
                        <label class="required-field" for="my_commission_amount">Amount</label>
                        <input type="number" placeholder="Amount" min="0" step="0.01" class="form-control" name="my_commission_amount" id="my_commission_amount" required>
                    </div>
                    <div class="form-group col-12">
                        <label class="required-field" for="my_commission_notes">Notes</label>
                        <textarea class="form-control" name="my_commission_notes" id="my_commission_notes" placeholder="Notes..."></textarea>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                {{-- <button type="button" class="btn btn-sm btn-secondary" data-bs-dismiss="modal">Close</button> --}}
                <button type="submit" class="btn btn-sm btn-primary mx-auto">Save</button>
            </div>
        </div>
    </form>
    </div>
</div>


<div class="modal fade" id="editMyCommission">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Edit My Commission</h5>
                <button type="button" class="btn-close border" data-bs-dismiss="modal" aria-label="Close"
                    style="font-size: 12px;"></button>
            </div>
            <div class="modal-body load_modal">

            </div>
        </div>
    </div>
</div>

{{-- --------------------------------------------------------------------------------------------------------------- --}}

{{-- Agent Commission --}}

<div class="modal fade " id="agentCommission" tabindex="-1" aria-labelledby="agentCommissionLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header ">
            <h5 class="modal-title" id="agentCommissionLabel">Add Agent Commission</h5>
            <button type="button" class="btn-close border" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <form method="post" action="{{ route('admin.application.add-agent-commission') }}">
        @csrf
            <div class="modal-body">
                <input type="hidden" name="application_id" value="{{$data->id}}">
                <input type="hidden" name="agent_commission" value="{{$data->agent_commission}}">
                <input type="hidden" name="agent_id" value="{{$student->agent_id}}">
                <div class="row">
                    <div class="form-group col-md-6">
                        <label class="required-field" for="commission_paid_date">Date</label>
                        <input type="text" placeholder="Date" class="form-control modalMydatepicker" autocomplete="off" id="commission_paid_date" name="commission_paid_date" value="{{ Request::old('commission_paid_date') }}" required>
                    </div>
                    <div class="form-group col-md-6">
                        <label class="required-field" for="agent_commission_amount">Amount</label>
                        <input type="number" placeholder="Amount" min="0" step="0.01" class="form-control" name="agent_commission_amount" id="agent_commission_amount" required>
                    </div>
                    <div class="form-group col-12">
                        <label class="required-field" for="agent_commission_notes">Notes</label>
                        <textarea class="form-control" name="agent_commission_notes" id="agent_commission_notes" placeholder="Notes..."></textarea>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                {{-- <button type="button" class="btn btn-sm btn-secondary" data-bs-dismiss="modal">Close</button> --}}
                <button type="submit" class="btn btn-sm btn-primary mx-auto">Save</button>
            </div>
        </div>
    </form>
    </div>
</div>

<div class="modal fade" id="editAgentCommission">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Edit Agent Commission</h5>
                <button type="button" class="btn-close border" data-bs-dismiss="modal" aria-label="Close"
                    style="font-size: 12px;"></button>
            </div>
            <div class="modal-body load_modal">

            </div>
        </div>
    </div>
</div>

{{-- --------------------------------------------------------------------------------------------------------------- --}}

@push('after-styles')

@endpush

@push('after-scripts')
<script>
    $(document).ready(function () {
        addDeleteForms();
    });

    $('.modalMydatepicker').datetimepicker({
        timepicker: false,
        format: 'd-m-Y',
        scrollInput: false,
        maxDate: 0
    });
    
    $(document).on('click', '.editCollegeFeePayment', function() {
        var this_id = $(this).attr('data-id');
        var base_url = "{{ url('/admin/application/edit-college-fee-payment/') }}/" + this_id;
        $.get(base_url, function(data) {
            $('#editCollegeFeePayment').on('shown.bs.modal', function() {
                $('#editCollegeFeePayment .load_modal').html(data);
            });
            $('#editCollegeFeePayment').modal('show');
            $('#editCollegeFeePayment').on('hidden.bs.modal', function() {
                $('#editCollegeFeePayment .load_modal').html("");
            });
        });
    });

    $(document).on('click', '.editMyCommission', function() {
        var this_id = $(this).attr('data-id');
        var base_url = "{{ url('/admin/application/edit-my-commission/') }}/" + this_id;
        $.get(base_url, function(data) {
            $('#editMyCommission').on('shown.bs.modal', function() {
                $('#editMyCommission .load_modal').html(data);
            });
            $('#editMyCommission').modal('show');
            $('#editMyCommission').on('hidden.bs.modal', function() {
                $('#editMyCommission .load_modal').html("");
            });
        });
    });

    $(document).on('click', '.editAgentCommission', function() {
        var this_id = $(this).attr('data-id');
        var base_url = "{{ url('/admin/application/edit-agent-commission//') }}/" + this_id;
        $.get(base_url, function(data) {
            $('#editAgentCommission').on('shown.bs.modal', function() {
                $('#editAgentCommission .load_modal').html(data);
            });
            $('#editAgentCommission').modal('show');
            $('#editAgentCommission').on('hidden.bs.modal', function() {
                $('#editAgentCommission .load_modal').html("");
            });
        });
    });
</script>
@endpush
