<div class="row">
    <div class="col">
        <div class="table-responsive">
            @if(!$student->profile_complete)
            <div class="alert alert-danger" role="alert">
                Student Profile Incomplete
            </div>
            @endif
            <h4>Basic Information</h4>
            
            <div style="float:right;">
                @if($student->student_type == 'study_abroad' || $student->student_type == 'study_abroad_course' || $student->student_type == 'abroad_job' || $student->student_type == 'visa')
                {{-- {{ html()->modelForm($logged_in_user, 'POST', route('admin.downloads.userprofile'))->style('display:inline')->open() }}
                <input type="hidden" name="uid" value="{{ $student->id }}">
                <input type="submit" class="btn btn-success" name="download" value="Download Profile (pdf)">
                {{ html()->closeModelForm() }} --}}
                
                @endif
            </div>
            <div class="row mt-5">
                <div class="col-sm-12 col-md-4">
                    <label>First Name</label>
                    <p><b>{{ $student->first_name }}</b></p>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label>Middle Name</label>
                    <p><b>{{ ($student->middle_name!='')?$student->middle_name:'' }}</b></p>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label>Last Name</label>
                    <p><b>{{ ($student->last_name!='')?$student->last_name:'' }}</b></p>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label>Gender</label>
                    <p><b>{{ $student->gender }}</b></p>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label>E-mail</label>
                    <p><b>{{ $student->email }}</b></p>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label>Mobile</label>
                    <p><b>@if($student->dialcode) +{{ $student->dialcode }}-@endif{{ $student->mobile }}</b></p>
                </div>
               
                <div class="col-sm-12 col-md-4">
                    <label>Date of Birth</label>
                    <p><b> @if($student->birthday) {{date("d-m-Y", strtotime($student->birthday))}}@else -- @endif</b></p>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label>Referral Code</label>
                    <p><b>{{$student->refcode}}</b></p>
                </div>

            </div>
    @if($student->student_type!='course')
            <hr class="mb-1" style="height:2px;border-width:0;background-color:#b6b4b482">
            <h4 class="mb-3">Current Address</h4>
            <div class="row">
                <div class="col-sm-12 col-md-4">
                    <label>Address</label>
                    <p><b>{{ ($student->address_1!='')?$student->address_1:'--' }}</b></p>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label>Country</label>
                    <p><b>{{ ($student->country!='')?get_country_name($student->country):'--' }}</b></p>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label>State</label>
                    <p><b>{{ ($student->state!='')?get_state_name($student->state):'--' }}</b></p>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label>City</label>
                    <p><b>{{ ($student->city!='')?$student->city:'--' }}</b></p>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label>Postal Code</label>
                    <p><b>{{ ($student->post_code!='')?$student->post_code:'--' }}</b></p>
                </div>
            </div>
                <hr class="mb-1" style="height:2px;border-width:0;background-color:#b6b4b482">
                <h4 class="mb-3">Permanent Address</h4>
                @if($userDetails && $userDetails->permanent_address == $student->address_1)
                <div class="row">
                    <p class="mb-4"><b>Same as Current Address</b></p>
                    @else
                <div class="row">
                    <div class="col-sm-12 col-md-4">
                        <label>Address</label>
                        <p><b>{{ ($userDetails)? $userDetails->permanent_address : '--' }}</b></p>
                    </div>
                    <div class="col-sm-12 col-md-4">
                        <label>Country</label>
                        <p><b>{{ ($userDetails)? get_country_name($userDetails->permanent_country) : '--' }}</b></p>
                    </div>
                    <div class="col-sm-12 col-md-4">
                        <label>State</label>
                        <p><b>{{ ($userDetails)? get_state_name($userDetails->permanent_state) : '--' }}</b></p>
                    </div>
                    <div class="col-sm-12 col-md-4">
                        <label>City</label>
                        <p><b>{{ ($userDetails)? $userDetails->permanent_city : '--' }}</b></p>
                    </div>
                    <div class="col-sm-12 col-md-4">
                        <label>Postal Code</label>
                        <p><b>{{ ($userDetails)? $userDetails->permanent_post_code : '--'}}</b></p>
                    </div>
            @endif
            </div>
                <hr class="mb-1" style="height:2px;border-width:0;background-color:#b6b4b482">
                <h4 class="mb-3">Passport Information</h4>
                <div class="row">
                <div class="col-sm-12 col-md-4">
                    <label>Name (As in Passport)</label>
                    <p><b>{{ ($userDetails && $userDetails->name_passport)? $userDetails->name_passport : '--' }}</b></p>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label>Passport No.</label>
                    <p><b>{{ ($userDetails && $userDetails->passport_num)? $userDetails->passport_num : '--' }}</b></p>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label>Issue Date</label>
                    <p><b>@if($userDetails)
                        @if($userDetails->passport_issue_date) {{date("d-m-Y", strtotime($userDetails->passport_issue_date))}}@else
                        -- @endif
                        @else
                        --
                        @endif
                    </b></p>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label>Expiry Date</label>
                    <p><b>@if($userDetails)
                        @if($userDetails && $userDetails->passport_expiry_date) {{date("d-m-Y", strtotime($userDetails->passport_expiry_date))}}@else
                        -- @endif
                        @else
                        --
                        @endif
                    </b></p>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label>Issue Country</label>
                    <p><b>{{ ($userDetails)? get_country_name($userDetails->passport_country): '--' }}</b></p>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label>City of Birth</label>
                    <p><b>{{ ($userDetails && $userDetails->city_of_birth)? $userDetails->city_of_birth:'--' }}</b></p>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label>Country of Birth</label>
                    <p><b>{{ ($userDetails)? get_country_name($userDetails->country_of_birth) : '--' }}</b></p>
                </div>
            </div>
            <hr class="mb-1" style="height:2px;border-width:0;background-color:#b6b4b482">
            <h4 class="mb-3">Nationality</h4>
            <div class="row">
                <div class="col-sm-12 col-md-4">
                    <label>Nationality</label>
                    <p><b>{{ ($userDetails && $userDetails->nationality)? get_country_name($userDetails->nationality):'--' }}</b></p>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label>Citizenship</label>
                    <p><b>{{ ($userDetails && $userDetails->citizenship)? get_country_name($userDetails->citizenship):'--' }}</b></p>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label>Is the applicant a citizen of more than one country?</label>
                    <p><b>@if($userDetails)
                        {{ ($userDetails->dual_citizenship==1)?'Yes':'No' }}@if($userDetails->dual_citizenship=='1') [{{get_country_name($userDetails->dual_citizenship_country)}}] @endif
                        @else
                        --
                        @endif
                    </b></p>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label>Is the applicant living and studying in any other country?</label>
                    <p><b>@if($userDetails)
                        {{ ($userDetails->studying_abroad==1)?'Yes':'No' }}@if($userDetails->studying_abroad=='1') [{{get_country_name($userDetails->studying_abroad_country)}}] @endif
                        @else
                        --
                        @endif</b></p>
                </div>
            </div>
            <hr class="mb-1" style="height:2px;border-width:0;background-color:#b6b4b482">
            <h4 class="mb-3">Background Info</h4>
            <div class="row">
                <div class="col-sm-12 col-md-4">
                    <label>Has applicant applied for any type of immigration into any country?</label>
                    <p><b>@if($userDetails)
                        {{ ($userDetails && $userDetails->immigration==1)?'Yes':'No' }}@if($userDetails->immigration=='1') [{{get_country_name($userDetails->immigration_country)}}] @endif
                        @else
                        --
                        @endif
                    </b></p>
                </div>

                <div class="col-sm-12 col-md-4">
                    <label>Does applicant suffer from a serious medical condition?</label>
                    <p><b>{{ ($userDetails && $userDetails->medical_condition==1)?'Yes':'No' }}</b></p>
                </div>

                <div class="col-sm-12 col-md-4">
                    <label>Has applicant Visa refusal for any country?</label>
                    <p><b>@if($userDetails)
                        {{ ($userDetails->visa_refusal==1)?'Yes':'No' }}@if($userDetails->visa_refusal=='1') [{{get_country_name($userDetails->visa_refusal_country)}}] @endif
                    @else
                    --
                    @endif
                    </b></p>
                </div>

                <div class="col-sm-12 col-md-4">
                    <label>Has applicant ever been convicted of a criminal offence?</label>
                    <p><b>{{ ($userDetails && $userDetails->criminal_offence==1)?'Yes':'No' }}</b></p>
                </div>
            </div>
            <hr class="mb-1" style="height:2px;border-width:0;background-color:#b6b4b482">
            <h4 class="mb-3">Emergency Contacts</h4>
            <div class="row">
                <div class="col-sm-12 col-md-4">
                    <label>Name</label>
                    <p><b>{{ ($userDetails && $userDetails->emergency_name)? ucfirst($userDetails->emergency_name):'--' }}</b></p>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label>Email</label>
                    <p><b>{{ ($userDetails && $userDetails->emergency_email)? ucfirst($userDetails->emergency_email):'--' }}</b></p>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label>Phone</label>
                    <p><b>{{ ($userDetails && $userDetails->emergency_phone)? ucfirst($userDetails->emergency_phone):'--' }}</b></p>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label>Relationship with Applicant</label>
                    <p><b>{{ ($userDetails && $userDetails->emergency_relation)? ucfirst($userDetails->emergency_relation):'--' }}</b></p>
                </div>
            </div>
            @if(env('ADDITIONAL_SERVICES_ENABLE'))
            <hr class="mb-1" style="height:2px;border-width:0;background-color:#b6b4b482">
            <div class="row mt-3">
                <div class="col-sm-12 col-md-4">
                    <label>Other Services Interested In</label>
                    <p>
                        <b>
                            @if($student->services)
                            @php 
                                $service_interested = explode(",", $student->services);
                            @endphp
                            @foreach($service_interested as $interest)
                                @if(!$loop->last)
                                    {{get_services($interest)}},
                                @else
                                    {{get_services($interest)}}
                                @endif
                            @endforeach
                            @else
                            -
                            @endif
                        </b>
                    </p>
                </div>
            </div>
            @endif
            <hr class="mb-1" style="height:2px;border-width:0;background-color:#b6b4b482">
            <div class="row">
                <div class="col-sm-12 col-md-4">
                    <label>Require Study Permit?</label>
                    <p><b>{{ ($userDetails && $userDetails->study_permit==1)?'Yes':'No' }}</b></p>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label>Require Accommodation?</label>
                    <p><b>{{ ($userDetails && $userDetails->accommodation==1)?'Yes':'No' }}</b></p>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label>Require Education Loan?</label>
                    <p><b>{{ ($userDetails && $userDetails->education_loan==1)?'Yes':'No' }}</b></p>
                </div>
            </div>
            <hr class="mb-1" style="height:2px;border-width:0;background-color:#b6b4b482">
            <h4 class="mb-3">Academic Details</h4>
            <div class="row">
                <div class="col-sm-12 col-md-4">
                    <label>Country of Education</label>
                    <p><b>{{ ($userDetails)? get_country_name($userDetails->country_of_education):'--' }}</b></p>
                </div>
                <div class="col-sm-12 col-md-4">
                    <label>Highest Level of Education</label>
                    <p><b>{{ ($userDetails && $userDetails->highest_level_education)? ucfirst($userDetails->highest_level_education):'--' }}</b></p>
                </div>
            </div>

            <br />
            <hr>
            <h4 class="mt-4">Academic Information</h4>
            <table class="table table-hover">
                <tr>
                    <th>Level of Education</th>
                    <th>Percentage or CGPA</th>
                    <th>Year of Passing</th>
                    <th>Specialisation</th>
                    <th>School/ College</th>
                    <th>University / Board</th>
                    <th>Backlogs</th>
                </tr>
                @if($student->academics) 
                @foreach($student->academics as $education)
                <tr>
                    <td>{{ $education->education_level }}</td>
                    <td>{{ $education->percent_cgpa }}</td>
                    <td>{{ $education->pass_year }}</td>
                    <td>{{ $education->specialization }}</td>
                    <td>{{ $education->school_college }}</td>
                    <td>{{ $education->university }}</td>
                    <td>{{ $education->backlogs }}</td>
                </tr>
                @endforeach
                @endif
            </table>
            
            <br />
            <h4>Tests, Language Certifications</h4>
            <h6 style="text-decoration: underline;">English</h6>
            <table class="table table-hover">
                <tr>
                    <th>Exam</th>
                    <th>Overall Score</th>
                    <th>Speaking</th>
                    <th>Reading</th>
                    <th>Writing</th>
                    <th>Listening</th>   
                    <th>English</th>
                    <th>Math</th>
                    <th>Science</th>
                    <th>Essay</th>                 
                    <th>Score Expiry Date</th>
                </tr>
                @if($student->englishcert) 
                @foreach($student->englishcert as $exam)
                <tr>
                    <td>{{ $exam->exam }}</td>
                    <td>{{ $exam->overall_score }}</td>
                    <td>{{ $exam->speaking }}</td>
                    <td>{{ $exam->reading }}</td>
                    <td>{{ $exam->writing }}</td>
                    <td>{{ $exam->listening }}</td>
                    <td>{{ $exam->english }}</td>
                    <td>{{ $exam->math }}</td>
                    <td>{{ $exam->science }}</td>
                    <td>{{ $exam->essay }}</td>
                    <td>{{ $exam->expiry_date }}</td>
                </tr>
                @endforeach
                @endif
            </table>
            <h6 style="text-decoration: underline;">Other Languages</h6>
            <table class="table table-hover">
                <tr>
                    <th>Language</th>
                    <th>Level</th>
                    <th>Overall Score(%)</th>
                    <th>Speaking (Marks or %)</th>
                    <th>Reading (Marks or %)</th>
                    <th>Writing (Marks or %)</th>
                    <th>Listening (Marks or %)</th>                    
                    <th>Institute (Marks or %)</th>
                </tr>
                @if($student->languagecert) 
                @foreach($student->languagecert as $cert)
                <tr>
                    <td>{{ $cert->language }}</td>
                    <td>{{ $cert->level }}</td>
                    <td>{{ $cert->overall_score }}</td>
                    <td>{{ $cert->speaking }}</td>
                    <td>{{ $cert->reading }}</td>
                    <td>{{ $cert->writing }}</td>
                    <td>{{ $cert->listening }}</td>
                    <td>{{ $cert->institute }}</td>
                </tr>
                @endforeach
                @endif
            </table>            
            
            <br />
            <h4>GRE / GMAT</h4>
            <table class="table table-hover">
                <tr>
                    <th>Exam</th>
                    <th>Total Score</th>
                    <th>Verbal</th>
                    <th>Quantitative</th>
                    <th>Analytical</th>
                    <th>Integrated</th>                    
                    <th>Score Expiry Date</th>
                </tr>
                @if($student->gregmat) 
                @foreach($student->gregmat as $exam)
                <tr>
                    <td>{{ $exam->exam }}</td>
                    <td>{{ $exam->total_score }}</td>
                    <td>{{ $exam->verbal }}</td>
                    <td>{{ $exam->quantitative }}</td>
                    <td>{{ $exam->analytical }}</td>
                    <td>{{ $exam->integrated }}</td>
                    <td>{{ $exam->expiry_date }}</td>
                </tr>
                @endforeach
                @endif
            </table>            
            
            
            <br />
            <h4>Internships</h4>
            <table class="table table-hover">
                <tr>
                    <th>Company Name</th>
                    <th>Number of days/months or years</th>
                    <th>Place</th>
                </tr>
                @if($student->internships) 
                @foreach($student->internships as $internship)
                <tr>
                    <td>{{ $internship->company }}</td>
                    <td>{{ $internship->duration }}</td>
                    <td>{{ $internship->place }}</td>
                </tr>
                @endforeach
                @endif
            </table>   

            <h6 style="text-decoration: underline;">Additional Courses</h6>
            <table class="table table-hover">
                <tr>
                    <th>Course</th>
                    <th>Duration</th>
                    <th>Number of Hours</th>
                    <th>Certification issue Authority</th>
                </tr>
                @if($student->additionalcourses) 
                @foreach($student->additionalcourses as $additionalcourse)
                <tr>
                    <td>{{ $additionalcourse->course }}</td>
                    <td>{{ $additionalcourse->duration }}</td>
                    <td>{{ $additionalcourse->hours }}</td>
                    <td>{{ $additionalcourse->institute }}</td>
                </tr>
                @endforeach
                @endif
            </table>               
            
            
            
            <br />
            <h4>Professional Experience</h4>
            <table class="table table-hover">
                <tr>
                    <th>Company Name</th>
                    <th>Designation</th>
                    <th>Start Date</th>
                    <th>End Date</th>
                </tr>
                @if($student->experiences) 
                @foreach($student->experiences as $experience)
                <tr>
                    <td>{{ $experience->company }}</td>
                    <td>{{ $experience->designation }}</td>
                    <td>{{ $experience->start_date }}</td>
                    <td>{{ $experience->end_date }}</td>
                </tr>
                @endforeach
                @endif
            </table>               
            
        </div>
        @endif
    </div>
</div>