@extends('backend.layouts.app')

@section('title', $module_title)

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">

            <div class="col-sm-5 col-5">
                <h4 class="card-title mb-0"> 
                    {{$page_heading}}
                </h4>
            </div><!--col-->
            <div class="col-sm-7 col-7">
                <div class="btn-toolbar float-right" role="toolbar" aria-label="New Article" style="margin-top: 20px;float: right;">
                    <a href="{{ route('admin.articles-create') }}" class="btn btn-primary btn-sm ml-1" data-toggle="tooltip" title="Add New Article"><i class="bi bi-plus-circle"></i> Create</a>
                </div><!--btn-toolbar-->
            </div><!--col--> 
            
        </div><!--row-->
        
        
        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive">
                    <table id="article_list" class="table table-hover ">
                        <thead>
                            <tr>
                                <th data-orderable="false">#</th>
                                <th>Name</th>
                                <th>Type</th>
                                <th>Status</th>
                                <th data-orderable="false">Action</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
{!! csrf_field() !!}
@endsection

@push ('after-scripts')

<script type="text/javascript">
$(document).ready(function () {
    $('#article_list').DataTable({
        processing: true,
        serverSide: true,
        "language": {
                            searchPlaceholder: "Search By Name, Type and Status"
                        },
         "lengthMenu" : [25,50,100],
                "ajax":{
                         "url": "{{route('admin.ajaxarticleslist')}}",
                         "dataType": "json",
                         "type": "post",
                          data: { '_token':  $('meta[name="csrf-token"]').attr('content')},
                       },  
        "drawCallback": function( settings ) {
                            addDeleteForms();
                          },
        "order": [ 5, "desc" ],
        autoWidth: true,
        responsive: true,
        columns: [
            {data: 'id', orderable: false, searchable: false},
            {data: 'title'},
            {data: 'type'},
            {data: 'status'},
            {data: 'actions', orderable: false, searchable: false},
            {data: "created_at"}
        ],
        columnDefs: [
            {
                "targets": [ 5 ],
                "visible": false
            }
        ]
        
    });
});

</script>
@endpush
