@extends('backend.layouts.app')

@section('title', "Create Article")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-10 col-10">
                <h4 class="card-title mb-0">
                    Create Article
                </h4>
            </div>
            <!--col-->
            <!--/.col-->
            <div class="col-sm-2 col-2" style="padding: 25px 0 10px 0;">
                <div class="btn-toolbar float-right" role="toolbar" aria-label="" style="float: right;">
                    <a href="{{ route('admin.articles') }}" class="btn btn-outline-primary btn-sm ml-1" data-toggle="tooltip" title="Article List">
                        <i class="fas fa-list-ul"></i> List</a>
                </div>
            </div>
            <!--/.col-->
        </div>
        <!--/.row-->

        <hr>

        <div class="row mt-4">
            <div class="col">
                <form action="{{route('admin.articles.store')}}" method="POST" id="article_form" enctype="multipart/form-data">
                    @include ("backend.articles.form")
                    @csrf
                    <div class="row" style="text-align:center;">
                        <div class="col-12">
                            <div class="form-group">
                                {{ html()->button($text = "  Add Article", $type = 'submit')->class('btn btn-primary btn-sm') }}
                                <button type="button" class="btn btn-outline-secondary btn-sm" onclick="history.back(-1)">Cancel</button>
                            </div>
                        </div>
                        <!-- <div class="col-6">
                        <div class="float-right">
                            <div class="form-group">
                            </div>
                        </div>
                    </div> -->
                    </div>
                </form>

            </div>
        </div>
    </div>

    <div class="card-footer">
        <div class="row">
            <div class="col">

            </div>
        </div>
    </div>
</div>
{!! csrf_field() !!}

@stop
@push('after-scripts')
<script>
    $(document).ready(function() {
        //$('#published_at_datepicker').datepicker({
        //    todayHighlight: true,
        //    format: 'dd/mm/yyyy',
        //    startDate: '-0d',
        //     autoclose: true,
        //});

        $('#published_at_datepicker').datetimepicker({
            timepicker: true,
            format: 'd-M-Y H:i',
            minDate: '0',
        });


        $("#article_type").change(function() {
            $("#module_type_block").hide();
            // $("#module_showin_menu").hide();
            $("#article_module").removeClass("required-validate");
            if ($("#article_type").val() == 'module_page') {
                $("#module_type_block").show();
                //$("#module_showin_menu").show();
                // $("#article_module").addClass("required-validate");
            }

        });

        $('#article_title').change(function() {
            var url_val = $(this).val().replace(/[_\W]+/g, "-").toLowerCase();
            $('#article_slug').val(url_val);
        });

        $("#article_show_in_main_menu").click(function() {
            $("#menu_title_block").hide();
            $("#menu_title").removeClass("required-validate");
            if ($("#article_show_in_main_menu").prop('checked') == true) {
                $("#menu_title_block").show();
                $("#menu_title").addClass("required-validate");
            }
        });

        $("#article_form").submit(function(event) {

            event.preventDefault();
            var form = $(this);
            var has_error = false;
            $("div.inline-err-msg").remove();
            var focus_id = ''

            if ($('#article_slug').val() != '') {
                $.post("{{route('admin.articles.ajaxValidateData')}}" + '?_token=' + '{{ csrf_token() }}', {
                    field: 'slug',
                    value: $('#article_slug').val(),
                    article_id: ''
                }, function(data) {
                    if (data == '1') {
                        //valid slug
                        $(".required-validate").each(function(index) {
                            fied_id = $(this).attr("id");
                            if ($(this).val() == '') {
                                has_error = true;
                                $(this).after("<div class='inline-err-msg'>This field is required</div>");
                                if (focus_id == '') {
                                    focus_id = fied_id;
                                }
                            }
                        });

                        if (has_error) {
                            $('#' + focus_id).focus();
                        } else {
                            form.off('submit');
                            form.submit();
                        }
                    } else if (data == '0') {
                        //invalid slug
                        $('#article_slug').focus();
                        $('#article_slug').after("<div class='inline-err-msg'>Already exists. Please try different one!</div>");
                        return;
                    }
                });
            } else {
                $('#article_slug').focus();
                $('#article_slug').after("<div class='inline-err-msg'>This field is required</div>");
            }

        });


        //$( "#article_form" ).submit(function( event ) {
        //    var has_error = false;
        //    $("div.inline-err-msg").remove();
        //    var focus_id = ''
        //    
        //    
        //    if($( '#article_slug' ).val() != ''){                
        //        $.post( "{{route('admin.articles.ajaxValidateData')}}"+'?_token=' + '{{ csrf_token() }}', {field: 'slug', value:$( '#article_slug' ).val(),article_id:''}, function (data){
        //          if(data=='1'){
        //           //valid slug
        //          }
        //          else if(data=='0'){
        //            //invalid slug
        //            has_error = true;
        //            $( '#article_slug' ).focus();
        //            $( '#article_slug' ).after("<div class='inline-err-msg'>Already exists. Please try different one!</div>");
        //            return;
        //          }
        //        });                
        //    
        //    }
        //    
        //    $( ".required-validate" ).each(function( index ) {
        //        fied_id = $( this ).attr("id");
        //       if($( this ).val() == ''){
        //            has_error = true;
        //            $( this ).after("<div class='inline-err-msg'>This field is required</div>");
        //            if(focus_id == ''){
        //                focus_id = fied_id;
        //            }
        //       }
        //    });
        //    
        //    if(has_error){
        //        event.preventDefault();
        //        //alert("Please enter required fields!");
        //        $( '#'+focus_id ).focus();
        //    }
        //    else{
        //        return true;
        //    }
        //});




    });
</script>
@endpush