@extends ('backend.layouts.app')

@section('title') {{ $module_action }} {{ $module_title }} @endsection

@section('breadcrumbs')
<x-backend-breadcrumbs>
    <x-backend-breadcrumb-item type="active" route='{{route("backend.articles")}}' icon='{{ $module_icon }}'>{{ $module_title }}</x-backend-breadcrumb-item>
</x-backend-breadcrumbs>
@endsection

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col">
                <h4 class="card-title mb-0">
                    <i class="{{ $module_icon }}"></i> {{ $module_title }} <small class="text-muted">{{ $module_action }}</small>
                </h4>
                <div class="small text-muted">
                     @lang(":module_name Management Dashboard", ['module_name'=>Str::title($module_name)])
                </div>
            </div>
            @if (count($errors) > 0)
                         <div class = "alert alert-danger ml-5">
                            <ul>
                               @foreach ($errors->all() as $error)
                                  <li>{{ $error }}</li>
                               @endforeach
                            </ul>
                         </div>
                      @endif

                      @if ($message = Session::get('success'))
                        <div class="alert alert-success alert-block ml-5">
                            <button type="button" class="close ml-2" data-dismiss="alert">×</button> 
                                <strong>{{ $message }}</strong>
                        </div>
                        @endif
            <div class="col-6 col-sm-4">
                <div class="float-right">
                    <div class="btn-group" role="group" aria-label="Toolbar button groups">
                        <!-- <div class="btn-group" role="group">
                            <button id="btnGroupToolbar" type="button" class="btn btn-secondary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fas fa-cog"></i>
                            </button>
                            <div class="dropdown-menu" aria-labelledby="btnGroupToolbar">
                                <a class="dropdown-item" href="">
                                    <i class="fas fa-eye-slash"></i> View trash
                                </a>
                            </div>
                        </div> -->
                    </div>
                </div>
            </div>
            <!--/.col-->
        </div>
        <!--/.row-->

        <div class="row mt-4">
            <div class="col">
                 <div class="table-responsive">
                    <table class="table table-hover">
                        <tr>
                            <th>Name :</th>
                            <td>{{$payment_details->title_en}}</td>
                        </tr>

                        <tr>
                            <th>Intro :</th>
                            <td><?=$payment_details->intro_en?></td>
                        </tr>
                        <tr>
                            <th>Content :</th>
                            <td><?=$payment_details->content_en?></td>
                        </tr>

                        <tr>
                            <th>Type :</th>
                            <td>{{$payment_details->type}}</td>
                        </tr>

                        <tr>
                            <th>Is Featured :</th>
                            <?php if ($payment_details->is_featured == 1) {
                                $fe = "Yes";
                            }else{
                                $fe = "No";
                            } ?>
                            <td>{{$fe}}</td>
                        </tr>
                        <?php if ($payment_details->status ==1) {
                           $st = "Published";
                        }else if ($payment_details->status == 0) {
                            $st = "Unpublished";
                        }else{
                            $st = "Draft";
                        }
                        ?>
                        <tr>
                            <th>Status :</th>
                            <td>{{$st}}</td>
                        </tr>
                        <tr>
                            <th>Published At :</th>
                            <td>{{$payment_details->published_at}}</td>
                        </tr>
                        <tr>
                            <th>Meta Title :</th>
                            <td>{{$payment_details->meta_title}}</td>
                        </tr>
                        <tr>
                            <th>Meta Keywords :</th>
                            <td>{{$payment_details->meta_keywords}}</td>
                        </tr>
                        <tr>
                            <th>Meta Description :</th>
                            <td>{{$payment_details->meta_description}}</td>
                        </tr>
                    </table>
                </div><!--/table-responsive-->
                <div class="col-6">
                        <div class="float-right">
                            <div class="form-group">
                                <a type="button" class="btn btn-warning" href="{{ url()->previous() }}"><i class="fas fa-reply"></i> Back</a>
                            </div>
                        </div>
                    </div>
            </div>
        </div>
    </div>
    <div class="card-footer">
        <div class="row">
            <div class="col-7">
                <div class="float-left">

                </div>
            </div>
            <div class="col-5">
                <div class="float-right">

                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push ('after-styles')

@endpush

@push ('after-scripts')
<!-- DataTables Core and Extensions -->

@endpush
