@extends('frontend.layouts.register-login')

@section('content')
<div class="login-register" style="background-image:url(assets/images/background/admin-login-bg.jpg);">
    <div class="login-box card">
        <div class="card-body">
            {{ html()->form('POST', route('frontend.auth.login.post'))->open() }}

            <h3 class="box-title m-b-20">Staff Login</h3>

            @include('includes.partials.messages')

            <div class="row">
                <div class="col">
                    <div class="form-group">
                        {{ html()->label(__('validation.attributes.frontend.email'))->for('email') }}

                        {{ html()->email('email')
                                        ->class('form-control')
                                        ->placeholder(__('validation.attributes.frontend.email'))
                                        ->attribute('maxlength', 191)
                                        ->required() }}
                    </div><!--form-group-->
                </div><!--col-->
            </div><!--row-->

            <div class="row">
                <div class="col">
                    <div class="form-group">
                        {{ html()->label(__('validation.attributes.frontend.password'))->for('password') }}

                        {{ html()->password('password')
                                        ->class('form-control')
                                        ->placeholder(__('validation.attributes.frontend.password'))
                                        ->required() }}
                    </div><!--form-group-->
                </div><!--col-->
            </div><!--row-->

            <div class="row">
                <div class="col">
                    <div class="form-group">
                        <div class="checkbox checkbox-primary pull-left p-t-0">
                            <input id="checkbox-signup" type="checkbox" name="remember" value="1">
                            <label for="checkbox-signup"> Remember me </label>
                        </div>
                        <a href="{{ route('frontend.auth.password.reset') }}" id="to-recover" class="text-dark pull-right"><!-- <i class="fa fa-lock m-r-5"></i> --> Forgot pwd?</a>
                    </div><!--form-group-->
                </div><!--col-->
            </div><!--row-->

            <div class="form-group text-center m-t-20">
                <div class="col-xs-12">
                    <button class="btn btn-lg btn-block text-uppercase waves-effect waves-light btn-themecolor" type="submit">Log In</button>
                </div>
            </div>            

            {{ html()->form()->close() }}

        </div>
    </div>
</div>
@endsection
