@extends('backend.layouts.app')

@section('title', __('labels.backend.access.roles.management') . ' | ' . __('labels.backend.access.roles.edit'))

@section('content')
{{ html()->modelForm($role, 'PATCH', route('admin.auth.role.update', $role))->class('form-horizontal')->open() }}
    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-sm-5">
                    <h4 class="card-title mb-0">
                        @lang('labels.backend.access.roles.management')
                        <small class="text-muted">@lang('labels.backend.access.roles.edit')</small>
                    </h4>
                </div><!--col-->
            </div><!--row-->
            <!--row-->

            <hr />

            <div class="row mt-4">
                <div class="col">
                    <div class="form-group row mb-3">
                        {{ html()->label(__('validation.attributes.backend.access.roles.name'))
                            ->class('col-md-2 form-control-label')
                            ->for('name') }}

                        <div class="col-md-10">
                            <input type="text" class="form-control" name="name" maxlength="191" id="name" value="{{$role->name}}" required placeholder="__('validation.attributes.backend.access.roles.name')" @if($role->name=='manager' || $role->name=='staff member') readonly @endif>

                            <!-- {{ html()->text('name')
                                ->class('form-control')
                                ->placeholder(__('validation.attributes.backend.access.roles.name'))
                                ->attribute('maxlength', 191)
                                ->required() }} -->
                        </div><!--col-->
                    </div><!--form-group-->
                    {{-- <div class="row">
                        <div class="col-md-2">
                        </div>
                        <div class="col-md-10 mb-3">
                            @if($role->name=='manager' || $role->name=='administrator')
                            <input type="checkbox" checked disabled>
                            <input type="hidden" name="managerial" value="1">
                            <label>This is managerial role</label><br>
                            @else
                            <input type="checkbox" name="managerial" {{($role->managerial)? 'checked' : ''}} value="1">
                            <label>This is managerial role</label><br>
                            @endif
                        </div>
                    </div> --}}
                  

                    <div class="form-group row mb-3">
                        {{ html()->label(__('validation.attributes.backend.access.roles.associated_permissions'))
                            ->class('col-md-2 form-control-label')
                            ->for('permissions') }}

                        <div class="col-md-10">
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="card">
                                        <div class="card-body">
                                            <h4 class="pt-3">Management</h4>
                                            <br>
                                            <div class="row">
                                                <div class="col-sm-12 col-md-12">
                                                    @if($role->name=='manager' || $role->name=='administrator')
                                                    <input type="checkbox" checked disabled>
                                                    <input type="hidden" name="managerial" value="1">
                                                    <label>This is managerial role</label><br>
                                                    @else
                                                    <input type="checkbox" name="managerial" {{($role->managerial)? 'checked' : ''}} value="1">
                                                    <label>This is managerial role</label><br>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @if($permissions->count())

                                {{-- @foreach($permissions as $permission)
                                @if(permission_enabled($permission->name))
                                         @if(in_array($permission->name,$rolePermissions))
                                                @if($permission->name == "view backend")
                                                    <input type="checkbox" checked disabled>
                                                    <input type="hidden" name="permissions[]" value="{{ $permission->name }}">
                                                    <label>{{ ucwords($permission->name) }}</label><br>
                                                @else
                                            <input type="checkbox"  name="permissions[]" value="{{ $permission->name }}" checked="checked">
                                            <label>{{ ucwords($permission->name) }}</label><br>
                                            @endif
                                        @else
                                            <input type="checkbox"  name="permissions[]" value="{{ $permission->name }}">
                                            <label>{{ ucwords($permission->name) }}</label><br>
                                        @endif    
                                        <small>{!! permission_details($permission->name) !!}</small><br /><br />
                                @endif
                                @endforeach --}}
                                @foreach($permissions as $permission)
                                    @if(permission_enabled($permission->name))
                                        @if(in_array($permission->name,$rolePermissions))
                                            @if($permission->name == "view backend")
                                            <input type="checkbox" checked disabled style="display:none;">
                                            <input type="hidden" name="permissions[]" value="{{ $permission->name }}" checked="checked">
                                            {{-- <label>{{ ucwords($permission->name) }}</label><br>
                                            <small>{!! permission_details($permission->name) !!}</small><br /><br /> --}}
                                            @endif
                                            @endif
                                    @endif
                                @endforeach

                                {{-- //view assigned data only --}}
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="card">
                                            <div class="card-body">
                                                <h4 class="pt-3">Limited Permissions Staff</h4>
                                                <br>
                                            @foreach($permissions->sortBy('display_order') as $permission)
                                                @if(permission_enabled($permission->name))
                                                    @if($permission->name == "view assigned data only")
                                                                <div class="row">
                                                                    <div class="col-sm-12 col-md-12">
                                                                        <input type="checkbox" @if(in_array($permission->name,$rolePermissions)) checked @endif  name="permissions[]" value="{{ $permission->name }}">
                                                                        <label>{{ ucwords($permission->name) }}</label><br>
                                                                        <small>{!! permission_details($permission->name) !!}</small><br /><br />
                                                                    </div>
                                                                </div>
                                                        @endif
                                                    @endif
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                {{-- //view assigned data only --}}
                                {{-- //Lead management --}}
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="card">
                                            <div class="card-body">
                                                <h4 class="pt-3">Lead Management</h4>
                                                <br>
                                            @foreach($permissions->sortBy('display_order') as $permission)
                                                @if(permission_enabled($permission->name))
                                                    @if($permission->group == "Lead Management")
                                                                <div class="row">
                                                                    <div class="col-sm-12 col-md-12">
                                                                        <input type="checkbox" @if(in_array($permission->name,$rolePermissions)) checked @endif name="permissions[]" value="{{ $permission->name }}">
                                                                        <label>{{ ucwords($permission->name) }}</label><br>
                                                                        <small>{!! permission_details($permission->name) !!}</small><br /><br />
                                                                    </div>
                                                                </div>
                                                        @endif
                                                    @endif
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                {{-- //Lead management --}}
                                {{-- //Student management --}}
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="card">
                                            <div class="card-body">
                                                <h4 class="pt-3">Student Management</h4>
                                                <br>
                                            @foreach($permissions->sortBy('display_order') as $permission)
                                                @if(permission_enabled($permission->name))
                                                    @if($permission->group == "Student Management")
                                                                <div class="row">
                                                                    <div class="col-sm-12 col-md-12">
                                                                        <input type="checkbox" @if(in_array($permission->name,$rolePermissions)) checked @endif name="permissions[]" value="{{ $permission->name }}">
                                                                        <label>{{ ucwords($permission->name) }}</label><br>
                                                                        <small>{!! permission_details($permission->name) !!}</small><br /><br />
                                                                    </div>
                                                                </div>
                                                        @endif
                                                    @endif
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                {{-- //Student management --}}
                                {{-- //Application Management --}}
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="card">
                                            <div class="card-body">
                                                <h4 class="pt-3">Application Management</h4>
                                                <br>
                                            @foreach($permissions->sortBy('display_order') as $permission)
                                                @if(permission_enabled($permission->name))
                                                    @if($permission->group == "Application Management")
                                                                <div class="row">
                                                                    <div class="col-sm-12 col-md-12">
                                                                        <input type="checkbox" @if(in_array($permission->name,$rolePermissions)) checked @endif name="permissions[]" value="{{ $permission->name }}">
                                                                        <label>{{ ucwords($permission->name) }}</label><br>
                                                                        <small>{!! permission_details($permission->name) !!}</small><br /><br />
                                                                    </div>
                                                                </div>
                                                        @endif
                                                    @endif
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                {{-- //Application Management --}}
                                {{-- //Staff Management --}}
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="card">
                                            <div class="card-body">
                                                <h4 class="pt-3">Staff Management</h4>
                                                <br>
                                            @foreach($permissions->sortBy('display_order') as $permission)
                                                @if(permission_enabled($permission->name))
                                                    @if($permission->group == "Staff Management")
                                                                <div class="row">
                                                                    <div class="col-sm-12 col-md-12">
                                                                        <input type="checkbox" @if(in_array($permission->name,$rolePermissions)) checked @endif name="permissions[]" value="{{ $permission->name }}">
                                                                        <label>{{ ucwords($permission->name) }}</label><br>
                                                                        <small>{!! permission_details($permission->name) !!}</small><br /><br />
                                                                    </div>
                                                                </div>
                                                        @endif
                                                    @endif
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                {{-- //Staff Management --}}
                                {{-- //Agent Management --}}
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="card">
                                            <div class="card-body">
                                                <h4 class="pt-3">Agent Management</h4>
                                                <br>
                                            @foreach($permissions->sortBy('display_order') as $permission)
                                                @if(permission_enabled($permission->name))
                                                    @if($permission->group == "Agent Management")
                                                                <div class="row">
                                                                    <div class="col-sm-12 col-md-12">
                                                                        <input type="checkbox" @if(in_array($permission->name,$rolePermissions)) checked @endif name="permissions[]" value="{{ $permission->name }}">
                                                                        <label>{{ ucwords($permission->name) }}</label><br>
                                                                        <small>{!! permission_details($permission->name) !!}</small><br /><br />
                                                                    </div>
                                                                </div>
                                                        @endif
                                                    @endif
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                {{-- //Agent Management --}}
                                {{-- //Course Management --}}
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="card">
                                            <div class="card-body">
                                                <h4 class="pt-3">Course Management</h4>
                                                <br>
                                            @foreach($permissions->sortBy('display_order') as $permission)
                                                @if(permission_enabled($permission->name))
                                                    @if($permission->group == "Course Management")
                                                                <div class="row">
                                                                    <div class="col-sm-12 col-md-12">
                                                                        <input type="checkbox" @if(in_array($permission->name,$rolePermissions)) checked @endif name="permissions[]" value="{{ $permission->name }}">
                                                                        <label>{{ ucwords($permission->name) }}</label><br>
                                                                        <small>{!! permission_details($permission->name) !!}</small><br /><br />
                                                                    </div>
                                                                </div>
                                                        @endif
                                                    @endif
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                {{-- //Course Management --}}
                                {{-- //Invoice Management --}}
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="card">
                                            <div class="card-body">
                                                <h4 class="pt-3">Invoice Management</h4>
                                                <br>
                                            @foreach($permissions->sortBy('display_order') as $permission)
                                                @if(permission_enabled($permission->name))
                                                    @if($permission->group == "Invoice Management")
                                                                <div class="row">
                                                                    <div class="col-sm-12 col-md-12">
                                                                        <input type="checkbox" @if(in_array($permission->name,$rolePermissions)) checked @endif name="permissions[]" value="{{ $permission->name }}">
                                                                        <label>{{ ucwords($permission->name) }}</label><br>
                                                                        <small>{!! permission_details($permission->name) !!}</small><br /><br />
                                                                    </div>
                                                                </div>
                                                        @endif
                                                    @endif
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                {{-- //Invoice Management --}}
                                {{-- //Support Tickets --}}
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="card">
                                            <div class="card-body">
                                                <h4 class="pt-3">Support Tickets</h4>
                                                <br>
                                            @foreach($permissions->sortBy('display_order') as $permission)
                                                @if(permission_enabled($permission->name))
                                                    @if($permission->group == "Support Tickets")
                                                                <div class="row">
                                                                    <div class="col-sm-12 col-md-12">
                                                                        <input type="checkbox" @if(in_array($permission->name,$rolePermissions)) checked @endif name="permissions[]" value="{{ $permission->name }}">
                                                                        <label>{{ ucwords($permission->name) }}</label><br>
                                                                        <small>{!! permission_details($permission->name) !!}</small><br /><br />
                                                                    </div>
                                                                </div>
                                                        @endif
                                                    @endif
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                {{-- //Support Tickets --}}
                                {{-- //CMS Management --}}
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="card">
                                            <div class="card-body">
                                                <h4 class="pt-3">CMS Management</h4>
                                                <br>
                                            @foreach($permissions->sortBy('display_order') as $permission)
                                                @if(permission_enabled($permission->name))
                                                    @if($permission->group == "CMS Management")
                                                                <div class="row">
                                                                    <div class="col-sm-12 col-md-12">
                                                                        <input type="checkbox" @if(in_array($permission->name,$rolePermissions)) checked @endif name="permissions[]" value="{{ $permission->name }}">
                                                                        <label>{{ ucwords($permission->name) }}</label><br>
                                                                        <small>{!! permission_details($permission->name) !!}</small><br /><br />
                                                                    </div>
                                                                </div>
                                                        @endif
                                                    @endif
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                {{-- //CMS Management --}}
                                {{-- //Upload Management --}}
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="card">
                                            <div class="card-body">
                                                <h4 class="pt-3">Upload Management</h4>
                                                <br>
                                            @foreach($permissions->sortBy('display_order') as $permission)
                                                @if(permission_enabled($permission->name))
                                                    @if($permission->group == "Upload Management")
                                                                <div class="row">
                                                                    <div class="col-sm-12 col-md-12">
                                                                        <input type="checkbox" @if(in_array($permission->name,$rolePermissions)) checked @endif name="permissions[]" value="{{ $permission->name }}">
                                                                        <label>{{ ucwords($permission->name) }}</label><br>
                                                                        <small>{!! permission_details($permission->name) !!}</small><br /><br />
                                                                    </div>
                                                                </div>
                                                        @endif
                                                    @endif
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                {{-- //Upload Management --}}
                                {{-- //Message Template Management --}}
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="card">
                                            <div class="card-body">
                                                <h4 class="pt-3">Message Template Management</h4>
                                                <br>
                                            @foreach($permissions->sortBy('display_order') as $permission)
                                                @if(permission_enabled($permission->name))
                                                    @if($permission->group == "Message Template Management")
                                                                <div class="row">
                                                                    <div class="col-sm-12 col-md-12">
                                                                        <input type="checkbox" @if(in_array($permission->name,$rolePermissions)) checked @endif name="permissions[]" value="{{ $permission->name }}">
                                                                        <label>{{ ucwords($permission->name) }}</label><br>
                                                                        <small>{!! permission_details($permission->name) !!}</small><br /><br />
                                                                    </div>
                                                                </div>
                                                        @endif
                                                    @endif
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                {{-- //Message Template Management --}}
                                {{-- //Referral Management --}}
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="card">
                                            <div class="card-body">
                                                <h4 class="pt-3">Referral Management</h4>
                                                <br>
                                            @foreach($permissions->sortBy('display_order') as $permission)
                                                @if(permission_enabled($permission->name))
                                                    @if($permission->group == "Referral Management")
                                                                <div class="row">
                                                                    <div class="col-sm-12 col-md-12">
                                                                        <input type="checkbox" @if(in_array($permission->name,$rolePermissions)) checked @endif name="permissions[]" value="{{ $permission->name }}">
                                                                        <label>{{ ucwords($permission->name) }}</label><br>
                                                                        <small>{!! permission_details($permission->name) !!}</small><br /><br />
                                                                    </div>
                                                                </div>
                                                        @endif
                                                    @endif
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                {{-- //Referral Management --}}
                                {{-- //Report Management --}}
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="card">
                                            <div class="card-body">
                                                <h4 class="pt-3">Report Management</h4>
                                                <br>
                                            @foreach($permissions->sortBy('display_order') as $permission)
                                                @if(permission_enabled($permission->name))
                                                    @if($permission->group == "Report Management")
                                                                <div class="row">
                                                                    <div class="col-sm-12 col-md-12">
                                                                        <input type="checkbox" @if(in_array($permission->name,$rolePermissions)) checked @endif name="permissions[]" value="{{ $permission->name }}">
                                                                        <label>{{ ucwords($permission->name) }}</label><br>
                                                                        <small>{!! permission_details($permission->name) !!}</small><br /><br />
                                                                    </div>
                                                                </div>
                                                        @endif
                                                    @endif
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                {{-- //Report Management --}}
                                {{-- //Advanced --}}
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="card">
                                            <div class="card-body">
                                                <h4 class="pt-3">Advanced</h4>
                                                <br>
                                            @foreach($permissions->sortBy('display_order') as $permission)
                                                @if(permission_enabled($permission->name))
                                                    @if($permission->group == "Advanced")
                                                                <div class="row">
                                                                    <div class="col-sm-12 col-md-12">
                                                                        <input type="checkbox" @if(in_array($permission->name,$rolePermissions)) checked @endif name="permissions[]" value="{{ $permission->name }}">
                                                                        <label>{{ ucwords($permission->name) }}</label><br>
                                                                        <small>{!! permission_details($permission->name) !!}</small><br /><br />
                                                                    </div>
                                                                </div>
                                                        @endif
                                                    @endif
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                {{-- //Advanced --}}
                                @endif
                            <small class="mt-0 mb-0"><b>Note:</b> While assigning "Edit/Manage" permissions for a role, make sure you assign "View" permission as well.</small>
                        </div><!--col-->
                    </div><!--form-group-->
                </div><!--col-->
            </div><!--row-->
        </div><!--card-body-->

        <div class="card-footer">
            <div class="row">
                <div class="col-md-12 text-center">
                    {{ form_submit(__('buttons.general.crud.update')) }}
                    {{ form_cancel(route('admin.auth.role.index'), __('buttons.general.cancel')) }}
                </div><!--col-->

                <div class="col text-right">
                </div><!--col-->
            </div><!--row-->
        </div><!--card-footer-->
    </div><!--card-->
{{ html()->closeModelForm() }}
@endsection
