@extends('backend.layouts.app')

@section('title', app_name() . ' | '. __('labels.backend.access.roles.management'))

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    @lang('labels.backend.access.roles.management')
                </h4>
            </div><!--col-->

            <div class="col-sm-7 pull-right">
                @include('backend.auth.role.includes.header-buttons') 
            </div><!--col-->
        </div><!--row-->

        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive" style="border: 1px solid rgb(244, 240, 240); border-radius: 6px;">
                    <table class="table table-striped bg-none mb-0">
                        <thead class="tableHeading">
                            <tr>
                                <th>@lang('labels.backend.access.roles.table.role') </th>
                                <th>@lang('labels.backend.access.roles.table.permissions')</th>
                                <th>Managerial</th>
                                <th>@lang('labels.backend.access.roles.table.number_of_users')</th>
                                <th>@lang('labels.general.actions')</th>
                            </tr>
                        </thead>
                        <tbody>
                        @foreach($roles as $role)
                            <tr>
                                <td>{{ ucwords($role->name) }}</td>
                                <td>
                                    @if($role->id == 1)
                                        @lang('labels.general.all')
                                    @else
                                        @if($role->permissions->count())
                                            @foreach($role->permissions as $permission)
                                                {{ ucwords($permission->name) }} | 
                                            @endforeach
                                        @else
                                            @lang('labels.general.none')
                                        @endif
                                    @endif
                                </td>
                                <td>{{ ($role->managerial) ? 'Yes' : ''}}</td>
                                <td>{{ $role->users->count() }}</td>
                                <td>{!! $role->action_buttons !!}</td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
            </div><!--col-->
        </div><!--row-->
        <div class="row">
            <div class="col-6">
                <div class="float-left">
                    {!! $roles->total() !!} {{ trans_choice('labels.backend.access.roles.table.total', $roles->total()) }}
                </div>
            </div><!--col-->

            <div class="col-6">
                <div class="float-right">
                    {!! $roles->render() !!}
                </div>
            </div><!--col-->
        </div><!--row-->
        <div class="row">
            <div class="col-12 mt-2">
                
                <strong>Note:</strong><br />
                Following features are accessible to Administrators only:
                <ul>
                    <li>Backups</li>
                </ul>
                Following features are accessible to Super Admin only:
                <ul>
                    <li>Delete Invoices</li>
                </ul>
            </div>
        </div>
    </div><!--card-body-->
</div><!--card-->
@endsection
@push('after-scripts')
<script>
    addDeleteForms();
</script>
@endpush
