<div class="row">
    <div class="col">
        <h3>Delete My Account</h3>
        <p>Your profile and all your information will be deleted from the portal.</p>
        <form id="account-removal-form" class="form-horizontal" method="POST" action="{{ route('admin.auth.agent.account.removal') }}">
            @csrf
            @method('DELETE')
            <div class="form-group">
                <label for="confirm_delete_text">
                    Please type <strong>DELETE</strong> to confirm account removal:
                </label>
                <input type="text" class="form-control mt-2" id="confirm_delete_text" name="confirm_delete_text" required>
                
                <button type="button" id="deleteAccountBtn" class="btn btn-danger mt-3">
                    Delete Account
                </button>
            </div>
        </form>
    </div> 
</div> 

@push ('after-scripts')
<script>
    document.addEventListener("DOMContentLoaded", function () {
        let deleteBtn = document.getElementById('deleteAccountBtn');

        if (deleteBtn) {  // only bind if button exists
            deleteBtn.addEventListener('click', function () {
                let form = document.getElementById('account-removal-form');
                console.log(form)
                if (!form) {
                    console.error("Form not found");
                    return;
                }

                let confirmInput = document.getElementById('confirm_delete_text').value.trim();
                if (confirmInput !== "DELETE") {
                    Swal.fire({
                        icon: 'error',
                        title: 'Confirmation required',
                        text: 'You must type DELETE exactly to confirm account removal.'
                    });
                    return;
                }

                Swal.fire({
                    title: 'Are you absolutely sure?',
                    text: "Your account will be permanently deactivated and you will be logged out.",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'Yes, delete my account',
                    cancelButtonText: 'Cancel'
                }).then((result) => {
                    if (result.isConfirmed) {
                        form.submit();
                    }
                });
            });
        }
    });

</script>
@endpush