@extends('backend.layouts.app')
@section('title', app_name() . ' | Account Management' )
  
@section('content')
<div class="row page-titles">
    <div class="col-md-5 align-self-center">
        <h3 class="text-themecolor">@lang('navs.frontend.user.account')</h3>
    </div>
</div>

<!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid">

    <!-- ============================================================== -->
    <!-- Start Page Content -->
    <!-- ============================================================== -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    
                    <div role="tabpanel" style="margin-top: 20px;">
                        <ul class="nav nav-tabs customtab" id="myTab" role="tablist">
                          <li class="nav-item" role="presentation">
                            <button class="nav-link active" id="account-tab" data-bs-toggle="tab" data-bs-target="#account" type="button" role="tab" aria-controls="account" aria-selected="true">My Account</button>
                          </li>
                          <li class="nav-item" role="presentation">
                            <button class="nav-link" id="password-tab" data-bs-toggle="tab" data-bs-target="#password" type="button" role="tab" aria-controls="password" aria-selected="false">Change Password</button>
                          </li>
                          <li class="nav-item" role="presentation">
                            <button class="nav-link" id="email-signature-tab" data-bs-toggle="tab" data-bs-target="#emailSignature" type="button" role="tab" aria-controls="emailSignature" aria-selected="false">Email Signature</button>
                          </li>
                          @if(\Auth::user()->isAgent() && get_site_config('student_agent_terminate_account'))
                            <li class="nav-item" role="presentation">
								<button class="nav-link" id="account_removal-tab" data-bs-toggle="tab" data-bs-target="#account_removal" type="button" role="tab" aria-controls="account_removal" aria-selected="false">Account Removal</button>
                            </li> 
                          @endif
                        </ul>
                        <div class="tab-content" id="myTabContent">
                          <div class="tab-pane fade show active" id="account" role="tabpanel" aria-labelledby="account-tab">
                                @include('frontend.user.account.tabs.profile')
                          </div>
                          <div class="tab-pane fade" id="password" role="tabpanel" aria-labelledby="password-tab">
                                @include('backend.auth.user.change-adminpassword')
                          </div>
                          <div class="tab-pane fade" id="emailSignature" role="tabpanel" aria-labelledby="email-signature-tab">
                            @include('backend.auth.user.email-signature')
                          </div>
                        @if(\Auth::user()->isAgent() && get_site_config('student_agent_terminate_account'))
                        <div class="tab-pane fade" id="account_removal" role="tabpanel" aria-labelledby="account_removal-tab">
                          @include('backend.auth.user.account-removal')
                        </div>
                        @endif
                        </div>                                    
                </div><!--card body-->
            </div><!-- card -->
        </div><!-- col-xs-12 -->
    </div><!-- row -->
</div>
@endsection

