@extends('backend.layouts.app')
@section('title', "Link Student to Agent")
@section('content')

<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-10 col-10">
                <h4 class="card-title mb-0">
                    Link Student to Agent
                </h4><br>
            </div>
            <!--col-->
            <div class="col-sm-2 col-2" style="margin-top:20px;text-align: right;">
                <button type="cancel" name="back" class="btn btn-primary btn-sm" value="Back" onclick="document.location ='{{ route('admin.auth.user.show', $user->id) }}'" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </button>
            </div>
        </div>
        <!--row-->
        {{ html()->form('POST', route('admin.auth.add.student-to.agent.save',$user))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}

        <input type="hidden" name="student_id" value="{{$user->id}}">
        <div class="form-group row">
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label"><b>User Name</b></span></label>
                <div class="">
                    <p class="">{{ $user->first_name }} {{$user->last_name }}</p>
                </div>
            </div>
        </div>

        <div class="form-group row">
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label"><b>User Email</b></label>
                <div class="">
                    <p>{{ $user->email }}</p>
                </div>
            </div>
        </div>
        @if($user->agent_id)
        <div class="form-group row">
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label"><b>User Agent</b></label>
                <div class="">
                    <p>{{ get_user_full_name_by_id($user->agent_id) }}</p>
                </div>
            </div>
        </div>
        @endif

        <div class="form-group row ">
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label"><b>Agents</b></label>
                <div class="">
                    <select class="form-select" id='agent_id' name="agent_id" required>
                        <option value=''>Select</option>
                             @foreach($agents as $agent)
                                <option value="{{$agent->id}}" {{($user->agent_id == $agent->id) ? 'selected' : ''}}>{{$agent->first_name . ' ' . $agent->last_name}}</option>
                            @endforeach
                    </select>
                </div>
            </div>
        </div>
            

        <div class="row" style="margin-top:10px;">
            <div class="col-sm-12 col-md-8">
                <div class="form-group mb-0 clearfix">
                    {{ form_submit("Save") }}
                    <button type="button" class="btn btn-secondary btn-sm" name="cancel" value="Cancel" onclick="document.location ='{{ route('admin.auth.user.index') }}'">Cancel</button>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
