@extends('backend.layouts.app')

@section('title', "Archived Students")

@include('backend.auth.user.includes.top-links-students')

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    Archived Students
                </h4>
            </div>
        </div>

        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive" style=" border-radius: 6px;">
                    <table class="table eductrl-datatable table-striped bg-none mb-0">
                        <thead class="">
                            <tr>
                                <th>ID</th>
                                <th>Name</th>
                                <th>Details</th>
                                <th>Signed Up</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>

                        {{-- @if(!$archived_student->count()) --}}
                            @foreach($archived_student as $user)
                                <tr>
                                    <td>{{ $user->id }}</td>
                                    <td><b>{{ get_user_full_name_by_id($user->id) }}</b></td>
                                    <td>{{ $user->email }} <br>
                                        @if($user->mobile) <i class='fas fa-phone-alt text-sub'></i> @endif
                                        @if($user->dialcode) +{{ $user->dialcode }} - @endif {{ $user->mobile }} <br>
                                        @if($user->dialcode && $user->whatsapp) <i class='fas fa-phone-alt text-sub'></i> +{{ $user->dialcode }} - {{ $user->whatsapp }}  <br> @endif 
                                        @if($user->country)<i class='fas fa-globe text-sub'></i> @endif
                                        @if($user->city) {{ $user->city }}, @endif
                                        @if($user->state) {{ get_state_name($user->state) }}, @endif
                                        @if($user->country) {{ get_country_name($user->country) }} <br> @endif 
                                        @if($user->branch) <span class="tagPrimary">{{ branch_name($user->branch) }}</span> @endif 
                                    </td>
                                    <td>{{ date("d M y", strtotime($user->created_at)) }}</td>
                                    <td><a href="{{route('admin.auth.user.un-archive-user', $user->id)}}" class="btn btn-sm btn-outline-primary" name="confirm_item" data-trans-title="Are you sure want to UnArchive this student ?"><i class="bi bi-archive-fill"></i> Unarchive </a></td>
                                </tr>
                            @endforeach
                        {{-- @else
                            <tr><td colspan="5"><p class="text-center">No Record Found</p></td></tr>
                        @endif --}}
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
