@extends('backend.layouts.app')
@section('title', "Assign User to Staff")
@section('content')

<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-10 col-10">
                <h4 class="card-title mb-0">
                    Assign User to Staff
                </h4><br>
            </div>
            <!--col-->
            <div class="col-sm-2 col-2" style="margin-top:20px;text-align: right;">
                <button type="cancel" name="back" class="btn btn-primary btn-sm" value="Back" onclick="document.location ='{{ route('admin.auth.user.index') }}'" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </button>
            </div>
        </div>
        <!--row-->
        {{ html()->form('POST', route('admin.auth.user.assignstudent.update'))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}

       
        <input type="hidden" name="stu_id" value="{{$studentdata->id}}">
        <div class="form-group row mb-2">
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label"><b>User Name</b></span></label>
                <div class="">
                    <p class="">{{ $studentdata->first_name }} {{$studentdata->last_name }}</p>
                </div>
            </div>
        </div>

        <div class="form-group row mb-2">
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label"><b>User Email</b></label>
                <div class="">
                    <p>{{ $studentdata->email }}</p>
                </div>
            </div>
        </div>

        <div class="form-group row mb-2">
            <div class="col-sm-12 col-md-4">
                <label class="col-form-label"><b>Assign To</b></label>
                <div class="">
                    <select class="form-select" id='staff' name="staff">
                        <option value=''>Select</option>
                        
                             @foreach($staff as $stf)
                                <option value="{{$stf->id}}" {{($studentdata->assigned_to == $stf->id) ? 'selected' : ''}}>{{$stf->first_name . ' ' . $stf->last_name}}</option>
                            @endforeach
                    </select>
                </div>
            </div>
        </div>
            

        <div class="row" style="margin-top:10px;">
            <div class="col-sm-12 col-md-8">
                <div class="form-group mb-0 clearfix">
                    {{ form_submit("Save") }}
                    <button type="button" class="btn btn-secondary btn-sm" name="cancel" value="Cancel" onclick="document.location ='{{ route('admin.auth.user.index') }}'">Cancel</button>
                </div>
            </div>
        </div>


    </div>
</div>
@endsection
