@extends('backend.layouts.app')
@section('title', app_name() . ' | Profile Management' )

@section('content')
<div class="row page-titles">
    <div class="col-md-5 align-self-center">
        <h3 class="text-themecolor">My Profile</h3>
    </div>
</div>

<!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid">

    <!-- ============================================================== -->
    <!-- Start Page Content -->
    <!-- ============================================================== -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">                
                    <h4 class="card-title">Update Profile</h4>                    
                    <div role="tabpanel">
                        <div class="tab-content">
                               
                               
                               
                            {{ html()->modelForm($logged_in_user, 'PATCH', route('admin.auth.update-abasicinfo'))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}
                            @method('PATCH')
                            <div class="row">
                                <div class="col-sm-12 col-md-8">
                                    <div class="form-group">
                                        {{ html()->label(__('validation.attributes.frontend.first_name'))->for('first_name') }}
                            
                                        {{ html()->text('first_name')
                                                ->class('form-control')
                                                ->placeholder(__('validation.attributes.frontend.first_name'))
                                                ->attribute('maxlength', 50)
                                                ->required()
                                                ->autofocus() }}
                                    </div><!--form-group-->
                                </div><!--col-->
                            </div><!--row-->
                                                        
                            
                            <div class="row">
                                <div class="col-sm-12 col-md-8">
                                    <div class="form-group">
                                        {{ html()->label(__('validation.attributes.frontend.last_name'))->for('last_name') }}
                            
                                        {{ html()->text('last_name')
                                                ->class('form-control')
                                                ->placeholder(__('validation.attributes.frontend.last_name'))
                                                ->attribute('maxlength', 50)
                                                ->required() }}
                                    </div><!--form-group-->
                                </div><!--col-->
                            </div><!--row-->
                            
                            <div class="row">
                                <div class="col-sm-12 col-md-8">
                                    <div class="form-group">
                                        {{ html()->label(__('labels.frontend.user.profile.mobile'))->for('mobile') }}
                            
                                        {{ html()->text('mobile')
                                                ->class('form-control')
                                                ->placeholder(__('labels.frontend.user.profile.mobile'))
                                                ->attribute('maxlength', config('app.USER_MOBILE_MAX_LENGTH') )
                                                ->attribute('minlength', config('app.USER_MOBILE_MIN_LENGTH') )
                                                ->required() }}
                                    </div><!--form-group-->
                                </div><!--col-->
                            </div><!--row-->
                            
                            <div class="row">
                                <div class="col-sm-12 col-md-8">
                                    <div class="form-group">
                                        {{ html()->label(__('validation.attributes.frontend.email'))->for('email') }}
                            
                                        {{ html()->email('email')
                                                    ->class('form-control')
                                                    ->placeholder(__('validation.attributes.frontend.email'))
                                                    ->attribute('maxlength', 191)
                                                    ->required() }}
                                    </div><!--form-group-->
                                </div><!--col-->
                            </div><!--row-->
                            
                            
                            <div class="row">
                                <div class="col-sm-12 col-md-8">
                                    <div class="form-group">
                                        {{ html()->label(__('labels.frontend.user.profile.address'))->for('address') }}
                            
                                        {{ html()->text('address_1')
                                                ->class('form-control')
                                                ->attribute('maxlength', 50) }}
                                    </div><!--form-group-->
                                </div><!--col-->
                            </div><!--row-->
                                                        
                            
                            <div class="row">
                                <div class="col-sm-12 col-md-8">
                                    <div class="form-group mb-0 mt-2 clearfix">
                                        <button type="submit" class="btn btn-primary btn-sm">Update</button>
                                    </div><!--form-group-->
                                </div><!--col-->
                            </div><!--row-->
                            {{ html()->closeModelForm() }}
                               

                        </div><!--tab content-->
                    </div><!--tab panel-->

                </div>
            </div>
        </div>
    </div>
</div>
<!-- ============================================================== -->
<!-- End Container fluid  -->
<!-- ============================================================== -->                    
@endsection
