@extends('backend.layouts.app')
@section('title', 'User Management | ' . __('labels.backend.access.users.change_password'))

@section('content')

@if(isset($is_staff) && $is_staff)
{{ html()->form('PATCH', route('admin.auth.staff.change-password.post', $user))->class('form-horizontal')->open() }}
@elseif(isset($is_agent) && $is_agent)
{{ html()->form('PATCH', route('admin.auth.agent.change-password.post', $user))->class('form-horizontal')->open() }}
@elseif(isset($is_trainer) && $is_trainer)
{{ html()->form('PATCH', route('admin.auth.agent.change-password.post', $user))->class('form-horizontal')->open() }}
@elseif(isset($is_lead) && $is_lead)
{{ html()->form('PATCH', route('admin.auth.user.change-password.post', $user))->class('form-horizontal')->open() }}
@else
{{ html()->form('PATCH', route('admin.auth.user.change-password.post', $user))->class('form-horizontal')->open() }}
@endif

<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    Change User Password
                </h4>

                <div class="smaller">
                    @lang('labels.backend.access.users.change_password_for', ['user' => $user->name])
                </div>
            </div>
            <!--col-->
        </div>
        <!--row-->

        <hr />

        <div class="row mt-4 mb-4">
            <div class="col">
                <div class="form-group row">
                    {{ html()->label(__('validation.attributes.backend.access.users.password'))->class('col-md-2 form-control-label')->for('password') }}

                    <div class="col-md-10">
                        {{ html()->password('password')
                                ->class('form-control')
                                ->placeholder( __('validation.attributes.backend.access.users.password'))
                                ->required()
                                ->autofocus() }}
                    </div>
                    <!--col-->
                </div>
                <!--form-group-->

                <div class="form-group row">
                    {{ html()->label(__('validation.attributes.backend.access.users.password_confirmation'))->class('col-md-2 form-control-label')->for('password_confirmation') }}

                    <div class="col-md-10">
                        {{ html()->password('password_confirmation')
                                ->class('form-control')
                                ->placeholder( __('validation.attributes.backend.access.users.password_confirmation'))
                                ->required() }}
                    </div>
                    <!--col-->
                </div>
                <!--form-group-->
            </div>
            <!--col-->
        </div>
        <!--row-->
    </div>
    <!--card-body-->

    <div class="card-footer">
        <div class="row" style="text-align:center;">
            <div class="col">
                {{ form_submit(__('buttons.general.crud.update')) }}

                @if(isset($is_staff) && $is_staff)
                {{ form_cancel(route('admin.auth.staff'), __('buttons.general.cancel')) }}
                @elseif(isset($is_agent) && $is_agent)
                {{ form_cancel(route('admin.agents.index'), __('buttons.general.cancel')) }}
                @elseif(isset($is_trainer) && $is_trainer)
                {{ form_cancel(route('admin.auth.user.index'), __('buttons.general.cancel')) }}
                @elseif(isset($is_lead) && $is_lead)
                {{ form_cancel(route('admin.leadmanagementdetails'), __('buttons.general.cancel')) }}
                @else
                {{ form_cancel(route('admin.auth.user.index'), __('buttons.general.cancel')) }}
                @endif


            </div>
            <!--col-->

            <!-- <div class="col text-right">
                </div> -->
            <!--row-->
        </div>
        <!--row-->
    </div>
    <!--card-footer-->
</div>
<!--card-->
{{ html()->form()->close() }}
@endsection