@extends('backend.layouts.app')

@section('title', __('labels.backend.access.users.management') . ' | ' . __('labels.backend.access.users.create'))

@section('content')
{{ html()->form('POST', route('admin.auth.student.store'))->id('student_form')->class('form-horizontal')->open() }}
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    Create {{_label('backend_student')}}
                    <!-- <small class="text-muted">@lang('labels.backend.access.users.create')</small> -->
                </h4>
            </div>
            <!--col-->
        </div>
        <div class="row">
            <div class="col">
                <span class="text-smaller">Fields marked with <span style="color:red;">*</span> are mandatory</span>
            </div>
        </div>
        <!--row-->

        <hr style="height:1px;">

        <div class="row mt-4 mb-4">
            <div class="col-sm-12 col-md-9">
                <div class="form-group row">
                    <div class="col-sm-12 col-md-4">
                        <label class="col-form-label required-field">First Name</span></label>
                        <div class="">
                            {{-- <span class="input-group-text"><i class="fa fa-user" style="font-size: 10px; color:rgb(106, 107, 107)"></i></span> --}}
                            <input type="text" placeholder="First Name" class="form-control" name="first_name" value="{{ Request::old('first_name') }}" pattern="[a-zA-Z\s]+" title="Only Alphabets and space is allowed" required>
                        </div>
                    </div>
                    <div class="col-sm-12 col-md-4">
                        <label class="col-form-label">Middle Name</span></label>
                        <div class="">
                            <input type="text" placeholder="Middle Name" class="form-control" name="middle_name" value="{{ Request::old('middle_name') }}" pattern="[a-zA-Z\s]+" title="Only Alphabets and space is allowed">
                        </div>
                    </div>
                    <div class="col-sm-12 col-md-4">
                        <label class="col-form-label required-field">Last Name</label>
                        <div class="">
                            <input type="text" placeholder="Last Name" class="form-control" name="last_name" value="{{ Request::old('last_name') }}" pattern="[a-zA-Z\s]+" title="Only Alphabets and space is allowed" required>
                        </div>
                    </div>
                </div>

                <div class="form-group row mt-2 mb-2">
                    <div class="col-sm-12">
                        <input type="radio" class="radio-col-blue" id="radio_1" name="gender" value="male" {{ Request::old('gender') == 'male' ? 'checked' : (Request::old('gender') == '' ? 'checked' : '') }} required />
                        <label for="radio_1">Male</label>

                        <input type="radio" style="margin-left:8px;" class="radio-col-blue" id="radio_2" name="gender" value="female" {{ Request::old('gender') == 'female' ? 'checked' : '' }} required />
                        <label for="radio_2">Female</label>
                    </div>
                </div>

                <div class="form-group row ">
                    <div class="col-sm-12 col-md-8">
                        <label class="col-form-label @if(get_site_config('student_create_admin_mandatory') == 'email' || get_site_config('student_create_admin_mandatory') == 'email_and_mobile') required-field @endif">Email</label>
                        <div class="">
                            <input type="email" 
                                placeholder="Email ID" 
                                autocomplete="off" 
                                class="form-control" 
                                name="email" 
                                id="email"
                                value="{{ Request::old('email') }}" 
                                @if(get_site_config('student_create_admin_mandatory') == 'email' || get_site_config('student_create_admin_mandatory') == 'email_and_mobile') required @endif>
                                <p class="error" id="invalid_email"></p>
                        </div>
                    </div>

                    <div class="col-sm-12 col-md-4">
                        <label class="col-form-label">Date of Birth</label>
                        <input type="text" placeholder="Date of Birth" class="form-control dobmydatepicker" autocomplete="off" id="dob" name="birthday" value="{{ Request::old('birthday') }}">
                    </div>
                </div>

                <div class="form-group row ">
                    <div class="col-sm-12 col-md-6">
                        <label class="col-form-label @if(get_site_config('student_create_admin_mandatory') == 'mobile' || get_site_config('student_create_admin_mandatory') == 'email_and_mobile') required-field @endif">Mobile No.</label>
                        <div class="input-group">
                            <div class="input-group-prepend" style="width: 50%">
                                <select class="form-select select2" id="dialcode" name="dialcode" style="padding:0.49rem 2rem 0.375rem 0.75rem;">
                                    {{-- <option value=''>Dialcode</option> --}}
                                    @foreach($dialcodes as $dialcode)
                                    <option 
                                    {{((Request::old('dialcode') && $dialcode->code == Request::old('dialcode')) || env('USER_DEFAULT_DIALCODE') == $dialcode->code) ? 'selected' : ''}} 
                                    value="{{$dialcode->code}}"
                                    data-name="{{$dialcode->name}}"
                                    >{{$dialcode->name}} +{{$dialcode->code}}</option>
                                    @endforeach
                                </select>
                            </div>
                            <input 
                            type="text" 
                            placeholder="Mobile No." 
                            class="form-control" 
                            id="mobile"
                            onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))" 
                            name="mobile" value="{{ Request::old('mobile') }}" 
                            minlength="{{ config('app.USER_MOBILE_MIN_LENGTH') }}" 
                            maxlength="{{ config('app.USER_MOBILE_MAX_LENGTH') }}" 
                            @if(get_site_config('student_create_admin_mandatory') == 'mobile' || get_site_config('student_create_admin_mandatory') == 'email_and_mobile') required @endif
                            >
                        </div>
                        <p class="error" id="invalid_mobile"></p>
                    </div>

                    <div class="col-sm-12 col-md-6">
                        <label for="whatsapp_number" class="col-form-label">Whatsapp No.</label>
                        <div class="input-group">
                            <div class="input-group-prepend" style="width: 50%">
                                <select class="form-select select2" id="whatsapp_dialcode" name="whatsapp_dialcode" style="padding:0.49rem 2rem 0.375rem 0.75rem;">
                                    {{-- <option value=''>Dialcode</option> --}}
                                    @foreach($dialcodes as $dialcode)
                                    <option 
                                    {{((Request::old('whatsapp_dialcode') && $dialcode->code == Request::old('whatsapp_dialcode')) || env('USER_DEFAULT_DIALCODE') == $dialcode->code) ? 'selected' : ''}} 
                                    value="{{$dialcode->code}}"
                                    data-name="{{$dialcode->name}}"
                                    >{{$dialcode->name}} +{{$dialcode->code}}</option>
                                    @endforeach
                                </select>
                            </div>
                            <input type="text" placeholder="Whatsapp No." id="whatsapp_number" minlength="{{ config('app.USER_MOBILE_MIN_LENGTH') }}" maxlength="{{ config('app.USER_MOBILE_MAX_LENGTH') }}" class="form-control" name="whatsapp_number" value="{{ Request::old('whatsapp_number') }}">
                        </div>
                        <div class="form-check" style="margin-top: -7px;">
                            <input type="checkbox"
                                class="form-check-input"
                                id="sameAsMobile"
                                >  
                            <label class="form-check-label" for="sameAsMobile" style="font-weight:500 !important;">Same as Mobile No.</label>
                        </div>
                    </div>

                    <div class="col-sm-12 col-md-4">
                        <label for="alternate_contact">Alternate Contact</label>
                        <div class="">
                            <input type="text" placeholder="Alternate Contact" id="alternate_contact" maxlength="50" class="form-control" name="alternate_contact" value="{{ Request::old('alternate_contact') }}">
                        </div>
                    </div>
                </div>

                <div class="form-group row ">
                    <div class="col-sm-12 col-md-4">
                        <label class="col-form-label required-field">Country</label>
                        <select class="form-select" id="country" name="country" required>
                            @foreach ($country_list as $key => $value)
                            <option value="{{ $key }}" @if(old('country') == $key || env('USER_DEFAULT_COUNTRY') == $key) selected @endif>{{ $value }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-sm-12 col-md-4">
                        <label class="col-form-label">State</label>
                        <div class="form-group">
                            <select class="form-control form-select" name="state" id="state-dd">
                            </select>
                        </div>
                    </div>
                    <div class="col-sm-12 col-md-4">
                        <label class="col-form-label">City</label>
                        <select class="form-control form-select" name="city" id="city-dd">
                        </select>
                        {{-- <input type="text" placeholder="City" value="{{ Request::old('city') }}" class="form-control validate_inpt" id="city" name="city"> --}}
                    </div>
                </div>

                <div class="form-group row ">
                    <div class="col-sm-12 col-md-4">
                        @if(!\Auth::user()->isAgent())
                            <label class="col-form-label required-field">Login Password</label>
                        @else
                            <label class="col-form-label">Login Password</label>
                        @endif
                        <div class="input-group" style="">
                            <input type="password" placeholder="Login Password" autocomplete="new-password" id="password" class="form-control" name="password" style="margin-bottom: 0px; border-right: 0 !important;" @if(!\Auth::user()->isAgent()) required @else  @endif>
                            <div class="input-group-prepend border-left-0" style="border: 0.666667px solid black; padding: 5px 10px; border-top-right-radius: 3.5px; border-bottom-right-radius: 3.5px; border-color: rgb(206, 212, 218)">
                                <i class="bi bi-eye-slash bold" id="togglePassword"></i>
                            </div>
                        </div>
                        <a class="text-primary" style="cursor: pointer;" onClick="generatePassword()">Generate Password</a>
                    </div>
                </div>
                <hr style="height: 1px;">
                <div class="form-group row">
                    <div class="col-sm-12 col-md-4">
                        <label class="col-form-label required-field">Interested Study Level</label>
                        <select class="form-select" id="study_level" name="study_level" required>
                            <option value="">Select Study Level</option>
                            @foreach(get_study_levels() as $key => $value)
                            <option value="{{$value}}" {{(Request::old('study_level') == $value)? 'selected' : ''}}>{{$value}}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-sm-12 col-md-8">
                        <label class="col-form-label">Country Interested to Study In</label>
                        {{-- <select name="country_pref[]" class="form-select select2" multiple> --}}
                        <select name="country_interested[]" class="form-select select2" multiple>
                            @foreach($countries as $country)
                            <option value="{{$country->title_en}}">{{$country->title_en}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <div class="form-group row " id="interested">
                    <div class="col-sm-12 col-md-4">
                        <label class="col-form-label">Course Interested to Study</label>
                        <input type="text" placeholder="Course Interested to Study" class="form-control validate_inpt" value="{{Request::old('course_interested')}}" id="course_interested" name="course_interested">
                    </div>
                    <div class="col-sm-12 col-md-4">
                        <label class="col-form-label">Intake</label>
                        <select name="intake" class="form-select form-control">
                            <option value="">Intake</option>
                            <?php $month = date('n'); // current month
                            for ($x = 0; $x < 24; $x++) { ?>
                                <option {{(Request::old('intake')==date('m Y', mktime(0,0,0,$month + $x,1)))? 'selected' : ''}} value="<?php echo date('m Y', mktime(0, 0, 0, $month + $x, 1)); ?>">
                                    <?php echo date('F Y', mktime(0, 0, 0, $month + $x, 1)); ?>
                                <?php } ?></option>
                        </select>
                    </div>
                </div>

                @if(config('app.product_code') == 'EDUCTRL_CRM')
                <hr style="height: 1px;">
                <div class="form-group row">
                    <label class="col-form-label">Course Interested in</label>
                    <div class="col-sm-12 col-md-8">
                        <select class="form-select" name="course">
                            <option value="">Select Course</option>
                            @isset($courses)
                            @foreach($courses as $course)
                            <option value="{{ $course->id }}" @if (old('course')==$course->title) selected="selected" @endif>{{ $course->title }}</option>
                            @endforeach
                            @endisset
                        </select>
                    </div>
                </div>
                @endif

                @if(env('ADDITIONAL_SERVICES_ENABLE'))
                <hr style="height: 1px;">
                <div class="row">
                    <div class="col-sm-12 col-md-8">
                        <label class="col-form-label">Other Services Interested</label>
                        <select name="services[]" class="form-select select2" multiple>
                            {{-- <option value="">Select</option> --}}
                            @foreach(get_services_data() as $service)
                                <option @if(old('services') == $service->id) selected @endif value="{{$service->id}}">{{$service->service_name}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                @endif
                <hr style="height: 1px;">

                @if(config('app.product_code') == 'OVERSEAS' || config('app.product_code') == 'EDUCTRL_CRM')
                <div id="overseas_fields" @if(config('app.product_code')=='EDUCTRL_CRM' ) style="display:none;" @endif>

                    <div class="form-group row">
                        <div class="col-sm-12 col-md-4">
                            <label class="col-form-label">Qualification</label>
                            <select class="form-select" id="qualification" name="qualification">
                                <option value="">Select Qualification</option>
                                @foreach(get_student_qualification_levels() as $value)
                                        <option value="{{$value}}" {{(Request::old('qualification') == $value)? 'selected' : ''}}>{{$value}}</option>
                                @endforeach
                                {{-- <option value="9th" {{ Request::old('9th') == '9th' ? 'selected' : '' }}>9th
                                </option>
                                <option value="10th" {{ Request::old('10th') == '10th' ? 'selected' : '' }}>10th
                                </option>
                                <option value="11th" {{ Request::old('11th') == '11th' ? 'selected' : '' }}>11th
                                </option>
                                <option value="12th" {{ Request::old('12th') == '12th' ? 'selected' : '' }}>12th
                                </option>
                                <option value="Bachelors" {{ Request::old('qualification') == 'Bachelors' ? 'selected' : '' }}>Bachelors
                                </option>
                                <option value="Masters" {{ Request::old('qualification') == 'Masters' ? 'selected' : '' }}>Masters
                                </option>
                                <option value="Ph.D" {{ Request::old('qualification') == 'Ph.D' ? 'selected' : '' }}>Ph.D
                                </option>                             --}}
                            </select>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <label class="col-form-label">Passout Year</label>
                            <input type="text" placeholder="Passout Year" onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))" minlength="4" maxlength="4" class="form-control" id="passout_year" name="passout_year" value="{{ Request::old('passout_year') }}">
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <label class="col-form-label">Score/Grade</label>
                            <input type="text" placeholder="Score/Grade" class="form-control" id="qualification_score" name="qualification_score" value="{{ Request::old('qualification_score') }}">
                        </div>
                    </div>

                    <div class="form-group row " id="csc">
                        <div class="col-sm-12 col-md-4">
                            <label class="col-form-label">Currently Studying Course</label>
                            <input type="text" placeholder="Currently Studying Course" class="form-control validate_inpt" id="currently_studying_course" name="currently_studying_course" value="{{ Request::old('currently_studying_course') }}">
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <label class="col-form-label">Work Experience</label>
                            <input type="text" placeholder="Work Experience" class="form-control" id="work_experience" name="work_experience" value="{{ Request::old('work_experience') }}">
                        </div>
                    </div>
                </div>
                @endif

                @if(config('app.product_code') == 'TRAINING')
                <input type="hidden" name="student_type" value="course">
                @elseif(config('app.product_code') == 'OVERSEAS')
                <input type="hidden" name="student_type" value="study_abroad">
                @elseif(config('app.product_code') == 'VISA')
                <input type="hidden" name="student_type" value="visa">
                @else
                <div class="form-group row mb-3">
                    <div class="col-md-6">
                        <label class="required-field">Interested In</label>
                        <select class="form-select" id="student_type" name="student_type" required>
                            <option value="">Select</option>
                            <option value="study_abroad">Study Abroad</option>
                            <option value="course">Trainings</option>
                            <option value="study_abroad_course">Study Abroad & Trainings</option>
                            @if(env('ABROAD_JOB_ADDON'))
                            <option value="abroad_job">Abroad Job</option>
                            @endif
                            @if(env('VISA_ADDON'))
                            <option value="visa">Visa</option>
                            @endif
                        </select>
                    </div>
                </div>
                @endif
{{-- //Custom Attributes --}}
@if(count($custom_attributes))
<hr style="height:1px;">
<div class="form-group row ">
    @foreach($custom_attributes as $custom_attribute)
        @if($custom_attribute->for_student_mandatory)
        <?php   $red = "required-field";
                $mandate = "required"; ?>
        @else
        <?php $red="";
              $mandate = "";?>
       @endif

        @if($custom_attribute->type == 'input')
            <div class="col-sm-12 col-md-4">
                <div class="form-group">
                    <label for="" class="col-form-label {{$red}}">{{$custom_attribute->label}}</label>
                    <div class="">
                        <input type="@if($custom_attribute->input_datatype == 'number' || $custom_attribute->input_datatype == 'decimal'){{'number'}}@elseif($custom_attribute->input_datatype == 'date' || $custom_attribute->input_datatype == 'year' || $custom_attribute->input_datatype == 'phone'){{'text'}}@else{{$custom_attribute->input_datatype}}@endif" {{ ($custom_attribute->input_datatype == 'decimal')? "step=any" : ''}} 
                        @if($custom_attribute->input_datatype == 'number' || $custom_attribute->input_datatype == 'decimal')
                            {{"min=$custom_attribute->input_min"}} {{"max=$custom_attribute->input_max"}}
                        @elseif($custom_attribute->input_datatype == 'date')
                        {{-- //No min or max added --}}
                        @elseif($custom_attribute->input_datatype == 'year')
                            onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))" minlength="4" maxlength="4"
                        @elseif($custom_attribute->input_datatype == 'phone')
                            onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 58) || event.charCode==32 || event.charCode==44 || event.charCode==43 || event.charCode==45 || event.charCode==40 || event.charCode==41)" minlength="10" maxlength="18"
                        @else
                            {{"minLength=$custom_attribute->input_min"}} {{"maxLength=$custom_attribute->input_max"}}
                        @endif
                         placeholder="{{$custom_attribute->placeholder}}" autocomplete="off" class="form-control @if($custom_attribute->input_datatype == 'date') {{'mydatepicker'}}@endif" name="{{$custom_attribute->attr_name}}" value='@if(isset($attrData[$custom_attribute->attr_name])){{ $attrData[$custom_attribute->attr_name]}}@else{{old("$custom_attribute->attr_name")}}@endif' {{$mandate}} >
                        
                    </div>
                </div>
            </div>
        @endif
        @if($custom_attribute->type == 'textarea')
        <div class="form-group row ">
            <div class="col-sm-12 col-md-8">
                <div class="form-group">
                    <label for="" class="col-form-label {{$red}}">{{$custom_attribute->label}}</label>
                    <div class="">
                        <textarea placeholder="{{$custom_attribute->placeholder}}" {{"minLength=$custom_attribute->input_min"}} {{"maxLength=$custom_attribute->input_max"}} class="form-control" name="{{$custom_attribute->attr_name}}" {{$mandate}}>{{ old("$custom_attribute->attr_name") }}</textarea>
                    </div>
                </div>
            </div>
        </div>
        @endif
        @if($custom_attribute->type == 'select')
        <?php
            $is_multi = $select2 = "";
            $select_vals = explode('|',$custom_attribute->selection_values);
            if($custom_attribute->select_multiple){
                $is_multi = "multiple";
                $select2 = "select2";
            }
        ?>
            <div class="col-sm-12 col-md-4">
                <div class="form-group">
                    <label for="" class="col-form-label {{$red}}">{{$custom_attribute->label}}</label>
                    <div class="">
                        <select placeholder="{{$custom_attribute->placeholder}}" class="form-select {{$select2}}" name="{{$custom_attribute->attr_name}}[]" {{$mandate}} {{$is_multi}}>
                            @if(!$is_multi)
                            <option value="">{{$custom_attribute->placeholder}}</option>
                            @endif
                            @foreach($select_vals as $sel_val)
                            <option {{ (is_array(old("$custom_attribute->attr_name")) && in_array($sel_val, old("$custom_attribute->attr_name"))) ? ' selected' : '' }} value="{{ $sel_val }}">{{ $sel_val }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>
        @endif
        @if($custom_attribute->type == 'checkbox')
        <?php
            $select_vals = explode('|',$custom_attribute->selection_values);
        ?>
            <div class="col-sm-12 col-md-4">
                <div class="form-group">
                    <label for="" class="col-form-label {{$red}}">{{$custom_attribute->label}}</label>
                    <div class="">
                            @foreach($select_vals as $sel_val)
                            <label>
                                <input class="form-check-input ms-2 dyna_chkbx {{$custom_attribute->attr_name}}" @if($mandate) onclick='chk_mend("{{$custom_attribute->attr_name}}")' @endif {{ (is_array(old("$custom_attribute->attr_name")) && in_array($sel_val, old("$custom_attribute->attr_name"))) ? ' checked' : '' }} type="checkbox" name="{{$custom_attribute->attr_name}}[]" value="{{$sel_val}}" @if(is_array(old("$custom_attribute->attr_name"))) {{''}} @else{{$mandate}}@endif> {{$sel_val}}
                            </label>
                            @endforeach
                    </div>
                </div>
            </div>
        @endif
        @if($custom_attribute->type == 'radio')
        <?php
            $select_vals = explode('|',$custom_attribute->selection_values);
        ?>
            <div class="col-sm-12 col-md-4">
                <div class="form-group">
                    <label for="" class="col-form-label {{$red}}">{{$custom_attribute->label}}</label>
                    <div class="">
                            @foreach($select_vals as $sel_val)
                            <label>
                                <input class="form-check-input ms-2 {{$custom_attribute->attr_name}}" @if($mandate) onclick='chk_mend("{{$custom_attribute->attr_name}}")' @endif {{ (is_array(old("$custom_attribute->attr_name")) && in_array($sel_val, old("$custom_attribute->attr_name"))) ? ' checked' : '' }} type="radio" name="{{$custom_attribute->attr_name}}[]" value="{{$sel_val}}" @if(is_array(old("$custom_attribute->attr_name"))) {{''}} @else{{$mandate}}@endif> {{$sel_val}}
                            </label>
                            @endforeach
                    </div>
                </div>
            </div>
        @endif
    @endforeach
</div>
<hr style="height:1px;">
@endif
{{-- //Custom Attributes --}}
@if(!\Auth::user()->isAgent())
                <div class="form-group row ">
                    <div class="col-sm-12 col-md-4">
                        <label class="col-form-label">Lead Source</label>
                        <div class="">
                            <select class="form-select" id='lead_source' name="lead_source">
                                <option value=''>Select</option>
                                @foreach(get_lead_sources() as $source_data)
                                <option {{($source_data == Request::old('lead_source'))? 'selected' : ''}} value="{{$source_data}}">{{ucfirst($source_data)}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-sm-12 col-md-4">
                        <div class="form-group">
                            <label for="address" class="col-form-label">Lead Source Details</label>
                            <div class="">
                                <input type="text" placeholder="Lead Source Details" class="form-control" name="lead_source_detail" value="{{ Request::old('lead_source_detail') }}">
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-12 col-md-4">
                        <div class="form-group">
                            <label for="" class="col-form-label">Campaign Name</label>
                            <div class="">
                                <input type="text" placeholder="Campaign Name" class="form-control" name="campaign_name" value="{{ Request::old('campaign_name') }}">
                            </div>
                        </div>
                    </div>
                        <div class="col-sm-12 col-md-4">
                            <label class="col-form-label"><b>Agent</b></label>
                            <div class="">
                                <select class="form-select" id='agent_id' name="agent_id">
                                    <option value=''>Select</option>
                                         @foreach($agents as $agent)
                                            <option value="{{$agent->id}}" {{(Request::old('agent_id') == $agent->id) ? 'selected' : ''}}>{{$agent->first_name . ' ' . $agent->last_name}}</option>
                                        @endforeach
                                </select>
                            </div>
                        </div>
                        @if(get_site_config('module_student_referral'))
                        <div class="col-sm-12 col-md-4">
                            <label class="col-form-label">Referred by Student</label>
                            <div class="">
                                <select class="form-select select2_ajax" id='ref_by' name="referred_by">
                                    <option value=''>Select Student</option>
                                    {{-- @foreach(get_users_list() as $user_data)
                                    <option {{($user_data->id == Request::old('referred_by'))? 'selected' : ''}} value="{{$user_data->id}}">{{ucfirst($user_data->text)}}</option>
                                    @endforeach --}}
                                </select>
                            </div>
                        </div>
                        @endif
                </div>
                
                <hr style="height:1px;">
                <div class="form-group row" id="branch">
                    <div class="col-sm-12 col-md-6">
                        <label class="col-form-label required-field">Branch</label>
                        <select class="form-select" id="branch" name="branch" required>
                            {{-- <option value="">Select Branch</option> --}}
                            @foreach($branch as $id => $name)
                                <option value="{{ $id }}" {{($id == Request::old('branch'))? 'selected' : ''}} >{{ $name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-sm-12 col-md-6">
                        <label class="col-form-label required-field">Assign To Staff</label>
                            <select class="form-select" id="assign_to" name="assigned_to" required="required">
                                <option value="">Select Staff</option>
                                @foreach($staff as $stf)
                                <option {{($stf->id == Request::old('assign_to') || $stf->id == \Auth::user()->id)? 'selected' : ''}} value="{{$stf->id}}">{{$stf->first_name.' '.$stf->last_name}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>   
                    @endif           
                </div>
            </div>
            
            <div class="row">
                @if($welcome_email && !\Auth::user()->isAgent())
                <span class="text-primary d-inline-block">
                    A Welcome Email(Template: STUDENT_CREATE_WELCOME) will be sent to the Student.
                </span>
                @endif
                @if(auth()->user()->isAgent())
                    <span class="small">Note: No email/sms/whatsapp notifications are sent to student</span>
                @endif
                <div class="col-md-9">
                    <div class="row mt-5">
                        <div class="col-3 mx-auto">
                            <input type="hidden" name="active" value="1">
                            <input type="hidden" name="confirmed" value="1">
                            {{ form_submit(__('buttons.general.crud.create')) }}
                            {{ form_cancel(route('admin.auth.user.index'), __('buttons.general.cancel')) }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

{{-- <div class="card-footer clearfix">
    <div class="row" style="text-align: center;">
        <div class="col">
            <input type="hidden" name="active" value="1">
            <input type="hidden" name="confirmed" value="1">
            {{ form_submit(__('buttons.general.crud.create')) }}
            {{ form_cancel(route('admin.auth.user.index'), __('buttons.general.cancel')) }}
        </div>
    </div>
</div> --}}

</div>

{{ html()->form()->close() }}
@endsection
@push ('after-styles')
<style>
    .select2-container .select2-selection--single {
        height: 33px !important;
    }
</style>
@endpush
@push('after-scripts')
<script>
    $(document).ready(function() {
        $('.dobmydatepicker').datetimepicker({
            timepicker: false,
            format: 'd-m-Y',
            scrollInput: false,
            maxDate: new Date()
        });

        $('.select2_ajax').select2({
            minimumInputLength: 3,
            ajax: {
                url: '{{ route("admin.get-ref-users") }}',
                type: "POST",
                dataType: 'json',
                data: function(params) {
                    return {
                        q: params.term, // search term
                        _token: '{{csrf_token()}}'
                    };
                },
            },
        });

        $('#country').on('change', function () {
            var idCountry = this.value;
            $("#state-dd").html('');
            $.ajax({
                url: "{{url('api/fetch-states')}}",
                type: "POST",
                data: {
                    country_id: idCountry,
                    _token: '{{csrf_token()}}'
                },
                dataType: 'json',
                success: function (result) {
                    $('#state-dd').html('<option value="">Select State</option>');
                    $.each(result.states, function (key, value) {
                    if(value.id == "{{old('state')}}"){
                        var selectedState = "selected=\"'selected'\"";
                    }
                    else{
                        var selectedState = "";
                    }
                        $("#state-dd").append('<option '+selectedState+' value="'+ value.id + '">' + value.name + '</option>');
                    });
                    $('#city-dd').html('<option value="">Select City</option>');
                }
            });
        });

        $('#state-dd').on('change', function() {
            var idState = this.value;
            $("#city-dd").html('');

            $.ajax({
                url: "{{ url('api/fetch-cities') }}",
                type: "POST",
                data: {
                state_id: idState,
                _token: '{{ csrf_token() }}'
            },
            dataType: 'json',
            success: function(res) {
                $("#city-dd").html('<option value="">Select City</option>');

                $.each(res.cities, function(key, value) {
                $("#city-dd").append(
                '<option value="' + value.id + '">' + value.name + '</option>'
                );
            });
            },
            
            });
        });

        


        $('#dialcode').change(function(){
            var dialcode = $('#dialcode').val();
            $('#whatsapp_dialcode').val(dialcode);
        })

        $('#country').trigger('change');
        $('#state-dd').trigger('change');
        $('#city-dd').trigger('change');


        $('#student_form').submit(function(e){
                $('#invalid_email, #invalid_mobile').text("");
                e.preventDefault();
                const mobile = $('#mobile').val();
                const email = $('#email').val();

                $.ajax({
                    url: "{{route('admin.validate-email-mobile')}}",
                    type: "POST",
                    data: {
                        mobile: mobile,
                        email: email,
                        _token: '{{csrf_token()}}'
                    },
                    dataType: 'json',
                    success: function (result) {
                        console.log(result);
                        if (result.email_err && result.mobile_err) {
                            $('#invalid_email').text(result.email_err);
                            $('#invalid_email').css("color", "red");
                            $('#invalid_mobile').text(result.mobile_err);
                            $('#invalid_mobile').css("color", "red");
                            $('#mobile').focus();
                            $('#email').focus();
                            return false;
                        }
                        else if(result.email_err) {
                            $('#invalid_email').text(result.email_err);
                            $('#invalid_email').css("color", "red");
                            $('#email').focus();
                            return false;
                        }
                        else if (result.mobile_err) {
                            $('#invalid_mobile').text(result.mobile_err);
                            $('#invalid_mobile').css("color", "red");
                            $('#mobile').focus();
                            return false;
                        }else{
                            $('#invalid_email, #invalid_mobile').text("");
                            e.currentTarget.submit();
                            return true;
                        }
                    }
                });
        });

        /* ======= Mobile No to whstaspp check ======= */
        function syncWhatsapp() {
            if ($("#sameAsMobile").is(":checked")) {
                $("#whatsapp_number").val($("#mobile").val());
                $("#whatsapp_dialcode").trigger('change');
            }
        }
        syncWhatsapp();
        
        $("#mobile").on("input", function () {
            syncWhatsapp();
        });

        $("#sameAsMobile").change(function () {
            if ($(this).is(":checked")) {
                syncWhatsapp();
            }
        });
    });


    function chk_mend(elClass) {
    el = document.getElementsByClassName(elClass);
    var atLeastOneChecked = false; //at least one cb is checked
    for (i = 0; i < el.length; i++) {
        if (el[i].checked === true) {
        atLeastOneChecked = true;
        }
    }

    if (atLeastOneChecked === true) {
        for (i = 0; i < el.length; i++) {
        el[i].required = false;
        }
    } else {
        for (i = 0; i < el.length; i++) {
            el[i].required = true;
            }
        }
    }

    // Toggle Passowrd
    const togglePassword = document.querySelector("#togglePassword");
        const password = document.querySelector("#password");

        togglePassword.addEventListener("click", function () {
            // toggle the type attribute
            const type = password.getAttribute("type") === "password" ? "text" : "password";
            password.setAttribute("type", type);
            
            // toggle the icon
            this.classList.toggle("bi-eye");
        });

        function generatePassword() {
            var length = 8,
                charset = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789",
                retVal = "";
            for (var i = 0, n = charset.length; i < length; ++i) {
                retVal += charset.charAt(Math.floor(Math.random() * n));
            }
            $('#password').val(retVal);
        }
</script>
@endpush