@extends('backend.layouts.app')

@section('title', __('labels.backend.access.users.management') . ' | ' . __('labels.backend.access.users.create'))

@section('content')
{{ html()->form('POST', route('admin.auth.student.store'))->class('form-horizontal')->open() }}
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    Create User
                    <!-- <small class="text-muted">@lang('labels.backend.access.users.create')</small> -->
                </h4>
            </div>
            <!--col-->
        </div>
        <div class="row">
            <div class="col">
                <span class="text-smaller">Fields marked with <span style="color:red;">*</span> are mandatory</span>
            </div>
        </div>
        <!--row-->

        <hr>

        <div class="row mt-4 mb-4">
            <div class="col">
                <div class="form-group row mb-3">
                    {{ html()->label(__('validation.attributes.backend.access.users.name'))->class('col-md-2 form-control-label required-field')->for('first_name') }}

                    <div class="col-md-3">
                        {{ html()->text('first_name')
                                    ->class('form-control')
                                    ->placeholder("First Name*")
                                    ->attribute('maxlength', 191)
                                    ->required()
                                    ->autofocus() }}
                    </div>

                    <div class="col-md-2">
                        {{ html()->text('middle_name')
                                    ->class('form-control')
                                    ->placeholder("Middle Name")
                                    ->attribute('maxlength', 191) }}
                    </div>
                    
                    <div class="col-md-3">
                        {{ html()->text('last_name')
                                    ->class('form-control')
                                    ->placeholder("Last Name*")
                                    ->attribute('maxlength', 191)
                                    ->required() }}
                    </div>
                    <!--col-->
                </div>
                <!--form-group-->

                <div class="form-group row mb-3">
                    <div class="col-md-2">
                        <label class="col-form-label required-field">Gender</label>
                    </div>
                    <div class="col-md-6">
                        <input type="radio" class="radio-col-blue" id="radio_1" name="gender" value="male" {{ Request::old('gender') == 'male' ? 'checked' : (Request::old('gender') == '' ? 'checked' : '') }} required />
                        <label for="radio_1">Male</label>
                        <input type="radio" style="margin-left:8px;" class="radio-col-blue" id="radio_2" name="gender" value="female" {{ Request::old('gender') == 'female' ? 'checked' : '' }} required />
                        <label for="radio_2">Female</label>
                    </div>
                </div>


                <div class="form-group row mb-3">
                    {{ html()->label(__('validation.attributes.backend.access.users.email'))->class('col-md-2 form-control-label required-field')->for('email') }}

                    <div class="col-md-6">
                        {{ html()->email('email')
                                    ->class('form-control')
                                    ->placeholder(__('validation.attributes.backend.access.users.email'))
                                    ->attribute('maxlength', 191)
                                    ->required()
                                     }}
                    </div>
                    <!--col-->
                </div>
                <!--form-group-->

                <div class="form-group row mb-3">
                    <div class="col-md-2">
                        <label class="required-field">Mobile</label>
                    </div>
                    <div class="col-md-4">

                        <div class="input-group">
                            <div class="input-group-prepend">
                                <select class="form-select" name="dialcode" style="padding:0.49rem 2rem 0.375rem 0.75rem;" required>
                                    <option value=''>Dialcode</option>
                                    @foreach($dialcodes as $dialcode)
                                    <option {{($dialcode->code == Request::old('dialcode'))? 'selected' : ''}} value="{{$dialcode->code}}">{{$dialcode->code}}</option>
                                    @endforeach
                                </select>
                            </div>
                            <input type="text" class="form-control" name="mobile" onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))" value="{{ Request::old('mobile') }}" minlength="{{ config('app.USER_MOBILE_MIN_LENGTH') }}" maxlength="{{ config('app.USER_MOBILE_MAX_LENGTH') }}" required>
                        </div>
                        @if(auth()->user()->isAgent())
                        <span class="small">Note: No email/sms are sent to student</span>
                        @endif
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <div class="col-md-2">
                        <label class="">Whatsapp No.</label>
                    </div>
                    <div class="col-md-4">
                        <div class="input-group">
                            <input type="text" class="form-control" name="whatsapp_number" onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))" value="{{ Request::old('whatsapp_number') }}" minlength="{{ config('app.USER_MOBILE_MIN_LENGTH') }}" maxlength="{{ config('app.USER_MOBILE_MAX_LENGTH') }}">
                        </div>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    {{ html()->label(__('validation.attributes.backend.access.users.birthday'))->class('col-md-2 form-control-label')->for('birthday') }}
                    <div class="col-md-6">
                        {{ html()->text('birthday')
                                    ->class('form-control mydatepicker') 
                                    ->placeholder('dd-mm-yyyy')
                                    ->attribute('maxlength', 191)
                                    ->attribute('autocomplete', 'off')
                                     }}
                    </div>
                </div>                

                <div class="form-group row mb-3">
                    <div class="col-md-2">
                        <label class="required-field">Country</label>
                    </div>
                    <div class="col-md-6">
                        <select class="form-select" id="country" name="country" required>
                            <option value="">Select</option>
                            @foreach ($country_list as $key => $value)
                            <option value="{{ $key }}">{{ $value }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <div class="col-md-2">
                        <label>Address</label>
                    </div>
                    <div class="col-md-6">
                        <input id="address" class="form-control" name="address_1" placeholder="">
                    </div>
                </div>


                @if(auth()->user()->isAgent())
                <input type="hidden" name="password" value="">
                @else
                <div class="form-group row mb-3">
                    {{ html()->label(__('validation.attributes.backend.access.users.password'))->class('col-md-2 form-control-label required-field')->for('password') }}

                    <div class="col-md-4">
                        {{ html()->password('password')
                                    ->class('form-control')
                                    ->placeholder(__('validation.attributes.backend.access.users.password'))
                                    ->required() }}
                    </div>
                </div>
                @endif

                <div class="form-group row">
                    <div class="col-md-2">
                        <label class="required-field">Branch</label>
                    </div>
                    <div class="col-sm-12 col-md-4">
                        <select class="form-select" id="branch" name="branch" required>
                            @foreach($branch as $id => $name)
                            <option value="{{ $id }}" {{($id == Request::old('branch'))? 'selected' : ''}} >{{ $name }}</option>
                            @endforeach
                        </select>
                    </div>
                </div> 


                {{--<div class="form-group row mb-3">
                    {{ html()->label(__('validation.attributes.backend.access.users.password_confirmation'))->class('col-md-2 form-control-label required-field')->for('password_confirmation') }}

                <div class="col-md-4">
                    {{ html()->password('password_confirmation')
                                    ->class('form-control')
                                    ->placeholder(__('validation.attributes.backend.access.users.password_confirmation'))
                                    ->required() }}
                </div>
                <!--col-->
            </div>
            <!--form-group-->--}}


            @if(config('app.product_code') == 'TRAINING')
            <input type="hidden" name="student_type" value="course">
            @elseif(config('app.product_code') == 'OVERSEAS')
            <input type="hidden" name="student_type" value="study_abroad">
            @elseif(config('app.product_code') == 'VISA')
            <input type="hidden" name="student_type" value="visa">
            @else
            <div class="form-group row mb-3">
                <div class="col-md-2">
                    <label class="required-field">Interested In</label>
                </div>
                <div class="col-md-6">
                    <select class="form-select" id="student_type" name="student_type" required>
                        <option value="">Select</option>
                        <option value="study_abroad">Study Abroad</option>
                        <option value="course">Trainings</option>
                        <option value="study_abroad_course">Study Abroad & Trainings</option>
                        @if(env('ABROAD_JOB_ADDON'))
                        <option value="abroad_job">Abroad Job</option>
                        @endif
                        @if(env('VISA_ADDON'))
                        <option value="visa">Visa</option>
                        @endif
                    </select>
                </div>
            </div>
            @endif

            @if(config('app.product_code') == 'OVERSEAS' || config('app.product_code') == 'EDUCTRL_CRM')
            <!-- <div class="form-group row mb-3">
                    <div class="col-md-2">
                        <label>Country Interested</label>
                    </div>
                    <div class="col-md-6">
                        <div class="col-sm-6" style="height: 120px;overflow-y:scroll">
                            @foreach($country_study as $item)
                            <input type="checkbox" id="country_interested" name="country_interested[]" value="{{$item->country}}">
                            <label>{{$item->country}}</label><br />
                            @endforeach
                        </div>
                    </div>
                </div> -->
            @endif

            <div class="form-group row mb-3">
                <div class="col-md-2">
                    <label class="">Lead Source</label>
                </div>
                <div class="col-md-4">
                    <select class="form-select" id='lead_source' name="lead_source">
                        <option value=''>Select</option>
                        @foreach(get_lead_sources() as $source_data)
                        <option value="{{$source_data}}">{{ucfirst($source_data)}}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-5">
                    <div class="form-group">
                        <input type="text" class="form-control" name="lead_source_detail" value="{{ Request::old('lead_source_detail') }}" placeholder="Details">
                    </div>
                </div>
            </div>

            {{--
                <div class="form-group row mb-3">
                    {{ html()->label(__('validation.attributes.backend.access.users.active'))->class('col-md-2 form-control-label')->for('active') }}

            <div class="col-md-10">
                <label class="switch switch-label switch-pill switch-primary">
                    {{ html()->checkbox('active', true, '1')->class('switch-input') }}
                    <span class="switch-slider" data-checked="yes" data-unchecked="no"></span>
                </label>
            </div>
            <!--col-->
        </div>
        <!--form-group-->

        <div class="form-group row mb-3">
            {{ html()->label(__('validation.attributes.backend.access.users.confirmed'))->class('col-md-2 form-control-label')->for('confirmed') }}

            <div class="col-md-10">
                <label class="switch switch-label switch-pill switch-primary">
                    {{ html()->checkbox('confirmed', true, '1')->class('switch-input') }}
                    <span class="switch-slider" data-checked="yes" data-unchecked="no"></span>
                </label>
            </div>
            <!--col-->
        </div>
        <!--form-group-->

        @if(! config('access.users.requires_approval'))
        <div class="form-group row mb-3">
            {{ html()->label(__('validation.attributes.backend.access.users.send_confirmation_email') . '<br/>' . '<small>' .  __('strings.backend.access.users.if_confirmed_off') . '</small>')->class('col-md-2 form-control-label')->for('confirmation_email') }}

            <div class="col-md-10">
                <label class="switch switch-label switch-pill switch-primary">
                    {{ html()->checkbox('confirmation_email', true, '1')->class('switch-input') }}
                    <span class="switch-slider" data-checked="yes" data-unchecked="no"></span>
                </label>
            </div>
            <!--col-->
        </div>
        <!--form-group-->
        @endif

        --}}

        {{-- <div class="form-group row mb-3">
            <div class="col-md-2">
                <label class="required-field">Status</label>
            </div>
            <div class="col-md-4">
                <select class="form-select" name="lead_status" required>
                    <option value="">Select Status</option>
                    <option value="lead">Lead</option>
                    <option value="student">Confirmed Student</option>
                </select>
            </div>
        </div> --}}
    </div>
</div>

</div>


<div class="card-footer clearfix">
    <div class="row" style="text-align: center;">
        <div class="col">
            <input type="hidden" name="active" value="1">
            <input type="hidden" name="confirmed" value="1">
            {{ form_submit(__('buttons.general.crud.create')) }}
            {{ form_cancel(route('admin.auth.user.index'), __('buttons.general.cancel')) }}
        </div>
    </div>
    <!--row-->
</div>
<!--card-footer-->
</div>
<!--card-->
{{ html()->form()->close() }}
@endsection


