@extends('backend.layouts.app')

@section('title', __('labels.backend.access.users.management') . ' | ' . __('labels.backend.access.users.deactivated'))

@section('breadcrumb-links')
    @include('backend.auth.user.includes.breadcrumb-links')
@endsection

@include('backend.auth.user.includes.top-links-students')


@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    @lang('labels.backend.access.users.management')
                    <small class="text-muted">@lang('labels.backend.access.users.deactivated')</small>
                </h4>
            </div><!--col-->
        </div><!--row-->

        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive">
                    <table class="table eductrl-datatable">
                        <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Details</th>
                            <th>Signed Up</th>
                            <th>Actions</th>
                        </tr>
                        </thead>
                        <tbody>
                        @if($users->count())
                            @foreach($users as $user)
                                <tr>
                                    <td>{{ $user->id }}</td>
                                    <td><b>{{ get_user_full_name_by_id($user->id) }}</b></td>
                                    <td>{{ $user->email }} <br>
                                        @if($user->mobile) <i class='fas fa-phone-alt text-sub'></i> @endif
                                        @if($user->dialcode) +{{ $user->dialcode }} - @endif {{ $user->mobile }} <br>
                                        @if($user->dialcode && $user->whatsapp) <i class='fas fa-phone-alt text-sub'></i> +{{ $user->dialcode }} - {{ $user->whatsapp }}  <br> @endif 
                                        @if($user->country)<i class='fas fa-globe text-sub'></i> @endif
                                        @if($user->city) {{ $user->city }}, @endif
                                        @if($user->state) {{ get_state_name($user->state) }}, @endif
                                        @if($user->country) {{ get_country_name($user->country) }} <br> @endif 
                                        @if($user->branch) <span class="badge badge-default">{{ branch_name($user->branch) }}</span> @endif 
                                    </td>
                                    <td>{{ $user->created_at->diffForHumans() }}</td>
                                    <td>{!! $user->action_buttons !!}</td>
                                </tr>
                            @endforeach
                        @else
                            <tr><td colspan="9"><p class="text-center">@lang('strings.backend.access.users.no_deactivated')</p></td></tr>
                        @endif
                        </tbody>
                    </table>
                </div>
            </div><!--col-->
        </div><!--row-->
        <div class="row" style="text-align: center;">
            <div class="col-6">
                <div class="float-left">
                    {!! $users->total() !!} {{ trans_choice('labels.backend.access.users.table.total', $users->total()) }}
                    {!! $users->render() !!}
                </div>
            </div><!--col-->

           <!--  <div class="col-6">
                <div class="float-right">
                </div>
            </div> --><!--col-->
        </div><!--row-->
    </div><!--card-body-->
</div><!--card-->
@endsection
