@extends('backend.layouts.app')

@section('title', 'Staff Management | ' . __('labels.backend.access.users.deactivated'))

@section('breadcrumb-links')
@include('backend.auth.user.includes.breadcrumb-links')
@endsection

@include('backend.auth.user.includes.top-links-staffs')


@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    Deactivated Staff
                </h4>
            </div><!--col-->
        </div><!--row-->

        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive">
                    <table class="table eductrl-datatable">
                        <thead>
                        <tr>
                            <th>@lang('labels.backend.access.users.table.last_name')</th>
                            <th>@lang('labels.backend.access.users.table.first_name')</th>
                            <th>@lang('labels.backend.access.users.table.email')</th>
                            <th>@lang('labels.backend.access.users.table.confirmed')</th>
                            <th>@lang('labels.backend.access.users.table.roles')</th>
                            <th>@lang('labels.backend.access.users.table.other_permissions')</th>
                            <th>@lang('labels.backend.access.users.table.social')</th>
                            <th>@lang('labels.backend.access.users.table.last_updated')</th>
                            <th>@lang('labels.general.actions')</th>
                        </tr>
                        </thead>
                        <tbody>
                        @if($users->count())
                            @foreach($users as $user)
                                <tr>
                                    <td>{{ $user->last_name }}</td>
                                    <td>{{ $user->first_name }}</td>
                                    <td>{{ $user->email }}</td>
                                    <td>{!! $user->confirmed_label !!}</td>
                                    <td>{!! $user->roles_label !!}</td>
                                    <td>{!! $user->permissions_label !!}</td>
                                    <td>{!! $user->social_buttons !!}</td>
                                    <td>{{ $user->updated_at->diffForHumans() }}</td>
                                    <td>
                                    
                                    {{-- {!! $user->action_buttons !!} --}}
                                    
                                    
                            <div class="btn-group" role="group" aria-label="@lang('labels.backend.access.users.user_actions')">
                                <a href="{{route('admin.auth.staff.show', $user->id)}}" data-toggle="tooltip" data-placement="top" title="@lang('buttons.general.crud.view')" class="btn btn-info" style="color: #fff;"><i class="ri-eye-fill"></i></a>
                                    
                                <div class="btn-group btn-group-sm" role="group">

                                  <button style="padding: 0.525rem 0.75rem;margin-bottom:0px;" id="userActions" type="button" class="btn btn-secondary dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="true">@lang('labels.general.more')
                                  </button>
                                  <div class="dropdown-menu dropdown-menu-end dropdown-menu-arrow" data-popper-placement="bottom-end">
                                        <a href="{{route('admin.auth.staff.edit', $user->id)}}" class="dropdown-item">Edit</a>            
                                        <a href="{{route('admin.auth.staff.login-as', $user->id)}}" class="dropdown-item">@lang('buttons.backend.access.users.login_as', ['user' => $user->full_name])</a>
                                        <a href="{{route('admin.auth.staff.change-password', $user->id)}}" class="dropdown-item">@lang('buttons.backend.access.users.change_password')</a>
                                   @if($user->id != 1 && $user->id != auth()->id())   
                                        @if($user->active)
                                            <a href="{{route('admin.auth.staff.mark', [$user->id, 0]) }}" class="dropdown-item">@lang('buttons.backend.access.users.deactivate')</a>
                                        @else
                                            <a href="{{route('admin.auth.staff.mark', [$user->id, 1])}}" class="dropdown-item">@lang('buttons.backend.access.users.activate')</a>
                                        @endif
                                          
                                          
                                        @if(!$user->confirmed && !config('access.users.requires_approval'))
                                            <a href="{{route('admin.auth.staff.account.confirm.resend', $user->id)}}" class="dropdown-item">@lang('buttons.backend.access.users.resend_email')</a>
                                        @endif
                                        
                                        @if($user->deleted_at == NULL)
                                            <a href="{{route('admin.auth.staff.destroy', $user->id)}}"
                                                data-method="delete"
                                                data-trans-button-cancel="@lang('buttons.general.cancel')"
                                                data-trans-button-confirm="@lang('buttons.general.crud.delete')"
                                                data-trans-title="@lang('strings.backend.general.are_you_sure')"
                                                class="dropdown-item">@lang('buttons.general.crud.delete')</a>
                                        @else
                                            <a href="{{route('admin.auth.staff.restore', $user->id)}}" name="confirm_item" class="dropdown-item">@lang('buttons.backend.access.users.restore_user')</a>
                                        @endif
                                    @endif
                                        <a href="https://wa.me/'{{$user->mobile}}" class="dropdown-item">Whatsapp</a>            
                                        <a href="{{route('admin.communicate.mail', $user->id)}}" class="dropdown-item">Email</a>            
                                        <a href="{{route('admin.communicate.sms', $user->id)}}" class="dropdown-item">SMS</a>            
                                  </div>
                                </div>
                            </div>
                                    
                                    
                                    </td>
                                </tr>
                            @endforeach
                        @else
                            <tr><td colspan="9"><p class="text-center">@lang('strings.backend.access.users.no_deactivated')</p></td></tr>
                        @endif
                        </tbody>
                    </table>
                </div>
            </div><!--col-->
        </div><!--row-->
        <div class="row" style="text-align:center">
            <div class="col-7">
                <div class="float-left">
                    {!! $users->total() !!} {{ trans_choice('labels.backend.access.users.table.total', $users->total()) }}
                    {!! $users->render() !!}
                </div>
            </div><!--col-->

            <!-- <div class="col-5">
                <div class="float-right">
                </div>
            </div> --><!--col-->
        </div><!--row-->
    </div><!--card-body-->
</div><!--card-->
@endsection