@extends('backend.layouts.app')

@section('title', __('labels.backend.access.users.management') . ' | ' . __('labels.backend.access.users.deleted'))

@section('breadcrumb-links')
    @include('backend.auth.user.includes.breadcrumb-links')
@endsection

@include('backend.auth.user.includes.top-links-students')

@section('content')
<form method="POST" action="{{ route('admin.auth.deleted.bulk-action') }}" id="bulkActionForm">
    @csrf
    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-sm-5">
                    <h4 class="card-title mb-0">
                        Deleted Users
                    </h4>
                </div><!--col-->
            </div><!--row-->

            <div class="row mt-4">
                <div class="col">
                    <div class="table-responsive">
                        <table class="table eductrl-datatable">
                            <thead>
                                <tr>
                                    <th><input type="checkbox" id="selectAll"></th>
                                    <th>ID</th>
                                    <th>Name</th>
                                    <th>Details</th>
                                    <th>Signed Up</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @if($users->count())
                                    @foreach($users as $user)
                                        <tr>
                                            <td><input type="checkbox" name="selected_ids[]" value="{{ $user->id }}"></td> {{-- Checkbox --}}
                                            <td>{{ $user->id }}</td>
                                            <td><b>{{ get_user_full_name_by_id($user->id) }}</b></td>
                                            <td>
                                                {{ $user->email }} <br>
                                                @if($user->mobile) <i class='fas fa-phone-alt text-sub'></i> @endif
                                                @if($user->dialcode) +{{ $user->dialcode }} - @endif {{ $user->mobile }} <br>
                                                @if($user->dialcode && $user->whatsapp) <i class='fas fa-phone-alt text-sub'></i> +{{ $user->dialcode }} - {{ $user->whatsapp }}  <br> @endif 
                                                @if($user->country)<i class='fas fa-globe text-sub'></i> @endif
                                                @if($user->city) {{ $user->city }}, @endif
                                                @if($user->state) {{ get_state_name($user->state) }}, @endif
                                                @if($user->country) {{ get_country_name($user->country) }} <br> @endif 
                                                @if($user->branch) <span class="tagPrimary">{{ branch_name($user->branch) }}</span> @endif 
                                            </td>
                                            <td>{{ $user->created_at->diffForHumans() }}</td>
                                            <td>{!! $user->action_buttons !!}</td>
                                        </tr>
                                    @endforeach
                                @else
                                    <tr><td colspan="9"><p class="text-center">@lang('strings.backend.access.users.no_deleted')</p></td></tr>
                                @endif
                            </tbody>
                        </table>
                    </div>
                </div><!--col-->
            </div><!--row-->

            {{-- Bulk action dropdown --}}
            <div class="row mt-3">
                <div class="col-md-6">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-inline">
                                <select name="action" class="form-control form-select" required>
                                    <option value="">-- Select Action --</option>
                                    <option value="restore">Restore</option>
                                    <option value="delete">Delete Permanently</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <button type="submit" class="btn btn-primary">Apply</button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row" style="text-align:center">
                <div class="col-6">
                    <div class="float-left">
                        {!! $users->total() !!} {{ trans_choice('labels.backend.access.users.table.total', $users->total()) }}
                        {!! $users->render() !!}
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
@endsection

@push('after-scripts')
<script>
    document.getElementById('selectAll').addEventListener('click', function () {
        const checkboxes = document.querySelectorAll('input[name="selected_ids[]"]');
        checkboxes.forEach(checkbox => checkbox.checked = this.checked);
    });
</script>
@endpush
