<form id="editEducationForm" action="{{route('admin.auth.update-staff-education-info')}}" method="POST">
    @csrf
    <input type="hidden" name="education_id" id="edit_staff_education_id" value="{{ $education->id ?? '' }}">

    <div class="row">
        <div class="col-md-6">
            <div class="mb-3">
                <label for="edit_institute_name" class="form-label">Institute Name</label>
                <input type="text" class="form-control" id="edit_institute_name" name="institute_name" value="{{ $education->institute_name ?? '' }}" >
            </div>
        </div>
        <div class="col-md-6">
            <div class="mb-3">
                <label for="edit_degree" class="form-label">Degree</label>
                <input type="text" class="form-control" id="edit_degree" name="degree" value="{{ $education->degree ?? '' }}" >
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6">
            <div class="mb-3">
                <label for="edit_course_specialization" class="form-label">Course Specialization</label>
                <input type="text" class="form-control" id="edit_course_specialization" name="course_specialization" value="{{ $education->course_specialization ?? '' }}">
            </div>
        </div>
        <div class="col-md-6">
            <div class="mb-3">
                <label for="edit_completion_date" class="form-label">Completion Date</label>
                <div class="input-group">
                <input type="text" class="form-control datepicker" name="completion_date" placeholder=" Completion date" value="{{ $education->completion_date ?? '' }}" >
                        <div class="input-group-append">
                        <span class="input-group-text"><i class="fa fa-calendar"></i></span>
                        </div>
                </div>
            </div>
        </div>
    </div>

    <div class="text-center">
    <button type="submit" class="btn btn-primary">Update</button>
</div>
</form>
<script>
    
  $(document).ready(function () {
    $('.datepicker').datetimepicker({
        format: 'd-m-Y',
        timepicker: false,
        scrollInput: false,
        onChangeDateTime: function(dp, $input) {
            $input.trigger('change'); 
        }
    });

    // Open the datepicker only for the corresponding input field
    $('.input-group-text').each(function () {
        $(this).click(function () {
            $(this).closest('.input-group').find('.datepicker').focus();
        });
    });
});
</script>