@extends('backend.layouts.app')
@if($staff_mgmt == 0)
@section('title', __('labels.backend.access.users.management') . ' | ' . __('labels.backend.access.users.edit'))
@else
@section('title', 'Staff Management | ' . __('labels.backend.access.users.edit'))
@endif

@section('content')


@if($staff_mgmt == 0)
{{ html()->modelForm($user, 'PATCH', route('admin.auth.user.update', $user->id))->class('form-horizontal')->open() }}
@else
{{ html()->modelForm($user, 'PATCH', route('admin.auth.staff.update', $user->id))->class('form-horizontal')->open() }}
@endif
<div class="card">

    <div class="card-body">
        <div class="row">
            <div class="col-sm-10">
                <h4 class="card-title mb-0">
                    @if($staff_mgmt == 1)
                    Staff Management
                    @else
                    @lang('labels.backend.access.users.management')
                    @endif
                    <small class="text-muted">@lang('labels.backend.access.users.edit')</small>
                </h4>

            </div>
            <!--col-->
            <div class="col-sm-2 " style="margin-top:20px;text-align: right;">
                @if($staff_mgmt == 1)
                <button type="cancel" name="back" class="btn btn-primary btn-sm " value="Back" onclick="document.location ='{{ route('admin.auth.staff') }}'" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </button>
                @else
                <button type="cancel" name="back" class="btn btn-primary btn-sm " value="Back" onclick="document.location ='{{ route('admin.auth.user.index') }}'" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </button>
                @endif
            </div>
            <div class="row">
                <div class="col">
                    <span class="text-smaller">Fields marked with <span style="color:red;">*</span> are mandatory</span>
                </div>
            </div>
            <!--row-->

            <hr>

            <div class="row mt-4 mb-4">
                <div class="col">
                    <div class="form-group row mb-3">
                        {{ html()->label(__('validation.attributes.backend.access.users.first_name'))->class('col-md-2 form-control-label required-field')->for('first_name') }}

                        <div class="col-md-6">
                            {{ html()->text('first_name')
                                ->class('form-control')
                                ->placeholder(__('validation.attributes.backend.access.users.first_name'))
                                ->attribute('maxlength', 191)
                                ->required() }}
                        </div>
                        <!--col-->
                    </div>
                    <!--form-group-->

                    @if($staff_mgmt == 0)
                    <div class="form-group row mb-3">
                        {{ html()->label(__('validation.attributes.backend.access.users.middle_name'))->class('col-md-2 form-control-label')->for('middle_name') }}

                        <div class="col-md-6">
                            {{ html()->text('middle_name')
                                    ->class('form-control')
                                    ->placeholder(__('validation.attributes.backend.access.users.middle_name'))
                                    ->attribute('maxlength', 191) }}
                        </div>
                        <!--col-->
                    </div>
                    <!--form-group-->
                    @endif

                    <div class="form-group row mb-3">
                        {{ html()->label(__('validation.attributes.backend.access.users.last_name'))->class('col-md-2 form-control-label required-field')->for('last_name') }}

                        <div class="col-md-6">
                            {{ html()->text('last_name')
                                ->class('form-control')
                                ->placeholder(__('validation.attributes.backend.access.users.last_name'))
                                ->attribute('maxlength', 191)
                                ->required()}}
                        </div>
                        <!--col-->
                    </div>
                    <!--form-group-->

                    <div class="form-group row mb-3">
                        <div class="col-md-2">
                            <label class="col-form-label required-field">Gender</label>
                        </div>
                        <div class="col-md-6">
                            <input type="radio" class="radio-col-blue" id="radio_1" name="gender" value="male" {{ $user->gender == 'male' ? 'checked' : '' }} required />
                            <label for="radio_1">Male</label>
                            <input type="radio" style="margin-left:8px;" class="radio-col-blue" id="radio_2" name="gender" value="female" {{ $user->gender == 'female' ? 'checked' : '' }} required />
                            <label for="radio_2">Female</label>
                        </div>
                    </div>


                    <div class="form-group row mb-3">
                        {{ html()->label(__('validation.attributes.backend.access.users.email'))->class('col-md-2 form-control-label required-field')->for('email') }}

                        <div class="col-md-6">
                            {{ html()->email('email')
                                    ->class('form-control')
                                    ->placeholder(__('validation.attributes.backend.access.users.email'))
                                    ->attribute('maxlength', 191)
                                    ->required()
                                     }}
                        </div>
                        <!--col-->
                    </div>
                    <!--form-group-->

                    <div class="form-group row mb-3">
                        <div class="col-md-2">
                            <label class="required-field">Mobile</label>
                        </div>
                        <div class="col-md-4">

                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <select class="form-select" name="dialcode" style="padding:0.49rem 2rem 0.375rem 0.75rem;" required>
                                        <option value=''>Dialcode</option>
                                        @foreach($dialcodes as $dialcode)
                                        <option {{$dialcode->code == $user->dialcode ? 'selected' : ''}} value="{{$dialcode->code}}">{{$dialcode->code}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <input type="text" class="form-control" name="mobile" onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))" value="{{ $user->mobile }}" minlength="{{ config('app.USER_MOBILE_MIN_LENGTH') }}" maxlength="{{ config('app.USER_MOBILE_MAX_LENGTH') }}" required>
                            </div>
                            @if(auth()->user()->isAgent())
                            <span class="small">Note: No email/sms are sent to student</span>
                            @endif
                        </div>
                    </div>
                     <div class="form-group row mb-3">
                        <div class="col-md-2">
                            <label class="">Whatsapp No.</label>
                        </div>
                        <div class="col-md-4">
                            <div class="input-group">
                                <input type="text" class="form-control" name="whatsapp_number" onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))" value="{{ $user->whatsapp }}" minlength="{{ config('app.USER_MOBILE_MIN_LENGTH') }}" maxlength="{{ config('app.USER_MOBILE_MAX_LENGTH') }}">
                            </div>
                        </div>
                    </div>
                    @if($staff_mgmt == 1)
                     <div class="form-group row mb-3">
                        {{ html()->label("Branch(s)")->class('col-md-2 required-field form-control-label')->for('branch') }}
                        <div class="col-md-10">
                            <select class="form-select select2" id="branch" name="branch[]" multiple required>
                            @foreach ($branch_list as $branch)
                            <option value="{{ $branch->id }}" @if(in_array($branch->id, $staff_branch)) selected  @endif>{{ $branch->branch_name }}</option>
                            @endforeach
                            </select>
                        </div>
                    </div>
                    @endif

                    @if($staff_mgmt == 0)

                    <div class="form-group row mb-3">
                        {{ html()->label(__('validation.attributes.backend.access.users.birthday'))->class('col-md-2 form-control-label')->for('birthday') }}
                        <div class="col-md-6">
                            {{ html()->date('birthday')
                                    ->class('form-control') 
                                    ->placeholder(__('validation.attributes.backend.access.users.birthday'))
                                    ->attribute('maxlength', 191) }}
                        </div>
                        <!--col-->
                    </div>

                    <div class="form-group row mb-3">
                        {{ html()->label(__('validation.attributes.backend.access.users.address'))->class('col-md-2 form-control-label')->for('address') }}
                        <div class="col-md-6">
                            {{ html()->text('address_1')
                                ->class('form-control')
                                ->placeholder(__('validation.attributes.backend.access.users.address'))
                                ->attribute('maxlength', 191)
                                }}
                        </div>
                    </div>

                    <div class="form-group row mb-3">
                        {{ html()->label(__('validation.attributes.backend.access.users.country'))->class('col-md-2 form-control-label required-field')->for('country') }}
                        <div class="col-md-6">
                            <select class="form-select" id="country" name="country" required>
                                <option value="">Select</option>
                                @foreach ($country_list as $key => $value)
                                <option value="{{ $key }}" @if($user->country == $key) selected @endif>{{ $value }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>


                    @if(config('app.product_code') == 'TRAINING')
                    <input type="hidden" name="student_type" value="course">
                    @elseif(config('app.product_code') == 'OVERSEAS')
                    <input type="hidden" name="student_type" value="study_abroad">
                    @else
                    @if(auth()->user()->isAgent())
                    <input type="hidden" name="student_type" value="study_abroad">
                    @else
                    <div class="form-group row mb-3">
                        <label class="col-md-2 required-field">Interested In</label>
                        <div class="col-md-6">
                            <select class="form-select" id="student_type" name="student_type" required>
                                <option value="">Select</option>
                                <option value="study_abroad" {{ $user->student_type == 'study_abroad' ? 'selected' : '' }}>Study Abroad</option>
                                <option value="course" {{ $user->student_type == 'course' ? 'selected' : '' }}>Trainings</option>
                                <option value="study_abroad_course" {{ $user->student_type == 'study_abroad_course' ? 'selected' : '' }}>Study Abroad & Trainings</option>
                                @if(env('ABROAD_JOB_ADDON'))
                                <option value="abroad_job" {{ $user->student_type == 'abroad_job' ? 'selected' : '' }}>Abroad Job</option>
                                @endif
                                @if(config('app.product_code') == 'VISA' || env('VISA_ADDON'))
                                <option value="visa" {{ $user->student_type == 'visa' ? 'selected' : '' }}>Visa</option>
                                @endif
                            </select>
                        </div>
                        <!--col-->
                    </div>
                    @endif
                    @endif
                    
                    @if($staff_mgmt == 0)
                        <div class="form-group row">
                            <div class="col-md-2">
                                <label class="required-field">Branch</label>
                            </div>
                            <div class="col-sm-12 col-md-4">
                                <select class="form-select" id="branch" name="branch" required>
                                    @foreach($branch_list as $key => $value)
                                    <option value="{{ $key }}" {{($key == Request::old('branch'))? 'selected' : ''}} @if($key == $user->branch) selected @endif >{{ $value }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div> 
                    @endif

                    {{--
                    @if(config('app.product_code') == 'OVERSEAS' || config('app.product_code') == 'EDUCTRL_CRM')
                    <div class="form-group row mb-3">
                        <label class="col-sm-2 col-form-label">Country Interested</label>
                        <div class="col-sm-6" style="height: 120px;overflow-y:scroll">
                            @foreach($all_country_list as $a_country)
                            @if(in_array($a_country->country,$interest_country_list))
                            <input type="checkbox" id="country_interested" name="country_interested[]" value="{{ $a_country->country }}" checked="checked">
                    <label>{{ $a_country->country }}</label><br>
                    @else
                    <input type="checkbox" id="country_interested" name="country_interested[]" value="{{ $a_country->country }}">
                    <label>{{ $a_country->country }}</label><br>
                    @endif
                    @endforeach
                </div>
            </div>
            @endif
            --}}

            <div class="form-group row mb-3">
                <div class="col-md-2">
                    <label class="">Lead Source</label>
                </div>
                <div class="col-md-4">
                    <select class="form-select" id='lead_source' name="lead_source">
                        <option value=''>Select</option>
                        @foreach(get_lead_sources() as $source_data)
                        <option value="{{$source_data}}" @if($user->lead_source == $source_data) selected @endif>{{ucfirst($source_data)}}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-5">
                    <div class="form-group">
                        <input type="text" class="form-control" name="lead_source_detail" value="{{ $user->lead_source_detail }}" placeholder="Details">
                    </div>
                </div>
            </div>


            @endif

            @if($staff_mgmt)
            <div class="form-group row mb-3">
                {{ html()->label('Abilities')->class('col-md-2 form-control-label required-field') }}

                <div class="table-responsive col-md-10">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>@lang('labels.backend.access.users.table.roles')</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>
                                    @if($roles->count())
                                    @foreach($roles as $role)
                                    @if(strtolower($role->name) == 'user' || strtolower($role->name) == 'trainer' || strtolower($role->name) == 'agent')
                                    @continue;
                                    @endif
                                    <div class="card">
                                        <div class="card-header">
                                            <div class="checkbox d-flex align-items-center">

                                                <div class="form-check">
                                                    <input name="roles[]" class="form-check-input" type="radio" id="role-{{$role->id}}" value="{{$role->name}}" <?php if (in_array($role->name, $userRoles)) echo "checked"; ?>>
                                                    <label class="form-check-label" for="role-{{$role->id}}">
                                                        {{ucfirst($role->name)}}
                                                    </label>
                                                </div>

                                            </div>
                                        </div>
                                        <div class="card-body">
                                            @if($role->id != 1)
                                            @if($role->permissions->count())
                                            @foreach($role->permissions as $permission)
                                            <i class="fas fa-dot-circle"></i> {{ ucwords($permission->name) }}
                                            @endforeach
                                            @else
                                            @lang('labels.general.none')
                                            @endif
                                            @else
                                            @lang('labels.backend.access.users.all_permissions')
                                            @endif
                                        </div>
                                    </div>
                                    <!--card-->
                                    @endforeach
                                    @endif
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <!--col-->
            </div>
            @endif



        </div>
        <!--col-->
    </div>
    <!--row-->
</div>
<!--card-body-->

<div class="card-footer">
    <div class="row" style="text-align:center;">
        <div class="col">
            {{ form_submit(__('buttons.general.crud.update')) }}
            @if($staff_mgmt == 0)
            {{ form_cancel(route('admin.auth.user.index'), __('buttons.general.cancel')) }}
            @else
            {{ form_cancel(route('admin.auth.staff'), __('buttons.general.cancel')) }}
            @endif
        </div>
        <!--col-->

        <!-- <div class="col text-right">
            </div> -->
        <!--row-->
    </div>
    <!--row-->
</div>
<!--card-footer-->
</div>
<!--card-->
{{ html()->closeModelForm() }}
@endsection