@extends('backend.layouts.app')
@section('title', 'Student Management | ' . __('labels.backend.access.users.edit'))
@section('content')
    {{-- @include('backend.auth.user.student-details-add-edit-modal.add_academics_detail_modal') --}}
    <div class="card">
        <div class="card-body" style="padding-bottom: 0px !important;">
            <div class="row border-bottom">
                <div class="col-sm-9 col-9">
                    <h4 class="card-title mb-0">
                        {{ $user->full_name }}
                    </h4>
                </div>

                <div class="col-sm-3 col-3" style="margin-top:20px;text-align: right;">
                    <button type="cancel" name="back" class="btn btn-primary btn-sm " value="Back"
                        onclick="document.location ='{{ route('admin.auth.user.show', $user->id) }}'" title="Back"> <i
                            class="fa fa-reply" aria-hidden="true"></i> </button>
                </div>
            </div>

            <div class="row mt-4 mb-4">
                <div class="col">
                    <div class="p-t-20">
                        {{-- <h6>Profile & Educational Details</h6> --}}
                        <!-- <h6 class="card-subtitle">Fill the below form & complete your personal & educational qualification details.</h6> -->
                        <form method="post" action="{{ route('admin.studyabroad.profile.basic.save') }}" enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" name="user_id" value="{{ $user->id }}">
                            <input type="hidden" name="is_lead" value="{{ $user->is_lead }}">
                            <div class="card" style="box-shadow: none; margin-bottom: 0px !important;"">
                                <div class="card-header" style="border-bottom: none;">
                                    <div class="row">
                                        <div class="col-9">
                                            <h4 class="m-b-0" style="border-bottom: none; font-weight: 700 !important;">
                                                Profile</h4>
                                        </div>
                                        <div class="col-3 text-end">
                                            <a href="{{ route('admin.auth.user.edit', $user) }}" target="_blank"
                                                class="btn btn-link btn-sm text-decoration-none">Edit Basic Info <i
                                                    class="bi bi-arrow-up-right-square"></i> </a>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body mt-4">
                                    <div class="row mb-3">
                                        <div class="col-12 d-flex">
                                            <div class="p-0 m-0">
                                                @if ($user->avatar_location != '')
                                                    <img src="{{ asset('storage/' . $user->avatar_location) }}" alt="user" width="100"
                                                        height="100" style="border-radius: 50%" />
                                                @else
                                                    <img src="{{ asset('assets/images/users/user.jpg') }}" alt="user" width="100" height="100"
                                                        style="border-radius: 50%" />
                                                @endif
                                            </div>
                                            <div class="form-group my-auto ms-3 w-50" id="">
                                                <input type="file" class="form-control" placeholder="Profile" id="avatar_location" name="avatar_location" accept=".jpg,.jpeg">
                                            </div>
                                        </div>
                                    </div>
                                    {{-- <div class="row">
                                        <div class="col-md-12">
                                            <a href="{{ route('admin.auth.user.edit', $user) }}" class="btn btn-link btn-sm"
                                                style="float: right;"><i class="fas fa-edit"></i> Edit Basic Info</a>
                                        </div>
                                    </div> --}}
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group" style="margin-bottom:15px !important;">
                                                <label class="required-field" style="margin-bottom: 0.2rem;">First
                                                    name</label>
                                                <input type="text" class="form-control" name="first_name" maxlength="50"
                                                    value="{{ $user->first_name }}" required>
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div class="form-group" style="margin-bottom:15px !important;">
                                                <label style="margin-bottom: 0.2rem;" class="">Middle name</label>
                                                <input type="text" class="form-control" name="middle_name" maxlength="50"
                                                    value="{{ $user->middle_name }}">
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div class="form-group" style="margin-bottom:15px !important;">
                                                <label style="margin-bottom: 0.2rem;" class="required-field">Last
                                                    name</label>
                                                <input type="text" class="form-control" name="last_name" maxlength="50"
                                                    value="{{ $user->last_name }}" required>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group" style="margin-bottom:15px !important;">
                                                <label style="margin-bottom: 0.2rem;" class="required-field">Gender</label>
                                                <div>
                                                    <div class="form-check form-check-inline">
                                                        <input type="radio" class="radio-col-blue form-check-input"
                                                            name="gender" id="male" value="male"
                                                            @if (Request::old('gender') == 'male') checked @elseif($user->gender == 'male') checked @endif
                                                            required>
                                                        <label class="custom-control-label form-check-label"
                                                            for="male">Male</label>
                                                    </div>
                                                    <div class="form-check form-check-inline">
                                                        <input type="radio" class="radio-col-blue form-check-input"
                                                            name="gender" id="female" value="female"
                                                            @if (Request::old('gender') == 'female') checked @elseif($user->gender == 'female') checked @endif
                                                            required>
                                                        <label class="custom-control-label form-check-label"
                                                            for="female">Female</label>
                                                        <!-- <div class="invalid-feedback">
                                                                        &nbsp;&nbsp;Please choose Gender.
                                                                    </div> -->
                                                    </div>
                                                    <div class="form-check form-check-inline">
                                                        <input type="radio" class="radio-col-blue form-check-input"
                                                            name="gender" id="other" value="other"
                                                            @if (Request::old('gender') == 'other') checked @elseif($user->gender == 'other') checked @endif
                                                            required>
                                                        <label class="custom-control-label form-check-label"
                                                            for="other">Other</label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-12 col-md-4">
                                            <label
                                                class="col-form-label @if (get_site_config('student_create_admin_mandatory') == 'email' ||
                                                        get_site_config('student_create_admin_mandatory') == 'email_and_mobile') required-field @endif">Email</label>
                                            <div class="">
                                                <input type="text" placeholder="Email ID" class="form-control"
                                                    name="email"
                                                    value="@if (Request::old('email')) {{ Request::old('email') }}@else{{ $user->email }} @endif"
                                                    @if (get_site_config('student_create_admin_mandatory') == 'email' ||
                                                            get_site_config('student_create_admin_mandatory') == 'email_and_mobile') required @endif>
                                            </div>
                                        </div>

                                        <div class="col-sm-12 col-md-4">
                                            <div class="form-group" style="">
                                                <label class="col-form-label">Date of Birth</label>
                                                <div class="input-group">
                                                    <input type="text" placeholder="Date of Birth"
                                                        class="form-control dobmydatepicker" autocomplete="off"
                                                        id="dob" name="birthday"
                                                        value="@if (Request::old('birthday')) {{ date('d-m-Y', strtotime(Request::old('birthday'))) }} @elseif($user->birthday) {{ date('d-m-Y', strtotime($user->birthday)) }} @endif">
                                                    <div class="input-group-append">
                                                        <span class="input-group-text" style="height: 33px !important;"><i
                                                                class="fa fa-calendar"></i></span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group row ">
                                        <div class="col-sm-12 col-md-6">
                                            <label class="col-form-label 
                                            @if(get_site_config('student_create_admin_mandatory') == 'mobile' || get_site_config('student_create_admin_mandatory') == 'email_and_mobile') required-field @endif">Mobile No.</label>
                                            <div class="input-group">
                                                <div class="input-group-prepend" style="width: 50%">
                                                    <select class="form-select select2" id="dialcode" name="dialcode" style="padding:0.49rem 2rem 0.375rem 0.75rem;">
                                                        {{-- <option value=''>Dialcode</option> --}}
                                                        @foreach($dialcodes as $dialcode)
                                                        <option 
                                                        {{(($dialcode->code == $user->dialcode) || (Request::old('dialcode') && Request::old('dialcode') == $dialcode->code)) ? 'selected' : ''}} 
                                                        value="{{$dialcode->code}}" data-name="{{$dialcode->name}}">{{$dialcode->name}} +{{$dialcode->code}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                <input 
                                                    type="text" 
                                                    placeholder="Mobile No." 
                                                    class="form-control" 
                                                    onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))" 
                                                    name="mobile" 
                                                    id="mobile"
                                                    value="@if(Request::old('mobile')){{ Request::old('mobile') }}@else{{ $user->mobile }}@endif" 
                                                    minlength="{{ config('app.USER_MOBILE_MIN_LENGTH') }}" 
                                                    maxlength="{{ config('app.USER_MOBILE_MAX_LENGTH') }}" 
                                                    @if(get_site_config('student_create_admin_mandatory') == 'mobile' || get_site_config('student_create_admin_mandatory') == 'email_and_mobile') required @endif>
                                                    
                                            </div>
                                        </div>
                        
                                        <div class="col-sm-12 col-md-6">
                                            <label for="whatsapp_number" class="col-form-label">Whatsapp No.</label>
                                            <div class="input-group">
                                                <div class="input-group-prepend" style="width: 50%">
                                                    <select class="form-select select2" id="whatsapp_dialcode" name="whatsapp_dialcode" style="padding:0.49rem 2rem 0.375rem 0.75rem;">
                                                        {{-- <option value=''>Dialcode</option> --}}
                                                        @foreach($dialcodes as $dialcode)
                                                        <option 
                                                        {{
                                                            (($dialcode->code == $user->whatsapp_dialcode) || 
                                                            (Request::old('whatsapp_dialcode') && Request::old('whatsapp_dialcode') == $dialcode->code)) ? 'selected' : ''
                                                        }} 
                                                        value="{{$dialcode->code}}" data-name="{{$dialcode->name}}">{{$dialcode->name}} +{{$dialcode->code}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                <input type="text" placeholder="Whatsapp No." id="whatsapp_number" minlength="{{ config('app.USER_MOBILE_MIN_LENGTH') }}" maxlength="{{ config('app.USER_MOBILE_MAX_LENGTH') }}" class="form-control" name="whatsapp_number" value="@if(Request::old('whatsapp_number')){{ Request::old('whatsapp_number') }}@else{{ $user->whatsapp }}@endif">
                                            </div>
                                            <div class="form-check" style="margin-top: -7px;">
                                                <input type="checkbox"
                                                    class="form-check-input"
                                                    id="sameAsMobile"
                                                    >  
                                                <label class="form-check-label" for="sameAsMobile" style="font-weight:500 !important;">Same as Mobile No.</label>
                                            </div>
                                        </div>
                        
                                        <div class="col-sm-12 col-md-4">
                                            <label for="alternate_contact">Alternate Contact</label>
                                            <div class="">
                                                <input type="text" placeholder="Alternate Contact" id="alternate_contact" maxlength="50" class="form-control" name="alternate_contact" value="@if(Request::old('alternate_contact')){{ Request::old('alternate_contact') }}@else{{ $user->alternate_contact }}@endif">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <div class="col-sm-12 col-md-4">
                                            <label class="col-form-label required-field">Interested Study Level</label>
                                            <select class="form-select" id="study_level" name="study_level" required>
                                                <option value="">Select Study Level</option>
                                                @foreach (get_study_levels() as $key => $value)
                                                    <option value="{{ $value }}"
                                                        @if (Request::old('study_level') == $value) selected @elseif($user->overseas_study_level_selection == $value) selected @endif>
                                                        {{ $value }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-sm-12 col-md-4">
                                            <label class="col-form-label">Country Interested to Study In</label>
                                            <select name="country_interested[]" class="form-control form-select select2"
                                                style="width: 100%" multiple="multiple">
                                                @foreach ($study_countries as $study_country)
                                                    <?php $countryInterest = '';
                                                    $country_interested = explode(',', $user->country_interested);
                                                    ?>
                                                    @foreach ($country_interested as $interest)
                                                        @if ($interest == $study_country->title_en)
                                                            <?php $countryInterest = 'selected'; ?>
                                                        @endif
                                                    @endforeach
                                                    <option value="{{ $study_country->title_en }}"
                                                        {{ $countryInterest }}>{{ $study_country->title_en }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-sm-12 col-md-4">
                                            <label class="col-form-label">Course Interested to Study</label>
                                            <input type="text" placeholder="Course Interested to Study"
                                                class="form-control validate_inpt"
                                                value="{{ $user->overseas_course_intersted }}" id=""
                                                name="course_interested">
                                        </div>
                                    </div>
                                    <div class="form-group row " id="interested">
                                        <div class="col-sm-12 col-md-4">
                                            <label class="col-form-label">Intake</label>
                                            <select name="intake" class="form-select form-control">
                                                <option value="">Intake</option>
                                                <?php $month = date('n'); // current month
                                                for ($x = 0; $x < 24; $x++) { ?>
                                                <option @if (
                                                    $userDetails &&
                                                        $userDetails->intake_month . ' ' . $userDetails->intake_year == date('m Y', mktime(0, 0, 0, $month + $x, 1))) selected @endif
                                                    value="<?php echo date('m Y', mktime(0, 0, 0, $month + $x, 1)); ?>">
                                                    <?php echo date('F Y', mktime(0, 0, 0, $month + $x, 1)); ?>
                                                    <?php } ?></option>
                                            </select>
                                        </div>
                                        @if(env('ADDITIONAL_SERVICES_ENABLE'))
                                        <div class="col-sm-12 col-md-4">
                                            <label class="col-form-label">Other Services Interested</label>
                                            <select name="services[]" class="form-select select2" multiple>
                                                @foreach (get_services_data() as $service)
                                                    <?php $serviceInterest = '';
                                                    $service_interested = explode(',', $user->services);
                                                    ?>
                                                    @foreach ($service_interested as $interest)
                                                        @if ($interest == $service->id)
                                                            <?php $serviceInterest = 'selected'; ?>
                                                        @endif
                                                    @endforeach
                                                    <option value="{{ $service->id }}" {{ $serviceInterest }}>
                                                        {{ $service->service_name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        @endif
                                    </div>
                                    <hr class="my-3" style="height:2px;border-width:0;background-color:#49494982;">
                                    <div class="form-group row">
                                        <div class="col-sm-12 col-md-4">
                                            <label class="col-form-label">Highest Qualification</label>
                                            <select class="form-select" id="qualification" name="qualification">
                                                <option value="">Select Qualification</option>
                                                <option value="9th"
                                                    @if (Request::old('qualification') == '9th') selected @elseif($userDetails && $userDetails->highest_level_education == '9th') selected @endif>
                                                    9th
                                                </option>
                                                <option value="10th"
                                                    @if (Request::old('qualification') == '10th') selected @elseif($userDetails && $userDetails->highest_level_education == '10th') selected @endif>
                                                    10th
                                                </option>
                                                <option value="11th"
                                                    @if (Request::old('qualification') == '11th') selected @elseif($userDetails && $userDetails->highest_level_education == '11th') selected @endif>
                                                    11th
                                                </option>
                                                <option value="12th"
                                                    @if (Request::old('qualification') == '12th') selected @elseif($userDetails && $userDetails->highest_level_education == '12th') selected @endif>
                                                    12th
                                                </option>
                                                <option value="Bachelors"
                                                    @if (Request::old('qualification') == 'Bachelors') selected @elseif($userDetails && $userDetails->highest_level_education == 'Bachelors') selected @endif>
                                                    Bachelors
                                                </option>
                                                <option value="Masters"
                                                    @if (Request::old('qualification') == 'Masters') selected @elseif($userDetails && $userDetails->highest_level_education == 'Masters') selected @endif>
                                                    Masters
                                                </option>
                                                <option value="Ph.D"
                                                    @if (Request::old('qualification') == 'Ph.D') selected @elseif($userDetails && $userDetails->highest_level_education == 'Ph.D') selected @endif>
                                                    Ph.D
                                                </option>
                                            </select>
                                        </div>
                                        <div class="col-sm-12 col-md-4">
                                            <label class="col-form-label">Passout Year</label>
                                            <input type="text" placeholder="Passout Year"
                                                onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))"
                                                minlength="4" maxlength="4" class="form-control" id="passout_year"
                                                name="passout_year"
                                                value="@if ($userDetails){{ $userDetails->passout_year }}@endif">
                                        </div>
                                        <div class="col-sm-12 col-md-4">
                                            <label class="col-form-label">Score/Grade</label>
                                            <input type="text" placeholder="Score/Grade" class="form-control"
                                                id="passout_year" name="qualification_score"
                                                value="@if ($userDetails && $userDetails->qualification_score) {{ $userDetails->qualification_score }} @endif">
                                        </div>
                                        <div class="col-sm-12 col-md-4">
                                            <label class="col-form-label">Currently Studying Course</label>
                                            <input type="text" placeholder="Currently Studying Course"
                                                class="form-control validate_inpt" id="currently_studying_course"
                                                name="currently_studying_course"
                                                value="@if ($userDetails) {{ $userDetails->current_course }} @endif">
                                        </div>
                                        <div class="col-sm-12 col-md-4">
                                            <label class="col-form-label">Work Experience</label>
                                            <input type="text" placeholder="Work Experience" class="form-control"
                                                id="work_experience" name="work_experience" placeholder="Work Experience"
                                                value="@if ($userDetails && $userDetails->work_experience) {{ $userDetails->work_experience }} @endif">
                                        </div>
                                    </div>
                                    <hr class="my-3" style="height:2px;border-width:0;background-color:#49494982;">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group" style="margin-bottom:15px !important;">
                                                <label style="margin-bottom: 0.2rem;" class="required-field">Marital
                                                    Status</label>
                                                <div>
                                                    <select class="form-control form-select" id="marital_status"
                                                        name="marital_status" required>
                                                        <option value="">Select</option>
                                                        <option value="never_married"
                                                            @if (Request::old('marital_status') == 'never_married') selected @elseif ($userDetails && $userDetails->marital_status == 'never_married') selected @endif>
                                                            Never Married</option>
                                                        <option value="married"
                                                            @if (Request::old('marital_status') == 'married') selected @elseif ($userDetails && $userDetails->marital_status == 'married') selected @endif>
                                                            Married</option>
                                                        <option value="engaged"
                                                            @if (Request::old('marital_status') == 'engaged') selected @elseif ($userDetails && $userDetails->marital_status == 'engaged') selected @endif>
                                                            Engaged</option>
                                                        <option value="separated"
                                                            @if (Request::old('marital_status') == 'separated') selected @elseif ($userDetails && $userDetails->marital_status == 'separated') selected @endif>
                                                            Separated</option>
                                                        <option value="divorced"
                                                            @if (Request::old('marital_status') == 'divorced') selected @elseif ($userDetails && $userDetails->marital_status == 'divorced') selected @endif>
                                                            Divorced</option>
                                                        <option value="widowed"
                                                            @if (Request::old('marital_status') == 'widowed') selected @elseif ($userDetails && $userDetails->marital_status == 'widowed') selected @endif>
                                                            Widowed</option>
                                                        <option value="defector"
                                                            @if (Request::old('marital_status') == 'defector') selected @elseif ($userDetails && $userDetails->marital_status == 'defector') selected @endif>
                                                            Defector</option>
                                                        <option value="other"
                                                            @if (Request::old('marital_status') == 'other') selected @elseif ($userDetails && $userDetails->marital_status == 'other') selected @endif>
                                                            Other</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-4" id="select_date_of_marriage"
                                            @if ($userDetails) @if ($userDetails->marital_status == 'never_married' || $userDetails->marital_status == '') 
                                                    style="display:none;" 
                                                @else 
                                                    style="" @endif
                                        @else style="display:none;" @endif>
                                            <div class="form-group" style="margin-bottom:15px !important;">
                                                <label style="margin-bottom: 0.2rem;">Date of Marriage</label>
                                                <div class="input-group">
                                                    <input type="text" class="form-control  maritalDate"
                                                        id="date_of_marriage" name="date_of_marriage"
                                                        placeholder="dd-mm-yyyy"
                                                        value="@if (Request::old('date_of_marriage')) {{ date('d-m-Y', strtotime(Request::old('date_of_marriage'))) }}@elseif(isset($userDetails->date_of_marriage)){{ date('d-m-Y', strtotime($userDetails->date_of_marriage)) }} @endif">
                                                    <div class="input-group-append">
                                                        <span class="input-group-text" style="height: 33px !important;"><i
                                                                class="fa fa-calendar"></i></span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <hr class="my-3" style="height:2px;border-width:0;background-color:#49494982;">

                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group" style="margin-bottom:15px !important;">
                                                <label style="margin-bottom: 0.2rem;"
                                                    class="required-field">Nationality</label>
                                                <select class="form-control form-select" name="nationality" required>
                                                    <option value="">Select</option>
                                                    @foreach ($countries as $country)
                                                        <option value="{{ $country->id }}"
                                                            {{ $userDetails && $country->id == $userDetails->nationality ? 'selected' : '' }}>
                                                            {{ $country->name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group" style="margin-bottom:15px !important;">
                                                <label style="margin-bottom: 0.2rem;"
                                                    class="required-field">Citizenship</label>
                                                <select class="form-control form-select" name="citizenship" required>
                                                    <option value="">Select</option>
                                                    @foreach ($countries as $country)
                                                        <option value="{{ $country->id }}"
                                                            {{ $userDetails && $country->id == $userDetails->citizenship ? 'selected' : '' }}>
                                                            {{ $country->name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group" style="margin-bottom:15px !important;">
                                                <label style="margin-bottom: 0.2rem;">Country of Education</label>
                                                <select class="form-control form-select" name="country_of_education">
                                                    <option value="">Select</option>
                                                    @foreach ($countries as $country)
                                                        <option value="{{ $country->id }}"
                                                            {{ $userDetails && $country->id == $userDetails->country_of_education ? 'selected' : '' }}>
                                                            {{ $country->name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    {{-- //Dynamic fields --}}

                                    @if (count($custom_attributes))
                                        <hr class="mb-1">
                                        <h4 class="mb-3">Additional Details</h4>
                                        <div class="form-group row ">
                                            {{-- @if (count($custom_attributes)) --}}
                                            <?php
                                            $attrData = json_decode($userDetails->user_data_js, true);
                                            if ($user->is_lead) {
                                                $attr_mand = 'for_lead_mandatory';
                                            } else {
                                                $attr_mand = 'for_student_mandatory';
                                            }
                                            ?>
                                            @foreach ($custom_attributes as $custom_attribute)
                                                @if ($custom_attribute->$attr_mand)
                                                    <?php $red = 'required-field';
                                                    $mandate = 'required'; ?>
                                                @else
                                                    <?php $red = '';
                                                    $mandate = ''; ?>
                                                @endif

                                                @if ($custom_attribute->type == 'input')
                                                    <div class="col-sm-12 col-md-4">
                                                        <div class="form-group">
                                                            <label for=""
                                                                class="col-form-label {{ $red }}">{{ $custom_attribute->label }}</label>
                                                            <div class="">
                                                                <input
                                                                    type="@if ($custom_attribute->input_datatype == 'number' || $custom_attribute->input_datatype == 'decimal') {{ 'number' }}@elseif(
                                                                        $custom_attribute->input_datatype == 'date' ||
                                                                            $custom_attribute->input_datatype == 'year' ||
                                                                            $custom_attribute->input_datatype == 'phone'){{ 'text' }}@else{{ $custom_attribute->input_datatype }} @endif"
                                                                    {{ $custom_attribute->input_datatype == 'decimal' ? 'step=any' : '' }}
                                                                    @if ($custom_attribute->input_datatype == 'number' || $custom_attribute->input_datatype == 'decimal') {{ "min=$custom_attribute->input_min" }} {{ "max=$custom_attribute->input_max" }}
                                                            @elseif($custom_attribute->input_datatype == 'date')
                                                            {{-- //No min or max added --}}
                                                            @elseif($custom_attribute->input_datatype == 'year')
                                                                onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))" minlength="4" maxlength="4"
                                                            @elseif($custom_attribute->input_datatype == 'phone')
                                                                onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 58) || event.charCode==32 || event.charCode==44 || event.charCode==43 || event.charCode==45 || event.charCode==40 || event.charCode==41)" minlength="10" maxlength="18"
                                                            @else
                                                                {{ "minLength=$custom_attribute->input_min" }} {{ "maxLength=$custom_attribute->input_max" }} @endif
                                                                    placeholder="{{ $custom_attribute->placeholder }}"
                                                                    autocomplete="off"
                                                                    class="form-control @if ($custom_attribute->input_datatype == 'date') {{ 'mydatepicker' }} @endif"
                                                                    name="{{ $custom_attribute->attr_name }}"
                                                                    value='@if (isset($attrData[$custom_attribute->attr_name])) {{ $attrData[$custom_attribute->attr_name] }}@else{{ old("$custom_attribute->attr_name") }} @endif'
                                                                    {{ $mandate }}>

                                                            </div>
                                                        </div>
                                                    </div>
                                                @endif
                                                @if ($custom_attribute->type == 'textarea')
                                                    <div class="form-group row ">
                                                        <div class="col-sm-12 col-md-8">
                                                            <div class="form-group">
                                                                <label for=""
                                                                    class="col-form-label {{ $red }}">{{ $custom_attribute->label }}</label>
                                                                <div class="">
                                                                    <textarea placeholder="{{ $custom_attribute->placeholder }}" {{ "minLength=$custom_attribute->input_min" }}
                                                                        {{ "maxLength=$custom_attribute->input_max" }} class="form-control" name="{{ $custom_attribute->attr_name }}"
                                                                        {{ $mandate }}>
                                                        @if (isset($attrData[$custom_attribute->attr_name]))
{{ $attrData[$custom_attribute->attr_name] }}@else{{ old("$custom_attribute->attr_name") }}
@endif
                                                        </textarea>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                @endif
                                                @if ($custom_attribute->type == 'select')
                                                    <?php
                                                    $is_multi = $select2 = '';
                                                    $select_vals = explode('|', $custom_attribute->selection_values);
                                                    if ($custom_attribute->select_multiple) {
                                                        $is_multi = 'multiple';
                                                        $select2 = 'select2';
                                                    }
                                                    ?>
                                                    <div class="col-sm-12 col-md-4">
                                                        <div class="form-group">
                                                            <label for=""
                                                                class="col-form-label {{ $red }}">{{ $custom_attribute->label }}</label>
                                                            <div class="">
                                                                <select placeholder="{{ $custom_attribute->placeholder }}"
                                                                    class="form-select {{ $select2 }}"
                                                                    name="{{ $custom_attribute->attr_name }}[]"
                                                                    {{ $mandate }} {{ $is_multi }}>
                                                                    @if (!$is_multi)
                                                                        <option value="">
                                                                            {{ $custom_attribute->placeholder }}</option>
                                                                    @endif
                                                                    @foreach ($select_vals as $sel_val)
                                                                        <option
                                                                            {{ isset($attrData[$custom_attribute->attr_name]) && is_array($attrData[$custom_attribute->attr_name]) && in_array($sel_val, $attrData[$custom_attribute->attr_name]) ? ' selected' : '' }}{{ is_array(old("$custom_attribute->attr_name")) && in_array($sel_val, old("$custom_attribute->attr_name")) ? ' selected' : '' }}
                                                                            value="{{ $sel_val }}">
                                                                            {{ $sel_val }}</option>
                                                                    @endforeach
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                @endif
                                                @if ($custom_attribute->type == 'checkbox')
                                                    <?php
                                                    $select_vals = explode('|', $custom_attribute->selection_values);
                                                    ?>
                                                    <div class="col-sm-12 col-md-4">
                                                        <div class="form-group">
                                                            <label for=""
                                                                class="col-form-label {{ $red }}">{{ $custom_attribute->label }}</label>
                                                            <div class="">
                                                                @foreach ($select_vals as $sel_val)
                                                                    <label>
                                                                        <input
                                                                            class="form-check-input ms-2 dyna_chkbx {{ $custom_attribute->attr_name }}"
                                                                            @if ($mandate) onclick='chk_mend("{{ $custom_attribute->attr_name }}")' @endif
                                                                            {{ isset($attrData[$custom_attribute->attr_name]) && is_array($attrData[$custom_attribute->attr_name]) && in_array($sel_val, $attrData[$custom_attribute->attr_name]) ? ' checked' : '' }}
                                                                            {{ is_array(old("$custom_attribute->attr_name")) && in_array($sel_val, old("$custom_attribute->attr_name")) ? ' checked' : '' }}
                                                                            type="checkbox"
                                                                            name="{{ $custom_attribute->attr_name }}[]"
                                                                            value="{{ $sel_val }}"
                                                                            @if (isset($attrData[$custom_attribute->attr_name]) && is_array($attrData[$custom_attribute->attr_name])) {{ '' }} @else{{ $mandate }} @endif>
                                                                        {{ $sel_val }}
                                                                    </label>
                                                                @endforeach
                                                            </div>
                                                        </div>
                                                    </div>
                                                @endif
                                                @if ($custom_attribute->type == 'radio')
                                                    <?php
                                                    $select_vals = explode('|', $custom_attribute->selection_values);
                                                    ?>
                                                    <div class="col-sm-12 col-md-4">
                                                        <div class="form-group">
                                                            <label for=""
                                                                class="col-form-label {{ $red }}">{{ $custom_attribute->label }}</label>
                                                            <div class="">
                                                                @foreach ($select_vals as $sel_val)
                                                                    <label>
                                                                        <input
                                                                            class="form-check-input ms-2 {{ $custom_attribute->attr_name }}"
                                                                            @if ($mandate) onclick='chk_mend("{{ $custom_attribute->attr_name }}")' @endif
                                                                            {{ isset($attrData[$custom_attribute->attr_name]) && is_array($attrData[$custom_attribute->attr_name]) && in_array($sel_val, $attrData[$custom_attribute->attr_name]) ? ' checked' : '' }}
                                                                            {{ is_array(old("$custom_attribute->attr_name")) && in_array($sel_val, old("$custom_attribute->attr_name")) ? ' checked' : '' }}
                                                                            type="radio"
                                                                            name="{{ $custom_attribute->attr_name }}[]"
                                                                            value="{{ $sel_val }}"
                                                                            @if (isset($attrData[$custom_attribute->attr_name]) && is_array($attrData[$custom_attribute->attr_name])) {{ '' }} @else{{ $mandate }} @endif>
                                                                        {{ $sel_val }}
                                                                    </label>
                                                                @endforeach
                                                            </div>
                                                        </div>
                                                    </div>
                                                @endif
                                            @endforeach
                                        </div>
                                    @endif


                                    {{-- //Dynamic fields --}}

                                    <hr class="my-3" style="height:2px;border-width:0;background-color:#49494982;">
                                    <h4 class="mb-3" style="font-weight: 700 !important;">Current Address</h4>

                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group" style="margin-bottom:15px !important;">
                                                <label style="margin-bottom: 0.2rem;" class="">Address</label>
                                                <input type="text" class="form-control validate_inpt" name="address"
                                                    maxlength="200" value="{{ $user->address_1 }}">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group" style="margin-bottom:15px !important;">
                                                <label style="margin-bottom: 0.2rem;" class="">Country</label>
                                                <select class="form-control form-select" id="country-dd" name="country">
                                                    <option value="">Select</option>
                                                    @foreach ($countries as $country)
                                                        <option value="{{ $country->id }}"
                                                            @if ($country->id == $user->country) selected @endif>
                                                            {{ $country->name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label style="margin-bottom: 0.2rem;" class="">State</label>
                                                <select class="form-control" name="state" id="state-dd">
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label style="margin-bottom: 0.2rem;" class="">City</label>
                                    <select class="form-control form-select" name="city" id="city" required>
                            </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group" style="margin-bottom:15px !important;">
                                                <label style="margin-bottom: 0.2rem;" class="">Postal Code/PIN
                                                    Code</label>
                                                <input type="text" class="form-control" name="post_code"
                                                    maxlength="20" value="{{ $user->post_code }}">
                                            </div>
                                        </div>
                                    </div>
                                    <hr class="my-3" style="height:2px;border-width:0;background-color:#49494982;">
                                    <h4 class="mb-3" style="font-weight: 700 !important;">Permanent Address</h4>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group" style="margin-bottom:15px !important;">
                                                <label><input class="mr-1"
                                                        style="position: inherit!important;left: 0px!important;opacity: 1!important;width: 15px;height: 15px;"
                                                        type="checkbox" id="same_as_current" name="same_as_current"
                                                        {{ $userDetails && $userDetails->permanent_address == $user->address_1 ? 'checked' : '' }}
                                                        value="1"> Same as Current Address</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div id="perm_block"
                                        @if ($userDetails && $userDetails->permanent_address == $user->address_1) style="display:none;" @else style="" @endif>
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="form-group" style="margin-bottom:15px !important;">
                                                    <label style="margin-bottom: 0.2rem;" class="">Address</label>
                                                    <input type="text" class="form-control" name="permanent_address"
                                                        maxlength="200"
                                                        value="{{ $userDetails ? $userDetails->permanent_address : '' }}">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group" style="margin-bottom:15px !important;">
                                                    <label style="margin-bottom: 0.2rem;" class="">Country</label>
                                                    <select class="form-control form-select" id="per-country-dd"
                                                        name="permanent_country">
                                                        <option value="">Select</option>
                                                        @foreach ($countries as $country)
                                                            <option value="{{ $country->id }}"
                                                                {{ $userDetails && $country->id == $userDetails->permanent_country ? 'selected' : '' }}>
                                                                {{ $country->name }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label style="margin-bottom: 0.2rem;" class="">State</label>
                                                    <select class="form-control" name="permanent_state"
                                                        id="per-state-dd">
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label style="margin-bottom: 0.2rem;" class="">City</label>
                                                    <input type="text" class="form-control validate_inpt"
                                                        name="permanent_city" id="per-city"
                                                        value="{{ $userDetails ? $userDetails->permanent_city : '' }}">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group" style="margin-bottom:15px !important;">
                                                    <label style="margin-bottom: 0.2rem;" class="">Postal
                                                        Code</label>
                                                    <input type="text" class="form-control" name="permanent_post_code"
                                                        maxlength="20"
                                                        value="{{ $userDetails ? $userDetails->permanent_post_code : '' }}">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <hr class="my-3" style="height:2px;border-width:0;background-color:#49494982;">
                                    <h4 class="mb-3" style="font-weight: 700 !important;">Passport Information</h4>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group" style="margin-bottom:15px !important;">
                                                <label style="margin-bottom: 0.2rem;" class="">Name as per
                                                    Passport</label>
                                                <input type="text" class="form-control" id="name_passport"
                                                    name="name_passport" maxlength="150"
                                                    value="{{ $userDetails ? $userDetails->name_passport : '' }}">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group" style="margin-bottom:15px !important;">
                                                <label style="margin-bottom: 0.2rem;" class="">Passport No.</label>
                                                <input type="text" class="form-control" name="passport_num"
                                                    id="passport_num" maxlength="50"
                                                    value="{{ $userDetails ? $userDetails->passport_num : '' }}">
                                            </div>
                                        </div>
                                        <div class="col-md-2">
                                            <div class="form-group" style="margin-bottom:15px !important;">
                                                <label style="margin-bottom: 0.2rem;" class="">Issue Date</label>
                                                <input type="text" class="form-control maritalDate"
                                                    name="passport_issue_date" maxlength="50"
                                                    value="@if($userDetails && $userDetails->passport_issue_date){{ date('d-m-Y', strtotime($userDetails->passport_issue_date)) }}@endif"
                                                    autocomplete="off">
                                            </div>
                                        </div>
                                        <div class="col-md-2">
                                            <div class="form-group" style="margin-bottom:15px !important;">
                                                <label style="margin-bottom: 0.2rem;" class="">Expiry Date</label>
                                                <input type="text" class="form-control expiryDatePicker"
                                                    name="passport_expiry_date" maxlength="50"
                                                    value="@if($userDetails && $userDetails->passport_expiry_date){{ date('d-m-Y', strtotime($userDetails->passport_expiry_date)) }}@endif"
                                                    autocomplete="off">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group" style="margin-bottom:15px !important;">
                                                <label style="margin-bottom: 0.2rem;">Issue Country</label>
                                                <select class="form-control form-select" name="passport_country">
                                                    <option value="">Select</option>
                                                    @foreach ($countries as $country)
                                                        <option value="{{ $country->id }}"
                                                            {{ $userDetails && $country->id == $userDetails->passport_country ? 'selected' : '' }}>
                                                            {{ $country->name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group" style="margin-bottom:15px !important;">
                                                <label style="margin-bottom: 0.2rem;">City of Birth</label>
                                                <input type="text" class="form-control validate_inpt"
                                                    name="city_of_birth"
                                                    value="{{ $userDetails ? $userDetails->city_of_birth : '' }}">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group" style="margin-bottom:15px !important;">
                                                <label style="margin-bottom: 0.2rem;">Country of Birth</label>
                                                <select class="form-control form-select" name="country_of_birth">
                                                    <option value="">Select</option>
                                                    @foreach ($countries as $country)
                                                        <option value="{{ $country->id }}"
                                                            {{ $userDetails && $userDetails->country_of_birth == $country->id ? 'selected' : '' }}>
                                                            {{ $country->name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <hr class="my-3" style="height:2px;border-width:0;background-color:#49494982;">
                                    <h4 class="mb-3" style="font-weight: 700 !important;">Nationality</h4>

                                    <div class="row">
                                        <div class="col-md-6 mt-1">
                                            <div class="form-group" style="margin-bottom:15px !important;">
                                                <label style="margin-bottom: 0.2rem;" class="mb-2">Is the applicant a
                                                    citizen of more than one country?</label>
                                                <div>
                                                    <input type="radio" class="radio-col-blue" name="dual_citizenship"
                                                        id="no_dual" value="0"
                                                        @if ($userDetails && $userDetails->dual_citizenship == '0') checked @endif>
                                                    <label class="custom-control-label" for="no_dual">No</label>
                                                    <input type="radio" class="radio-col-blue" name="dual_citizenship"
                                                        id="yes_dual" value="1"
                                                        @if ($userDetails && $userDetails->dual_citizenship == '1') checked @endif>
                                                    <label class="custom-control-label" for="yes_dual">Yes</label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6" id="select_dual_country"
                                            @if ($userDetails) @if ($userDetails->dual_citizenship == '0' || $userDetails->dual_citizenship == '') style="display:none;" 
                                            @else 
                                                style="" @endif
                                        @else style="display:none;" @endif>
                                            <div class="form-group" style="margin-bottom:15px !important;">
                                                <label style="margin-bottom: 0.2rem;">Country</label>
                                                <select class="form-control form-select select2" style="width: 100%"
                                                    id="dual_citizenship_country" name="dual_citizenship_country[]"
                                                    multiple>
                                                    @foreach ($countries as $country)
                                                        <?php $countryInterest = '';
                                                        if (Request::old('dual_citizenship_country')) {
                                                            $dual_citizenship_country = Request::old('dual_citizenship_country');
                                                        } else {
                                                            $dual_citizenship_country = explode(',', $userDetails->dual_citizenship_country);
                                                        }
                                                        ?>
                                                        @foreach ($dual_citizenship_country as $interest)
                                                            @if ($interest == $country->id)
                                                                <?php $countryInterest = 'selected'; ?>
                                                            @endif
                                                        @endforeach
                                                        <option value="{{ $country->id }}" {{ $countryInterest }}>
                                                            {{ $country->name }}</option>
                                                    @endforeach
                                                    {{-- <option value="">Select</option>
                                                    @foreach ($countries as $country)
                                                        <option value="{{ $country->id }}" {{($userDetails && $country->id == $userDetails->dual_citizenship_country) ? "selected" : ''}}>{{ $country->name }}</option>
                                                    @endforeach --}}
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6 mt-1">
                                            <div class="form-group" style="margin-bottom:15px !important;">
                                                <label style="margin-bottom: 0.2rem;" class="mb-2">Is the applicant
                                                    living and studying in any other country?</label>
                                                <div>
                                                    <input type="radio" class="radio-col-blue" name="studying_abroad"
                                                        id="no_studying_abroad" value="0"
                                                        @if ($userDetails && $userDetails->studying_abroad == '0') checked @endif>
                                                    <label class="custom-control-label"
                                                        for="no_studying_abroad">No</label>
                                                    <input type="radio" class="radio-col-blue" name="studying_abroad"
                                                        id="yes_studying_abroad" value="1"
                                                        @if ($userDetails && $userDetails->studying_abroad == '1') checked @endif>
                                                    <label class="custom-control-label"
                                                        for="yes_studying_abroad">Yes</label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6" id="select_studying_abroad_country"
                                            @if ($userDetails) @if ($userDetails->studying_abroad == '0' || $userDetails->studying_abroad == '') style="display:none;" 
                                        @else 
                                            style="" @endif
                                        @else style="display:none;" @endif
                                            >
                                            <div class="form-group" style="margin-bottom:15px !important;">
                                                <label style="margin-bottom: 0.2rem;">Country</label>
                                                <select class="form-control form-select" id="studying_abroad_country"
                                                    name="studying_abroad_country">
                                                    <option value="">Select</option>
                                                    @foreach ($countries as $country)
                                                        <option value="{{ $country->id }}"
                                                            {{ $userDetails && $country->id == $userDetails->studying_abroad_country ? 'selected' : '' }}>
                                                            {{ $country->name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <hr class="my-3" style="height:2px;border-width:0;background-color:#49494982;">
                                    <h4 class="mb-3" style="font-weight: 700 !important;">Background Info</h4>
                                    <div class="row">
                                        <div class="col-md-6 mt-1">
                                            <div class="form-group" style="margin-bottom:15px !important;">
                                                <label style="margin-bottom: 0.2rem;" class="mb-2">Has applicant applied
                                                    for any type of immigration into any country?</label>
                                                <div>
                                                    <input type="radio" class="radio-col-blue" name="immigration"
                                                        id="no_immigration" value="0"
                                                        @if ($userDetails && $userDetails->immigration == '0') checked @endif>
                                                    <label class="custom-control-label" for="no_immigration">No</label>
                                                    <input type="radio" class="radio-col-blue" name="immigration"
                                                        id="yes_immigration" value="1"
                                                        @if ($userDetails && $userDetails->immigration == '1') checked @endif>
                                                    <label class="custom-control-label" for="yes_immigration">Yes</label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6" id="select_immigration_country"
                                            @if ($userDetails) @if ($userDetails->immigration == '0' || $userDetails->immigration == '') style="display:none;" 
                                @else 
                                    style="" @endif
                                        @else style="display:none;" @endif
                                            >
                                            <div class="form-group" style="margin-bottom:15px !important;">
                                                <label style="margin-bottom: 0.2rem;">Country</label>
                                                <select class="form-control form-selects select2" style="width: 100%"
                                                    id="immigration_country" name="immigration_country[]" multiple>
                                                    @foreach ($countries as $country)
                                                        <?php $countryInterest = '';
                                                        if (Request::old('immigration_country')) {
                                                            $immigration_country = Request::old('immigration_country');
                                                        } else {
                                                            $immigration_country = explode(',', $userDetails->immigration_country);
                                                        }
                                                        ?>
                                                        @foreach ($immigration_country as $interest)
                                                            @if ($interest == $country->id)
                                                                <?php $countryInterest = 'selected'; ?>
                                                            @endif
                                                        @endforeach
                                                        <option value="{{ $country->id }}" {{ $countryInterest }}>
                                                            {{ $country->name }}</option>
                                                    @endforeach
                                                    {{-- <option value="">Select</option>
                                                @foreach ($countries as $country)
                                                    <option value="{{ $country->id }}" {{($userDetails && $country->id == $userDetails->immigration_country) ? "selected" : ''}}>{{ $country->name }}</option>
                                                @endforeach --}}
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6 mt-1">
                                            <div class="form-group" style="margin-bottom:15px !important;">
                                                <label style="margin-bottom: 0.2rem;" class="mb-2">Does applicant suffer
                                                    from a serious medical condition? </label>
                                                <div>
                                                    <input type="radio" class="radio-col-blue" name="medical_condition"
                                                        id="no_medical_condition" value="0"
                                                        @if ($userDetails && $userDetails->medical_condition == '0') checked @endif>
                                                    <label class="custom-control-label"
                                                        for="no_medical_condition">No</label>
                                                    <input type="radio" class="radio-col-blue" name="medical_condition"
                                                        id="yes_medical_condition" value="1"
                                                        @if ($userDetails && $userDetails->medical_condition == '1') checked @endif>
                                                    <label class="custom-control-label"
                                                        for="yes_medical_condition">Yes</label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6 mt-1">
                                            <div class="form-group" style="margin-bottom:15px !important;">
                                                <label style="margin-bottom: 0.2rem;" class="mb-2">Has applicant Visa
                                                    refusal for any country?</label>
                                                <div>
                                                    <input type="radio" class="radio-col-blue" name="visa_refusal"
                                                        id="no_visa_refusal" value="0"
                                                        @if ($userDetails && $userDetails->visa_refusal == '0') checked @endif>
                                                    <label class="custom-control-label" for="no_visa_refusal">No</label>
                                                    <input type="radio" class="radio-col-blue" name="visa_refusal"
                                                        id="yes_visa_refusal" value="1"
                                                        @if ($userDetails && $userDetails->visa_refusal == '1') checked @endif>
                                                    <label class="custom-control-label" for="yes_visa_refusal">Yes</label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6" id="select_visa_refusal_country"
                                            @if ($userDetails) @if ($userDetails->visa_refusal == '0' || $userDetails->visa_refusal == '') style="display:none;" 
                                @else 
                                    style="" @endif
                                        @else style="display:none;" @endif
                                            >
                                            <div class="form-group" style="margin-bottom:15px !important;">
                                                <label style="margin-bottom: 0.2rem;">Country</label>
                                                <select class="form-control form-select select2" style="width: 100%"
                                                    id="visa_refusal_country" name="visa_refusal_country[]" multiple>
                                                    @foreach ($countries as $country)
                                                        <?php $countryInterest = '';
                                                        if (Request::old('visa_refusal_country')) {
                                                            $visa_refusal_country = Request::old('visa_refusal_country');
                                                        } else {
                                                            $visa_refusal_country = explode(',', $userDetails->visa_refusal_country);
                                                        }
                                                        ?>
                                                        @foreach ($visa_refusal_country as $interest)
                                                            @if ($interest == $country->id)
                                                                <?php $countryInterest = 'selected'; ?>
                                                            @endif
                                                        @endforeach
                                                        <option value="{{ $country->id }}" {{ $countryInterest }}>
                                                            {{ $country->name }}</option>
                                                    @endforeach
                                                    {{-- <option value="">Select</option>
                                                @foreach ($countries as $country)
                                                    <option value="{{ $country->id }}" {{($userDetails && $country->id == $userDetails->visa_refusal_country) ? "selected" : ''}}>{{ $country->name }}</option>
                                                @endforeach --}}
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6 mt-1">
                                            <div class="form-group" style="margin-bottom:15px !important;">
                                                <label style="margin-bottom: 0.2rem;" class="mb-2">Has applicant ever
                                                    been convicted of a criminal offence?</label>
                                                <div>
                                                    <input type="radio" class="radio-col-blue" name="criminal_offence"
                                                        id="no_criminal_offence" value="0"
                                                        @if ($userDetails && $userDetails->criminal_offence == '0') checked @endif>
                                                    <label class="custom-control-label"
                                                        for="no_criminal_offence">No</label>
                                                    <input type="radio" class="radio-col-blue" name="criminal_offence"
                                                        id="yes_criminal_offence" value="1"
                                                        @if ($userDetails && $userDetails->criminal_offence == '1') checked @endif>
                                                    <label class="custom-control-label"
                                                        for="yes_criminal_offence">Yes</label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <hr class="my-3" style="height:2px;border-width:0;background-color:#49494982;">
                                    <h4 class="mb-3" style="font-weight: 700 !important;">Emergency Contacts</h4>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group" style="margin-bottom:15px !important;">
                                                <label style="margin-bottom: 0.2rem;">Name</label>
                                                <input type="text" class="form-control" name="emergency_name"
                                                    maxlength="50"
                                                    value="{{ $userDetails ? $userDetails->emergency_name : '' }}">
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div class="form-group" style="margin-bottom:15px !important;">
                                                <label style="margin-bottom: 0.2rem;" class="">Email</label>
                                                <input type="email" class="form-control" name="emergency_email"
                                                    maxlength="50"
                                                    value="{{ $userDetails ? $userDetails->emergency_email : '' }}">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group" style="margin-bottom:15px !important;">
                                                <label style="margin-bottom: 0.2rem;">Phone</label>
                                                <input type="text" class="form-control" name="emergency_phone"
                                                    minlength="{{ config('app.USER_MOBILE_MIN_LENGTH') }}"
                                                    maxlength="{{ config('app.USER_MOBILE_MAX_LENGTH') }}"
                                                    value="{{ $userDetails ? $userDetails->emergency_phone : '' }}">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group" style="margin-bottom:15px !important;">
                                                <label style="margin-bottom: 0.2rem;">Relationship with Applicant</label>
                                                <input type="text" class="form-control validate_inpt"
                                                    name="emergency_relation" maxlength="20"
                                                    value="{{ $userDetails ? $userDetails->emergency_relation : '' }}">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group" style="margin-bottom:15px !important;">
                                                <label style="margin-bottom: 0.2rem;">Address</label>
                                                <input type="text" class="form-control validate_inpt"
                                                    name="emergency_address" maxlength="100"
                                                    value="{{ $userDetails ? $userDetails->emergency_address : '' }}">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group" style="margin-bottom:15px !important;">
                                                <label style="margin-bottom: 0.2rem;" class="">Country</label>
                                                <select class="form-control form-select" id="emergency_country-dd"
                                                    name="emergency_country">
                                                    <option value="">Select</option>
                                                    @foreach ($countries as $country)
                                                        <option value="{{ $country->id }}"
                                                            @if ($country->id == $userDetails->emergency_country) selected @endif>
                                                            {{ $country->name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label style="margin-bottom: 0.2rem;" class="">State</label>
                                                <select class="form-control form-select" name="emergency_state"
                                                    id="emergency_state-dd">
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label style="margin-bottom: 0.2rem;">City</label>
                                                <input type="text" class="form-control" maxlength="50"
                                                    placeholder="City" name="emergency_city" maxlength="100"
                                                    value="{{ $userDetails ? $userDetails->emergency_city : '' }}"
                                                    id="emergency_city">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group" style="margin-bottom:15px !important;">
                                                <label style="margin-bottom: 0.2rem;" class="">Postal
                                                    Code</label>
                                                <input type="text" class="form-control" placeholder="Postal Code"
                                                    name="emergency_postalcode"
                                                    value="{{ $userDetails ? $userDetails->emergency_postalcode : '' }}"
                                                    maxlength="10">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="mt-4 text-center">
                                        <button type="submit" class="btn btn-primary"
                                            style="padding-left:40px;padding-right:40px;">Save</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @if (get_site_config('academic_details_in_profile'))
        <div class="card border" style="">
            <div class="card-header ">
                <h4 class="m-b-0" style="font-weight: 700 !important;">Academic Details</h4>
            </div>

            <div>
                <input type="hidden" name="user_id" value="{{ $user->id }}">
                <div class=" card-body">
                    <div class="table-responsive mt-4">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Education Level</th>
                                    <th>Course Name</th>
                                    <th>Institute</th>
                                    <th>University/Board</th>
                                    <th>Country of Institute</th>
                                    <th>Campus City</th>
                                    <th>Postal Code</th>
                                    <th>Start Date</th>
                                    <th>Completion Date</th>
                                    <th>Course status</th>
                                    <th>Marks %</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @if (count($profile_academics) != 0)
                                    @foreach ($profile_academics as $profile_academic)
                                        <tr>
                                            <td>
                                                @if ($profile_academic->education_level == 10 || $profile_academic->education_level == 12)
                                                    {{ $profile_academic->education_level }}
                                                    <sup
                                                        class="text-sm font-weight-bold">th</sup>@else{{ $profile_academic->education_level }}
                                                @endif
                                            </td>
                                            <td style="min-width: 120px;">
                                                {{ $profile_academic->course_name }}</td>
                                            <td style="min-width: 120px;">
                                                {{ $profile_academic->institute }}</td>
                                            <td style="min-width: 120px;">
                                                {{ $profile_academic->university }}</td>
                                            <td>{{ get_country_name($profile_academic->institute_country) }}
                                            </td>
                                            <td>{{ $profile_academic->campus_city }}</td>
                                            <td>{{ $profile_academic->postal_code }}</td>
                                            <td>
                                                @if ($profile_academic->start_year)
                                                    {{ $profile_academic->start_year }}
                                                @endif
                                            </td>
                                            <td>
                                                @if ($profile_academic->pass_year)
                                                    {{ $profile_academic->pass_year }}
                                                @endif
                                            </td>
                                            <td>{{ $profile_academic->course_status }}</td>
                                            <td>
                                                @if ($profile_academic->percent_cgpa)
                                                    {{ $profile_academic->percent_cgpa }} %
                                                @endif
                                            </td>
                                            <td>

                                                <div class="d-flex">
                                                    <button id="data-id"
                                                        class="btn btn-sm btn-outline-primary editProfileAcademics "
                                                        data-id="{{ $profile_academic->id }}" data-placement="top"
                                                        title="Edit"><i class="fa fa-edit"></i>
                                                    </button>

                                                    <form
                                                        action="{{ route('admin.profile.academics_information.delete') }}"
                                                        method="POST"
                                                        onSubmit="if(!confirm('Are you sure want to delete this Academic Information?')){return false;}">
                                                        @csrf
                                                        <input type="hidden" name="id"
                                                            value="{{ $profile_academic->id }}">
                                                        <input type="hidden" name="userid"
                                                            value="{{ $profile_academic->userid }}">

                                                        <button title="Delete" type="submit"
                                                            class="btn btn-sm btn-outline-danger"><i
                                                                class="fa fa-trash"></i></button>
                                                    </form>

                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                @else
                                    <tr>
                                        <td colspan="12" class="text-center">No Records Found
                                        </td>
                                    </tr>
                                @endif
                            </tbody>
                        </table>
                    </div>

                    @if (count($profile_academics) == 0)
                        <button class="btn btn-primary addProfileAcademics" data-placement="top" title="Add More"><i
                                class="fa fa-plus"></i> Add New</button>
                    @else
                        <button class="btn btn-primary addProfileAcademics" data-placement="top" title="Add More"><i
                                class="fa fa-plus"></i> Add More</button>

                    @endif
                </div>
            </div>
        </div>
        {{-- </div>
                    </div> --}}

        <div class="card border" style="margin-bottom:0;">
            <div class="card-header">
                <h4 class="m-b-0" style="font-weight: 700 !important;">English/ Aptitude/ Language Tests</h4>
            </div>

            <div>
                <form method="post" action="{{ route('admin.studyabroad.profile.lang.save') }}">
                    @csrf
                    @php
                        $languages = ['IELTS', 'TOEFL', 'PTE'];
                    @endphp
                    <input type="hidden" name="user_id" value="{{ $user->id }}">
                    <div class=" card-body">
                        <p class="mb-1 mt-3" id="eng_one_lang_checks">
                            <label class="checkbox-inline" style="margin-right: 5px;cursor:pointer;">
                                <input type="checkbox" value="" @if (isset($eng[$languages[0]]) &&
                                        ($eng[$languages[0]]['overall_score'] ||
                                            $eng[$languages[0]]['speaking'] ||
                                            $eng[$languages[0]]['reading'] ||
                                            $eng[$languages[0]]['listening'] ||
                                            $eng[$languages[0]]['writing'])) checked @endif
                                    id="IELTS_checkbox" onclick="show_hide_eng('IELTS')"> IELTS
                            </label>
                            <label class="checkbox-inline" style="margin-right: 5px;cursor:pointer;">
                                <input type="checkbox" value="" @if (isset($eng[$languages[1]]) &&
                                        ($eng[$languages[1]]['overall_score'] ||
                                            $eng[$languages[1]]['speaking'] ||
                                            $eng[$languages[1]]['reading'] ||
                                            $eng[$languages[1]]['listening'] ||
                                            $eng[$languages[1]]['writing'])) checked @endif
                                    id="TOEFL_checkbox" onclick="show_hide_eng('TOEFL')"> TOEFL
                            </label>
                            <label class="checkbox-inline" style="margin-right: 5px;cursor:pointer;">
                                <input type="checkbox" value="" @if (isset($eng[$languages[2]]) &&
                                        ($eng[$languages[2]]['overall_score'] ||
                                            $eng[$languages[2]]['speaking'] ||
                                            $eng[$languages[2]]['reading'] ||
                                            $eng[$languages[2]]['listening'] ||
                                            $eng[$languages[2]]['writing'])) checked @endif
                                    id="PTE_checkbox" onclick="show_hide_eng('PTE')"> PTE
                            </label>
                        </p>
                        <div class="table-responsive mt-4" id="english_lang_table"
                            @if (!(@isset($eng[$languages[0]]) || @isset($eng[$languages[1]]) || @isset($eng[$languages[2]]))) style="display: none;" @endif>
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>Exam</th>
                                        <th>Overall Score</th>
                                        <th>Speaking</th>
                                        <th>Reading</th>
                                        <th>Listening</th>
                                        <th>Writing</th>
                                        <th>Score expiry Date</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @for ($i = 0; $i < count($languages); $i++)
                                        <tr id="{{ $languages[$i] }}"
                                            @if (
                                                !(isset($eng[$languages[$i]]) &&
                                                    ($eng[$languages[$i]]['overall_score'] ||
                                                        $eng[$languages[$i]]['speaking'] ||
                                                        $eng[$languages[$i]]['reading'] ||
                                                        $eng[$languages[$i]]['listening'] ||
                                                        $eng[$languages[$i]]['writing'])
                                                )) style="display: none;" @endif>
                                            <td>{{ $languages[$i] }}</td>
                                            @isset($eng[$languages[$i]])
                                                <td>
                                                    <input type="number" name='eng[<?= $languages[$i] ?>][overall_score]'
                                                        class='form-control' step="0.01"
                                                        value="{{ $eng[$languages[$i]]['overall_score'] }}" />
                                                </td>
                                                <td>
                                                    <input type="number" name='eng[<?= $languages[$i] ?>][speaking]'
                                                        class='form-control' step="0.01"
                                                        value="{{ $eng[$languages[$i]]['speaking'] }}" />
                                                </td>
                                                <td>
                                                    <input type="number" name='eng[<?= $languages[$i] ?>][reading]'
                                                        class='form-control' step="0.01"
                                                        value="{{ $eng[$languages[$i]]['reading'] }}" />
                                                </td>
                                                <td>
                                                    <input type="number" name='eng[<?= $languages[$i] ?>][listening]'
                                                        class='form-control' step="0.01"
                                                        value="{{ $eng[$languages[$i]]['listening'] }}" />
                                                </td>
                                                <td>
                                                    <input type="number" name='eng[<?= $languages[$i] ?>][writing]'
                                                        class='form-control' step="0.01"
                                                        value="{{ $eng[$languages[$i]]['writing'] }}" />
                                                </td>
                                                <td>
                                                    <input type="text" name='eng[<?= $languages[$i] ?>][expiry_date]'
                                                        class='form-control mydatepicker' placeholder="dd-mm-yyyy"
                                                        @if ($eng[$languages[$i]]['expiry_date'])
                                                    value="{{ date('d-m-Y', strtotime($eng[$languages[$i]]['expiry_date'])) }}"
                                        @endif style="min-width:100px;" />
                                        </td>
                                    @else
                                        <td>
                                            <input type="number" name='eng[<?= $languages[$i] ?>][overall_score]'
                                                class='form-control' step="0.01" value="" />
                                        </td>
                                        <td>
                                            <input type="number" name='eng[<?= $languages[$i] ?>][speaking]'
                                                class='form-control' step="0.01" value="" />
                                        </td>
                                        <td>
                                            <input type="number" name='eng[<?= $languages[$i] ?>][reading]'
                                                class='form-control' step="0.01" value="" />
                                        </td>
                                        <td>
                                            <input type="number" name='eng[<?= $languages[$i] ?>][listening]'
                                                class='form-control' step="0.01" value="" />
                                        </td>
                                        <td>
                                            <input type="number" name='eng[<?= $languages[$i] ?>][writing]'
                                                class='form-control' step="0.01" value="" />
                                        </td>
                                        <td>
                                            <input type="text" name='eng[<?= $languages[$i] ?>][expiry_date]'
                                                class='form-control mydatepicker' placeholder="dd-mm-yyyy" value=""
                                                style="min-width:100px;" />
                                        </td>
                                    @endisset
                                    </tr>
    @endfor
    </tbody>
    </table>
    </div>

    <!-- -------------//DET------------ -->
    <p class="mb-1 mt-3" id="eng_two_lang_checks">
        <label class="checkbox-inline" style="margin-right: 5px;cursor:pointer;">
            <input type="checkbox" value="" @if ($det_overall_score) checked @endif id="DET_checkbox"
                onclick="show_hide_det('DET')"> DET
        </label>
    </p>
    <div class="table-responsive mt-4" id="det_lang_table"
        @if (!$det_overall_score) style="display: none;" @endif>
        <table class="table">
            <thead>
                <tr>
                    {{-- <th>Exam</th> --}}
                    <th>Overall Score</th>
                    <th>Score expiry Date</th>
                </tr>
            </thead>
            <tbody>
                <tr id="DET" @if (!$det_overall_score) style="display: none;" @endif>
                    {{-- <td>DET</td> --}}
                    <td>
                        <input type="number" name='det_overall_score' class='form-control' step="0.01"
                            value="{{ $det_overall_score }}" />
                    </td>
                    <td>
                        <input type="text" name='det_expiry_date' class='form-control mydatepicker'
                            placeholder="dd-mm-yyyy"
                            @if ($det_expiry_date) value="{{ date('d-m-Y', strtotime($det_expiry_date)) }}" @endif
                            style="min-width:100px;" />
                    </td>
                </tr>
            </tbody>
        </table>
    </div>

    <!-- -------------//ACT------------ -->
    <p class="mb-1 mt-3" id="eng_three_lang_checks">
        <label class="checkbox-inline" style="margin-right: 5px;cursor:pointer;">
            <input type="checkbox" value="" @if ($act_overall_score || $act_math || $act_reading || $act_writing || $act_science || $act_english) checked @endif
                id="ACT_checkbox" onclick="show_hide_act('ACT')"> ACT
        </label>
    </p>
    <div class="table-responsive mt-4" id="act_lang_table"
        @if (!($act_overall_score || $act_math || $act_reading || $act_writing || $act_science || $act_english)) style="display: none;" @endif>
        <table class="table">
            <thead>
                <tr>
                    {{-- <th>Exam</th> --}}
                    <th>Overall Score</th>
                    <th>Math</th>
                    <th>Reading</th>
                    <th>Writing</th>
                    <th>Science</th>
                    <th>English</th>
                    <th>Score expiry Date</th>
                </tr>
            </thead>
            <tbody>
                <tr id="ACT" @if (!($act_overall_score || $act_math || $act_reading || $act_writing || $act_science || $act_english)) style="display: none;" @endif>
                    {{-- <td>ACT</td> --}}
                    <td>
                        <input type="number" name='act_overall_score' class='form-control' step="0.01"
                            value="{{ $act_overall_score }}" />
                    </td>
                    <td>
                        <input type="number" name='act_math' class='form-control' step="0.01" value="{{ $act_math }}" />
                    </td>
                    <td>
                        <input type="number" name='act_reading' class='form-control' step="0.01"
                            value="{{ $act_reading }}" />
                    </td>
                    <td>
                        <input type="number" name='act_writing' class='form-control' step="0.01"
                            value="{{ $act_writing }}" />
                    </td>
                    <td>
                        <input type="number" name='act_science' class='form-control' step="0.01"
                            value="{{ $act_science }}" />
                    </td>
                    <td>
                        <input type="number" name='act_english' class='form-control' step="0.01"
                            value="{{ $act_english }}" />
                    </td>
                    <td>
                        <input type="text" name='act_expiry_date' class='form-control mydatepicker'
                            placeholder="dd-mm-yyyy"
                            @if ($act_expiry_date) value="{{ date('d-m-Y', strtotime($act_expiry_date)) }}" @endif
                            style="min-width:100px;" />
                    </td>
                </tr>
            </tbody>
        </table>
    </div>

    <!-- -------------//SAT------------ -->
    <p class="mb-1 mt-3" id="eng_four_lang_checks">
        <label class="checkbox-inline" style="margin-right: 5px;cursor:pointer;">
            <input type="checkbox" value="" @if ($sat_overall_score || $sat_math || $sat_reading || $sat_writing || $sat_essay) checked @endif
                id="SAT_checkbox" onclick="show_hide_sat('SAT')"> SAT
        </label>
    </p>
    <div class="table-responsive mt-4" id="sat_lang_table"
        @if (!($sat_overall_score || $sat_math || $sat_reading || $sat_writing || $sat_essay)) style="display: none;" @endif>
        <table class="table">
            <thead>
                <tr>
                    {{-- <th>Exam</th> --}}
                    <th>Overall Score</th>
                    <th>Math</th>
                    <th>Reading</th>
                    <th>Writing</th>
                    <th>Essay</th>
                    <th>Score expiry Date</th>
                </tr>
            </thead>
            <tbody>
                <tr id="SAT" @if (!($sat_overall_score || $sat_math || $sat_reading || $sat_writing || $sat_essay)) style="display: none;" @endif>
                    {{-- <td>SAT</td> --}}
                    <td>
                        <input type="number" name='sat_overall_score' class='form-control' step="0.01"
                            value="{{ $sat_overall_score }}" />
                    </td>
                    <td>
                        <input type="number" name='sat_math' class='form-control' step="0.01" value="{{ $sat_math }}" />
                    </td>
                    <td>
                        <input type="number" name='sat_reading' class='form-control' step="0.01"
                            value="{{ $sat_reading }}" />
                    </td>
                    <td>
                        <input type="number" name='sat_writing' class='form-control' step="0.01"
                            value="{{ $sat_writing }}" />
                    </td>
                    <td>
                        <input type="number" name='sat_essay' class='form-control' step="0.01" value="{{ $sat_essay }}" />
                    </td>
                    <td>
                        <input type="text" name='sat_expiry_date' class='form-control mydatepicker'
                            placeholder="dd-mm-yyyy"
                            @if ($sat_expiry_date) value="{{ date('d-m-Y', strtotime($sat_expiry_date)) }}" @endif
                            style="min-width:100px;" />
                    </td>
                </tr>
            </tbody>
        </table>
    </div>

    <p class="mb-1 mt-3" id="gre_gmat_lang_checks">
        <label class="checkbox-inline" style="margin-right: 5px;cursor:pointer;">
            <input type="checkbox" value="" @if (
                $exam['gre']['total_score'] ||
                    $exam['gre']['verbal'] ||
                    $exam['gre']['quantitative'] ||
                    $exam['gre']['analytical'] ||
                    $exam['gre']['integrated']
            ) checked @endif
                id="GRE_checkbox" onclick="show_hide_gre_gmat('GRE')"> GRE
        </label>
        <label class="checkbox-inline" style="margin-right: 5px;cursor:pointer;">
            <input type="checkbox" value="" @if (
                $exam['gmat']['total_score'] ||
                    $exam['gmat']['verbal'] ||
                    $exam['gmat']['quantitative'] ||
                    $exam['gmat']['analytical'] ||
                    $exam['gmat']['integrated']
            ) checked @endif
                id="GMAT_checkbox" onclick="show_hide_gre_gmat('GMAT')"> GMAT
        </label>
    </p>
    <div class="table-responsive mt-4" id="gre_gmat_lang_table"
        @if (
            !(
                $exam['gmat']['total_score'] ||
                $exam['gmat']['verbal'] ||
                $exam['gmat']['quantitative'] ||
                $exam['gmat']['analytical'] ||
                $exam['gmat']['integrated'] ||
                $exam['gre']['total_score'] ||
                $exam['gre']['verbal'] ||
                $exam['gre']['quantitative'] ||
                $exam['gre']['analytical'] ||
                $exam['gre']['integrated']
            )) style="display: none;" @endif>
        <table class="table">
            <thead>
                <tr>
                    <th>Exam</th>
                    <th>Total Score</th>
                    <th>Verbal Reasoning</th>
                    <th>Quantitative</th>
                    <th>Analytical</th>
                    <th>Integrated</th>
                    <th>Expiry Date</th>
                </tr>
            </thead>
            <tbody>
                <tr id="GRE" @if (
                    !(
                        $exam['gre']['total_score'] ||
                        $exam['gre']['verbal'] ||
                        $exam['gre']['quantitative'] ||
                        $exam['gre']['analytical'] ||
                        $exam['gre']['integrated']
                    )) style="display: none;" @endif>
                    <td>GRE</td>
                    <td>
                        <input type="number" name="exam[gre][total_score]" class="form-control" step="0.01"
                            value="{{ $exam['gre']['total_score'] }}" onkeyup='validnum(this.value,"total_gre");'
                            onkeypress="return onlyNumberKey(event)" autocomplete="off" />
                        <span id="total_gre_err" class="text-danger d-none" style="font-size: 10px;">GRE Total score
                            range is: 260 to
                            340</span>
                    </td>
                    <td>
                        <input type="number" name="exam[gre][verbal]" class="form-control" step="0.01"
                            value="{{ $exam['gre']['verbal'] }}" onkeyup='validnum(this.value,"verbal_gre");'
                            onkeypress="return onlyNumberKey(event)" autocomplete="off" />
                        <span id="verbal_gre_err" class="text-danger d-none" style="font-size: 10px;">GRE Verbal
                            Reasoning range is: 130 to
                            170</span>
                    </td>
                    <td>
                        <input type="number" name="exam[gre][quantitative]" class="form-control" step="0.01"
                            value="{{ $exam['gre']['quantitative'] }}" onkeyup='validnum(this.value,"quant_gre");'
                            onkeypress="return onlyNumberKey(event)" autocomplete="off" />
                        <span id="quant_gre_err" class="text-danger d-none" style="font-size: 10px;">GRE Quantitative
                            range is: 130 to
                            170</span>
                    </td>
                    <td>
                        <input type="number" name="exam[gre][analytical]" class="form-control" step="0.01"
                            value="{{ $exam['gre']['analytical'] }}" onkeyup='validnum(this.value,"ana_gre");'
                            onkeypress="return onlyNumberKey(event)" autocomplete="off" />
                        <span id="ana_gre_err" class="text-danger d-none" style="font-size: 10px;">GRE Analytical
                            score range is: 0 to
                            6</span>
                    </td>
                    <td>
                        <input type="number" name="exam[gre][integrated]" class="form-control" step="0.01"
                            value="{{ $exam['gre']['integrated'] }}" onkeyup='validnum(this.value,"inte_gre");'
                            onkeypress="return onlyNumberKey(event)" autocomplete="off" />
                        <span id="inte_gre_err" class="text-danger d-none" style="font-size: 10px;">GRE Integrated
                            score range is: 260 to
                            340</span>
                    </td>
                    <td>
                        <input type="text" name="exam[gre][expiry_date]" class="form-control mydatepicker"
                            placeholder="dd-mm-yyyy"
                            @if ($exam['gre']['expiry_date']) value="{{ date('d-m-Y', strtotime($exam['gre']['expiry_date'])) }}" @endif
                            style="min-width:120px;" autocomplete="off" />
                    </td>

                </tr>
                <tr id="GMAT"@if (
                    !(
                        $exam['gmat']['total_score'] ||
                        $exam['gmat']['verbal'] ||
                        $exam['gmat']['quantitative'] ||
                        $exam['gmat']['analytical'] ||
                        $exam['gmat']['integrated']
                    )) style="display: none;" @endif>
                    <td>GMAT</td>
                    <td>
                        <input type="number" name="exam[gmat][total_score]" class="form-control" step="0.01"
                            value="{{ $exam['gmat']['total_score'] }}" onkeyup='validnum(this.value,"total_gmat");'
                            onkeypress="return onlyNumberKey(event)" autocomplete="off" />
                        <span id="total_gmat_err" class="text-danger d-none" style="font-size: 10px;">GMAT Total score
                            range is: 200 to
                            800</span>
                    </td>
                    <td>
                        <input type="number" name="exam[gmat][verbal]" class="form-control" step="0.01"
                            value="{{ $exam['gmat']['verbal'] }}" onkeyup='validnum(this.value,"verbal_gmat");'
                            onkeypress="return onlyNumberKey(event)" autocomplete="off" />
                        <span id="verbal_gmat_err" class="text-danger d-none" style="font-size: 10px;">GMAT Verbal
                            Reasoning range is: 0 to
                            60</span>
                    </td>
                    <td>
                        <input type="number" name="exam[gmat][quantitative]" class="form-control" step="0.01"
                            value="{{ $exam['gmat']['quantitative'] }}" onkeyup='validnum(this.value,"quant_gmat");'
                            onkeypress="return onlyNumberKey(event)" autocomplete="off" />
                        <span id="quant_gmat_err" class="text-danger d-none" style="font-size: 10px;">GMAT
                            Quantitative range is: 0 to
                            60</span>
                    </td>
                    <td>
                        <input type="number" name="exam[gmat][analytical]" class="form-control" step="0.01"
                            value="{{ $exam['gmat']['analytical'] }}" onkeyup='validnum(this.value,"ana_gmat");'
                            onkeypress="return onlyNumberKey(event)" autocomplete="off" />
                        <span id="ana_gmat_err" class="text-danger d-none" style="font-size: 10px;">GMAT Analytical
                            score range is: 0 to
                            6</span>
                    </td>
                    <td>
                        <input type="number" name="exam[gmat][integrated]" class="form-control" step="0.01"
                            value="{{ $exam['gmat']['integrated'] }}" onkeyup='validnum(this.value,"inte_gmat");'
                            onkeypress="return onlyNumberKey(event)" autocomplete="off" />
                        <span id="inte_gmat_err" class="text-danger d-none" style="font-size: 10px;">GMAT Integrated
                            score range is: 1 to
                            8</span>
                    </td>
                    <td>
                        <input type="text" name="exam[gmat][expiry_date]" class="form-control mydatepicker"
                            placeholder="dd-mm-yyyy"
                            @if ($exam['gmat']['expiry_date']) value="{{ date('d-m-Y', strtotime($exam['gmat']['expiry_date'])) }}" @endif
                            style="min-width:120px;" autocomplete="off" />
                    </td>
                </tr>
            </tbody>
        </table>
    </div>

    <h5 class="mt-3">Other Language Certifications</h5>
    @php
        $languages = ['German', 'French', 'Spanish', 'Japanese'];
    @endphp
    <p class="mb-1" id="other_lang_checks">
        <label class="checkbox-inline" style="margin-right: 5px;cursor:pointer;">
            <input type="checkbox" value="" @if (isset($lang[$languages[0]]) &&
                    ($lang[$languages[0]]['level'] ||
                        $lang[$languages[0]]['overall_score'] ||
                        $lang[$languages[0]]['speaking'] ||
                        $lang[$languages[0]]['reading'] ||
                        $lang[$languages[0]]['writing'] ||
                        $lang[$languages[0]]['institute'] ||
                        $lang[$languages[0]]['listening'])) checked @endif id="german"
                onclick="show_hide_lang('german')"> German
        </label>
        <label class="checkbox-inline" style="margin-right: 5px;cursor:pointer;">
            <input type="checkbox" value="" @if (isset($lang[$languages[1]]) &&
                    ($lang[$languages[1]]['level'] ||
                        $lang[$languages[1]]['overall_score'] ||
                        $lang[$languages[1]]['speaking'] ||
                        $lang[$languages[1]]['reading'] ||
                        $lang[$languages[1]]['writing'] ||
                        $lang[$languages[1]]['institute'] ||
                        $lang[$languages[1]]['listening'])) checked @endif id="french"
                onclick="show_hide_lang('french')"> French
        </label>
        <label class="checkbox-inline" style="margin-right: 5px;cursor:pointer;">
            <input type="checkbox" value="" @if (isset($lang[$languages[2]]) &&
                    ($lang[$languages[2]]['level'] ||
                        $lang[$languages[2]]['overall_score'] ||
                        $lang[$languages[2]]['speaking'] ||
                        $lang[$languages[2]]['reading'] ||
                        $lang[$languages[2]]['writing'] ||
                        $lang[$languages[2]]['institute'] ||
                        $lang[$languages[2]]['listening'])) checked @endif id="spanish"
                onclick="show_hide_lang('spanish')"> Spanish
        </label>
        <label class="checkbox-inline" style="margin-right: 5px;cursor:pointer;">
            <input type="checkbox" value="" @if (isset($lang[$languages[3]]) &&
                    ($lang[$languages[3]]['level'] ||
                        $lang[$languages[3]]['overall_score'] ||
                        $lang[$languages[3]]['speaking'] ||
                        $lang[$languages[3]]['reading'] ||
                        $lang[$languages[3]]['writing'] ||
                        $lang[$languages[3]]['institute'] ||
                        $lang[$languages[3]]['listening'])) checked @endif id="japanese"
                onclick="show_hide_lang('japanese')"> Japanese
        </label>
    </p>
    <div class="table-responsive" id="other_lang_table"
        @if (
            !(
                @isset($lang[$languages[0]]) ||
                @isset($lang[$languages[1]]) ||
                @isset($lang[$languages[2]]) ||
                @isset($lang[$languages[3]])
            )) style="display: none;" @endif>
        <table class="table">
            <thead>
                <tr>
                    <th>Language</th>
                    <th>Level</th>
                    <th>Overall Score</th>
                    <th>Speaking</th>
                    <th>Reading</th>
                    <th>Listening</th>
                    <th>Writing</th>
                    <th>Institute</th>
                </tr>
            </thead>
            <tbody>
                @for ($i = 0; $i < count($languages); $i++)
                    <tr id="{{ strtolower($languages[$i]) }}_tr"
                        @if (
                            !(isset($lang[$languages[$i]]) &&
                                ($lang[$languages[$i]]['level'] ||
                                    $lang[$languages[$i]]['overall_score'] ||
                                    $lang[$languages[$i]]['speaking'] ||
                                    $lang[$languages[$i]]['reading'] ||
                                    $lang[$languages[$i]]['writing'] ||
                                    $lang[$languages[$i]]['institute'] ||
                                    $lang[$languages[$i]]['listening'])
                            )) style="display: none;" @endif>
                        <td>{{ $languages[$i] }}</td>

                        @isset($lang[$languages[$i]])
                            <td>
                                <input type="number" name='lang[<?= $languages[$i] ?>][level]' class='form-control' step="0.01"
                                    value="{{ $lang[$languages[$i]]['level'] }}" />
                            </td>
                            <td>
                                <input type="number" name='lang[<?= $languages[$i] ?>][overall_score]' step="0.01"
                                    class='form-control' value="{{ $lang[$languages[$i]]['overall_score'] }}" />
                            </td>
                            <td>
                                <input type="number" name='lang[<?= $languages[$i] ?>][speaking]' class='form-control' step="0.01"
                                    value="{{ $lang[$languages[$i]]['speaking'] }}" />
                            </td>
                            <td>
                                <input type="number" name='lang[<?= $languages[$i] ?>][reading]' class='form-control' step="0.01"
                                    value="{{ $lang[$languages[$i]]['reading'] }}" />
                            </td>
                            <td>
                                <input type="number" name='lang[<?= $languages[$i] ?>][listening]' class='form-control' step="0.01"
                                    value="{{ $lang[$languages[$i]]['listening'] }}" />
                            </td>
                            <td>
                                <input type="number" name='lang[<?= $languages[$i] ?>][writing]' class='form-control' step="0.01"
                                    value="{{ $lang[$languages[$i]]['writing'] }}" />
                            </td>
                            <td>
                                <input type="text" name='lang[<?= $languages[$i] ?>][institute]' class='form-control' step="0.01"
                                    value="{{ $lang[$languages[$i]]['institute'] }}" style="min-width:100px;" />
                            </td>
                        @else
                            <td>
                                <input type="number" name='lang[<?= $languages[$i] ?>][level]' class='form-control' step="0.01"
                                    value="" />
                            </td>
                            <td>
                                <input type="number" name='lang[<?= $languages[$i] ?>][overall_score]' step="0.01"
                                    class='form-control' value="" />
                            </td>
                            <td>
                                <input type="text" name='lang[<?= $languages[$i] ?>][speaking]' class='form-control' step="0.01"
                                    value="" />
                            </td>
                            <td>
                                <input type="number" name='lang[<?= $languages[$i] ?>][reading]' class='form-control' step="0.01"
                                    value="" />
                            </td>
                            <td>
                                <input type="number" name='lang[<?= $languages[$i] ?>][listening]' class='form-control' step="0.01"
                                    value="" />
                            </td>
                            <td>
                                <input type="number" name='lang[<?= $languages[$i] ?>][writing]' class='form-control' step="0.01"
                                    value="" />
                            </td>
                            <td>
                                <input type="text" name='lang[<?= $languages[$i] ?>][institute]' class='form-control' step="0.01"
                                    value="" style="min-width:100px;" />
                            </td>
                        @endisset
                    </tr>
                @endfor

            </tbody>
        </table>
    </div>

    <div class="mt-4 text-center">
        <button type="submit" class="btn btn-primary" style="padding-left:40px;padding-right:40px;">Save</button>
    </div>
    </div>
    </form>
    </div>
    </div>
    {{-- </div> --}}

    <div class="card border" style="margin-bottom:0;margin-top:30px;">
        <div class="card-header">
            <h4 class="m-b-0" style="font-weight: 700 !important;">Internships</h4>
        </div>
        <div>
            <input type="hidden" name="user_id" value="{{ $user->id }}">
            <div class=" card-body">
                <div class="table-responsive mt-4">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Company Name</th>
                                <th>Duration</th>
                                <th>Place</th>
                                <th style="width:200px;">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if (count($internships) != 0)
                                @php
                                    $i = 0;
                                @endphp
                                @foreach ($internships as $internship)
                                    <tr>
                                        <td>
                                            {{ $internship['company'] }}
                                        </td>
                                        <td>
                                            {{ $internship['duration'] }}
                                        </td>
                                        <td>
                                            {{ Str::ucfirst($internship['place']) }}
                                        </td>
                                        <td>
                                            <div class="d-flex justify-content-center">
                                                <button id="data-id"
                                                    class="btn btn-sm btn-outline-primary editProfileInternship "
                                                    data-id="{{ $internship['id'] }}" data-placement="top"
                                                    title="Edit"><i class="fa fa-edit"></i> Edit
                                                </button>


                                                <form action="{{ route('admin.profile.internship_information.delete') }}" method="POST"
                                                    onSubmit="if(!confirm('Are you sure want to delete this Internship Information?')){return false;}">
                                                    @csrf
                                                    <input type="hidden" name="id"
                                                        value="{{ $internship['id'] }}">
                                                    <input type="hidden" name="userid"
                                                        value="{{ $internship['userid'] }}">

                                                    <button title="Delete" type="submit"
                                                        class="btn btn-sm btn-outline-danger ms-1"><i
                                                            class="fa fa-trash"></i> Delete</button>
                                                </form>

                                            </div>
                                        </td>
                                    </tr>
                                    @php
                                        $i++;
                                    @endphp
                                @endforeach
                            @else
                                <tr>
                                    <td colspan="11" class="text-center">No Records Found
                                    </td>
                                </tr>
                            @endif
                        </tbody>
                    </table>
                </div>

                @if (count($internships) != 0)

                    <button class="btn btn-primary addProfileinternship" data-placement="top" title="Add More"><i
                            class="fa fa-plus"></i> Add More</button>
                @else
                    <button class="btn btn-primary addProfileinternship" data-placement="top" title="Add More"><i
                            class="fa fa-plus"></i> Add New</button>

                @endif
            </div>
        </div>
    </div>

    <div class="card border" style="margin-bottom:0;margin-top:30px;">
        <div class="card-header">
            <h4 class="m-b-0" style="font-weight: 700 !important;">Other Courses Completed</h4>
        </div>
        <div class="d-flex">
            <input type="hidden" name="user_id" value="{{ $user->id }}">
            <div class=" card-body">
                <div class="table-responsive mt-4">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Course</th>
                                <th>Duration</th>
                                <th>Certificate Issued Authority</th>
                                <th style="width:200px;">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if (count($courses) != 0)
                                @php
                                    $i = 0;
                                @endphp
                                @foreach ($courses as $course)
                                    <tr>
                                        <td>
                                            {{ $course['course'] }}
                                        </td>
                                        <td>
                                            {{ $course['duration'] }}
                                        </td>
                                        <td>
                                            {{ $course['institute'] }}
                                        </td>
                                        <td>
                                            <div class="d-flex justify-content-center">
                                                <button id="data-id"
                                                    class="btn btn-sm btn-outline-primary editProfileCourse "
                                                    data-id="{{ $course['id'] }}" data-placement="top"
                                                    title="Edit"><i class="fa fa-edit"></i> Edit
                                                </button>


                                                <form action="{{ route('admin.profile.course_information.delete') }}" method="POST"
                                                    onSubmit="if(!confirm('Are you sure want to delete This Other Course Information?')){return false;}">
                                                    @csrf
                                                    <input type="hidden" name="id"
                                                        value="{{ $course['id'] }}">
                                                    <input type="hidden" name="userid"
                                                        value="{{ $course['userid'] }}">

                                                    <button title="Delete" type="submit"
                                                        class="btn btn-sm btn-outline-danger ms-1"><i
                                                            class="fa fa-trash"></i> Delete</button>
                                                </form>

                                            </div>
                                        </td>
                                    </tr>
                                    @php
                                        $i++;
                                    @endphp
                                @endforeach
                            @else
                                <tr>
                                    <td colspan="11" class="text-center">No Records Found
                                    </td>
                                </tr>
                            @endif
                        </tbody>
                    </table>
                </div>

                @if (count($courses) != 0)

                    <button class="btn btn-primary addProfileCourse" data-placement="top" title="Add More"><i
                            class="fa fa-plus"></i> Add More</button>
                @else
                    <button class="btn btn-primary addProfileCourse" data-placement="top" title="Add More"><i
                            class="fa fa-plus"></i> Add New</button>

                @endif
            </div>
        </div>
    </div>
    {{-- </form> --}}
    </div>
    {{-- </div> --}}

    <div class="card border" style="margin-top:30px;">

        <div class="card-header ">
            <h4 class="m-b-0" style="font-weight: 700 !important;">Employment History</h4>
        </div>

        <div class="card-body">
            <div id="employment" class="mt-4 table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th style="min-width: 120px !important;">Employment Type</th>
                            <th style="min-width: 120px !important;">Currently Working</th>
                            <th style="min-width: 130px">Organisation Name</th>
                            <th style="min-width: 90px !important;">Industry Type</th>
                            <th style="min-width: 120px !important;">Employer Phone</th>
                            <th style="min-width: 120px !important;">Street Address</th>
                            <th style="min-width: 70px !important;">Country</th>
                            <th style="min-width: 70px !important;">State</th>
                            <th style="min-width: 70px !important;">City</th>
                            <th style="min-width: 70px !important;">Post Code</th>
                            <th style="min-width: 120px !important;">Contact Person Name</th>
                            <th style="min-width: 120px;">Contact Person Business Phone</th>
                            <th style="min-width: 120px;">Contact Person Mobile No</th>
                            <th style="min-width: 130px;">Your Working Position Designation</th>
                            <th style="min-width: 120px;">Date Start From</th>
                            <th style="min-width: 120px;">Date Working Ended</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @if (count($profile_employment_details) != 0)
                            @foreach ($profile_employment_details as $profile_employment_detail)
                                <tr>
                                    <td>{{ $profile_employment_detail->employment_histroy_type }}</td>
                                    <td>{{ $profile_employment_detail->employment_history_currently_working }}</td>
                                    <td>{{ $profile_employment_detail->employment_history_organisation_name }}</td>
                                    <td>{{ $profile_employment_detail->employment_history_industry_type }}</td>
                                    <td>{{ $profile_employment_detail->employment_history_employer_phone }}</td>
                                    <td>{{ $profile_employment_detail->employment_history_address }}</td>
                                    <td>{{ get_country_name($profile_employment_detail->employment_history_country) }}
                                    </td>
                                    <td>{{ get_state_name($profile_employment_detail->employment_history_state) }}</td>
                                    <td>{{ $profile_employment_detail->employment_history_city }}</td>
                                    <td>{{ $profile_employment_detail->employment_history_postcode }}</td>
                                    <td>{{ $profile_employment_detail->employment_history_contact_person_name }}</td>
                                    <td>{{ $profile_employment_detail->employment_history_contact_person_business_phone }}
                                    </td>
                                    <td>{{ $profile_employment_detail->employment_history_contact_person_mobile_number }}
                                    </td>
                                    <td>{{ $profile_employment_detail->employment_history_working_position_occupation }}
                                    </td>
                                    <td>
                                        @if ($profile_employment_detail->employment_history_start_date)
                                            {{ date('d M Y', strtotime($profile_employment_detail->employment_history_start_date)) }}
                                        @endif
                                    </td>
                                    <td>
                                        @if ($profile_employment_detail->employment_history_working_ended)
                                            {{ date('d M Y', strtotime($profile_employment_detail->employment_history_working_ended)) }}
                                        @endif
                                    </td>
                                    <td>
                                        <div class="d-flex">
                                            <button class="btn btn-sm btn-primary editEmployment "
                                                data-id="{{ $profile_employment_detail->id }}" data-toggle="tooltip"
                                                data-placement="top" title="Edit"><i
                                                    class="fa fa-edit"></i></button>

                                            <form action="{{ route('admin.profile.employment_information.delete') }}" method="POST"
                                                onSubmit="if(!confirm('Are you sure want to delete this Employment History?')){return false;}">
                                                @csrf
                                                <input type="hidden" name="id"
                                                    value="{{ $profile_employment_detail->id }}">
                                                <button title="Delete" type="submit"
                                                    class="btn btn-sm btn-outline-danger"><i
                                                        class="fa fa-trash ms-1"></i></button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        @else
                            <tr>
                                <td colspan="18" class="text-center">No Record Found
                                </td>
                            </tr>
                        @endif
                    </tbody>
                </table>

            </div>
            @if (count($profile_employment_details) == 0)
                <button class="btn btn-primary mt-2 addEmployment" data-placement="top"
                    title="Add Unemployment History"><i class="fa fa-plus"></i> Add Employment History</button>
            @else
                <button class="btn btn-primary mt-2 addEmployment" data-placement="top" title="Add More"><i
                        class="fa fa-plus"></i> Add More</button>
            @endif
        </div>
    </div>

    <div class="card border">
        <div class="card-header ">
            <h4 class="m-b-0" style="font-weight: 700 !important;">Visa Application History</h4>
        </div>

        <div class="card-body">
            <div id="employment" class="mt-4 table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Country Applied For</th>
                            <th>Name Used</th>
                            <th>Visa Name/Type</th>
                            <th>Application Date</th>
                            <th>Application Number</th>
                            <th>Outcome</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @if (count($visa_application_history) != 0)
                            @foreach ($visa_application_history as $application_history)
                                <tr>
                                    <td>{{ get_country_name($application_history->country_applied_for_visa) }}</td>
                                    <td>{{ $application_history->name_used_for_visa_apply }}</td>
                                    <td>{{ $application_history->visa_apply_visa_type }}</td>
                                    <td>
                                        @if ($application_history->visa_apply_application_date)
                                            {{ date('d M Y', strtotime($application_history->visa_apply_application_date)) }}
                                        @endif
                                    </td>
                                    <td>{{ $application_history->visa_apply_application_number }}</td>
                                    <td>{{ $application_history->visa_apply_outcome }}</td>
                                    <td class="d-flex">
                                        <button class="btn btn-sm btn-primary editVisaHistory "
                                            data-id="{{ $application_history->id }}" data-toggle="tooltip"
                                            data-placement="top" title="Edit"><i class="fa fa-edit"></i></button>
                                        <form action="{{ route('admin.profile.visa_information.delete') }}" method="POST"
                                            onSubmit="if(!confirm('Are you sure want to delete this Visa Application History?')){return false;}">
                                            @csrf
                                            <input type="hidden" name="id"
                                                value="{{ $application_history->id }}">
                                                <input type="hidden" name="userid"
                                                value="{{ $application_history->user_id }}">
                                            <button title="Delete" type="submit"
                                                class="btn btn-sm btn-outline-danger ms-1"><i
                                                    class="fa fa-trash"></i></button>
                                        </form>
                                    </td>
                                </tr>
                            @endforeach
                        @else
                            <tr>
                                <td colspan="8" class="text-center">No Record Found
                                </td>
                            </tr>
                        @endif
                    </tbody>
                </table>
                @if (count($visa_application_history) == 0)

                    <button class="btn btn-primary addVisaHistory" data-placement="top" title="Add Travel History"><i
                            class="fa fa-plus"></i> Add Visa History</button>
                @else
                    <button class="btn btn-primary addVisaHistory" data-placement="top" title="Add More"><i
                            class="fa fa-plus"></i> Add More</button>

                @endif
            </div>

        </div>

        @endif
    </div>
    

    <div class="card border">


        <div class="card-header ">
            <h4 class="m-b-0" style="font-weight: 700 !important;">International Travel History</h4>
        </div>

        <div class="card-body">
            <div id="employment" class="mt-4 table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Country Visited</th>
                            <th>Name Used On Entry</th>
                            <th>Visa Type</th>
                            <th>Visa Issue At</th>
                            <th>Date From </th>
                            <th>Date Up To</th>
                            <th>Reason of Visit</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @if (count($profile_travel_historys) != 0)
                            @foreach ($profile_travel_historys as $profile_travel_history)
                                <tr>
                                    <td>{{ get_country_name($profile_travel_history->country_visited) }}</td>
                                    <td>{{ $profile_travel_history->name_used_on_country }}</td>
                                    <td>{{ $profile_travel_history->visa_type }}</td>
                                    <td>{{ $profile_travel_history->visa_issue_at }}</td>
                                    <td>
                                        @if ($profile_travel_history->date_from)
                                            {{ date('d M Y', strtotime($profile_travel_history->date_from)) }}
                                        @endif
                                    </td>
                                    <td>
                                        @if ($profile_travel_history->date_up_to)
                                            {{ date('d M Y', strtotime($profile_travel_history->date_up_to)) }}
                                        @endif
                                    </td>
                                    <td>{{ $profile_travel_history->reason_of_visit }}</td>
                                    <td class="d-flex">
                                        <button class="btn btn-sm btn-primary editTravelHistory "
                                            data-id="{{ $profile_travel_history->id }}" data-toggle="tooltip"
                                            data-placement="top" title="Edit"><i class="fa fa-edit"></i></button>
                                        <form method="POST" action="{{ route('admin.profile.travel_history.delete') }}"
                                            onSubmit="if(!confirm('Are you sure want to delete this Travel History?')){return false;}">
                                            @csrf
                                            <input type="hidden" name="id"
                                                value="{{ $profile_travel_history->id }}">
                                                <input type="hidden" name="userid"
                                                value="{{ $profile_travel_history->userid }}">
                                            <button title="Delete" type="submit"
                                                class="btn btn-sm btn-outline-danger ms-1"><i
                                                    class="fa fa-trash"></i></button>
                                        </form>
                                    </td>
                                </tr>
                            @endforeach
                        @else
                            <tr>
                                <td colspan="8" class="text-center">No Record Found
                                </td>
                            </tr>
                        @endif
                    </tbody>
                </table>
                @if (count($profile_travel_historys) == 0)
                    <button class="btn btn-primary addTravelHistory" data-placement="top"
                        title="Add Travel History"><i class="fa fa-plus"></i> Add Travel History</button>
                @else
                    <button class="btn btn-primary addTravelHistory" data-placement="top" title="Add More"><i
                            class="fa fa-plus"></i> Add More</button>
                @endif
            </div>
        </div>
    </div>

    
    <div class="card border " style="margin-top:30px;">
        <div class="card-header ">
            <h4 class="m-b-0" style="font-weight: 700 !important;">Family Details</h4>
        </div>

        {{-- </div> --}}

        <div>

            <input type="hidden" name="user_id" value="{{ $user->id }}">
            <div class=" card-body">
                <div class="table-responsive mt-4">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Relationship</th>
                                <th>Name</th>
                                <th>Email</th>
                                <th>Contact</th>
                                <th>Date of Birth</th>
                                <th>Country of Birth</th>
                                <th>Country of Residence</th>
                                <th>Action</th>


                            </tr>
                        </thead>
                        <tbody>
                            @if (count($profile_family) != 0)
                                @foreach ($profile_family as $family)
                                    <tr>
                                        <td>
                                            {{ $family->relationship }}
                                        </td>
                                        <td style="min-width: 120px;">
                                            {{ $family->first_name }} {{ $family->last_name }}</td>
                                        <td style="min-width: 120px;">
                                            {{ $family->email }}</td>
                                        <td style="min-width: 120px;">
                                            +{{ $family->dial_code }}-{{ $family->mobile }}</td>
                                        <td>{{ $family->birth_date }}
                                        </td>
                                        <td>{{ get_country_name($family->birth_country) }}
                                        </td>
                                        <td>{{ get_country_name($family->residence_country) }}
                                        </td>
                                        <td>

                                            <div class="d-flex">
                                                <button id="data-id"
                                                    class="btn btn-sm btn-outline-primary editProfileFamily "
                                                    data-id="{{ $family->id }}" data-placement="top"
                                                    title="Edit"><i class="fa fa-edit"></i>
                                                </button>

                                                <form action="{{ route('admin.family.course_information.delete') }}"
                                                    method="POST"
                                                    onSubmit="if(!confirm('Are you sure want to delete this Family Details?')){return false;}">
                                                    @csrf
                                                    <input type="hidden" name="id"
                                                        value="{{ $family->id }}">
                                                    <input type="hidden" name="userid"
                                                        value="{{ $family->userid }}">

                                                    <button title="Delete" type="submit"
                                                        class="btn btn-sm btn-outline-danger ms-1"><i
                                                            class="fa fa-trash"></i></button>
                                                </form>

                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                                
                            @else
                                <tr>
                                    <td colspan="8" class="text-center">No Records Found
                                    </td>
                                </tr>
                            @endif
                        </tbody>
                    </table>
                </div>

                @if (count($profile_family) == 0)
                    <button class="btn btn-primary addProfileFamily" data-placement="top" title="Add More"><i
                            class="fa fa-plus"></i>
                        Add New</button>
                @else
                    <button class="btn btn-primary addProfileFamily" data-placement="top" title="Add More"><i
                            class="fa fa-plus"></i>
                        Add More</button>
                @endif
            </div>
        </div>
    </div>

    </div>
    <!--col-->
    </div>
    <!--row-->
    </div>
    <!--card-body-->

    <!--   <div class="card-footer">
                                                                    <div class="row" style="text-align:center;">
                                                                        <div class="col">
                                                                            {{ form_cancel(route('admin.auth.staff'), __('buttons.general.cancel')) }}
                                                                        </div>
                                                                    </div>
                                                                </div> -->


    <!-- modal add user hidden -->
    <div class="modal fade" id="addAcademicsDetail">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Add Academic Detail</h5>
                    <button type="button" class="btn-close border" data-bs-dismiss="modal" aria-label="Close"
                        style="font-size: 12px;"></button>
                </div>
                <div class="modal-body load_modal">

                </div>
            </div>
        </div>
    </div>
    <!-- modal edit user hidden -->

    <div class="modal fade" id="editAcademicsDetail">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Edit Academic Detail</h5>
                    <button type="button" class="btn-close border" data-bs-dismiss="modal" aria-label="Close"
                        style="font-size: 12px;"></button>
                </div>
                <div class="modal-body load_modal">

                </div>
            </div>
        </div>
    </div>

    <!-- modal edit internship hidden -->
    <div class="modal fade" id="editInternshipDetail">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Edit Internship Detail</h5>
                    <button type="button" class="btn-close border" data-bs-dismiss="modal" aria-label="Close"
                        style="font-size: 12px;"></button>
                </div>
                <div class="modal-body load_modal">

                </div>
            </div>
        </div>
    </div>

    <!-- modal add internship hidden -->
    <div class="modal fade" id="addInternshipDetail">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Add Internship Detail</h5>
                    <button type="button" class="btn-close border" data-bs-dismiss="modal" aria-label="Close"
                        style="font-size: 12px;"></button>
                </div>
                <div class="modal-body load_modal">

                </div>
            </div>
        </div>
    </div>


    <!-- modal add Course hidden -->
    <div class="modal fade" id="addCourseDetail">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Add Course Details</h5>
                    <button type="button" class="btn-close border" data-bs-dismiss="modal" aria-label="Close"
                        style="font-size: 12px;"></button>
                </div>
                <div class="modal-body load_modal">

                </div>
            </div>
        </div>
    </div>
    <!-- modal edit course hidden -->
    <div class="modal fade" id="editCourseDetail">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Edit Course Detail</h5>
                    <button type="button" class="btn-close border" data-bs-dismiss="modal" aria-label="Close"
                        style="font-size: 12px;"></button>
                </div>
                <div class="modal-body load_modal">

                </div>
            </div>
        </div>
    </div>

    <!-- modal add Family hidden -->
    <div class="modal fade" id="addFamilyDetail">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Add Family Details</h5>
                    <button type="button" class="btn-close border" data-bs-dismiss="modal" aria-label="Close"
                        style="font-size: 12px;"></button>
                </div>
                <div class="modal-body load_modal">

                </div>
            </div>
        </div>
    </div>
    <!-- modal edit family hidden -->
    <div class="modal fade" id="editFamily">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Edit Family Detail</h5>
                    <button type="button" class="btn-close border" data-bs-dismiss="modal" aria-label="Close"
                        style="font-size: 12px;"></button>
                </div>
                <div class="modal-body load_modal">

                </div>
            </div>
        </div>
    </div>
    <!-- modal add employment hidden -->
    <div class="modal fade" id="addEmployment">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Add Employment History</h5>
                    <button type="button" class="btn-close border" data-bs-dismiss="modal" aria-label="Close"
                        style="font-size: 12px;"></button>
                </div>
                <div class="modal-body load_modal">

                </div>
            </div>
        </div>
    </div>
    <!-- modal edit employment hidden -->

    <div class="modal fade" id="editEmployment">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Edit Employment History</h5>
                    <button type="button" class="btn-close border" data-bs-dismiss="modal" aria-label="Close"
                        style="font-size: 12px;"></button>
                </div>
                <div class="modal-body load_modal">

                </div>
            </div>
        </div>
    </div>
    <!-- modal add Travel history hidden -->
    <div class="modal fade" id="addTravelHistory">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Add Travel History</h5>
                    <button type="button" class="btn-close border" data-bs-dismiss="modal" aria-label="Close"
                        style="font-size: 12px;"></button>
                </div>
                <div class="modal-body load_modal">

                </div>
            </div>
        </div>
    </div>
    <!-- modal edit Travel history hidden -->

    <div class="modal fade" id="editTravelHistory">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Edit Travel History</h5>
                    <button type="button" class="btn-close border" data-bs-dismiss="modal" aria-label="Close"
                        style="font-size: 12px;"></button>
                </div>
                <div class="modal-body load_modal">

                </div>
            </div>
        </div>
    </div>
    <!-- modal add Visa history hidden -->
    <div class="modal fade" id="addVisaHistory">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Add Visa History</h5>
                    <button type="button" class="btn-close border" data-bs-dismiss="modal" aria-label="Close"
                        style="font-size: 12px;"></button>
                </div>
                <div class="modal-body load_modal">

                </div>
            </div>
        </div>
    </div>

    <!-- modal edit Visa history hidden -->
    <div class="modal fade" id="editVisaHistory">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Edit Visa History</h5>
                    <button type="button" class="btn-close border" data-bs-dismiss="modal" aria-label="Close"
                        style="font-size: 12px;"></button>
                </div>
                <div class="modal-body load_modal">

                </div>
            </div>
        </div>
    </div>
    <!--card-->
    {{ html()->closeModelForm() }}
    </div>

@endsection
@push('after-scripts')
    <script>
        function syncWhatsapp() {
            if ($("#sameAsMobile").is(":checked")) {
                $("#whatsapp_number").val($("#mobile").val()).prop("readonly", true);
                $("#whatsapp_dialcode").val($("#dialcode").val()).prop("readonly", true);
                $("#whatsapp_dialcode").trigger('change');
            } else {
                $("#whatsapp_number").prop("readonly", false);
                $("#whatsapp_dialcode").prop("readonly", false);
            }
        }

        // $("#sameAsMobile").prop("checked", true);

        syncWhatsapp();                                
        $("#mobile, #dialcode").on("input change", syncWhatsapp);
        $("#sameAsMobile").on("change", syncWhatsapp);
    </script>
    <script>
        $(document).ready(function() {
            $('.dobmydatepicker').datetimepicker({
                timepicker: false,
                format: 'd-m-Y',
                scrollInput: false,
                maxDate: new Date()
            });
            $('#country-dd').on('change', function() {
                var idCountry = this.value;
                $("#state-dd").html('');
                $.ajax({
                    url: "{{ url('api/fetch-states') }}",
                    type: "POST",
                    data: {
                        country_id: idCountry,
                        _token: '{{ csrf_token() }}'
                    },
                    dataType: 'json',
                    success: function(result) {
                        $('#state-dd').html('<option value="">Select State</option>');
                        $.each(result.states, function(key, value) {
                            if (value.id == "{{ $user->state }}") {
                                var selectedState = "selected=\"'selected'\"";
                            } else if (value.id == "{{ old('state') }}") {
                                var selectedState = "selected=\"'selected'\"";
                            } else {
                                var selectedState = "";
                            }
                            $("#state-dd").append('<option ' + selectedState +
                                ' value="' + value.id + '">' + value.name +
                                '</option>');
                        });
                    }
                });
            });
            $('#state-dd').on('change', function() {
                var idState = this.value != '' ? this.value : '{{ $user->state }}';
            console.log({
                "thisvalue on state": this.value,
                "userstate": '{{ $user->state }}'
            });

                        $("#city").html('');
                $.ajax({
                    url: "{{ url('api/fetch-cities') }}",
                    type: "POST",
                    data: {
                        state_id: idState,
                        _token: '{{ csrf_token() }}'
                    },
                    dataType: 'json',
                    success: function(res) {
                        $('#city').html('<option value="">Select City</option>');

                        var userCity = '{{ $user->city }}';

                        $.each(res.cities, function(key, value) {
                            console.log("City ID:", value.id);
                            console.log("City Name:", value.name);
                            console.log("User's City ID:", userCity);

                            var selected = (value.id == userCity) ? 'selected' : '';

                            console.log("User's selected:", selected);

                            $("#city").append(
                '<option value="' + value.id + '" ' + selected + '>' + value.name + '</option>'
            );
                        });
                    }
                });
            });

            // trigger change
            $('#country-dd').trigger('change');
            $('#state-dd').trigger('change');
            $('#city').trigger('change');
            // for emergency contact
            $('#emergency_country-dd').on('change', function() {
                var idCountry = this.value;
                $("#emergency_state-dd").html('');
                $.ajax({
                    url: "{{ url('api/fetch-states') }}",
                    type: "POST",
                    data: {
                        country_id: idCountry,
                        _token: '{{ csrf_token() }}'
                    },
                    dataType: 'json',
                    success: function(result) {
                        $('#emergency_state-dd').html('<option value="">Select State</option>');
                        $.each(result.states, function(key, value) {
                            if (value.id == "{{ $user->state }}") {
                                var selectedState = "selected=\"'selected'\"";
                            } else if (value.id == "{{ old('state') }}") {
                                var selectedState = "selected=\"'selected'\"";
                            } else {
                                var selectedState = "";
                            }
                            $("#emergency_state-dd").append('<option ' + selectedState +
                                ' value="' + value.id + '">' + value.name +
                                '</option>');
                        });
                    }
                });
            });

            var emergency_country = document.getElementById('emergency_country-dd').value;
            if (emergency_country) {
                $.ajax({
                    url: "{{ url('api/fetch-states') }}",
                    type: "POST",
                    data: {
                        country_id: emergency_country,
                        _token: '{{ csrf_token() }}'
                    },
                    dataType: 'json',
                    success: function(result) {
                        $('#emergency_state-dd').html('<option value="">Select State</option>');
                        $.each(result.states, function(key, value) {
                            if (value.id == "{{ $userDetails->emergency_state }}") {
                                var selectedState = "selected=\"'selected'\"";
                            } else if (value.id == "{{ old('emergency_state') }}") {
                                var selectedState = "selected=\"'selected'\"";
                            } else {
                                var selectedState = "";
                            }
                            $("#emergency_state-dd").append('<option ' + selectedState +
                                ' value="' + value.id + '">' + value.name +
                                '</option>');
                        });
                    }
                });

            }
            //adding profile academics
            $('.addProfileAcademics').on('click', function() {
                var base_url = "{{ route('admin.profile.academics_information.add') }}";
                $.get(base_url, function(data) {
                    $('#addAcademicsDetail').on('shown.bs.modal', function() {
                        $('#addAcademicsDetail .load_modal').html(data);
                        $('#add_academics_information_user_id').val({{ $user->id }});
                    });
                    $('#addAcademicsDetail').modal('show');
                    $('#addAcademicsDetail').on('hidden.bs.modal', function() {
                        $('#addAcademicsDetail .load_modal').html("");
                    });
                });
            })

            //Editing profile acedemics

            $('.editProfileAcademics').on('click', function() {

                var this_id = $(this).attr('data-id');

                var base_url = "{{ url('/admin/profile/edit_academics_details/open/') }}/" +
                    this_id;

                $.get(base_url, function(data) {
                    $('#editAcademicsDetail').on('shown.bs.modal', function() {
                        $('#editAcademicsDetail .load_modal').html(data);
                        $('#edit_academics_information_user_id').val({{ $user->id }});
                    });
                    $('#editAcademicsDetail').modal('show');
                    $('#editAcademicsDetail').on('hidden.bs.modal', function() {
                        $('#editAcademicsDetail .load_modal').html("");
                    });
                });
            });

            $('.editProfileInternship').on('click', function() {

                var this_id = $(this).attr('data-id');
                var base_url = "{{ url('/admin/profile/edit_internship_details/open/') }}/" +
                    this_id;

                $.get(base_url, function(data) {
                    $('#editInternshipDetail').on('shown.bs.modal', function() {
                        $('#editInternshipDetail .load_modal').html(data);
                        $('#edit_internship_information_user_id').val(
                            {{ $user->id }});
                    });
                    $('#editInternshipDetail').modal('show');
                    $('#editInternshipDetail').on('hidden.bs.modal', function() {
                        $('#editInternshipDetail .load_modal').html("");
                    });
                });
            });

            $('.addProfileinternship').on('click', function() {
                var base_url = "{{ route('admin.profile.internship_information.add') }}";
                $.get(base_url, function(data) {
                    $('#addInternshipDetail').on('shown.bs.modal', function() {
                        $('#addInternshipDetail .load_modal').html(data);
                        $('#add_internship_information_user_id').val({{ $user->id }});
                    });
                    $('#addInternshipDetail').modal('show');
                    $('#addInternshipDetail').on('hidden.bs.modal', function() {
                        $('#addInternshipDetail .load_modal').html("");
                    });
                });
            })

            $('.editProfileCourse').on('click', function() {

                var this_id = $(this).attr('data-id');
                var base_url = "{{ url('/admin/profile/edit_course_details/open/') }}/" +
                    this_id;

                $.get(base_url, function(data) {
                    $('#editCourseDetail').on('shown.bs.modal', function() {
                        $('#editCourseDetail .load_modal').html(data);
                        $('#edit_course_information_user_id').val(
                            {{ $user->id }});
                    });
                    $('#editCourseDetail').modal('show');
                    $('#editCourseDetail').on('hidden.bs.modal', function() {
                        $('#editCourseDetail .load_modal').html("");
                    });
                });
            });

            $('.addProfileCourse').on('click', function() {
                var base_url = "{{ route('admin.profile.course_information.add') }}";
                $.get(base_url, function(data) {
                    $('#addCourseDetail').on('shown.bs.modal', function() {
                        $('#addCourseDetail .load_modal').html(data);
                        $('#add_course_information_user_id').val({{ $user->id }});
                    });
                    $('#addCourseDetail').modal('show');
                    $('#addCourseDetail').on('hidden.bs.modal', function() {
                        $('#addCourseDetail .load_modal').html("");
                    });
                });
            })

            //adding profile Family
            $('.addProfileFamily').on('click', function() {
                var base_url = "{{ route('admin.profile.family_information.add') }}";
                $.get(base_url, function(data) {
                    $('#addFamilyDetail').on('shown.bs.modal', function() {
                        $('#addFamilyDetail .load_modal').html(data);
                        $('#add_family_information_user_id').val({{ $user->id }});
                    });
                    $('#addFamilyDetail').modal('show');
                    $('#addFamilyDetail').on('hidden.bs.modal', function() {
                        $('#addFamilyDetail .load_modal').html("");
                    });
                });
            })

            $('.editProfileFamily').on('click', function() {

                var this_id = $(this).attr('data-id');
                var base_url = "{{ url('/admin/profile/edit_family_details/open/') }}/" +
                    this_id;

                $.get(base_url, function(data) {
                    $('#editFamily').on('shown.bs.modal', function() {
                        $('#editFamily .load_modal').html(data);
                        $('#edit_family_information_user_id').val(
                            {{ $user->id }});
                    });
                    $('#editFamily').modal('show');
                    $('#editFamily').on('hidden.bs.modal', function() {
                        $('#editFamily .load_modal').html("");
                    });
                });
            });

            // Add  Employment Histroy
            $('.addEmployment').on('click', function() {
                var base_url = "{{ route('admin.profile.employment_information.add') }}";
                $.get(base_url, function(data) {
                    $('#addEmployment').on('shown.bs.modal', function() {
                        $('#addEmployment .load_modal').html(data);
                        $('#add_employment_history_user_id').val({{ $user->id }});
                    });
                    $('#addEmployment').modal('show');
                    $('#addEmployment').on('hidden.bs.modal', function() {
                        $('#addEmployment .load_modal').html("");
                    });
                });
            });

            // Edit Employment Histroy
            $('.editEmployment').on('click', function() {
                var this_id = $(this).attr('data-id');

                var base_url = "{{ url('/admin/profile/edit_employment/open/') }}/" + this_id;
                $.get(base_url, function(data) {
                    $('#editEmployment').on('shown.bs.modal', function() {
                        $('#editEmployment .load_modal').html(data);
                        $('#edit_employment_history_user_id').val({{ $user->id }});
                    });
                    $('#editEmployment').modal('show');
                    $('#editEmployment').on('hidden.bs.modal', function() {
                        $('#editEmployment .load_modal').html("");
                    });
                });
            });

            // Add and Edit Travel Histroy
            $('.addTravelHistory').on('click', function() {
                var base_url = "{{ url('/admin/profile/add_travel_history/open') }}";
                $.get(base_url, function(data) {
                    $('#addTravelHistory').on('shown.bs.modal', function() {
                        $('#addTravelHistory .load_modal').html(data);
                        $('#add_travel_history_user_id').val({{ $user->id }});
                    });
                    $('#addTravelHistory').modal('show');
                    $('#addTravelHistory').on('hidden.bs.modal', function() {
                        $('#addTravelHistory .load_modal').html("");
                    });
                });
            });

            $('.editTravelHistory').on('click', function() {
                var this_id = $(this).attr('data-id');

                var base_url = "{{ url('/admin/profile/edit_travel_history/open/') }}/" + this_id;
                $.get(base_url, function(data) {
                    $('#editTravelHistory').on('shown.bs.modal', function() {
                        $('#editTravelHistory .load_modal').html(data);
                        $('#edit_travel_history_user_id').val({{ $user->id }});
                    });
                    $('#editTravelHistory').modal('show');
                    $('#editTravelHistory').on('hidden.bs.modal', function() {
                        $('#editTravelHistory .load_modal').html("");
                    });
                });
            });

            // Add and Edit Visa Histroy
            $('.addVisaHistory').on('click', function() {

                var base_url = "{{ url('/admin/profile/add_visa_history/open') }}";
                $.get(base_url, function(data) {
                    $('#addVisaHistory').on('shown.bs.modal', function() {
                        $('#addVisaHistory .load_modal').html(data);
                        $('#add_visa_history_user_id').val({{ $user->id }});
                    });
                    $('#addVisaHistory').modal('show');
                    $('#addVisaHistory').on('hidden.bs.modal', function() {
                        $('#addVisaHistory .load_modal').html("");
                    });
                });
            });

            $('.editVisaHistory').on('click', function() {
                var this_id = $(this).attr('data-id');

                var base_url = "{{ url('/admin/profile/edit_visa_history/open/') }}/" + this_id;
                $.get(base_url, function(data) {
                    $('#editVisaHistory').on('shown.bs.modal', function() {
                        $('#editVisaHistory .load_modal').html(data);
                        $('#edit_visa_history_user_id').val({{ $user->id }});
                    });
                    $('#editVisaHistory').modal('show');
                    $('#editVisaHistory').on('hidden.bs.modal', function() {
                        $('#editVisaHistory .load_modal').html("");
                    });
                });
            });

            $('#per-country-dd').on('change', function() {
                var idCountry = this.value;
                $("#per-state-dd").html('');
                $.ajax({
                    url: "{{ url('api/fetch-states') }}",
                    type: "POST",
                    data: {
                        country_id: idCountry,
                        _token: '{{ csrf_token() }}'
                    },
                    dataType: 'json',
                    success: function(result) {
                        $('#per-state-dd').html('<option value="">Select State</option>');
                        $.each(result.states, function(key, value) {
                            if (value.id ==
                                "{{ $userDetails ? $userDetails->permanent_state : '' }}"
                            ) {
                                var selectedState = "selected=\"'selected'\"";
                            } else if (value.id == "{{ old('permanent_state') }}") {
                                var selectedState = "selected=\"'selected'\"";
                            } else {
                                var selectedState = "";
                            }
                            $("#per-state-dd").append('<option ' + selectedState +
                                ' value="' + value.id + '">' + value.name +
                                '</option>');
                        });
                    }
                });
            });
            $('#country-dd,#per-country-dd').trigger('change');

            $('#mobile_dialcode').change(function() {
                var dialcode = $('#mobile_dialcode').val();
                $('#whatsapp_dialcode').val(dialcode);
            })


            $('#same_as_current').on("click", function() {
                if ($(this).is(':checked')) {
                    $('#perm_block').hide();
                } else {
                    $('#perm_block').show();
                }
            });


            $('body').on('click', '#yes_dual', function() {
                $('#dual_citizenship_country').attr("required", true);
                $('#select_dual_country').show();
            });

            $('body').on('click', '#no_dual', function() {
                $('#dual_citizenship_country').prop('required', false);
                $('#select_dual_country').hide();
            });

            $('body').on('click', '#yes_studying_abroad', function() {
                $('#studying_abroad_country').attr("required", true);
                $('#select_studying_abroad_country').show();
            });

            $('body').on('click', '#no_studying_abroad', function() {
                $('#studying_abroad_country').prop('required', false);
                $('#select_studying_abroad_country').hide();
            });

            $('body').on('click', '#yes_immigration', function() {
                $('#immigration_country').attr("required", true);
                $('#select_immigration_country').show();
            });

            $('body').on('click', '#no_immigration', function() {
                $('#immigration_country').prop('required', false);
                $('#select_immigration_country').hide();
            });

            $('body').on('click', '#yes_visa_refusal', function() {
                $('#visa_refusal_country').attr("required", true);
                $('#select_visa_refusal_country').show();
            });

            $('body').on('click', '#no_visa_refusal', function() {
                $('#visa_refusal_country').prop('required', false);
                $('#select_visa_refusal_country').hide();
            });

            // Married Or Not
            $('#marital_status').on('change', function() {
                if ($('#marital_status').val() == "married") {
                    $('#date_of_marriage').attr("required", true);
                    $('#select_date_of_marriage').show();
                } else {
                    $('#date_of_marriage').prop('required', false);
                    $('#select_date_of_marriage').hide();
                }
            });

            $("#marital_status").trigger("change");

            $('.maritalDate').datetimepicker({
                timepicker: false,
                format: 'd-m-Y',
                scrollInput: false,
                maxDate: 0
            });

            $('.expiryDatePicker').datetimepicker({
                timepicker: false,
                format: 'd-m-Y',
                scrollInput: false,
                minDate: new Date()
            });

            $('#passport_num').keypress(function(event) {
                //get envent value       
                var inputValue = event.which;
                // check whitespaces only.
                if (inputValue == 32 || (inputValue >= 91 && inputValue <= 96)) {
                    return false;
                }
                // check number only.
                if (inputValue == 48 || inputValue == 49 || inputValue == 50 || inputValue == 51 ||
                    inputValue == 52 || inputValue == 53 || inputValue == 54 || inputValue == 55 ||
                    inputValue == 56 || inputValue == 57) {
                    return true;
                }

                // check special char.
                if (!(inputValue >= 65 && inputValue <= 120) && (inputValue != 32 && inputValue != 0)) {
                    event.preventDefault();
                }
            });
            $('#name_passport').keypress(function(event) {
                //get envent value       
                var inputValue = event.which;
                // check whitespaces only.
                // if(inputValue == 32 || (inputValue >= 91 && inputValue <= 96)){
                //     return false;    
                // }
                // check number only.
                if (inputValue == 48 || inputValue == 49 || inputValue == 50 || inputValue == 51 ||
                    inputValue == 52 || inputValue == 53 || inputValue == 54 || inputValue == 55 ||
                    inputValue == 56 || inputValue == 57) {
                    return false;
                }

                // check special char.
                if (!(inputValue >= 65 && inputValue <= 122) && (inputValue != 32 && inputValue != 0)) {
                    event.preventDefault();
                }
            })

        });

        function chk_mend(elClass) {
            el = document.getElementsByClassName(elClass);
            var atLeastOneChecked = false; //at least one cb is checked
            for (i = 0; i < el.length; i++) {
                if (el[i].checked === true) {
                    atLeastOneChecked = true;
                }
            }

            if (atLeastOneChecked === true) {
                for (i = 0; i < el.length; i++) {
                    el[i].required = false;
                }
            } else {
                for (i = 0; i < el.length; i++) {
                    el[i].required = true;
                }
            }
        }

        function onlyNumberKey(evt) {
            // Only ASCII character in that range allowed
            var ASCIICode = (evt.which) ? evt.which : evt.keyCode
            if (ASCIICode > 31 && (ASCIICode < 48 || ASCIICode > 57))
                return false;
            return true;
        }

        function show_hide(show_id) {
            if ($('#' + show_id).is(':checked')) {
                $('#' + show_id + '_div').show(400);
            } else {
                $('#' + show_id + '_div').hide(400);
            }
        }

        function show_hide_input_field(show_id) {
            if ($('#' + show_id + '_checkbox').is(':checked')) {
                $('#' + show_id).show(200);
            } else {
                $('#' + show_id).hide(200);
            }
        }

        function show_hide_eng(show_id) {
            if (document.querySelectorAll('#eng_one_lang_checks input[type=checkbox]:checked').length > 0) {
                $('#english_lang_table').show(200);
            } else {
                $('#english_lang_table').hide(200);
            }

            show_hide_input_field(show_id);
        }

        function show_hide_det(show_id) {
            if (document.querySelectorAll('#eng_two_lang_checks input[type=checkbox]:checked').length > 0) {
                $('#det_lang_table').show(200);
            } else {
                $('#det_lang_table').hide(200);
            }

            show_hide_input_field(show_id);
        }

        function show_hide_act(show_id) {
            if (document.querySelectorAll('#eng_three_lang_checks input[type=checkbox]:checked').length > 0) {
                $('#act_lang_table').show(200);
            } else {
                $('#act_lang_table').hide(200);
            }

            show_hide_input_field(show_id);
        }

        function show_hide_sat(show_id) {
            if (document.querySelectorAll('#eng_four_lang_checks input[type=checkbox]:checked').length > 0) {
                $('#sat_lang_table').show(200);
            } else {
                $('#sat_lang_table').hide(200);
            }

            show_hide_input_field(show_id);
        }

        function show_hide_gre_gmat(show_id) {
            if (document.querySelectorAll('#gre_gmat_lang_checks input[type=checkbox]:checked').length > 0) {
                $('#gre_gmat_lang_table').show(200);
            } else {
                $('#gre_gmat_lang_table').hide(200);
            }

            show_hide_input_field(show_id);
        }

        function show_hide_lang(show_id) {
            if (document.querySelectorAll('#other_lang_checks input[type=checkbox]:checked').length > 0) {
                $('#other_lang_table').show(200);
            } else {
                $('#other_lang_table').hide(200);
            }

            if ($('#german').is(':checked')) {
                $('#german_tr').show(200);
            } else {
                $('#german_tr').hide(200);
            }
            if ($('#french').is(':checked')) {
                $('#french_tr').show(200);
            } else {
                $('#french_tr').hide(200);
            }
            if ($('#spanish').is(':checked')) {
                $('#spanish_tr').show(200);
            } else {
                $('#spanish_tr').hide(200);
            }
            if ($('#japanese').is(':checked')) {
                $('#japanese_tr').show(200);
            } else {
                $('#japanese_tr').hide(200);
            }

        }

        function validnum(num, type) {
            if (type == "total_gre") {
                if (num < 260 || num > 340) {
                    $("#total_gre_err").removeClass('d-none');
                    $('#gre_gmat_save').addClass('disabled');
                    return false;
                } else {
                    $("#total_gre_err").addClass('d-none');
                    $('#gre_gmat_save').removeClass('disabled');
                    return true;
                }
            }

            if (type == "verbal_gre") {
                if (num < 130 || num > 170) {
                    $("#verbal_gre_err").removeClass('d-none');
                    $('#gre_gmat_save').addClass('disabled');
                    return false;
                } else {
                    $("#verbal_gre_err").addClass('d-none');
                    $('#gre_gmat_save').removeClass('disabled');
                    return true;
                }
            }

            if (type == "quant_gre") {
                if (num < 130 || num > 170) {
                    $("#quant_gre_err").removeClass('d-none');
                    $('#gre_gmat_save').addClass('disabled');
                    return false;
                } else {
                    $("#quant_gre_err").addClass('d-none');
                    $('#gre_gmat_save').removeClass('disabled');
                    return true;
                }
            }

            if (type == "ana_gre") {
                if (num < 0 || num > 6) {
                    $("#ana_gre_err").removeClass('d-none');
                    $('#gre_gmat_save').addClass('disabled');
                    return false;
                } else {
                    $("#ana_gre_err").addClass('d-none');
                    $('#gre_gmat_save').removeClass('disabled');
                    return true;
                }
            }

            if (type == "inte_gre") {
                if (num < 260 || num > 340) {
                    $("#inte_gre_err").removeClass('d-none');
                    $('#gre_gmat_save').addClass('disabled');
                    return false;
                } else {
                    $("#inte_gre_err").addClass('d-none');
                    $('#gre_gmat_save').removeClass('disabled');
                    return true;
                }
            }

            //GMAT
            if (type == "total_gmat") {
                if (num < 200 || num > 800) {
                    $("#total_gmat_err").removeClass('d-none');
                    $('#gre_gmat_save').addClass('disabled');
                    return false;
                } else {
                    $("#total_gmat_err").addClass('d-none');
                    $('#gre_gmat_save').removeClass('disabled');
                    return true;
                }
            }

            if (type == "verbal_gmat") {
                if (num < 0 || num > 60) {
                    $("#verbal_gmat_err").removeClass('d-none');
                    $('#gre_gmat_save').addClass('disabled');
                    return false;
                } else {
                    $("#verbal_gmat_err").addClass('d-none');
                    $('#gre_gmat_save').removeClass('disabled');
                    return true;
                }
            }

            if (type == "quant_gmat") {
                if (num < 0 || num > 60) {
                    $("#quant_gmat_err").removeClass('d-none');
                    $('#gre_gmat_save').addClass('disabled');
                    return false;
                } else {
                    $("#quant_gmat_err").addClass('d-none');
                    $('#gre_gmat_save').removeClass('disabled');
                    return true;
                }
            }

            if (type == "ana_gmat") {
                if (num < 0 || num > 6) {
                    $("#ana_gmat_err").removeClass('d-none');
                    $('#gre_gmat_save').addClass('disabled');
                    return false;
                } else {
                    $("#ana_gmat_err").addClass('d-none');
                    $('#gre_gmat_save').removeClass('disabled');
                    return true;
                }
            }

            if (type == "inte_gmat") {
                if (num < 1 || num > 8) {
                    $("#inte_gmat_err").removeClass('d-none');
                    $('#gre_gmat_save').addClass('disabled');
                    return false;
                } else {
                    $("#inte_gmat_err").addClass('d-none');
                    $('#gre_gmat_save').removeClass('disabled');
                    return true;
                }
            }
        }
    </script>
@endpush
