@extends('backend.layouts.app')
@section('title', __('labels.backend.access.users.management') . ' | ' . __('labels.backend.access.users.edit'))

@section('content')


<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-10">
                <h4 class="card-title mb-0">
                    {{-- @lang('labels.backend.access.users.management') --}}
                    {{-- <small class="text-muted">@lang('labels.backend.access.users.edit')</small> --}}
                    Edit {{_label('backend_student')}} Basic Details
                </h4>

            </div>
            <!--col-->
            <div class="col-sm-2 " style="margin-top:20px;text-align: right;">
                <button type="cancel" name="back" class="btn btn-primary btn-sm " value="Back" onclick="document.location ='{{ route('admin.auth.user.index') }}'"title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </button>
            </div>
            <div class="row">
                <div class="col">
                    <span class="text-smaller">Fields marked with <span style="color:red;">*</span> are mandatory</span>
                </div>
            </div>

            <hr style="height:1px;">
            {{ html()->modelForm($user, 'PATCH', route('admin.auth.user.update', $user->id))->class('form-horizontal')->open() }}
            <div class="row mt-4 mb-4">
                <div class="col-sm-12 col-md-9">
                    <div class="form-group row">
                        <div class="col-sm-12 col-md-4">
                            <label class="col-form-label required-field">First Name</span></label>
                            <div class="">
                                <input type="text" placeholder="First Name" class="form-control" name="first_name" value="@if(Request::old('first_name')){{ Request::old('first_name') }}@else{{ $user->first_name }}@endif" pattern="[a-zA-Z\s]+" title="Only Alphabets and space is allowed" required>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <label class="col-form-label">Middle Name</span></label>
                            <div class="">
                                <input type="text" placeholder="Middle Name" class="form-control" name="middle_name" value="@if(Request::old('middle_name')){{ Request::old('middle_name') }}@else{{ $user->middle_name }}@endif" pattern="[a-zA-Z\s]+" title="Only Alphabets and space is allowed">
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <label class="col-form-label required-field">Last Name</label>
                            <div class="">
                                <input type="text" placeholder="Last Name" class="form-control" name="last_name" value="@if(Request::old('last_name')){{ Request::old('last_name') }}@else{{ $user->last_name }}@endif" pattern="[a-zA-Z\s]+" title="Only Alphabets and space is allowed" required>
                            </div>
                        </div>
                    </div>

                    <div class="form-group row mt-2 mb-2">
                        <div class="col-sm-12">
                            <input type="radio" class="radio-col-blue" id="radio_1" name="gender" value="male" @if(Request::old('gender') == "male") checked @elseif($user->gender == "male") checked @endif required />
                            <label for="radio_1">Male</label>
        
                            <input type="radio" style="margin-left:8px;" class="radio-col-blue" id="radio_2" name="gender" value="female" @if(Request::old('gender') == "female") checked @elseif($user->gender == "female") checked @endif required />
                            <label for="radio_2">Female</label>

                            <input type="radio" style="margin-left:8px;" class="radio-col-blue" id="radio_3" name="gender" value="other" @if(Request::old('gender') == "other") checked @elseif($user->gender == "other") checked @endif required />
                            <label for="radio_3">Other</label>
                        </div>
                    </div>

                    <div class="form-group row ">
                        <div class="col-sm-12 col-md-8">
                            <label class="col-form-label @if(get_site_config('student_create_admin_mandatory') == 'email' || get_site_config('student_create_admin_mandatory') == 'email_and_mobile') required-field @endif">Email</label>
                            <div class="">
                                <input type="text" placeholder="Email ID" class="form-control" name="email" value="@if(Request::old('email')){{ Request::old('email') }}@else{{ $user->email }}@endif" @if(get_site_config('student_create_admin_mandatory') == 'email' || get_site_config('student_create_admin_mandatory') == 'email_and_mobile') required @endif>
                            </div>
                        </div>

                        <div class="col-sm-12 col-md-4">
                            <label class="col-form-label">Date of Birth</label>
                            <input type="text" placeholder="Date of Birth" class="form-control dobmydatepicker" autocomplete="off" id="dob" name="birthday" value="@if(Request::old('birthday')) {{ date('d-m-Y', strtotime(Request::old('birthday'))) }} @elseif($user->birthday) {{ date('d-m-Y', strtotime($user->birthday)) }} @endif">
                        </div>
                    </div>

                    <div class="form-group row ">
                        <div class="col-sm-12 col-md-6">
                            <label class="col-form-label 
                            @if(get_site_config('student_create_admin_mandatory') == 'mobile' || get_site_config('student_create_admin_mandatory') == 'email_and_mobile') required-field @endif">Mobile No.</label>
                            <div class="input-group">
                                <div class="input-group-prepend" style="width: 50%">
                                    <select class="form-select select2" id="dialcode" name="dialcode" style="padding:0.49rem 2rem 0.375rem 0.75rem;">
                                        {{-- <option value=''>Dialcode</option> --}}
                                        @foreach($dialcodes as $dialcode)
                                        <option 
                                        {{(($dialcode->code == $user->dialcode) || (Request::old('dialcode') && Request::old('dialcode') == $dialcode->code)) ? 'selected' : ''}} 
                                        value="{{$dialcode->code}}" data-name="{{$dialcode->name}}">{{$dialcode->name}} +{{$dialcode->code}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <input 
                                    type="text" 
                                    placeholder="Mobile No." 
                                    class="form-control" 
                                    onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))" 
                                    name="mobile" 
                                    id="mobile"
                                    value="@if(Request::old('mobile')){{ Request::old('mobile') }}@else{{ $user->mobile }}@endif" 
                                    minlength="{{ config('app.USER_MOBILE_MIN_LENGTH') }}" 
                                    maxlength="{{ config('app.USER_MOBILE_MAX_LENGTH') }}" 
                                    @if(get_site_config('student_create_admin_mandatory') == 'mobile' || get_site_config('student_create_admin_mandatory') == 'email_and_mobile') required @endif>
                                    
                            </div>
                        </div>
        
                        <div class="col-sm-12 col-md-6">
                            <label for="whatsapp_number" class="col-form-label">Whatsapp No.</label>
                            <div class="input-group">
                                <div class="input-group-prepend" style="width: 50%">
                                    <select class="form-select select2" id="whatsapp_dialcode" name="whatsapp_dialcode" style="padding:0.49rem 2rem 0.375rem 0.75rem;">
                                        {{-- <option value=''>Dialcode</option> --}}
                                        @foreach($dialcodes as $dialcode)
                                        <option 
                                        {{
                                            (($dialcode->code == $user->whatsapp_dialcode) || 
                                            (Request::old('whatsapp_dialcode') && Request::old('whatsapp_dialcode') == $dialcode->code)) ? 'selected' : ''
                                        }} 
                                        value="{{$dialcode->code}}" data-name="{{$dialcode->name}}">{{$dialcode->name}} +{{$dialcode->code}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <input type="text" placeholder="Whatsapp No." id="whatsapp_number" minlength="{{ config('app.USER_MOBILE_MIN_LENGTH') }}" maxlength="{{ config('app.USER_MOBILE_MAX_LENGTH') }}" class="form-control" name="whatsapp_number" value="@if(Request::old('whatsapp_number')){{ Request::old('whatsapp_number') }}@else{{ $user->whatsapp }}@endif">
                            </div>
                            <div class="form-check" style="margin-top: -7px;">
                                <input type="checkbox"
                                    class="form-check-input"
                                    id="sameAsMobile"
                                    >  
                                <label class="form-check-label" for="sameAsMobile" style="font-weight:500 !important;">Same as Mobile No.</label>
                            </div>
                        </div>
        
                        <div class="col-sm-12 col-md-4">
                            <label for="alternate_contact">Alternate Contact</label>
                            <div class="">
                                <input type="text" placeholder="Alternate Contact" id="alternate_contact" maxlength="50" class="form-control" name="alternate_contact" value="@if(Request::old('alternate_contact')){{ Request::old('alternate_contact') }}@else{{ $user->alternate_contact }}@endif">
                            </div>
                        </div>
                    </div>

                    <div class="form-group row ">
                        <div class="col-sm-12 col-md-4">
                            <label class="col-form-label required-field">Country</label>
                            <select class="form-select" id="country" name="country" required>
                                {{-- <option value="">Select</option> --}}
                                @foreach ($country_list as $key => $value)
                                <option value="{{ $key }}" @if(Request::old('country') == $key) selected @elseif ($user->country == $key) selected @endif>{{ $value }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <label class="col-form-label">State</label>
                            <div class="form-group">
                                <select class="form-control form-select" name="state" id="state-dd">
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <label class="col-form-label">City</label>
                            <!-- <input type="text" placeholder="City" value="@if(Request::old('city')){{ Request::old('city') }}@else{{$user->city}}@endif" class="form-control validate_inpt" id="city" name="city"> -->
                              <select class="form-control form-select" name="city" id="city-dd">
                            </select>
                        </div>
                    </div>
                    <hr style="height:1px;">
                    <div class="form-group row">
                        <div class="col-sm-12 col-md-4">
                            <label class="col-form-label required-field">Interested Study Level</label>
                            <select class="form-select" id="study_level" name="study_level" required>
                                <option value="">Select Study Level</option>
                                @foreach(get_study_levels() as $key => $value)
                                <option value="{{$value}}" @if(Request::old('study_level') == $value) selected @elseif($user->overseas_study_level_selection == $value) selected @endif >{{$value}}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-sm-12 col-md-8">
                            <label class="col-form-label">Country Interested to Study In</label>
                            <select name="country_interested[]" class="form-control form-select select2" style="width: 100%" multiple="multiple">
                                @foreach($countries as $country)
                                    <?php $countryInterest = "";  
                                        if(Request::old('country_interested'))
                                            $country_interested = Request::old('country_interested'); 
                                        else
                                            $country_interested = explode(",", $user->country_interested); 
                                    ?>
                                    @foreach($country_interested as $interest)
                                        @if($interest == $country->title_en)
                                            <?php $countryInterest = "selected"; ?>
                                        @endif
                                    @endforeach
                                    <option value="{{ $country->title_en }}" {{$countryInterest}}>{{ $country->title_en }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="form-group row " id="interested">
                        <div class="col-sm-12 col-md-4">
                            <label class="col-form-label">Course Interested to Study</label>
                            <input type="text" placeholder="Course Interested to Study" class="form-control validate_inpt" value="@if(Request::old('course_interested')){{ Request::old('course_interested') }}@else{{$user->overseas_course_intersted}}@endif" id="course_interested" name="course_interested">
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <label class="col-form-label">Intake</label>
                            <select name="intake" class="form-select form-control">
                            <option value="">Intake</option>
                            <?php $month = date('n'); // current month
                            for ($x = 0; $x < 24; $x++) { ?>
                            <option @if(Request::old('intake') == date('m Y', mktime(0,0,0,$month + $x,1))) selected @elseif($userdetails && $userdetails->intake_month.' '.$userdetails->intake_year == date('m Y', mktime(0,0,0,$month + $x,1))) selected  @endif value="<?php echo date('m Y', mktime(0,0,0,$month + $x,1)); ?>" >
                            <?php echo date('F Y', mktime(0,0,0,$month + $x,1)); ?>
                            <?php } ?></option>
                            </select>
                        </div>
                        
                    </div>

                    @if(config('app.product_code') == 'EDUCTRL_CRM')
                    <hr style="height: 1px;">
                    <div class="form-group row">
                        <label class="col-form-label">Course Interested in</label>
                        <div class="col-sm-12 col-md-8">
                            <select class="form-select" name="course">
                                <option value="">Select Course</option>
                                @isset($courses)
                                @foreach($courses as $course)
                                <option value="{{ $course->id }}" @if (old('course') == $course->id) selected="selected" @elseif($user && $user->coaching_course_interested == $course->id) selected @endif>{{ $course->title }}</option>
                                @endforeach
                                @endisset
                            </select>
                        </div>
                    </div>
                    @endif

                    @if(env('ADDITIONAL_SERVICES_ENABLE'))
                    <hr style="height:1px;">
                    <div class="row">
                        <div class="col-sm-12 col-md-8">
                            <label class="col-form-label">Other Services Interested</label>
                            <select name="services[]" class="form-select select2" multiple>
                                {{-- <option value="">Select</option> --}}
                                @foreach(get_services_data() as $service)
                                    <?php $serviceInterest = "";  
                                    if(Request::old('services'))
                                        $service_interested = Request::old('services'); 
                                    else
                                        $service_interested = explode(",", $user->services); 
                                    ?>
                                    @foreach($service_interested as $interest)
                                        @if($interest == $service->id)
                                            <?php $serviceInterest = "selected"; ?>
                                        @endif
                                    @endforeach
                                    <option value="{{$service->id}}" {{$serviceInterest}}>{{$service->service_name}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    @endif
                    <hr style="height:1px;">
                        <div class="form-group row">
                            <div class="col-sm-12 col-md-4">
                                <label class="col-form-label">Qualification</label>
                                <select class="form-select" id="qualification" name="qualification">
                                    <option value="">Select Qualification</option>
                                    <option value="9th" @if(Request::old('qualification') == "9th") selected @elseif($userdetails && $userdetails->highest_level_education == '9th') selected @endif>9th
                                    </option>
                                    <option value="10th" @if(Request::old('qualification') == "10th") selected @elseif($userdetails && $userdetails->highest_level_education == '10th') selected @endif>10th
                                    </option>
                                    <option value="11th" @if(Request::old('qualification') == "11th") selected @elseif($userdetails && $userdetails->highest_level_education == '11th') selected @endif>11th
                                    </option>
                                    <option value="12th" @if(Request::old('qualification') == "12th") selected @elseif($userdetails && $userdetails->highest_level_education == '12th') selected @endif>12th
                                    </option>
                                    <option value="Bachelors" @if(Request::old('qualification') == "Bachelors") selected @elseif($userdetails && $userdetails->highest_level_education == 'Bachelors') selected @endif>Bachelors
                                    </option>
                                    <option value="Masters" @if(Request::old('qualification') == "Masters") selected @elseif($userdetails && $userdetails->highest_level_education == 'Masters') selected @endif>Masters
                                    </option>
                                    <option value="Ph.D" @if(Request::old('qualification') == "Ph.D") selected @elseif($userdetails && $userdetails->highest_level_education == 'Ph.D') selected @endif>Ph.D
                                    </option>                            
                                </select>
                            </div>
                            <div class="col-sm-12 col-md-4">
                                <label class="col-form-label">Passout Year</label>
                                <input type="text" placeholder="Passout Year" onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))" minlength="4" maxlength="4" class="form-control" id="passout_year" name="passout_year" value="@if(Request::old('passout_year')){{ Request::old('passout_year') }}@elseif($userdetails){{ $userdetails->passout_year }}@endif">
                            </div>
                            <div class="col-sm-12 col-md-4">
                                <label class="col-form-label">Score/Grade</label>
                                <input type="text" placeholder="Score/Grade" class="form-control" id="passout_year" name="qualification_score" value="@if(Request::old('qualification_score')){{ Request::old('qualification_score') }}@elseif($userdetails && $userdetails->qualification_score) {{$userdetails->qualification_score}}@endif">
                            </div>
                        </div>

                        <div class="form-group row " id="csc">
                            <div class="col-sm-12 col-md-4">
                                <label class="col-form-label">Currently Studying Course</label>
                                <input type="text" placeholder="Currently Studying Course" class="form-control validate_inpt" id="currently_studying_course" name="currently_studying_course" value="@if(Request::old('currently_studying_course')){{ Request::old('currently_studying_course') }}@elseif($userdetails){{ $userdetails->current_course }}@endif">
                            </div>
                            <div class="col-sm-12 col-md-4">
                                <label class="col-form-label">Work Experience</label>
                                <input type="text" placeholder="Work Experience" class="form-control" id="work_experience" name="work_experience" value="@if(Request::old('work_experience')){{ Request::old('work_experience') }}@elseif($userdetails){{ $userdetails->work_experience }}@endif">
                            </div>
                        </div>

                        @if(config('app.product_code') == 'TRAINING')
                        <input type="hidden" name="student_type" value="course">
                        @elseif(config('app.product_code') == 'OVERSEAS')
                        <input type="hidden" name="student_type" value="study_abroad">
                        @elseif(config('app.product_code') == 'VISA')
                        <input type="hidden" name="student_type" value="visa">
                        @else
                        <div class="form-group row mb-3">
                            <div class="col-md-6">
                                <label class="required-field">Interested In</label>
                                <select class="form-select" id="student_type" name="student_type" required>
                                    <option value="">Select</option>
                                    <option value="study_abroad" @if(Request::old('student_type') == "study_abroad") selected @elseif($user && $user->student_type == 'study_abroad') selected @endif>Study Abroad</option>
                                    <option value="course" @if(Request::old('student_type') == "course") selected @elseif($user && $user->student_type == 'course') selected @endif>Coaching</option>
                                    <option value="study_abroad_course" @if(Request::old('student_type') == "study_abroad_course") selected @elseif($user && $user->student_type == 'study_abroad_course') selected @endif>Study Abroad & Coaching</option>
                                    @if(env('ABROAD_JOB_ADDON'))
                                    <option value="abroad_job" @if(Request::old('student_type') == "abroad_job") selected @elseif($user && $user->student_type == 'abroad_job') selected @endif>Abroad Job</option>
                                    @endif
                                    @if(env('VISA_ADDON'))
                                    <option value="visa" @if(Request::old('student_type') == "visa") selected @elseif($user && $user->student_type == 'visa') selected @endif>Visa</option>
                                    @endif
                                </select>
                            </div>
                        </div>
                        @endif
        {{-- //Dynamic fields --}}
        @if(count($custom_attributes))
            <hr style="height:1px;">
            <div class="form-group row ">
                <?php 
                if($userdetails)
                $attrData =  json_decode($userdetails->user_data_js, true);
                ?>
                @foreach($custom_attributes as $custom_attribute)
                    @if($custom_attribute->for_student_mandatory)
                    <?php   
                            $red = "required-field";
                            $mandate = "required"; ?>
                    @else
                    <?php 
                            $red="";
                            $mandate = "";?>
                   @endif
                   
                    @if($custom_attribute->type == 'input')
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="" class="col-form-label {{$red}}">{{$custom_attribute->label}}</label>
                                <div class="">
                                    <input type="@if($custom_attribute->input_datatype == 'number' || $custom_attribute->input_datatype == 'decimal'){{'number'}}@elseif($custom_attribute->input_datatype == 'date' || $custom_attribute->input_datatype == 'year' || $custom_attribute->input_datatype == 'phone'){{'text'}}@else{{$custom_attribute->input_datatype}}@endif" {{ ($custom_attribute->input_datatype == 'decimal')? "step=any" : ''}} 
                                    @if($custom_attribute->input_datatype == 'number' || $custom_attribute->input_datatype == 'decimal')
                                        {{"min=$custom_attribute->input_min"}} {{"max=$custom_attribute->input_max"}}
                                    @elseif($custom_attribute->input_datatype == 'date')
                                    {{-- //No min or max added --}}
                                    @elseif($custom_attribute->input_datatype == 'year')
                                        onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))" minlength="4" maxlength="4"
                                    @elseif($custom_attribute->input_datatype == 'phone')
                                        onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 58) || event.charCode==32 || event.charCode==44 || event.charCode==43 || event.charCode==45 || event.charCode==40 || event.charCode==41)" minlength="10" maxlength="18"
                                    @else
                                        {{"minLength=$custom_attribute->input_min"}} {{"maxLength=$custom_attribute->input_max"}}
                                    @endif
                                     placeholder="{{$custom_attribute->placeholder}}" autocomplete="off" class="form-control @if($custom_attribute->input_datatype == 'date') {{'mydatepicker'}}@endif" name="{{$custom_attribute->attr_name}}" value='@if(isset($attrData[$custom_attribute->attr_name])){{ $attrData[$custom_attribute->attr_name]}}@else{{old("$custom_attribute->attr_name")}}@endif' {{$mandate}} >
                                    
                                </div>
                            </div>
                        </div>
                    @endif
                    @if($custom_attribute->type == 'textarea')
                    <div class="form-group row ">
                        <div class="col-sm-12 col-md-8">
                            <div class="form-group">
                                <label for="" class="col-form-label {{$red}}">{{$custom_attribute->label}}</label>
                                <div class="">
                                    <textarea placeholder="{{$custom_attribute->placeholder}}" {{"minLength=$custom_attribute->input_min"}} {{"maxLength=$custom_attribute->input_max"}} class="form-control" name="{{$custom_attribute->attr_name}}" {{$mandate}}>@if(isset($attrData[$custom_attribute->attr_name])){{ $attrData[$custom_attribute->attr_name]}}@else{{old("$custom_attribute->attr_name")}}@endif</textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                    @if($custom_attribute->type == 'select')
                    <?php
                        $is_multi = $select2 = "";
                        $select_vals = explode('|',$custom_attribute->selection_values);
                        if($custom_attribute->select_multiple){
                            $is_multi = "multiple";
                            $select2 = "select2";
                        }
                    ?>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="" class="col-form-label {{$red}}">{{$custom_attribute->label}}</label>
                                <div class="">
                                    <select placeholder="{{$custom_attribute->placeholder}}" class="form-select {{$select2}}" name="{{$custom_attribute->attr_name}}[]" {{$mandate}} {{$is_multi}}>
                                        @if(!$is_multi)
                                        <option value="">{{$custom_attribute->placeholder}}</option>
                                        @endif
                                        @foreach($select_vals as $sel_val)
                                        <option {{ (isset($attrData[$custom_attribute->attr_name]) && is_array($attrData[$custom_attribute->attr_name]) && in_array($sel_val, $attrData[$custom_attribute->attr_name])) ? ' selected' : '' }}{{ (is_array(old("$custom_attribute->attr_name")) && in_array($sel_val, old("$custom_attribute->attr_name"))) ? ' selected' : '' }} value="{{ $sel_val }}">{{ $sel_val }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                    @endif
                    @if($custom_attribute->type == 'checkbox')
                    <?php
                        $select_vals = explode('|',$custom_attribute->selection_values);
                    ?>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="" class="col-form-label {{$red}}">{{$custom_attribute->label}}</label>
                                <div class="">
                                        @foreach($select_vals as $sel_val)
                                        <label>
                                            <input class="form-check-input ms-2 dyna_chkbx {{$custom_attribute->attr_name}}" @if($mandate) onclick='chk_mend("{{$custom_attribute->attr_name}}")' @endif {{ (isset($attrData[$custom_attribute->attr_name]) && is_array($attrData[$custom_attribute->attr_name]) && in_array($sel_val, $attrData[$custom_attribute->attr_name])) ? ' checked' : '' }} {{ (is_array(old("$custom_attribute->attr_name")) && in_array($sel_val, old("$custom_attribute->attr_name"))) ? ' checked' : '' }} type="checkbox" name="{{$custom_attribute->attr_name}}[]" value="{{$sel_val}}" @if(isset($attrData[$custom_attribute->attr_name]) && is_array($attrData[$custom_attribute->attr_name])) {{''}} @else{{$mandate}}@endif> {{$sel_val}}
                                        </label>
                                        @endforeach
                                </div>
                            </div>
                        </div>
                    @endif
                    @if($custom_attribute->type == 'radio')
                    <?php
                        $select_vals = explode('|',$custom_attribute->selection_values);
                    ?>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="" class="col-form-label {{$red}}">{{$custom_attribute->label}}</label>
                                <div class="">
                                        @foreach($select_vals as $sel_val)
                                        <label>
                                            <input class="form-check-input ms-2 {{$custom_attribute->attr_name}}" @if($mandate) onclick='chk_mend("{{$custom_attribute->attr_name}}")' @endif {{ (isset($attrData[$custom_attribute->attr_name]) && is_array($attrData[$custom_attribute->attr_name]) && in_array($sel_val, $attrData[$custom_attribute->attr_name])) ? ' checked' : '' }} {{ (is_array(old("$custom_attribute->attr_name")) && in_array($sel_val, old("$custom_attribute->attr_name"))) ? ' checked' : '' }} type="radio" name="{{$custom_attribute->attr_name}}[]" value="{{$sel_val}}" @if(isset($attrData[$custom_attribute->attr_name]) && is_array($attrData[$custom_attribute->attr_name])) {{''}} @else{{$mandate}}@endif> {{$sel_val}}
                                        </label>
                                        @endforeach
                                </div>
                            </div>
                        </div>
                    @endif
                @endforeach
            </div>
            @endif
            
            {{-- //Dynamic fields --}}
        @if(!\Auth::user()->isAgent())
            <hr style="height:1px;">
                        <div class="form-group row ">
                            <div class="col-sm-12 col-md-4">
                                <label class="col-form-label">Lead Source</label>
                                <div class="">
                                    <select class="form-select" id='lead_source' name="lead_source">
                                        <option value=''>Select</option>
                                        @foreach(get_lead_sources() as $source_data)
                                        <option @if(Request::old('lead_source') == $source_data) selected @elseif($source_data == $user->lead_source) selected @endif value="{{$source_data}}">{{ucfirst($source_data)}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-12 col-md-4">
                                <div class="form-group">
                                    <label for="address" class="col-form-label">Lead Source Details</label>
                                    <div class="">
                                        <input type="text" placeholder="Lead Source Details" class="form-control validate_inpt" name="lead_source_detail" value="@if(Request::old('lead_source_detail')){{ Request::old('lead_source_detail') }}@elseif($userdetails){{ $userdetails->lead_source_detail }}@endif">
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-12 col-md-4">
                                <div class="form-group">
                                    <label for="" class="col-form-label">Campaign Name</label>
                                    <div class="">
                                        <input type="text" placeholder="Campaign Name" class="form-control" name="campaign_name" value="@if(Request::old('campaign_name')){{ Request::old('campaign_name') }}@elseif($userdetails){{ $userdetails->lead_campaign_name }}@endif">
                                    </div>
                                </div>
                            </div>
                        </div>
                    <div class="form-group row ">
                    <div class="col-sm-12 col-md-4">
                        <label class="col-form-label required-field">Branch</label>
                        <select class="form-select" id="branch" name="branch" required>
                            <option value="">Select Branch</option>
                            @foreach($branch_list as $id => $name)
                                <option value="{{ $id }}" @if(Request::old('branch') == $id) selected @elseif($id == $user->branch) selected @endif >{{ $name }}</option>
                            @endforeach
                        </select>
                    </div>
                    @if(get_site_config('module_student_referral'))
                        <div class="col-sm-12 col-md-4">
                            <label class="col-form-label">Referred by Student</label>
                            <div class="">
                                <input type="hidden" name="ref_by_old_val" id="ref_by_old_val" value="{{$user->ref_by}}">
                                <select class="form-select select2_ajax" id='ref_by' name="referred_by">
                                    <option value=''>Select Student</option>
                                    @if($user->ref_by)
                                    <option selected value="{{$user->ref_by}}">{{get_user_full_name_by_id($user->ref_by)}}</option>
                                    @endif
                                </select>
                            </div>
                        </div>
                    @endif
                    </div>
                    @endif
                </div>
            </div>
        </div>
        @if(auth()->user()->isAgent())
            <span class="small">Note: No email/sms/whatsapp notifications are sent to student</span>
        @endif
        </div>
        <div class="card-footer">
            <div class="row" style="text-align:center;">
                <div class="col">
                    {{ form_submit(__('buttons.general.crud.update')) }}
                    {{ form_cancel(route('admin.auth.user.index'), __('buttons.general.cancel')) }}
                </div>
            </div>
        </div>
</div>

{{ html()->closeModelForm() }}
@endsection
@push ('after-styles')
<style>
    .select2-container .select2-selection--single {
        height: 33px !important;
    }
</style>
@endpush

@push('after-scripts')
<script>
    function syncWhatsapp() {
        if ($("#sameAsMobile").is(":checked")) {
            $("#whatsapp_number").val($("#mobile").val()).prop("readonly", true);
            $("#whatsapp_dialcode").val($("#dialcode").val()).prop("readonly", true);
            $("#whatsapp_dialcode").trigger('change');
        } else {
            $("#whatsapp_number").prop("readonly", false);
            $("#whatsapp_dialcode").prop("readonly", false);
        }
    }

    // $("#sameAsMobile").prop("checked", true);

    syncWhatsapp();                                
    $("#mobile, #dialcode").on("input change", syncWhatsapp);
    $("#sameAsMobile").on("change", syncWhatsapp);
</script>
<script>
    $(document).ready(function() {
        $('.dobmydatepicker').datetimepicker({
            timepicker: false,
            format: 'd-m-Y',
            scrollInput: false,
            maxDate: new Date()
        });
        $('.select2_ajax').select2({
            minimumInputLength: 3,
            ajax: {
                url: '{{ route("admin.get-ref-users") }}',
                type: "POST",
                dataType: 'json',
                data: function(params) {
                    return {
                        exclude_user: '{{$user->id}}',
                        q: params.term, // search term
                        _token: '{{csrf_token()}}'
                    };
                },
            },
        });

        $('#country').on('change', function () {
            var idCountry = this.value;
            $("#state-dd").html('');
            $.ajax({
                url: "{{url('api/fetch-states')}}",
                type: "POST",
                data: {
                    country_id: idCountry,
                    _token: '{{csrf_token()}}'
                },
                dataType: 'json',
                success: function (result) {
                    $('#state-dd').html('<option value="">Select State</option>');
                    $.each(result.states, function (key, value) {
                    if(value.id == "{{($user)?$user->state:''}}"){
                            var selectedState = "selected=\"'selected'\"";
                        }else if(value.id == "{{old('state')}}"){
                            var selectedState = "selected=\"'selected'\"";
                        }
                        else{
                            var selectedState = "";
                        }
                        $("#state-dd").append('<option '+selectedState+' value="'+ value.id + '">' + value.name + '</option>');
                    });
                    $('#city-dd').html('<option value="">Select City</option>');
                }
            });
        });
        $('#state-dd').on('change', function() {
    var idState = this.value != '' ? this.value : '{{ $user->state }}';
console.log({
    "thisvalue on state": this.value,
    "userstate": '{{ $user->state }}'
});


    $("#city-dd").html('');
    $.ajax({
        url: "{{ url('api/fetch-cities') }}",
        type: "POST",
        data: {
            state_id: idState,
            _token: '{{ csrf_token() }}'
        },
        dataType: 'json',
        success: function(res) {
            $('#city-dd').html('<option value="">Select City</option>');

            var userCity = '{{ $user->city }}';

            $.each(res.cities, function(key, value) {
                var selected = (value.id == userCity) ? 'selected' : '';

                console.log("User's selected:", selected);

                $("#city-dd").append(
    '<option value="' + value.id + '" ' + selected + '>' + value.name + '</option>'
);
            });
        }
    });
});

// trigger change
$('#country').trigger('change');
$('#state-dd').trigger('change');
$('#city-dd').trigger('change');


        $('#dialcode').change(function(){
            var dialcode = $('#dialcode').val();
            $('#whatsapp_dialcode').val(dialcode);
        })

    });

    function chk_mend(elClass) {
        el = document.getElementsByClassName(elClass);
        var atLeastOneChecked = false; //at least one cb is checked
        for (i = 0; i < el.length; i++) {
            if (el[i].checked === true) {
            atLeastOneChecked = true;
            }
        }

        if (atLeastOneChecked === true) {
            for (i = 0; i < el.length; i++) {
            el[i].required = false;
            }
        } else {
            for (i = 0; i < el.length; i++) {
            el[i].required = true;
            }
        }
    }
</script>
@endpush