@extends('backend.layouts.app')
@section('title', __('labels.backend.access.users.management') . ' | ' . __('labels.backend.access.users.edit'))

@section('content')


{{ html()->modelForm($user, 'PATCH', route('admin.auth.staff.update', $user->id))->class('form-horizontal')->open() }}
<div class="card">

    <div class="card-body">
        <div class="row">
            <div class="col-sm-10">
                <h4 class="card-title mb-0">
                    Staff Management
                    <small class="text-muted">@lang('labels.backend.access.users.edit')</small>
                </h4>

            </div>
            <!--col-->
            <div class="col-sm-2 " style="margin-top:20px;text-align: right;">
                <button type="cancel" name="back" class="btn btn-primary btn-sm " value="Back" onclick="document.location ='{{ route('admin.auth.user.index') }}'" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </button>
            </div>
            <div class="row">
                <div class="col">
                    <span class="text-smaller">Fields marked with <span style="color:red;">*</span> are mandatory</span>
                </div>
            </div>
            <!--row-->

            <hr>

            <div class="row mt-4 mb-4">
                <div class="col">
                    <div class="form-group row mb-3">
                        {{ html()->label(__('validation.attributes.backend.access.users.first_name'))->class('col-md-2 form-control-label required-field')->for('first_name') }}

                        <div class="col-md-6">
                            {{ html()->text('first_name')
                                ->class('form-control')
                                ->placeholder(__('validation.attributes.backend.access.users.first_name'))
                                ->attribute('maxlength', 191)
                                ->required() }}
                        </div>
                        <!--col-->
                    </div>
                    <!--form-group-->


                    <div class="form-group row mb-3">
                        {{ html()->label(__('validation.attributes.backend.access.users.last_name'))->class('col-md-2 form-control-label required-field')->for('last_name') }}

                        <div class="col-md-6">
                            {{ html()->text('last_name')
                                ->class('form-control')
                                ->placeholder(__('validation.attributes.backend.access.users.last_name'))
                                ->attribute('maxlength', 191)
                                ->required()}}
                        </div>
                        <!--col-->
                    </div>
                    <!--form-group-->

                    <div class="form-group row mb-3">
                        {{ html()->label(__('validation.attributes.backend.access.users.email'))->class('col-md-2 form-control-label required-field')->for('email') }}

                        <div class="col-md-6">
                            {{ html()->email('email')
                                    ->class('form-control')
                                    ->placeholder(__('validation.attributes.backend.access.users.email'))
                                    ->attribute('maxlength', 191)
                                    ->required()
                                     }}
                        </div>
                        <!--col-->
                    </div>
                    <!--form-group-->


                    <div class="form-group row mb-3">
                        {{ html()->label(__('validation.attributes.backend.access.users.mobile'))->class('col-md-2 form-control-label required-field')->for('mobile') }}

                        <div class="col-md-4">
                            {{ html()->text('mobile')
                                ->class('form-control')
                                ->placeholder(__('validation.attributes.backend.access.users.mobile'))
                                ->attribute('maxlength', config('app.USER_MOBILE_MAX_LENGTH') )
                                ->required() }}
                        </div>
                        <!--col-->
                    </div>

                    <div class="form-group row mb-3">
                        {{ html()->label("Branch(s)")->class('col-md-2 required-field form-control-label')->for('branch') }}
                        <div class="col-md-10">
                            <select class="form-select select2" id="branch" name="branch[]" multiple required>
                            @foreach ($branch_list as $branch)
                            <option value="{{ $branch->id }}" @if(in_array($branch->id, $staff_branch)) selected  @endif>{{ $branch->branch_name }}</option>
                            @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="form-group row mb-3">
                        {{ html()->label('Abilities')->class('col-md-2 form-control-label required-field') }}

                        <div class="table-responsive col-md-10">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>@lang('labels.backend.access.users.table.roles')</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>
                                            @if($roles->count())
                                            @foreach($roles as $role)
                                            @if(strtolower($role->name) == 'user' || strtolower($role->name) == 'trainer' || strtolower($role->name) == 'agent')
                                            @continue;
                                            @endif
                                            <div class="card">
                                                <div class="card-header" style="padding-bottom: 0;color:#2a2a2a;font-weight:bold;">
                                                    <div class="checkbox d-flex align-items-center">

                                                        <div class="form-check">
                                                            <input name="roles[]" class="form-check-input" type="checkbox" id="role-{{$role->id}}" value="{{$role->name}}" <?php if (in_array($role->name, $userRoles)) echo "checked"; ?>>
                                                            <label class="form-check-label" for="gridCheck1">
                                                                {{ucfirst($role->name)}}
                                                            </label>
                                                        </div>

                                                    </div>
                                                </div>
                                                <div class="card-body" style="padding-top:10px;color:#5d5d5d;">
                                                    @if($role->id != 1)
                                                    @if($role->permissions->count())
                                                    @foreach($role->permissions as $permission)
                                                    <i class="fa fa-check"></i>&nbsp;{{ ucwords($permission->name) }}&nbsp;&nbsp;&nbsp;
                                                    @endforeach
                                                    @else
                                                    @lang('labels.general.none')
                                                    @endif
                                                    @else
                                                    @lang('labels.backend.access.users.all_permissions')
                                                    @endif
                                                </div>
                                            </div>
                                            <!--card-->
                                            @endforeach
                                            @endif
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <!--col-->
                    </div>


                </div>
                <!--col-->
            </div>
            <!--row-->
        </div>
        <!--card-body-->

        <div class="card-footer">
            <div class="row" style="text-align:center;">
                <div class="col">
                    {{ form_submit(__('buttons.general.crud.update')) }}
                    {{ form_cancel(route('admin.auth.staff'), __('buttons.general.cancel')) }}
                </div>
                <!--col-->

                <!-- <div class="col text-right">
            </div> -->
                <!--row-->
            </div>
            <!--row-->
        </div>
        <!--card-footer-->
    </div>
    <!--card-->
    {{ html()->closeModelForm() }}
    @endsection