@extends('backend.layouts.app')

@section('title', 'Student Management')

@include('backend.auth.user.includes.top-links-students')

@section('content')

<div class="card">
    <div class="card-body" style="padding-left: 0px !important; padding-right: 0px !important;">
        <div class="row" style="padding-left: 20px !important; padding-right: 20px !important; margin-top: -10px;">
            <div class="col-sm-5 col-10">
                <h4 class="card-title mb-0">{{_label('backend_students')}}</h4>
            </div>
            <!--col-->

            <div class="col-sm-7 col-2">
                <div style="margin-top: 20px;float: right;" class="btn-toolbar float-right" role="toolbar" aria-label="@lang('labels.general.toolbar_btn_groups')">
                <a href="{{ route('admin.auth.student.create') }}" class="btn btn-primary btn-sm ml-1" data-toggle="tooltip" title=" @lang('labels.general.create_new')"><i class="bi bi-plus-circle"></i> Create</a>
                </div>
            </div>
            <!--col-->

        </div>
        <!--row-->

        <div class="filterBox mx-2" style="border-radius: 8px; border: 1px solid rgb(197, 206, 252);">
            <p class="" style="font-size: 18px !important; margin-top: 10px; margin-bottom: 6px;">Filter</p>
             <div class="row">      
            <div class="col-sm-12 col-md-3">
                <label for="overseas_status" style="font-weight: normal !important;">Student Status</label>
                <select class="form-select select2students" id='overseas_status' multiple>
                    {{-- <option value=''>- Status -</option> --}}
                    @foreach($overseas_status_list as $value)
                    <option value="{{$value->status}}" {{($filters['overseas_status'] == $value->status)? 'selected' : ''}}>{{$value->status}}</option>
                    @endforeach
                </select>
            </div>
            
            @if(!\Auth::user()->can('view assigned data only'))
            @if(!auth()->user()->isAgent())
            <div class="col-sm-12 col-md-3">
                <label for="assigned_to" style="font-weight: normal !important;">Assigned To Staff</label>
                <select class="form-select" name="assigned_to" id="assigned_to">
                    <option value="">- Select -</option>
                    <option value="null">Unassigned</option>
                    @foreach($staff as $stf)
                    <option {{($filters['assigned_to'] == $stf->id)? 'selected' : ''}} value="{{$stf->id}}">{{$stf->first_name.' '.$stf->last_name}} @if($logged_in_user->id == $stf->id)(Me) @endif</option>
                    @endforeach
                </select>
            </div>
            @endif
            @endif
            @if(!auth()->user()->isAgent())    
            <div class="col-sm-12 col-md-3">
                <label for="user_country" style="font-weight: normal !important;">Country Of Residence</label>
                <select class="form-select" name="user_country" id="user_country">
                    <option value="">- Select -</option>
                    @foreach($user_countries->sortBy('country') as $countries)
                    <option {{($filters['user_countries'] == $countries->country)? 'selected' : ''}} value="{{$countries->country}}">{{get_country_name($countries->country)}}</option>
                    @endforeach
                </select>
            </div>	 
            <div class="col-sm-12 col-md-2">
                <label for="branch" style="font-weight: normal !important;">Branch</label>
                <select class="form-select" id="branch" name="branch">
                    <option value="all" @if($current_branch == 'all') selected="selected" @endif>All</option>
                    @foreach($branch as $id => $name)
                    <option value="{{ $id }}" @if($current_branch == $id) selected="selected" @endif>{{ $name }}</option>
                    @endforeach
                </select>
            </div>
            @endif
            @if(!auth()->user()->isAgent())
            <div class="col-sm-12 col-md-1">
                <button id="filter_toggle" class="btn btn-sm btn-outline-primary" style=" margin-top: 22px; padding-left: 5px; padding-right: 5px;" title="Filters"><i class="bi bi-funnel"></i> <span id="filter_more">More</span></button>
            </div>
            @endif

            <div class="col-12">
                <div class="row" id="filters"@if(!auth()->user()->isAgent()) style="display:none; border: none !important;" @endif>
                    @if(!auth()->user()->isAgent())
                    <div class="col-sm-12 col-md-3">
                        <label for="country_pref" style="font-weight: normal !important;">Country Interested In</label>
                        <select class="form-select country_interested_in" id='country_pref' multiple>
                            {{-- <option value=''>Country Interested In</option> --}}
                            @foreach($countriesFilter as $country)
                            <option value="{{$country->title_en}}">{{$country->title_en}}</option>
                            @endforeach
                        </select>
                    </div>
    
                    <div class="col-sm-12 col-md-3">
                        <label for="study_level_filter" style="font-weight: normal !important;">Study Level Interested</label>
                        <select class="form-select" id="study_level_filter" name="study_level_filter">
                            <option value="">Select Study Level</option>
                            @foreach(get_study_levels() as $key => $value)
                                <option value="{{$value}}">{{$value}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-sm-12 col-md-3">
                        <label for="course_interested_filter" style="font-weight: normal !important;">Course Interested to Study In</label>
                        <select name="course_interested_filter" id="course_interested_filter" class="form-select">
                            <option value="">Select Course Interested</option>
                            @foreach($courseFilter as $key => $value)
                                <option value="{{$value->overseas_course_intersted}}">{{$value->overseas_course_intersted}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-sm-12 col-md-3">
                        <label for="intake_filter" style="font-weight: normal !important;">Intake</label>
                        <select name="intake_filter" id="intake_filter" class="form-select form-control">
                            <option value="">Intake</option>
                            <?php $month = date('n'); // current month
                            for ($x = 0; $x < 24; $x++) { ?>
                                <option {{(Request::old('intake')==date('m Y', mktime(0,0,0,$month + $x,1)))? 'selected' : ''}} value="<?php echo date('m Y', mktime(0, 0, 0, $month + $x, 1)); ?>">
                                    <?php echo date('F Y', mktime(0, 0, 0, $month + $x, 1)); ?>
                                <?php } ?></option>
                        </select>
                    </div>
                    @if(env('ADDITIONAL_SERVICES_ENABLE'))
                    <div class="col-sm-12 col-md-3">
                        <label for="service_pref" style="font-weight: normal !important;">Service Interested In</label>
                        <select class="form-select service_interested_in" id='service_pref' multiple>
                            @foreach(get_services_data() as $service)
                            <option @if(old('services') == $service->id) selected @endif value="{{$service->id}}">{{$service->service_name}}</option>
                            @endforeach
                        </select>
                    </div>
                    @endif
                
                    <div class="col-sm-12 col-md-3">
                        <label for="created_date" style="font-weight: normal !important;">Created Date</label>
                        <input type="text" autocomplete="off" class="form-control" id="created_date" name="created_date" placeholder="Created Date">
                    </div>
                    <div class="col-sm-12 col-md-3">
                        <label for="next_followup_date" style="font-weight: normal !important;">Next Follow-up</label>
                        <select class="form-select" id="next_followup_date" name="next_followup_date">
                            <option value="--">- Select -</option>
                            <option value="overdue">Overdue</option>
                            <option value="today">Today</option>
                            <option value="tomorrow">Tomorrow</option>
                            <option value="in_next_7_days" >In Next 7 Days</option>
                            <option value="custom" id="custom">Custom</option>
                        </select>
                    </div>
                    <div class="col-sm-12 col-md-3 d-none" id="followup_daterange_box">
                        <label for="followup_daterange" style="font-weight: normal !important;">Date Range</label>
                        <div class="input-group mb-3" >
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="border-top-right-radius: 0px; border-bottom-right-radius: 0px;" id="basic-addon2"><i class="bi bi-calendar-check" style="font-size: 0.9rem;"></i></span>
                            </div>
                            <input type="text" autocomplete="off" id="followup_daterange" value="@isset($filters['followup_daterange']){{$filters['followup_daterange']}}@endisset" name="followup_daterange" class="daterange form-control" placeholder="Choose">
                        </div>
                    </div>
    
                    <div class="col-sm-12 col-md-3">
                        <label for="student_age" style="font-weight: normal !important;">Profile Age Greater Than</label>
                        <input type="number" id="student_age" min="1" step="1" value="@isset($filters['student_age']){{$filters['student_age']}}@endisset" name="student_age" class="form-control" placeholder="Days">
                    </div>
                    <div class="col-sm-12 col-md-3">
                        <label style="font-weight: normal !important;" for="tags_filter">Tags</label>
                        <select class="form-select select2" id='tags_filter' name="tags_filter" multiple>
                            @foreach(get_all_tags() as $tags_data)
                                    <option value="{{$tags_data->tag_name}}" {{($filters['tags_filter'] == $tags_data->tag_name)? 'selected' : ''}}>{{$tags_data->tag_name}}</option>
                            @endforeach
                        </select>
                    </div>
                    @if(!auth()->user()->isAgent())
                    <div class="row">
                        <div class="col-12">
                            {{-- @if(config('app.product_code
                                ') == 'VISA')
                            <input type="checkbox" name="mystu" id="mystu" value="1" @if($filters['my_data']=='1' ) checked @endif> 
                            <label for="mystu">My Clients Only</label>
                            @else
                            <input type="checkbox" name="mystu" id="mystu" value="1" @if($filters['my_data']=='1' ) checked @endif> 
                            <label for="mystu">My Students Only</label>
                            @endif --}}
                            <input type="checkbox" name="mystu" id="mystu" value="1" @if($filters['my_data']=='1' ) checked @endif> 
                            <label for="mystu" style="font-weight: normal !important;">My {{_label('backend_students')}} Only</label>
                            

                            <input type="checkbox" class="ms-3" name="excludeAgentStudent" id="excludeAgentStudent" value="1" @if($filters['my_data']=='1' ) checked @endif>
                            <label for="excludeAgentStudent" style="font-weight: normal !important;">Exclude Agent {{_label('backend_students')}}</label>

                            <input type="checkbox" class="ms-3" name="agentListOnly" id="agentListOnly" value="1"> 
                            <label for="agentListOnly" style="font-weight: normal !important;">Agent {{_label('backend_students')}} Only</label>
                        </div>
                    </div>
                    @endif

                    @endif
                    <div class="row">
                        <div class="col-sm-12 col-md-6 mx-auto d-flex justify-content-center">
                            <button onclick="javascript:searchTable();" class=" btn btn-primary btn-sm px-4 mx-2">
                                <span id="filter-spin-button">Filter</span>
                                <div class="spinner-border text-white spinner-border-sm mx-2" id="filter-spin" role="status">
                                    <span class="visually-hidden">Loading...</span>
                                </div>
                            </button>
                            <button onclick="javascript:clearTable();" class=" btn btn-outline-primary btn-sm px-4">Clear</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        </div>

        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive">
                    <table class="table" id='student_users'>
                        <thead>
                            <tr>
                                <th>
                                    <div class="form-check form-check-sm form-check-custom form-check-solid ms-2">
                                        <input class="form-check-input" type="checkbox" id="check_all" name="check_all"/>
                                    </div>                                                                        
                                </th>
                                <th>ID</th>
                                <th style="display: none;">Name</th>
                                <th style="display: none;">Email</th>
                                <th style="display: none;">Mobile</th>
                                <th style="display: none;">Whatsapp</th>
                                <th style="display: none;">Location</th>
                                <th style="display: none;">Branch</th>
                                <th>{{_label('backend_student')}}</th>
                                <th style="min-width: 65px !important; padding-right: 20px !important;">Next Follow-up</th>
                                <th>Status</th>
                                <th style="padding-right: 20px !important;">Assigned to</th>
                                <th style="min-width: 65px !important; padding-right: 20px !important;">Created</th>
                                <th style="min-width: 121px !important;">@lang('labels.general.actions')</th>
                            </tr>
                        </thead>
                    </table>
                    <br><br>
                    @if(!(\Auth::user()->isAgent()))
                    <div class="col-md-3 col-sm-12 process-selected mx-3" id="bulk_operation" style="display:none; margin:15px 2px;">
                        {{-- <label class="label label-default">With Selected</label> --}}
                        <select class="form-select" name="bulk_assigned_to" id="bulk_assigned_to">
                            <option value="">- Bulk Actions -</option>
                            <option value="bulk_student_assignment">Assign {{_label('backend_students')}} to Staff</option>
                            <option value="bulk_archive_student">Archive {{_label('backend_students')}}</option>
                            <option value="bulk_student_delete">Delete {{_label('backend_students')}}</option>
                        </select>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
    <!--card-body-->
</div>
<!--card-->

<div class="modal fade" id="studentAssignedStaffModal">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Assign User to Staff</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" style="font-size: 30px;"></button>
            </div>
            <div class="modal-body load_modal" style="padding: 0px 20px;">

            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="createTagModal">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Add Tags</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" style="font-size: 50px;"></button>
            </div>
            <div class="modal-body tag_modal_data">
                <form method="POST" id="add_tag_form" action="">
                @csrf
                <div class="form-group row">
                        <input type="hidden" name="client_id" id="tag_client_id" value="">
                        <div class="col-sm-12">
                            <label style="padding-bottom: 2px;" class="col-form-label required-field"><b>Select/Add New Tag</b></label>
                            <div class="">
                                <select class="form-select select2tags" id='client_tags' name="client_tags[]" multiple>
                                        @foreach(get_all_tags() as $tags)
                                        <option value="{{$tags->tag_name}}">{{$tags->tag_name}}</option>
                                        @endforeach
                                </select>
                            </div>
                        </div>
                </div>
                <div class="row" style="margin-top:10px;">
                    <div class="col-sm-4 mx-auto">
                        <div class="form-group mb-0 clearfix">
                            <button class="btn btn-primary btn-sm" type="submit">Add Tag</button>
                        </div>
                    </div>
                </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('after-scripts')
<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<script>
    $(document).ready(function() {
        loadData();
        $(".select2students").select2({
            placeholder: "",
        });
        $(".select2tags").select2({
            tags: true
        });
        $(document).on('keypress', '.select2-search__field', function() {
            $(this).attr('maxlength', 20);
            var inputValue = event.which;
            if ((inputValue == 44)) {
                event.preventDefault();
            }
        });
        $("#check_all").on("click", function () {
            if ($("input:checkbox[name='check_all']").prop("checked")) {
                $("input:checkbox[name='multiselect']").prop("checked", true);
            } else {
                $("input:checkbox[name='multiselect']").prop("checked", false);
            }
            checkboxCheckSelected();
        });

        $("#next_followup_date").change(function() {
            if (this.value == 'custom') {
                $('#followup_daterange_box').removeClass('d-none');
            }else{
                $('#followup_daterange_box').addClass('d-none');            
            }
        });

        $('.daterange').daterangepicker({
            autoUpdateInput: false,
        });
        $('.daterange').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('DD-MM-YYYY') + ' to ' + picker.endDate.format('DD-MM-YYYY'));
        });
        $('.daterange').on('cancel.daterangepicker', function(ev, picker) {
            $(this).val('');
        });

        // $('#mystu').change(function() {
        //     $("#student_users").dataTable().fnDestroy();
        //     loadData();
        // });

        // $('#excludeAgentStudent').change(function() {
        //     $("#student_users").dataTable().fnDestroy();
        //     loadData();
        // });

        var start = moment().subtract(29, 'days');
        var end = moment();
        $('#created_date').daterangepicker({
            "showDropdowns": true,
            "showWeekNumbers": true,
            "showISOWeekNumbers": true,
            autoUpdateInput: false,
            locale: {
                    format: 'DD-MM-YYYY',
                    "separator": " to ",
            },
            "ranges": {
                'Today': [moment(), moment()],
                'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                'This Month': [moment().startOf('month'), moment().endOf('month')],
                'Last 6 Month': [moment().subtract(6, 'month'), moment()],
                'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                },
            "alwaysShowCalendars": true,
        });
        $('#created_date').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('DD-MM-YYYY') + ' to ' + picker.endDate.format('DD-MM-YYYY'));
        });
        $('#created_date').on('cancel.daterangepicker', function(ev, picker) {
            $(this).val('');
        });
        
        $('#bulk_assigned_to').on('change', function() {
            // Checking with selected empty or not
            var dataArray = new Array();
            $("input:checkbox[name=multiselect]:checked").each(function() {
                dataArray.push($(this).val());
            });
            if(dataArray.length == 0){
                alert("Please select at-least one Student!");
                $('#bulk_assigned_to').val("");
                return;
            }

            if(this.value == 'bulk_student_assignment'){
                processBulkLead();
            }
            if(this.value == 'bulk_student_delete'){
                Swal.fire({
                    title: `Are you sure you want to delete selected {{_label('backend_students')}}?`,
                    showCancelButton: true,
                    confirmButtonText: "Delete",
                    cancelButtonText: "Cancel",
                    type: 'warning'
                }).then((result) => {
                    result.value && processBulkDelete();
                });      
            }
            else if(this.value == 'bulk_archive_student'){
                Swal.fire({
                    title: `Are you sure you want to archive selected {{_label('backend_students')}}?`,
                    showCancelButton: true,
                    confirmButtonText: "Archive",
                    cancelButtonText: "Cancel",
                    type: 'warning'
                }).then((result) => {
                    result.value && processBulkArchive();
                });
            }else{

            }
        });

        $(".country_interested_in").select2({
            placeholder: "",
        });
        $(".service_interested_in").select2({
            placeholder: "",
        });

        $('#filter_toggle').on('click', function() {
            $('#filters').slideToggle();
            let filter_text = $('#filter_more').text();
            if(filter_text === "More"){
                $('#filter_more').text("Less");
            } else{
                $('#filter_more').text("More");
            }
        });
        
        $('#overseas_status ~.select2-container--default, #user_country, #assigned_to, #branch').on('click', function() {
            $('#filters').slideDown();
            let filter_text = $('#filter_more').text();
            if(filter_text === "More"){
                $('#filter_more').text("Less");
            } 
        });

    });

    function processBulkDelete(){
        var dataArray = new Array();
        $("input:checkbox[name=multiselect]:checked").each(function(){
            dataArray.push($(this).val());
        });
        var sub_options = {url: "{{route('admin.auth.user.bulkdeletestudent')}}",
                  method: "POST",
                  data: {'id_arr':dataArray, '_token':  $('meta[name="csrf-token"]').attr('content')}
                 };
        manual_form_submit(sub_options);
    }

    function processBulkArchive(){
        var dataArray = new Array();
        $("input:checkbox[name=multiselect]:checked").each(function(){
            dataArray.push($(this).val());
        });
        var sub_options = {url: "{{route('admin.auth.user.bulk.archived-student')}}",
            method: "POST",
            data: {'id_arr':dataArray, '_token':  $('meta[name="csrf-token"]').attr('content')}
        };
        manual_form_submit(sub_options);
    }

    function processBulkLead(){
        var dataArray = new Array();
        $("input:checkbox[name=multiselect]:checked").each(function(){
            dataArray.push($(this).val());
        });
        var sub_options = {url: "{{route('admin.auth.user.bulkassignstudent')}}",
                  method: "POST",
                  data: {'id_arr':dataArray, '_token':  $('meta[name="csrf-token"]').attr('content')}
                 };
        manual_form_submit(sub_options);
    }

    function manual_form_submit(options){
        var $form = $("<form />");
        $form.attr("action",options.url);
        $form.attr("method",options.method);
        for (var data in options.data)
        $form.append('<input type="hidden" name="'+data+'" value="'+options.data[data]+'" />');
        $("body").append($form);
        $form.submit();
    }  

    function checkboxCheckSelected(){
        var total_check_boxes = $("input:checkbox[name='multiselect']").length;
        var total_checked_boxes = $("input:checkbox[name='multiselect']:checked").length;
        if (total_check_boxes === total_checked_boxes) {
            $("#check_all").prop("checked", true);
        }
        else {
            $("#check_all").prop("checked", false);
        }
        if(total_checked_boxes > 0){
            $(".process-selected").show();
        }
        else{
            $(".process-selected").hide();
        }
    }

    function clearSelectedCheckboxs(){
        $("#check_all").prop("checked", false);
        $(".process-selected").hide();
        
    }
    
    function loadData(mystu) {
        $('#student_users').DataTable({
            @if($logged_in_user->isAdmin() || $logged_in_user->can('export lead, student data'))
            "dom": '<"row px-3"<"col-md-3 text-start"l><"col-md-5 text-start"f><"col-md-4 text-end"B>>rt<"ps-3"i><"pe-3"p>',
            @else
            "dom": '<"row px-3"<"col-md-3 text-start"l><"col-md-5 text-start"f><"col-md-4 text-end">>rt<"ps-3"i><"pe-3"p>',
            @endif
            "processing": true,
            "serverSide": true,
            "autoWidth": true,
            "responsive": true,
            "scrollX": true,
            "sScrollXInner": "100%",
            "language": {
                searchPlaceholder: "Search By ID, Name, Email, Mobile..."
            },
            "lengthMenu": [10, 25, 50, 100, 500],
            "ajax": {
                "url": "{{route('admin.auth.user.ajaxuserdata')}}",
                "dataType": "json",
                "type": "post",
                data: {
                    @if(config('app.product_code') == 'EDUCTRL_CRM')
                    'student_type': $('#student_type').val(),
                    @endif
                    'overseas_status': $('#overseas_status').val(),
                    'coaching_status': $('#coaching_status').val(),
                    '_token': $('meta[name="csrf-token"]').attr('content'),
                    'user_country': $('#user_country').val(),
                    @if(!auth()->user()->isAgent())
                    'assigned_to': $('#assigned_to').val(),
                    'next_followup': $('#next_followup_date').val(),
                    'followup_daterange': $('#followup_daterange').val(),
                    'created_date': $('#created_date').val(),
                    'mystu': $('#mystu:checked').val(),
                    'excludeAgentStudent': $('#excludeAgentStudent:checked').val(),
                    'agentListOnly': $('#agentListOnly:checked').val(),
                    @endif
                    'branch': $('#branch').val(),
                    'student_age': $('#student_age').val(),
                    'tags_filter': $('#tags_filter').val(),
                    'country_pref': $('#country_pref').val(),
                    'study_level_filter': $('#study_level_filter').val(),
                    'course_interested_filter': $('#course_interested_filter').val(),
                    'intake_filter': $('#intake_filter').val(),
                    'service_pref': $('#service_pref').val(),
                },

            },
            "drawCallback": function( settings ) {
                addDeleteForms();
                $('#bulk_operation').show();  
            },
            "columns": [
                { 
                    "data": 'id',
                    orderable: false,
                },
                { 
                    "data": 'id',
                },
                {
                    "data": "export_name",
                    visible: false,
                },
                {
                    data: 'email',
                    visible: false,
                },
                {
                    data: 'mobile',
                    visible: false,
                },
                {
                    data: 'whatsapp',
                    visible: false,
                },
                {
                    data: 'location',
                    visible: false,
                },
                {
                    data: 'branch',
                    visible: false,
                },
                {
                    "data": "details",
                    orderable: true,
                },
                {
                    "data": "next_followup",
                    orderable: true,
                },
                {
                    "data": "status",
                    orderable: false,
                },
                {
                    "data": 'assigned_to_name',
                },
                {
                    "data": "created_at",
                },   
                {
                    "data": "options",
                    orderable: false,
                },

            ],
            "fnInitComplete": function (oSettings, json) {
                $("#filter-spin").hide();
                $("#filter-spin-button").text("Filter");
            },
            columnDefs: [
                @if(!auth()->user()->isAgent())
                {
                    targets: 0,
                    orderable: false,
                    render: function (data) {
                    
                        if(data != ''){
                            return `
                                <div class="form-check form-check-sm form-check-custom form-check-solid">
                                    <input class="form-check-input data-checkboxs" onclick="javascript:checkboxCheckSelected();" name="multiselect" type="checkbox" value="${data}" />
                                </div>`;
                        }
                        else{
                            return `
                                <div class="form-check form-check-sm form-check-custom form-check-solid">
                                    <input class="form-check-input data-checkboxs" name="multiselectd" type="checkbox" value="" disabled />
                                </div>`;
                        }
                    }
                },
                @endif
                
                @if(auth()->user()->isAgent())
                {
                    target: 0,
                    visible: false,
                },
                {
                    target: 7,
                    visible: false,
                },
                {
                    target: 9,
                    visible: false,
                },
                {
                    target: 11,
                    visible: false,
                },
                @endif
             ],
            'order': [
                [12, 'desc']
            ],
            @if($logged_in_user->isAdmin() || $logged_in_user->can('export lead, student data'))
            "buttons": [{
                    extend: 'excel',
                    text: '<i class="ri-file-excel-2-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Excel" ></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        @if(auth()->user()->isAgent())
                            columns: [1, 2, 3, 4, 5, 6, 7, 10, 12]
                        @else
                            columns: [1, 2, 3, 4, 5, 6, 7, 9, 10, 11, 12]
                        @endif
                    },
                },
                {
                    extend: 'pdf',
                    text: '<i class="bi bi-file-earmark-pdf" data-toggle="tooltip" data-placement="top" title="Pdf"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    orientation: 'landscape',
                    exportOptions: {
                        @if(auth()->user()->isAgent())
                            columns: [12, 1, 2, 3, 4, 5, 6, 7, 10]
                        @else                        
                            columns: [12, 1, 2, 3, 4, 5, 7, 6, 10, 9, 11, 12]
                        @endif
                    },
                },
                {
                    extend: 'print',
                    text: '<i class="bi bi-printer" data-toggle="tooltip" data-placement="top" title="Print"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    orientation: 'landscape',
                    exportOptions: {
                        @if(auth()->user()->isAgent())
                            columns: [12, 1, 2, 3, 4, 5, 6, 7, 10]
                        @else
                            columns: [12, 1, 2, 3, 4, 5, 7, 6, 10, 9, 11]
                        @endif
                    },
                },
                {
                    extend: 'copy',
                    text: '<i class="ri-file-copy-2-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Copy"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        @if(auth()->user()->isAgent())
                            columns: [1, 2, 3, 4, 5, 6, 7, 10, 12]
                        @else
                            columns: [1, 2, 3, 4, 5, 6, 7, 9, 10, 11, 12]
                        @endif
                    },
                },
                {
                    extend: 'csv',
                    text: '<i class="ri-file-excel-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Csv"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        @if(auth()->user()->isAgent())
                            columns: [1, 2, 3, 4, 5, 6, 7, 10, 12]
                        @else
                            columns: [1, 2, 3, 4, 5, 6, 7, 9, 10, 11, 12]
                        @endif
                    },
                },
            ]
            @endif
        });
    }

    $("#excludeAgentStudent").change(function() {
        $('#agentListOnly').val('1').prop('checked',false);
    });
    $("#agentListOnly").change(function() {
        $('#excludeAgentStudent').val('1').prop('checked',false);
    });

    $(document).on('click', '.add-tag-btn', function() {
        var this_id = $(this).attr('data-id');
            $('#tag_client_id').val(this_id);
            $('#createTagModal').modal('show');
            $('#createTagModal').on('hidden.bs.modal', function() {
                $('#tag_client_id').val('');
                $('#client_tags').val("").trigger("change");
            });
    });

    $(document).on('click', '.remove-tag', function(event) {
        event.preventDefault();
        var client_id = $(this).attr('id');
        var tag_name = $(this).attr('data-tag_name');
        $.ajax({
            url: "{{route('admin.auth.user.remove-tag')}}",
            type: "POST",
            data: {
                client_id: client_id,
                tag_name: tag_name,
                _token: '{{csrf_token()}}'
            },
            context: this,
            success: function (result) {
                if(result.success){
                    var table = $('#student_users').DataTable();
                    table.draw( false );
                } else{
                    swal.fire({
                        title: result.message,
                        icon: "error",
                        button: "ok",
                    });
                }
            }
        }); 
    });

    $('#add_tag_form').on('submit', function(e) {
        e.preventDefault();
        let client_id = $('#tag_client_id').val();
        let client_tags = $('#client_tags').val();
        $.ajax({
            url: "{{route('admin.auth.user.add-tag')}}",
            type: "POST",
            data: {
                "_token": "{{ csrf_token() }}",
                client_id: client_id,
                client_tags: client_tags,
            },
            success: function(result) {
                if(result.success){
                    swal.fire({
                        title: result.message,
                        icon: "success",
                        button: "ok",
                    });
                    $('#createTagModal').modal('hide');
                    var table = $('#student_users').DataTable();
                    table.draw( false );
                } else{
                    swal.fire({
                        title: result.message,
                        icon: "error",
                        button: "ok",
                    });
                    $('#createTagModal').modal('hide');
                }
            },
            error: function(response) {
                swal.fire({
                    title: "Something went wrong!",
                    icon: "danger"
                });
            },
        });
    });
    function searchTable() {
        $("#filter-spin").show();
        $("#filter-spin-button").text("Filtering");
        $("#student_users").dataTable().fnDestroy();
        loadData();
    }

    function clearTable() {
        $("#filter-spin").show();
        @if(config('app.product_code') == 'EDUCTRL_CRM')
            if($('#student_type').length) {
                $('#student_type').val('');
            }
        @endif
        if($('#overseas_status').length) {
            $('#overseas_status').val('');
            $('#overseas_status').val('').trigger('change');
        }
        if($('#coaching_status').length) {
            $('#coaching_status').val('');
        }
        if($('#assigned_to').length) {
            $('#assigned_to').val('');
        }
        $('#next_followup_date').val('--').trigger('change');
        $('#next_followup_date').val('all');
        $('#followup_daterange').val('');
        $('#created_date').val(''); 
        $('#mystu').val('1').prop('checked',false);
        $('#excludeAgentStudent').val('1').prop('checked',false);
        $('#agentListOnly').val('1').prop('checked',false);
        
        $('#user_country').val('');
        $('#branch').val('all');
        $('#student_age').val('');
        $("#student_users").dataTable().fnDestroy();

        $('#country_pref').val('').trigger('change');
        $('#study_level_filter').val('').trigger('change');
        $('#course_interested_filter').val('').trigger('change');
        $('#intake_filter').val('').trigger('change');
        $('#service_pref').val('').trigger('change');
        $('#tags_filter').val('').trigger('change');
        @if(!auth()->user()->isAgent())
        $('#filters').slideToggle();
        $('#filter_more').text("More");
        @endif
        loadData();
    }    

    $(document).on('click', '.assigned_to_staff', function() {
        var this_id = $(this).attr('data-id');

        var base_url = "{{ url('admin/auth/assignclient/')}}/" + this_id;
        $.get(base_url, function(data) {
            $('#studentAssignedStaffModal').on('shown.bs.modal', function() {
                $('#studentAssignedStaffModal .load_modal').html(data);
            });
            $('#studentAssignedStaffModal').modal('show');
            $('#studentAssignedStaffModal').on('hidden.bs.modal', function() {
                $('#studentAssignedStaffModal .load_modal').html("");
            });
        });
    });
</script>
@endpush
@push ('after-styles')
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
<style>
.select2-container {
        width: 100% !important;
    }
    .select2-container.select2-container--default.select2-container--open {
        z-index: 5000;
    }

    .select2-container .select2-search--inline .select2-search__field{
        height: 10px !important;
        padding: 8px !important;
    }
    .select2-container--default .select2-selection--multiple{
        padding-bottom: 0px !important;
    }

    .edu-tooltip {
        position: relative;
        margin-top: -10px;
        /* margin-bottom: 0px; */
        /* display: inline-block; */
        /* border-bottom: 1px dotted black; */
    }

    .edu-tooltip .edu-tooltiptext {
        visibility: hidden;
        width: 300px;
        background-color: rgb(62, 62, 62);
        color: #fff;
        font-size: 0.9em;
        text-align: center;
        border-radius: 6px;
        padding: 5px 5px;
        position: absolute;
        z-index: 1;
        top: 100%;
        left: 50%;
        margin-left: -60px;
        line-height: 16px;
        font-size: 12px;
        text-wrap: wrap;
        font-style:normal;
    }

    .edu-tooltip .edu-tooltiptext::after {
        content: "";
        position: absolute;
        bottom: 100%;
        left: 20%;
        margin-left: -5px;
        border-width: 5px;
        border-style: solid;
        border-color: transparent transparent rgb(62, 62, 62) transparent;
    }

    .edu-tooltip:hover .edu-tooltiptext {
        visibility: visible;
    }
    .lead-horizontal {
        overflow-x: scroll;
    }

    .select2-search--inline > textarea{
        height: 12px !important;
    } 
</style>
@endpush
