@extends('backend.layouts.app')
@section('title', 'Edit Serivce Application')
@section('content')

<div class="card">
    <div class="card-body">
        <div class="row mt-4">
            <div class="col">
                <div class="row mb-2">
                    <div class="col-sm-10 col-10">
                        <h4>Edit Service Request</h4>
                    </div>
                    <div class="col-sm-2 col-2" style="text-align: right;">
                        <button type="cancel" name="back" class="btn btn-primary btn-sm" value="Back" onclick="document.location ='{{ url('admin/auth/user/'.$service_application->user_id.'#services') }}'" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </button>
                    </div>
                </div>
                <form method="post" action="{{route('admin.service-request.edit.store')}}">
                    <div class="row">
                        @csrf
                        <input type="hidden" name="service_application_id" value="{{$service_application->id}}">
                        <input type="hidden" name="user_id" value="{{$service_application->user_id}}">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="" class="required-field">Select Service</label>
                                <select class="form-control form-select" id="service_id" name="service_id" disabled required>
                                    <option value="">Select</option>
                                    @foreach(get_services_data() as $service)
                                        <option @if(old('service_id') == $service->id) selected @elseif($service_application->service_id == $service->id) selected @endif value="{{$service->id}}">{{$service->service_name}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4" id="country_block">
                            <div class="form-group">
                                <label for="" class="required-field" id="country_label">Country</label>
                                <select class="form-control form-select" id="country" name="country" required>
                                    <option value="">Country</option>
                                    @foreach($countries as $country)
                                        <option @if(old('country') == $country->id) selected @elseif($service_application->country == $country->id) selected @endif value="{{$country->id}}">{{$country->name}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="college_appl_id" id="college_appl_id">University Application ID</label>
                                <select class="form-control form-select" id="college_appl_id" name="college_appl_id" required>
                                    <option value="0">N/A</option>
                                    @foreach($universityApplId as $universityAppl)
                                        <option @if(old('college_appl_id') == $universityAppl->appl_id) selected @elseif($service_application->college_appl_id == $universityAppl->appl_id) selected @endif value="{{$universityAppl->appl_id}}">{{$universityAppl->appl_id}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <span class="label"><b>Amount</b></span><br>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" style="padding: 5px 10px;font-size: 15px;">{{env('APP_CURRENCY_SYMBOL')}}</span>
                                </div>
                                <input type="number" id="amount" name="amount" class="form-control" placeholder="Amount" value="{{$service_application->amount}}">
                            </div>
                        </div>
                        <div class="col-md-8">
                            <div class="form-group">
                                <label for="">Description</label>
                                <input type="text" name="description" class="form-control" value="@if(old('description')){{Request::old('description')}}@elseif($service_application->description){{$service_application->description}}@endif" placeholder="Notes">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-2 mx-auto">
                            <button type="submit" class="form-control btn btn-primary">Update</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

@endsection

@push ('after-scripts')
<script>
    $(document).ready(function() {        
        $('#service_id').on('change', function () {
            var services_id = this.value;
            $.ajax({
                url: "{{route("admin.search.service.country")}}",
                type: "POST",
                data: {
                    services_id: services_id,
                    _token: '{{csrf_token()}}'
                },
                dataType: 'json',
                success: function (results) {
                    if(results.results){
                        $('#country').attr('required','required');
                        $('#country_label').addClass('required-field');
                        $('#country_block').show();
                    }else{
                        $('#country').removeAttr('required');
                        $('#country_label').removeClass('required-field');
                        $('#country_block').hide();
                    }
                }
            });
        });

        $('#service_id').trigger('change');
    });
</script>
@endpush