@extends('backend.layouts.app')
@section('title'){{$user->name.": Details"}} @endsection

@section('content')
<div class="card">
    {{-- <div class="row" @if($user->is_lead) style="background: #d5bb6c;" @else style="background: #1976d2;border-color: #1976d2;" @endif> --}}
    <div class="row p-3">
        <div class="col-1 mt-2">
            @if($user->avatar_location != '')
            <img width="60px" height="60px" src="{{ asset('storage/'.$user->avatar_location) }}" alt="user" style="border-radius: 50%" />
            @else
                @if($user->gender == "female")
                    <img src="{{asset('assets/images/users/girl.png')}}" width="60px" height="60px" style="border-radius: 50%" class="border" alt="">
                @else
                    <img src="{{asset('assets/images/users/boy.png')}}" width="60px" height="60px" style="border-radius: 50%" class="border" alt="">
                @endif
            {{-- <img width="60px" height="60px" src="{{ asset('assets/images/users/user.jpg') }}" alt="user" style="border-radius: 50%" /> --}}
            @endif
        </div>
        
        <div class="col-11">
            {{-- <div @if($user->is_lead) class="card-header text-dark" style="background: #d5bb6c; border-color: #d5bb6c" @else class="card-header text-white"  style="background: #1976d2;border-color: #1976d2;" @endif> --}}
                <h4 class="text-dark" style="font-weight: 600">{{ $user->name }}</h4>
                @if($user->email)
                <svg style="margin-bottom: 5px !important; color: rgb(52, 52, 52) !important;" xmlns="http://www.w3.org/2000/svg" width="14" height="14" fill="currentColor" class="bi bi-envelope sub-text" viewBox="0 0 16 16">
                    <path d="M0 4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V4Zm2-1a1 1 0 0 0-1 1v.217l7 4.2 7-4.2V4a1 1 0 0 0-1-1H2Zm13 2.383-4.708 2.825L15 11.105V5.383Zm-.034 6.876-5.64-3.471L8 9.583l-1.326-.795-5.64 3.47A1 1 0 0 0 2 13h12a1 1 0 0 0 .966-.741ZM1 11.105l4.708-2.897L1 5.383v5.722Z"/>
                  </svg>&nbsp;
                    <span class="sub-text" style="color: rgb(52, 52, 52) !important;">{{ $user->email }}
                    @if(!\Auth::user()->isAgent())
                    <a target='_blank' href="{{ route('admin.communicate.mail', $user->id)}}" title="Email" class="text-reset" style="margin-bottom: 0px !important;"> 
                        {{-- <img src="{{asset('assets/images/icon/mail.png')}}" width="25px" alt=""> --}}
                        <i class="bi bi-envelope btn btn-sm btn-outline-primary border-0" style="font-size: 20px !important;"></i>
                    </a>
                    @endif
                    </span>
                @endif
                @if($user->mobile)
                {{-- <br> --}}&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                {{-- <div class=" d-inline-block">
                    <div class=" d-inline-block"> --}}
                        <svg style="margin-bottom: 5px !important; color: rgb(52, 52, 52) !important;" xmlns="http://www.w3.org/2000/svg" width="14" height="14" fill="currentColor" class="bi bi-telephone sub-text" viewBox="0 0 16 16">
                            <path d="M3.654 1.328a.678.678 0 0 0-1.015-.063L1.605 2.3c-.483.484-.661 1.169-.45 1.77a17.568 17.568 0 0 0 4.168 6.608 17.569 17.569 0 0 0 6.608 4.168c.601.211 1.286.033 1.77-.45l1.034-1.034a.678.678 0 0 0-.063-1.015l-2.307-1.794a.678.678 0 0 0-.58-.122l-2.19.547a1.745 1.745 0 0 1-1.657-.459L5.482 8.062a1.745 1.745 0 0 1-.46-1.657l.548-2.19a.678.678 0 0 0-.122-.58L3.654 1.328zM1.884.511a1.745 1.745 0 0 1 2.612.163L6.29 2.98c.329.423.445.974.315 1.494l-.547 2.19a.678.678 0 0 0 .178.643l2.457 2.457a.678.678 0 0 0 .644.178l2.189-.547a1.745 1.745 0 0 1 1.494.315l2.306 1.794c.829.645.905 1.87.163 2.611l-1.034 1.034c-.74.74-1.846 1.065-2.877.702a18.634 18.634 0 0 1-7.01-4.42 18.634 18.634 0 0 1-4.42-7.009c-.362-1.03-.037-2.137.703-2.877L1.885.511z"/>
                        </svg>
                    {{-- </div> --}}
                      &nbsp;
                        <span class="sub-text" style="color: rgb(52, 52, 52) !important;">@if($user->dialcode) +{{ $user->dialcode }}-@endif{{ $user->mobile }}</span>&nbsp;
                {{-- </div> --}}
                @if(!\Auth::user()->isAgent())
                    @if(get_site_config('outbound_call_enabled'))
                        <button data-num="{{$user->id}}" class="text-reset call_btn btn" title="Phone" style="margin: 0px !important; padding: 0px !important;"> 
                            {{-- <i class='fas fa-phone-alt contactIcon'></i> --}}
                            <i class="bi bi-telephone-outbound btn btn-sm btn-outline-info border-0" style="font-size: 20px !important;"></i>
                        </button> 
                    @endif
                    <a target='_blank' href="{{ route('admin.communicate.sms', $user->id)}}" title="Message" class="text-reset" style="margin-bottom: 0px !important"> 
                        {{-- <i class="bi bi-envelope btn btn-sm btn-outline-primary rounded-circle"></i> --}}
                        <i class="bi bi-chat-dots btn btn-sm btn-outline-info border-0" style="font-size: 20px !important;"></i>
                            </a> 
                    @endif
                    
                    {{-- <a href="tel:+{{$user->dialcode}}{{$user->mobile}}"  class="text-reset btn btn-sm" style="margin-bottom: 0px !important"> 
                        <i class='fas fa-phone-alt '  style="color:white"></i>
                    </a> --}}
                @endif

                @if($user->whatsapp)
                {{-- <br> --}}&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                <svg style="margin-bottom: 5px !important; color: rgb(52, 52, 52) !important;" xmlns="http://www.w3.org/2000/svg" width="14" height="14" fill="currentColor" class="bi bi-whatsapp sub-text" viewBox="0 0 16 16">
                    <path d="M13.601 2.326A7.854 7.854 0 0 0 7.994 0C3.627 0 .068 3.558.064 7.926c0 1.399.366 2.76 1.057 3.965L0 16l4.204-1.102a7.933 7.933 0 0 0 3.79.965h.004c4.368 0 7.926-3.558 7.93-7.93A7.898 7.898 0 0 0 13.6 2.326zM7.994 14.521a6.573 6.573 0 0 1-3.356-.92l-.24-.144-2.494.654.666-2.433-.156-.251a6.56 6.56 0 0 1-1.007-3.505c0-3.626 2.957-6.584 6.591-6.584a6.56 6.56 0 0 1 4.66 1.931 6.557 6.557 0 0 1 1.928 4.66c-.004 3.639-2.961 6.592-6.592 6.592zm3.615-4.934c-.197-.099-1.17-.578-1.353-.646-.182-.065-.315-.099-.445.099-.133.197-.513.646-.627.775-.114.133-.232.148-.43.05-.197-.1-.836-.308-1.592-.985-.59-.525-.985-1.175-1.103-1.372-.114-.198-.011-.304.088-.403.087-.088.197-.232.296-.346.1-.114.133-.198.198-.33.065-.134.034-.248-.015-.347-.05-.099-.445-1.076-.612-1.47-.16-.389-.323-.335-.445-.34-.114-.007-.247-.007-.38-.007a.729.729 0 0 0-.529.247c-.182.198-.691.677-.691 1.654 0 .977.71 1.916.81 2.049.098.133 1.394 2.132 3.383 2.992.47.205.84.326 1.129.418.475.152.904.129 1.246.08.38-.058 1.171-.48 1.338-.943.164-.464.164-.86.114-.943-.049-.084-.182-.133-.38-.232z"/>
                  </svg>&nbsp;
                <span class="sub-text" style="color: rgb(52, 52, 52) !important;">@if($user->whatsapp_dialcode) +{{ $user->whatsapp_dialcode }}-@endif{{ $user->whatsapp }}</span>&nbsp;
                @if(!\Auth::user()->isAgent())
                    {{-- @if(env('WATI_WHATSAPP_TOKEN')) --}}
                    @if(get_site_config('whatsapp_enabled'))
                        <a &nbsp; target='_blank' href="{{ route('admin.communicate.whatsapp', $user->id)}}" title="Whatsapp" class="text-reset" style="margin-bottom: 0px !important">
                            {{-- <i class='fab fa-whatsapp contactIcon'></i> --}}
                            <i class="bi bi-whatsapp btn btn-sm btn-outline-success border-0" style="font-size: 20px !important;"></i>
                        </a>
                    @else
                        <a &nbsp; target='_blank' href="https://wa.me/+{{$user->dialcode}}{{$user->whatsapp}}" title="Whatsapp" class="text-reset" style="margin-bottom: 0px !important">
                            {{-- <i class='fab fa-whatsapp contactIcon'></i> --}}
                            <i class="bi bi-whatsapp btn btn-sm btn-outline-success border-0" style="font-size: 20px !important;"></i>
                        </a>
                    @endif
                @endif
                @endif
                <span title="Assigned Staff" class="text-reset" style="margin-bottom: 0px !important; float: right!important;">
                    <i class="ri-user-2-fill menu-icon" style="font-size: 16px !important;vertical-align: sub;"></i>
                    {!!($user->assigned_to) ? "<span class='text-primary'>".get_user_full_name_by_id($user->assigned_to)."</span>" : '<span class="text-danger">--</span>'!!}
                </span>
                @if($user->user_country || $user->city || $user->state)
                    <br>
                    <svg style="margin-bottom: 5px !important;color: rgb(52, 52, 52) !important;" xmlns="http://www.w3.org/2000/svg" width="14" height="14" fill="currentColor" class="bi bi-globe-americas sub-text" viewBox="0 0 16 16">
                        <path d="M8 0a8 8 0 1 0 0 16A8 8 0 0 0 8 0ZM2.04 4.326c.325 1.329 2.532 2.54 3.717 3.19.48.263.793.434.743.484-.08.08-.162.158-.242.234-.416.396-.787.749-.758 1.266.035.634.618.824 1.214 1.017.577.188 1.168.38 1.286.983.082.417-.075.988-.22 1.52-.215.782-.406 1.48.22 1.48 1.5-.5 3.798-3.186 4-5 .138-1.243-2-2-3.5-2.5-.478-.16-.755.081-.99.284-.172.15-.322.279-.51.216-.445-.148-2.5-2-1.5-2.5.78-.39.952-.171 1.227.182.078.099.163.208.273.318.609.304.662-.132.723-.633.039-.322.081-.671.277-.867.434-.434 1.265-.791 2.028-1.12.712-.306 1.365-.587 1.579-.88A7 7 0 1 1 2.04 4.327Z"/>
                      </svg>
                    @if($user->city)
                        <span class="sub-text" style="color: rgb(52, 52, 52) !important;">{{ strtoupper($user->city) }}</span>,&nbsp;
                    @endif
                    @if($user->state)
                        <span class="sub-text" style="color: rgb(52, 52, 52) !important;">{{ strtoupper(get_state_name($user->state)) }}</span>,&nbsp;
                    @endif
                    @if($user->user_country)
                    <span class="sub-text" style="color: rgb(52, 52, 52) !important;">{{ strtoupper($user->user_country->title_en) }}</span>&nbsp;
                    @endif
                @endif
                @if($user->is_lead)
                    <br>
                    <span class="tag mt-2" style="background-color:"{{get_lead_status_color($user->lead_status)}} !important">{{$user->lead_status}}</span>
                    @if($userDetails->lead_disqualified_reason && $user->lead_status == get_disqualified_lead_status())
                    <span>{{$userDetails->lead_disqualified_reason}}</span>
                    @endif
                {{-- @else
                <div class="mt-2">
                    @if ($user->overseas_status == 'Profile') 
                        <span style="font-size: 10px;font-weight: 400;" class="badge badge-success">Profile Complete</span>
                    @elseif ($user->overseas_status == 'Course Preferences') 
                        <span style="font-size: 10px;font-weight: 400;" class="badge badge-success">Course Preference Added</span>
                    @elseif ($user->overseas_status == 'Documents') 
                        <span style="font-size: 10px;font-weight: 400;" class="badge badge-success">Documents Uploaded</span>
                    @elseif ($user->overseas_status == 'Application Processing') 
                        <span style="font-size: 10px;font-weight: 400;" class="badge badge-success">University Applications Processing</span>
                    @elseif ($user->overseas_status == 'Application Rejected/Cancelled') 
                        <span style="font-size: 10px;font-weight: 400;" class="badge badge-danger">University Applications Rejected/Cancelled</span>
                    @elseif ($user->overseas_status == 'Case Closed - Rejected By Institution')
                        <span style="font-size: 10px;font-weight: 400;" class="badge badge-danger">Case Closed - Rejected By Institution</span>
                    
                    @elseif ($user->overseas_status == 'Admission Complete') 
                        <span style="font-size: 10px;font-weight: 400;" class="badge badge-success">Admission Complete</span>
                    @elseif ($user->overseas_status == 'Lead') 
                        <span style="font-size: 10px;font-weight: 400;" class="badge badge-primary">Lead</span>
                    @else 
                        <span style="font-size: 10px;font-weight: 400;" class="badge badge-danger">Profile Incomplete</span>
                    @endif
                </div> --}}
                @else
                <br>
                    <span class="tag mt-2" style="background-color:{{get_overseas_status_color($user->overseas_status)}} !important">{{$user->overseas_status}}</span>
                @endif
                @if($user->tags)
                    <span class="ms-4"><i class="bi bi-tags" style="font-size: 18px !important;vertical-align: bottom;"></i>
                        @php $tags_array = explode(',', $user->tags); @endphp
                        @foreach($tags_array as $tags)
                             <span class='badge text-dark me-1 mb-1' style='background: #E9F8F4;'>{{$tags}}</span>
                        @endforeach
                    </span>
                @endif
            {{-- </div> --}}
        </div>
        {{-- <div class="col-3 col-sm-2 my-auto">
            <div @if($user->is_lead) class="card-header text-dark" style="background: #d5bb6c;  border-color: #d5bb6c;" @else class="card-header text-white"  style="background: #1976d2; border-color: #1976d2; " @endif>
                <div style="width:120px;">
                    @if($user->avatar_location != '')
                    <img width="100px" height="100px" src="{{ asset('storage/'.$user->avatar_location) }}" alt="user" style="border-radius: 50%" />
                    @else
                    <img width="100px" height="100px" src="{{ asset('assets/images/users/user.jpg') }}" alt="user" style="border-radius: 50%" />
                    @endif
                </div>
            </div>    
        </div> --}}
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col mt-2">

                {{-- <ul class="nav nav-tabs" id="myTab" role="tablist"> --}}
                <ul class="nav nav-pills nav-fill user-details-nav-links" id="myTab" role="tablist">
                    <li class="nav-item" role="presentation">
                        <button onclick="addURL('overview')" style="font-weight:bold;" class="nav-link active" id="overview-tab" data-bs-toggle="tab" data-bs-target="#overview" type="button" role="tab" aria-controls="overview" aria-selected="true"> @lang('labels.backend.access.users.tabs.titles.overview')</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button onclick="addURL('profile')" style="font-weight:bold; " class="nav-link" id="profile-tab" data-bs-toggle="tab" data-bs-target="#profile" type="button" role="tab" aria-controls="profile" aria-selected="false"> Profile</button>
                    </li>
                    @if(get_site_config('module_course_suggestion'))
                    <li class="nav-item" role="presentation">
                        <button onclick="addURL('course_sugg')" style="font-weight:bold;" class="nav-link" id="coursefindersuggestion-tab" data-bs-toggle="tab" data-bs-target="#coursefindersuggestion" type="button" role="tab" aria-controls="coursefindersuggestion" aria-selected="false"> Course Suggestion</button>
                    </li>
                    @endif

                    <li class="nav-item" role="presentation">
                        <button onclick="addURL('coursepreference')" style="font-weight:bold;" class="nav-link" id="coursepreference-tab" data-bs-toggle="tab" data-bs-target="#coursepreference" type="button" role="tab" aria-controls="coursepreference" aria-selected="false"> Course Preferences</button>
                    </li>

                    @if($user->student_type == 'abroad_job')                    
                    <li class="nav-item" role="presentation">
                        <button onclick="addURL('ajp')" style="font-weight:bold;" class="nav-link" id="abroadjobpreference-tab" data-bs-toggle="tab" data-bs-target="#abroadjobpreference" type="button" role="tab" aria-controls="abroadjobpreference" aria-selected="false"> Abroad Job Preference</button>
                    </li>
                    @endif                    

                    @if($user->student_type == 'visa')                    
                    <li class="nav-item" role="presentation">
                        <button onclick="addURL('visa_pref')" style="font-weight:bold;" class="nav-link" id="visapreference-tab" data-bs-toggle="tab" data-bs-target="#visapreference" type="button" role="tab" aria-controls="visapreference" aria-selected="false"> Visa Preference</button>
                    </li>
                    @endif

                    @if(!$user->is_lead)
                    <li class="nav-item" role="presentation">
                        <button onclick="addURL('docs')" style="font-weight:bold;" class="nav-link" id="docs-tab" data-bs-toggle="tab" data-bs-target="#docs" type="button" role="tab" aria-controls="docs" aria-selected="false"> Documents</button>
                    </li>

                    <li class="nav-item" role="presentation">
                        <button onclick="addURL('app')" style="font-weight:bold;" class="nav-link" id="application-tab" data-bs-toggle="tab" data-bs-target="#application" type="button" role="tab" aria-controls="application" aria-selected="false"> Applications</button>
                    </li>

                    @if(env('ADDITIONAL_SERVICES_ENABLE'))
                    <li class="nav-item" role="presentation">
                        <button onclick="addURL('services')" style="font-weight:bold;" class="nav-link" id="services-tab" data-bs-toggle="tab" data-bs-target="#services" type="button" role="tab" aria-controls="services" aria-selected="false"> Services</button>
                    </li>
                    @endif
                    @endif
                </ul>

                <div class="tab-content" id="myTabContent">
                    <div class="tab-pane fade show active" id="overview" role="tabpanel" aria-labelledby="overview-tab">
                        @include('backend.auth.user.show.tabs.overview')
                    </div>
                    <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                        @include('backend.auth.user.show.tabs.profile')
                    </div>

                    <div class="tab-pane fade" id="coursepreference" role="tabpanel" aria-labelledby="coursepreference">
                        @include('backend.auth.user.show.tabs.coursepreference')
                    </div>

                    @if($user->student_type == 'abroad_job')
                    <div class="tab-pane fade" id="abroadjobpreference" role="tabpanel" aria-labelledby="abroadjobpreference-tab">
                        @include('backend.auth.user.show.tabs.abroadjobpreference')
                    </div>
                    @endif

                    @if($user->student_type == 'visa')
                    <div class="tab-pane fade" id="visapreference" role="tabpanel" aria-labelledby="visapreference-tab">
                        @include('backend.auth.user.show.tabs.visapreference')
                    </div>
                    @endif

                    <div class="tab-pane fade" id="docs" role="tabpanel" aria-labelledby="docs-tab">
                        @include('backend.auth.user.show.tabs.docs')
                    </div>

                    <div class="tab-pane fade" id="application" role="tabpanel" aria-labelledby="application-tab">
                        @include('backend.auth.user.show.tabs.applications')
                    </div>

                    @if(get_site_config('module_course_suggestion'))
                    <div class="tab-pane fade" id="coursefindersuggestion" role="tabpanel" aria-labelledby="coursefindersuggestion-tab">
                        @include('backend.auth.user.show.tabs.course_finder_suggestion')
                    </div>
                    @endif

                    @if(env('ADDITIONAL_SERVICES_ENABLE'))
                    <div class="tab-pane fade" id="services" role="tabpanel" aria-labelledby="services-tab">
                        @include('backend.auth.user.show.tabs.services')
                    </div>
                    @endif
                </div>

            </div>
        </div>
    </div>
    <!--card-body-->

    <div class="card-footer">
        <div class="row">
            <div class="col">
                <small class="float-right text-muted">
                    <strong>@lang('labels.backend.access.users.tabs.content.overview.created_at'):</strong> {{ timezone()->convertToLocal($user->created_at) }} ({{ $user->created_at->diffForHumans() }}),
                    <strong>@lang('labels.backend.access.users.tabs.content.overview.last_updated'):</strong>@if($user->updated_at) {{ timezone()->convertToLocal($user->updated_at) }} ({{ $user->updated_at->diffForHumans() }})@endif
                    @if($user->trashed())
                    <strong>@lang('labels.backend.access.users.tabs.content.overview.deleted_at'):</strong> {{ timezone()->convertToLocal($user->deleted_at) }} ({{ $user->deleted_at->diffForHumans() }})
                    @endif
                </small>
            </div>
            <!--col-->
        </div>
        <!--row-->
    </div>
    <!--card-footer-->
</div>
<!--card-->
@endsection

@push('after-scripts')

<script>
$(document).ready(function(e)  {
    $(document).on('click', '.call_btn', function(e) {
        var user_id = $(this).attr('data-num');

        Swal.fire({
        title: `Are you sure you want to call?`,
            showCancelButton: true,
            confirmButtonText: "Yes",
            cancelButtonText: "Cancel",
            icon: 'question'
        }).then((result) => {
            if(user_id !="" && result.value){
                    var url = "{{route('admin.communicate.phoneCall', [':user_id'])}}";
                    url = url.replace(':user_id', user_id);
                    $.ajax({
                        type:'GET',
                        url: url,
                        dataType:'json',
                        success:function(data){
                            console.log(data);
                            if(data.err){
                                $.toast({
                                    heading: 'Error',
                                    text: data.msg,
                                    position: 'top-right',
                                    loaderBg: '#ff6849',
                                    icon: 'error',
                                    hideAfter: 3000,
                                    stack: 8
                                });
                                return false;
                            }
                            if(data.Call.Status){
                                Swal.fire({
                                    title: "Call Status: "+data.Call.Status,
                                    text: "Calling: "+data.Call.To,
                                    icon: "success"
                                });
                            }
                            if(data.RestException){
                                alert("Error!");
                            }
                        }
                    });
                }
            });
    });
});




    addDeleteForms();

    $(document).ready(function() {
        let selectedTab = window.location.hash;
        if (selectedTab) {
            //console.log('show tab:'+selectedTab);
            $('.nav-link[data-bs-target="' + selectedTab + '"]').trigger('click');
        }
    });
    function addURL(type){
        console.log(type)
        if(type == 'overview'){
            var uri = window.location.toString();
            if (uri.indexOf("#overview") < 0) {
                window.location.href= window.location+"#overview";
            }
        }else{
            var uri = window.location.toString();
            if (uri.indexOf("#overview") > 0) {
                var clean_uri = uri.substring(0, uri.indexOf("#overview"));
                window.history.replaceState({}, document.title, clean_uri);
            }
        }
        if(type == 'profile'){
            var uri = window.location.toString();
            if (uri.indexOf("#profile") < 0) {
                window.location.href= window.location+"#profile";
            }
        }else{
            var uri = window.location.toString();
            if (uri.indexOf("#profile") > 0) {
                var clean_uri = uri.substring(0, uri.indexOf("#profile"));
                window.history.replaceState({}, document.title, clean_uri);
            }
        }
        if(type == 'course_sugg'){
            var uri = window.location.toString();
            if (uri.indexOf("#course_sugg") < 0) {
                window.location.href= window.location+"#course_sugg";
            }
        }else{
            var uri = window.location.toString();
            if (uri.indexOf("#course_sugg") > 0) {
                var clean_uri = uri.substring(0, uri.indexOf("#course_sugg"));
                window.history.replaceState({}, document.title, clean_uri);
            }
        }
        if(type == 'coursepreference'){
            var uri = window.location.toString();
            if (uri.indexOf("#coursepreference") < 0) {
                window.location.href= window.location+"#coursepreference";
            }
        }else{
            var uri = window.location.toString();
            if (uri.indexOf("#coursepreference") > 0) {
                var clean_uri = uri.substring(0, uri.indexOf("#coursepreference"));
                window.history.replaceState({}, document.title, clean_uri);
            }
        }
        if(type == 'docs'){
            var uri = window.location.toString();
            if (uri.indexOf("#docs") < 0) {
                window.location.href= window.location+"#docs";
            }
        }else{
            var uri = window.location.toString();
            if (uri.indexOf("#docs") > 0) {
                var clean_uri = uri.substring(0, uri.indexOf("#docs"));
                window.history.replaceState({}, document.title, clean_uri);
            }
        }
        if(type == 'app'){
            var uri = window.location.toString();
            if (uri.indexOf("#app") < 0) {
                window.location.href= window.location+"#app";
            }
        }else{
            var uri = window.location.toString();
            if (uri.indexOf("#app") > 0) {
                var clean_uri = uri.substring(0, uri.indexOf("#app"));
                window.history.replaceState({}, document.title, clean_uri);
            }
        } 
        if(type == 'services'){
            var uri = window.location.toString();
            if (uri.indexOf("#services") < 0) {
                window.location.href= window.location+"#services";
            }
        }else{
            var uri = window.location.toString();
            if (uri.indexOf("#services") > 0) {
                var clean_uri = uri.substring(0, uri.indexOf("#services"));
                window.history.replaceState({}, document.title, clean_uri);
            }
        }
    }
</script>
@endpush





