@php
$countries = get_study_countries();
@endphp
<div class="row">
    <div class="col-md-12">
        @if(!$user->profile_complete)
        <div class="alert alert-danger" role="alert">
            User Profile Incomplete, profile must be completed first.
        </div>
        @endif
    </div>

</div>
<div class="row">
    <div class="col">
        <h4>Abroad Job Preferences</h4>
        <div class="table-responsive">
            <table class="table table-hover">
                <tr>
                    <th>Country</th>
                    <th>Actions</th>
                </tr>
                @if($user->abroad_jobpreferences)
                @foreach($user->abroad_jobpreferences as $abroad_jobpreference)
                <tr>
                    <td>{{ $abroad_jobpreference['country'] }}</td>
                    <td>
                        @if(!check_application($abroad_jobpreference['id'], 'abroad_job'))
                        <a class="btn btn-primary btn-sm" href="{{route('admin.overseas.abroad_jobapplication.add',$abroad_jobpreference['id'])}}" title="Add Application">Create Application</a>&nbsp;&nbsp;
                        @else
                        <a class="btn btn-primary btn-sm" href="{{route('admin.overseas.abroad_jobapplication.view',$abroad_jobpreference['id'])}}" title="View Application">View Application</a>&nbsp;&nbsp;
                        @endif
                        <a href="{{route('admin.overseas.abroad_jobpref.delete', $abroad_jobpreference['id'])}}" data-method="delete" data-trans-button-cancel="Cancel" data-trans-button-confirm="Delete" data-trans-title="Are you sure?"><i class='fas fa-trash-alt text-danger' style='font-size:17px'></i></a>
                    </td>
                </tr>
                @endforeach
                @endif
                <tr>
                    <td colspan="5"><b>Add New Abroad Job Preference</b></td>
                </tr>
                <form method="post" action="{{route('admin.overseas.abroad_jobpref.save')}}">
                    @csrf
                    <input type="hidden" name="user_id" value="{{$user->id}}">
                    <tr>
                        <td>
                            <div class="form-group">
                                <select class="form-control form-select" name="country" required>
                                    <option value="">Country</option>
                                    @foreach($countries as $country)
                                    <option @if(old('country')==$country) selected @endif value="{{$country}}">{{$country}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </td>
                        
                        <td>
                            <button type="submit" class="form-control btn btn-primary">Add</button>
                        </td>
                    </tr>
                </form>
            </table>
        </div>
    </div>
</div>


@push('after-scripts')
<script>
    $(document).ready(function() {
        addDeleteForms();
        
    });
</script>
@endpush